<?php

include '../../../include/cp_header.php';
$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/language/$language/user.php") ) {
	include XOOPS_ROOT_PATH."/language/$language/user.php";
}

if ( file_exists("../language/$language/main.php") ) {
	include "../language/$language/main.php";
} else {
	include "../language/english/main.php";
}

if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}

include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

define('_OKIMG',"<img src='../images/icon_ok.png' width='6' height='12' border='0' alt='' /> ");
define('_NGIMG',"<img src='../images/icon_error.png' width='6' height='12' border='0' alt='' /> ");
define('_WARNIMG',"<img src='../images/icon_notice.png' width='6' height='12' border='0' alt='' /> ");

$myts =& MyTextSanitizer::getInstance();
xoops_cp_header();
$table = $xoopsDB->prefix( 'xoonips_config' );

function xoonipsOKMessage($str1, $str2){
	if( empty($str2) ) {
		return _OKIMG."$str1";
	} else {
		return _OKIMG."$str1<span style='font-weight:bold;'>$str2</span>";
	}
}

function xoonipsErrorMessage($str1, $str2){
	if( empty($str2) ) {
		return _NGIMG."$str1";
	} else {
		return _NGIMG."$str1<span style='color:#ff0000; font-weight:bold;'>$str2</span>";
	}
}

function xoonipsNoticeMessage($str1, $str2){
	if( empty($str2) ) {
		return _WARNIMG."$str1";
	} else {
		return _WARNIMG."$str1<span style='color:#ff0000; font-weight:bold;'>$str2</span>";
	}
}

// start test.
$resultTexts = array();
$error = false;
$has_odbc_module = true;
$has_xnpal_module = true;


// get DSN
$mhandler =& xoops_gethandler('module');
$module = $mhandler->getByDirname( 'xoonips' );
$chandler = & xoops_gethandler('config');
$assoc = $chandler->getConfigsByCat(false, $module->mid());
$dsn = $assoc['dsn'];
//$dsn = 'hoge';

if (empty($dsn)) {
	$resultTexts[] = xoonipsErrorMessage(_MD_XOONIPS_CONFIG_TEST_L1, _MD_XOONIPS_CONFIG_TEST_L1_NG); // no setting in DSN.
	$error = true;
} else {
	$resultTexts[] = xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L1, $dsn);
}

if ( !ini_get('enable_dl') ) {
	$resultTexts[] = xoonipsErrorMessage(_MD_XOONIPS_CONFIG_TEST_L2, _MD_XOONIPS_CONFIG_DISABLED); // can't dl()
	$error = true;
} else {
	$resultTexts[] = xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L2, _MD_XOONIPS_CONFIG_ENABLED); //
}

// Path in AL // todo: AL's path sets the same path as create_session.
$path = 'XNPAL.so';
// Load AL
if ( !extension_loaded(basename($path, '.so') ) )
	if( @dl($path) == false ){ // miss to load dl()
		$has_xnpal_module = false;
		$error = true;
	} else {
		if ( !function_exists( 'xnp_initialize_db' ) ){
			$has_xnpal_module = false;
			$error = true;
		}
	}
if ( $has_xnpal_module ){
	$resultTexts[] = xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L5, _MD_XOONIPS_CONFIG_ENABLED);
} else {
	$resultTexts[] = xoonipsNoticeMessage(_MD_XOONIPS_CONFIG_TEST_L5, _MD_XOONIPS_CONFIG_DISABLED);
}

// Unified ODBC extension
if ( !extension_loaded('odbc') )
	if( @dl('odbc.so') == false )
		$has_odbc_module = false;
if ( $has_odbc_module ){
	$resultTexts[] = xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L3, _MD_XOONIPS_CONFIG_ENABLED);
} else {
	$resultTexts[] = xoonipsNoticeMessage(_MD_XOONIPS_CONFIG_TEST_L3, _MD_XOONIPS_CONFIG_DISABLED);
}

// Test in ODBC.
if ( function_exists('odbc_connect') ){
	$result = odbc_connect( $dsn, XOOPS_DB_USER, XOOPS_DB_PASS );
	if ( $result == false ){
		$resultTexts[] = xoonipsErrorMessage(_MD_XOONIPS_CONFIG_TEST_L4, _MD_XOONIPS_CONFIG_FAILED . " - " . odbc_errormsg() . "(" . odbc_error() . ")" );
		$error = true;
	} else {
		$resultTexts[] = xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L4, _MD_XOONIPS_CONFIG_SUCCEEDED);
	}
} else {
	$resultTexts[] = xoonipsNoticeMessage(_MD_XOONIPS_CONFIG_TEST_L4, _MD_XOONIPS_CONFIG_SKIPED);
}


// Initialize AL
if ( function_exists( 'xnp_initialize_db' ) ){
	$result = xnp_initialize_db( $dsn, XOOPS_DB_USER, XOOPS_DB_PASS, XOOPS_DB_NAME, XOOPS_DB_PREFIX );
	if ($result != 0) {
		$resultTexts[] = xoonipsErrorMessage(_MD_XOONIPS_CONFIG_TEST_L6, _MD_XOONIPS_CONFIG_FAILED . " - ($result)"); // miss initialize_db.
		$error = true;
	} else {
		$resultTexts[] = xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L6, _MD_XOONIPS_CONFIG_SUCCEEDED); // success initialize_db.
	}
} else {
	$resultTexts[] = xoonipsErrorMessage(_MD_XOONIPS_CONFIG_TEST_L6, _MD_XOONIPS_CONFIG_SKIPED);
	$error = true;
}

// total test result
if ( $error == false ) {
	$resultTexts[] = " <br>\n".xoonipsOKMessage(_MD_XOONIPS_CONFIG_TEST_L7, _MD_XOONIPS_CONFIG_SUCCEEDED);
} else {
	$resultTexts[] = " <br>\n".xoonipsErrorMessage(_MD_XOONIPS_CONFIG_TEST_L7, _MD_XOONIPS_CONFIG_FAILED);
}

$resultText = implode( " <br>\n", $resultTexts );

//// Make form
$form = new XoopsThemeForm( _MD_XOONIPS_CONFIG_CONFIG_TEST_LABEL, "config_test", "config_test.php" );
$form->addElement(new XoopsFormLabel(_MD_XOONIPS_CONFIG_RESULT_LABEL, $resultText));
$form->addElement(new XoopsFormButton('', 'xoonips_test', _MD_XOONIPS_CONFIG_TEST_AGAIN_LABEL, 'submit'));
$form -> display();
xoops_cp_footer();
?>
