<?php
//  $Revision: 1.2.4.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include '../../../include/cp_header.php';
$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/language/$language/user.php") ) {
	include XOOPS_ROOT_PATH."/language/$language/user.php";
}

if ( file_exists("../language/$language/main.php") ) {
	include "../language/$language/main.php";
} else {
	include "../language/english/main.php";
}

if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}

include_once '../condefs.php';
include_once '../include/lib.php';
require_once '../include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];


$configs = array(
		'repositories'              => array( 'type' => 's'  , 'value' => ''  ),
		'logs'                      => array( 'type' => 's'  , 'value' => ''  )
);

include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

$myts =& MyTextSanitizer::getInstance();

xoops_cp_header();

foreach( $configs as $k => $v ){
    if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v['value'];
    }
}

if ( isset($_POST['op']) && $_POST['op'] == 'update' ) {
    global $xoopsDB;
	// Insert into database.
    
    $added = array( );
    $removed = array( );
    $esc_urls = array();
    foreach( preg_split( "/[\r\n]+/", $repositories ) as $url ){
        if( $url == '' ) continue;
        $esc_urls[] = $myts -> addSlashes( $url );
    }

    $sql = "SELECT repository_id FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' );
    $result = $xoopsDB -> query( $sql." WHERE URL NOT IN ('".implode( "', '", $esc_urls )."' )" );
    while( list( $id ) = $xoopsDB -> fetchRow( $result ) ) $removed[] = $id;
    
    //insert repositories
	$sort = 0;
    foreach( $esc_urls as $url ){
		if( preg_match( '/^;/', $url ) > 0 ) $enabled_flag = 0;
		else $enabled_flag = 1;
        $result = $xoopsDB -> query( "SELECT repository_id FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )
                                     ." WHERE URL='${url}'" );
		if( !$xoopsDB -> fetchRow( $result ) ){
			$result = $xoopsDB -> query( "INSERT INTO ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )
                                         ." (URL, enabled, sort) VALUES ('${url}', ${enabled_flag}, ${sort})" );
        }else{ 
			$result = $xoopsDB -> query( "UPDATE ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )
                                         ." SET enabled=${enabled_flag}, sort=${sort}, deleted=0 WHERE url='${url}'" );
        }            
		$sort++;
    }
    
    //remove repositries
    $result = $xoopsDB -> query( "UPDATE ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )
                                 ." SET deleted=1 WHERE repository_id IN (".implode( ',', $removed ).")" );
//    $result = $xoopsDB -> query( "DELETE FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )
//                                 ." WHERE repository_id IN (".implode( ',', $removed ).")" );
    
	//remove records of deleted repositry
//    $result = $xoopsDB -> query( "DELETE FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_metadata' )
//                                 ." WHERE repository_id IN (".implode( ',', $removed ).")" );
    
	redirect_header('oaipmh.php', 3, _MD_AM_DBUPDATED );
	exit;
}

// Config data is read from database.
$ar = $configs;
//retrieve repository urls
$result = $xoopsDB -> query( "SELECT URL FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' ). " WHERE deleted!=1 ORDER BY sort" );
$urls = array();
while( list( $url ) = $xoopsDB -> fetchRow( $result ) ) $urls[] = $url;
$ar['repositories']['value'] = implode( "\n", $urls );

//compose log text from repositories
$result = $xoopsDB -> query( "SELECT CONCAT_WS( '\t', FROM_UNIXTIME( last_access_date ), URL, last_access_result ) FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )." WHERE last_access_date IS NOT NULL AND last_access_result IS NOT NULL AND enabled=1 AND deleted!=1 ORDER BY sort" );
$log = array();
while( list( $url ) = $xoopsDB -> fetchRow( $result ) ) $log[] = $url;
$ar['logs']['value'] = implode( "\n", $log );

// Make form elements and characters in display.
// logs have readonly attribute.
?>
<form name='oaipmh' id='oaipmh' action='oaipmh.php' method='post'>
<table width='100%' class='outer' cellspacing='1'>
 <tr>
  <th colspan='2'><? echo _MD_XOONIPS_OAIPMH_CONFIG; ?></th>
 </tr>
 <tr valign='top' align='left'>
  <td class='head'><? echo _MD_XOONIPS_OAIPMH_CONFIG_REPOSITORIES; ?></td>
  <td class='even'>
   <textarea name='repositories' id='repositories' rows='10' cols='40'><? echo $ar['repositories']['value']; ?></textarea>
  </td>
 </tr>
 <tr valign='top' align='left'>
  <td class='head'><? echo _MD_XOONIPS_OAIPMH_CONFIG_LOGS; ?></td>
  <td class='even'>
   <textarea readonly name='logs' id='logs' rows='10' cols='40'><? echo $ar['logs']['value']; ?></textarea>
  </td>
 </tr>
 <input type='hidden' name='op' id='op' value='update' />
 <tr valign='top' align='left'>
  <td class='head'>
  </td>
  <td class='even'>
   <input type='submit' class='formButton' name='submit'  id='submit' value='Submit' />
  </td>
 </tr>
</table>
</form>
<?
xoops_cp_footer();
?>
