<?php
//  $Revision: 1.9.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
// 
// $op
//   'export' .... Export and download
//   'list'   .... page of agreement licence(item to export)
//   'config' .... set condition to Export
// 
// $index_id
//   User wants to export specified index_id
// 
// $ids
//   array of item_id to export
// 
// $recursive
//   Do indexes export recursively?
//   1 .... Yes
//   0 .... No
//   Undefine .... No
//
// $attachment
//   Do attachment files export?
//   1 .... Yes
//   0 .... No
//   Undefine .... No
session_cache_limiter('none'); // Escape IE's Bug 1 -> http://jp2.php.net/header  Harry 10-Dec-2004 03:26
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
include_once 'include/imexport.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

if ( !$xoopsUser ) {
    redirect_header( 'index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
    exit();
}

$uid = $_SESSION['xoopsUserId'];

    //Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
    redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
    exit();
}

foreach( array( 'op' => '',
                'index_id' => '',
                'recursive' => 0,
                'attachment' => 0,
                'ids' => array() ) as $k => $v ){
    if( isset( $_GET[ $k ] ) ){
        $$k = $_GET[ $k ];
    }else if( isset( $_POST[ $k ] ) ){
        $$k = $_POST[ $k ];
    }else{
        if( isset( $v ) ){
            $$k = $v;
        }
    }
}

if( $op == 'export' )
{
    $config_handler =& xoops_gethandler('config');
    $xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
    
    //$ids = array_key_exists( 'ids', $_POST ) ? $_POST['ids'] : ( array_key_exists( 'ids', $_GET ) ? $_GET['ids'] : '' );
    
    $zippedFiles = array(); // The filenames, that zipped.
    $removeFiles = array(); // The filenames, that should be removed.
    $tmpfile = tempnam("/tmp", "FOO");
    unlink( $tmpfile );
    $tmpdir = $tmpfile."D";
    if( !mkdir( $tmpdir ) ){
        die( "can't make directory '${tmpdir}'\n" );
        exit();
    }
    chdir($tmpdir);
    
    $index = array();
    if( $index_id != '' ){
        $res = xnp_get_index( $xnpsid, $index_id, $index );
        if( $res == RES_OK ){
            $tmpfile = tempnam("/tmp", "FOO");
            $filename = "index.xml";
            $fp = fopen($tmpfile, "w");
            if( !$fp ){
                xoonips_error( "can't open file '${tmpfile}' for write." );
                continue;
            }
            
            if( fwrite($fp, "<indexes>\n" )
                && xnpExportIndex( $fp, $index_id, $recursive == 1 )
                && fwrite($fp, "</indexes>\n" ) ){
                fclose($fp);
                // change character code in export files
                $fp_r = fopen($tmpfile, "r");
                $fp_w = fopen($filename, "w");
                if( !$fp_r || !$fp_w ){
                    if( !$fp_r ) xoonips_error( "can't open file '${tmpfile}' for read." );
                    if( !$fp_w ) xoonips_error( "can't open file '${filename}' for write." );
                    unlink( $tmpfile );
                    unlink( $filename );
                    if( $fp_r ) fclose( $fp_r );
                    if( $fp_w ) fclose( $fp_w );
                    continue;
                }
                while( !feof( $fp_r ) ){
                    fputs( $fp_w, encodeServer2Client( fgets( $fp_r, 131072 ) ) );
                }
                fclose( $fp_r );
                fclose( $fp_w );
                unlink( $tmpfile );
            
                $zippedFiles[] = $filename;
                $removeFiles[] = "${tmpdir}/${filename}";
                
                //Contents of $filename(Result) change in encodeServer2Client.
                $zippedFiles[] = $filename;
                $removeFiles[] = "${tmpdir}/${filename}";
            }else{
                xoonips_error( "error in writing to '${tmpfile}'" );
                fclose($fp);
                unlink( $filename );
            }                
        }
    }
    
    foreach( $ids as $item_id ){
        $tmpfile = tempnam("/tmp", "FOO");
        $filename = "${item_id}.xml";
        $fp = fopen($tmpfile, "w");
        if( !$fp ){
            xoonips_error( "can't open file '${tmpfile}' for write." );
            continue;
        }
        //Contents of $filename(Result) change in encodeServer2Client.
        if( xnpExportItem( $fp, $item_id, $attachment == 1 ) ){
            fclose($fp);
            // change character code in export files
            $fp_r = fopen($tmpfile, "r");
            $fp_w = fopen($filename, "w");
            if( !$fp_r || !$fp_w ){
                if( !$fp_r ) xoonips_error( "can't open file '${tmpfile}' for read." );
                if( !$fp_w ) xoonips_error( "can't open file '${filename}' for write." );
                unlink( $tmpfile );
                unlink( $filename );
                if( $fp_r ) fclose( $fp_r );
                if( $fp_w ) fclose( $fp_w );
                continue;
            }
	        while( !feof( $fp_r ) ){
                fputs( $fp_w, encodeServer2Client( fgets( $fp_r, 131072 ) ) );
            }
            fclose( $fp_r );
            fclose( $fp_w );
            unlink( $tmpfile );
            
            $zippedFiles[] = $filename;
            $removeFiles[] = "${tmpdir}/${filename}";
        }else{
            xoonips_error( "error in writing to '${tmpfile}'" );
            fclose($fp);
            unlink( $filename );
        }
    }
    
    if( count( $zippedFiles ) == 0 ){
        redirect_header('index.php',2,_MD_XOONIPS_EXPORT_EXPORT_ITEMS_EMPTY );
    }
    
// do ZIP
    $zipFile = tempnam("/tmp", "FOO");
    unlink($zipFile);
    $removeFiles[] = $zipFile.".zip";
    $result = xnp_zip_create($zipFile, $zippedFiles);
    if (0 != $result){
        var_dump( $zipFile );
        var_dump( $zippedFiles );
        passthru( "ls -al $tmpdir" );
        print_r (get_loaded_extensions());
        print_r (get_extension_funcs ("XooNIps Abstract Layer"));
        //error(_MD_XOONIPS_ITEM_CANNOT_CREATE_ZIP . "result=$result");
    }
    $size = filesize($zipFile."zip");
    
    header("Cache-Control: none");  // escape IE's Bug 2
//header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0"); // output of cache-control(default)
    header("Content-Disposition: attachment; filename=\"export.zip\"");
    header("Content-Type: application/zip");
    if( $size != false ) header("Content-Length: $size");
    readfile($zipFile.".zip");
    
    foreach( $removeFiles as $f ){ unlink( $f ); }
    rmdir($tmpdir); 
    exit();
}
else if( $op == 'list' )
{
    $config_handler =& xoops_gethandler('config');
    $xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
    $xoopsOption['template_main'] = 'xoonips_export_license.html';

    include XOOPS_ROOT_PATH.'/header.php';
    include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
    
    if( $index_id != '' ){
        $tmp_idx = array( $index_id );
        while( count( $tmp_idx ) > 0 ){
            $i = array_shift( $tmp_idx );
            
            $tmp_ids = array();
            $res = xnp_get_item_id_by_index_id( $xnpsid, $i, array(), $tmp_ids );
            if( $res == RES_OK ){
                $ids = array_merge( $ids, $tmp_ids );
            }
                
            if( !$recursive ) break;
            
            $child = array();
            $res = xnp_get_indexes( $xnpsid, $i, array(), $child );
            if( $res == RES_OK ){
                foreach( $child as $c ){
                    array_push( $tmp_idx, $c['item_id'] );
                }
            }
        }
    }
    
    $tmp = array();
    $itemtypes = array();
    $res = xnp_get_item_types( $tmp );
    foreach( $tmp as $i ){ $itemtypes[ $i['item_type_id'] ] = $i; }
    
    $items = array( );
    foreach( $ids as $i ){
        $item_basic = array();
        $res = xnp_get_item( $xnpsid, $i, $item_basic );
        if( $res == RES_OK
            && array_key_exists( $item_basic['item_type_id'], $itemtypes ) ){
            $func_license_required = $itemtypes[ $item_basic['item_type_id'] ]['name']."GetLicenseRequired";
            $func_license = $itemtypes[ $item_basic['item_type_id'] ]['name']."GetLicenseStatement";
            $func_html = $itemtypes[ $item_basic['item_type_id'] ]['name']."GetListBlock";
            $func_export = $itemtypes[ $item_basic['item_type_id'] ]['name']."ExportItem";
            include_once XOOPS_ROOT_PATH."/modules/".$itemtypes[ $item_basic['item_type_id'] ]['viewphp'];
            $license_required = function_exists( $func_license_required ) ? $func_license_required( $i ) : false;
            list( $license, $use_cc ) = function_exists( $func_license ) ? $func_license( $i ) : array( '', false );
            $html = function_exists( $func_html ) ? $func_html( $item_basic ) : '';
            if( !function_exists( $func_export ) || !export_enable( $i ) ){ $key = 'not_export'; }
            else if( $license_required ){ $key = 'license_required'; }
            else { $key = 'export'; }
            if( !array_key_exists( $key, $items ) ){
                $items[$key] = array();
            }
            $items[$key][] = array( 'item_id' => $i,
                                    //'license_required' => $license_required,
                                    'license' => $license,
                                    'use_cc' => $use_cc,
                                    'detail_html' => $html,
                                    //'export_flag' => function_exists( $func_export )
                                    );
        }
    }
    if( $index_id != '' ) $xoopsTpl->assign('index_id', $index_id );
    $xoopsTpl->assign('item', $items );
    $xoopsTpl->assign('attachment', $attachment );
    $xoopsTpl->assign('recursive', $recursive );
    include XOOPS_ROOT_PATH.'/footer.php';
}
else if( $op == 'config' )
{
    include XOOPS_ROOT_PATH.'/header.php';
    include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
    
    echo _MD_XOONIPS_EXPORT_PANKUZU_EXPORT;
    echo _MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR;
    echo _MD_XOONIPS_EXPORT_PANKUZU_EXPORT_CONFIG;
    
    $form = new XoopsThemeForm(_MD_XOONIPS_EXPORT_CONFIG_TITLE, "exportconfig", "export.php");
    if( isset( $index_id ) && $index_id != '' ){
        $form->addElement( new XoopsFormRadioYN(_MD_XOONIPS_EXPORT_RECURSIVE, 'recursive', $recursive ) );
    }else{
        $form->addElement( new XoopsFormLabel(_MD_XOONIPS_EXPORT_RECURSIVE, _NO ) );
        $form->addElement( new XoopsFormHidden( 'recursive', '0' ) );
    }
    $value = '';
    if( xnp_get_config_value( 'export_attachment', $value ) != RES_OK ){
        $value = 'off';
    }
    if( $value == 'on' ){
        $form->addElement( new XoopsFormRadioYN(_MD_XOONIPS_EXPORT_ATTACHMENT, 'attachment', $attachment ) );
    }else{
        $form->addElement( new XoopsFormLabel(_MD_XOONIPS_EXPORT_ATTACHMENT, _NO ) );
        $form->addElement( new XoopsFormHidden( 'attachment', '0' ) );
    }
    $form->addElement( new XoopsFormButton("", "submit", _SUBMIT, "submit") );
    $form->addElement( new XoopsFormHidden("op", "list") );
    if( isset( $index_id ) && $index_id != '' )
        $form->addElement( new XoopsFormHidden("index_id", $index_id) );
    if( isset( $ids ) ){
        foreach( $ids as $i ){
            $form->addElement( new XoopsFormHidden("ids[]", $i ) );
        }
    }
    $form->display();
    include XOOPS_ROOT_PATH.'/footer.php';
}
else
{
    echo "NOP";
}

/**
 * 
 * check indexes belong to items
 * return true(condition to export is full) / false(condition to export isn't full)
 * 
 */
function export_enable( $item_id )
{
    global $xnpsid, $uid;
    
    $xids = array();
    $result = xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids );
    if ( $result != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
    }
    foreach( $xids as $index_id ){
        // check that index is editable
        $index = array();
        $result = xnp_get_index( $xnpsid, $index_id, $index );
        if( $result != RES_OK ) continue; // skip index if access forbidden(ex: other's index)
        if( $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid ||
            $index['open_level'] == OL_GROUP_ONLY && xnp_is_group_admin( $xnpsid, $index['owner_gid'], $uid ) ||
            $index['open_level'] == OL_PUBLIC && xnp_is_moderator( $xnpsid, $uid ) && $index['item_id'] != IID_BINDERS && $index['item_id'] != IID_ROOT ){
            return true;
        }
    }
    return false;
}
?>

