<?php
//  $Revision: 1.6.2.2 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //


// Demands of search from outside(quicksearch) process, result of search is returned.
// 
// usage: http://hostname/foo/bar/ext_search.php?uname=<username>&pass=<md5 password>&cond=<keyword>
// https://localhost/XooNIps/modules/xoonips/ext_search.php?uname=user200&pass=519c1c326c807690b5aa8cb44bfebebd&cond=book4
// https://localhost/XooNIps/modules/xoonips/ext_search.php?uname=user200&pass=519c1c326c807690b5aa8cb44bfebebd00&cond=book4
// https://localhost/XooNIps/modules/xoonips/ext_search.php?uname=user200&pass=519c1c326c807690b5aa8cb44bfebebd&cond=mitchel
// https://localhost/XooNIps/modules/xoonips/ext_search.php?uname=user200&pass=519c1c326c807690b5aa8cb44bfebebd00&cond=mitchel

include '../../mainfile.php';
if (!defined('XOOPS_ROOT_PATH')) {
	exit();
}
include_once XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php';

if( $xoopsConfig['closesite'] == 1 ){ exit(); }

$uname = !isset($_GET['uname']) ? '' : trim($_GET['uname']);
$pass = !isset($_GET['pass']) ? '' : trim($_GET['pass']);
$cond = !isset($_GET['cond']) ? '' : trim($_GET['cond']);

if( $uname != '' && $pass != '' ) {
    $member_handler =& xoops_gethandler('member');
    $myts =& MyTextsanitizer::getInstance();
    $user =& $member_handler->loginUserMD5(addslashes($myts->stripSlashesGPC($uname)), addslashes($myts->stripSlashesGPC($pass)));
    if( $user != false ){
        if( $user->getVar('level') == 0 ){ $user = false; } 
        $_SESSION['xoopsUserId'] = $user->getVar('uid');
        $_SESSION['xoopsUserGroups'] = $user->getGroups();
        $xoopsUser = $user;
    }else{
        $_SESSION['xoopsUserId'] = 0;
    }
    header( "Location: ".XOOPS_URL."/modules/xoonips/ext_search.php?cond=${cond}" );
    
}else{
    header( "Content-type: text/xml" );
    
    require_once 'include/create_session.php';
    $result = xnp_load_al_silent();
    
    $XNPSID=0;
    
    if( array_key_exists( 'xoopsUserId', $_SESSION ) ){ $uid = $_SESSION['xoopsUserId']; }
    else{ $uid = 0; }
    $result = xnp_create_session( session_id(), (int)$uid, $XNPSID );
    //$result = xnp_create_session( session_id(), (int)$_SESSION['xoopsUserId'], $XNPSID );
    if( $result != 0 ){
        $_SESSION['XNPSID'] = 0; // guest sid
    }else{
        $_SESSION['XNPSID'] = $XNPSID; // XooNIps user after login
    }
    
    require_once 'include/lib.php';
    $iids = array();
    $errorMessage = NULL;
    $search_var = array();
    $res = xnpSearchExec( 'quicksearch', $cond, 'all', false, $errorMessage, $iids, $search_var );
    $cnt = 0;
    $fp = tmpfile();
    foreach( $iids as $i ){
		$item = array();
		$result = xnp_get_item( $_SESSION['XNPSID'], $i, $item );
		if( $result == RES_OK ){
            if( $fp ){
                if( xnpBasicInformation2XML( $fp, $item ) ) $cnt++;
            }else{
                echo "Can't open temporary file\n";
            }
		}
    }
    echo "<search_result count=\"".$cnt."\" cond=\"".urlencode( $cond )."\">";
    fseek($fp, 0);
    while( !feof( $fp ) ) echo fread($fp, 1024);
    echo "</search_result>";
    fclose($fp);
}

?>
