<?php
// $Id: groupadmin.php,v 1.5.4.1 2006/06/20 06:05:20 makotonton Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
error_reporting(E_ALL);
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'include/lib.php';
include_once 'condefs.php';
include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
include_once XOOPS_ROOT_PATH . '/modules/system/constants.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

if ( isset($_GET['uid']) )
	$uid = intval($_GET['uid']);
else
	$uid = 0;

if ($uid <= 0) {
	if ( $xoopsUser ) {
		//Next, try to retrive a UID from a xoopsUser.
		$uid=$xoopsUser->getVar('uid');
	}else{
		redirect_header('index.php', 1, _NOPERM);
		exit();
	}
}

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
	redirect_header('index.php', 1, _MD_XOONIPS_ACCOUNT_NOT_ACTIVATED);
	exit();
}

//User(Not group's administrator) can't control.
//(except XOOPS administrator. They can access all groups.)
$gids = array();
$criteria = array();
if( $xoopsUser->isAdmin( $xoopsModule->getVar('mid') ) ){
    //XOOPS administrator can control members of all platform's groups.
    xnp_dump_gids( $xnpsid, $criteria, $gids );
}else if( 0 != xnp_get_groups_by_uid( $xnpsid, $uid, $criteria, $gids ) ){
	redirect_header('index.php', 1, _MD_XOONIPS_ACCOUNT_QUERY_ERROR);
	exit();
}
$adminGids = array();
for ( $i = 0; $i < count($gids); $i++ ){
	//echo "$uid, {$gids[$i]}<br>\n";
	if ( $xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
         || xnp_is_group_admin( $xnpsid, $gids[$i], $uid ) )
		$adminGids[] = $gids[$i];
}
if ( count( $adminGids ) == 0 ){
	redirect_header('index.php', 3, _NOPERM);
	exit();
}

foreach( array( 'op' => '', 'uids'=>null, 'gid'=>null ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

require(XOOPS_ROOT_PATH.'/header.php');

if ( !isset( $op ) || $op == '' )
	$op = 'list';

switch ( $op ) {
case 'list':
	$groups = array();
	$result = xnp_get_groups( $xnpsid, $adminGids, array(), $groups );
	
	if ( 0 != $result ){
		redirect_header('index.php', 3, "cannot xnp_get_groups()");
		exit();
	}
	$xoopsTpl->assign( 'groups', $groups );
	break;
case 'delUser':
	if( isset( $gid ) && isset( $uids ) ){
		foreach( $uids as $id ){
			if( !xnp_is_group_admin( $xnpsid, $gid, $id ) ){
				xnp_delete_member( $xnpsid, $gid, $id );
				// record events(delete member)
				xnp_insert_event( $xnpsid, ETID_DELETE_GROUP_MEMBER, time(), $uid, xnpGetRemoteHost(), array( 'gid'=>$gid, 'uid'=>$id ) );
			}
		}
	}
	break;
case 'addUser':
	if( isset( $gid ) && isset( $uids ) ){
		foreach( $uids as $id ){
			if( !xnp_is_group_admin( $xnpsid, $gid, $id ) ){
				xnp_insert_member( $xnpsid, $gid, $id, 0 );
				// record events(insert member)
				xnp_insert_event( $xnpsid, ETID_INSERT_GROUP_MEMBER, time(), $uid, xnpGetRemoteHost(), array( 'gid'=>$gid, 'uid'=>$id ) );
				xnpGenerateRss( ); //update RSS
			}
		}
	}
	break;
case 'modify':
	if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
         && !xnp_is_group_admin( $xnpsid, $gid, $uid ) ){
        //not administrator, not groupadmin
		redirect_header( "groupadmin.php", 3, _MD_XOONIPS_ACCOUNT_FORBIDDEN );
		exit( );
	}
	break;
}

if( $op == 'modify' || $op == 'addUser' || $op == 'delUser' ){
	if( isset( $gid ) ){
		$group = array( );
		if( xnp_get_group( $xnpsid, $gid, $group ) != 0 ){
			redirect_header( "groupadmin.php", 3, _MD_XOONIPS_ACCOUNT_QUERY_ERROR."(no such GID)" );
			exit( );
		}
		$xoopsTpl->assign( 'gid', $gid );
		$xoopsTpl->assign( 'gname', $group['gname'] );
		
		$member_uids = array();
		if( xnp_get_members( $xnpsid, $gid, array(), $member_uids ) != 0 ){
			redirect_header( "groupadmin.php", 3, _MD_XOONIPS_ACCOUNT_QUERY_ERROR );
			exit( );
		}
		$members = array();
		foreach( $member_uids as $id ){
			$user = array();
			if( xnp_is_activated( $xnpsid, $id )
			    && xnp_get_account( $xnpsid, $id, $user ) == 0 ){
				$members[] = array( 'uid' => $id, 'uname' => $user['uname'] );
			}
		}

		$nonmember_uids = array();
		if( xnp_dump_uids( $xnpsid, array(), $nonmember_uids ) != 0 ){
			redirect_header( "groupadmin.php", 3, _MD_XOONIPS_ACCOUNT_QUERY_ERROR );
			exit( );
		}
		$nonmembers = array();
		foreach( $nonmember_uids as $id ){
			if( xnp_is_activated( $xnpsid, $id )
			    && !in_array( $id, $member_uids ) ){
				$user = array();
				if( xnp_get_account( $xnpsid, $id, $user ) == 0 ){
					$nonmembers[] = array( 'uid' => $id, 'uname' => $user['uname'] );
				}
			}
		}
		$xoopsTpl->assign( 'members', $members );
		$xoopsTpl->assign( 'nonmembers', $nonmembers );
	}
}

$xoopsTpl->assign( 'op', $op );
$xoopsOption['template_main'] = 'xoonips_groupadmin.html';


require(XOOPS_ROOT_PATH.'/footer.php');
?>
