<?php
//  $Revision: 1.6.4.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/**
   
   op='list' or undefined .... list of groups
     
 */

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
include_once 'include/imexport.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if ( !$xoopsUser ) {
    $parsed = parse_url(XOOPS_URL);
    header( 'Location: '.XOOPS_URL.'/modules/xoonips/user.php?xoops_redirect='.urlencode( $parsed['path'].'/modules/xoonips/groups.php' ) );
    exit();
}

$uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
    $parsed = parse_url(XOOPS_URL);
    header( 'Location: '.XOOPS_URL.'/modules/xoonips/user.php?xoops_redirect='.urlencode( $parsed['path'].'/modules/xoonips/groups.php' ) );
    exit();
}


foreach( array( 'op' => 'list' ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

if( !isset( $op ) || $op == 'list' ){
    $gids = array();
    $groups = array();
    
    $xoopsOption['template_main'] = 'xoonips_group_list.html';
    include './header.php';
    
    $result = xnp_dump_gids( $xnpsid, array(), $gids );
    if( $result != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
        exit();
    }
    
    $result = xnp_get_groups( $xnpsid, $gids, array(), $groups );
    if( $result != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
        exit();
    }
    
    foreach( array_keys( $groups ) as $i ){
        $g =& $groups[ $i ];
        $g['gadmin'] = array();
        $uids = array();
        if( xnp_dump_group_admins( $xnpsid, $g['gid'], array(), $uids ) == RES_OK ){
            foreach( $uids as $uid ){
                $account = array();
                if( xnp_get_account( $xnpsid, $uid, $account ) == RES_OK ){
                    array_push( $g['gadmin'], array( 'uname' => $account['uname'],
                                                     'email' => $account['email'] ) );
                }else{
                    redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
                    exit();
                }
            }
        }else{
            redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
            exit();
        }
    }
    
    $xoopsTpl->assign('groups', $groups );
    include XOOPS_ROOT_PATH.'/footer.php';
}
?>   
