<?php
//  Functions for Japanese encode                                              //
//  $Revision: 1.16.2.4 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/*
Check language setting on server for multibyte strings.
Condition :
 -Xoops	charset
 -PHP	mbstring
*/
function xnpChkServerLang () {
	if (_CHARSET == 'ISO-8859-1') {
		return false;
	}
	else {
		if (extension_loaded("mbstring")) {
			return true;
		}
		else {
			return false;
		}
	}
}

/*
Check language setting of client.
Condition :
 -browser HTTP_ACCEPT_LANGUAGE
*/
function xnpChkClientLang () {
	if ( substr_count( $_SERVER["HTTP_ACCEPT_LANGUAGE"], "ja" ) > 0 ){
		return true;
	}
	else {
		return false;
	}
}

/*
htmlspecialchars with charcter entity references.
*/
function xnpHtmlspecialchars ($str) {
//	return str_replace( "&amp;#", "&#", htmlspecialchars($str, ENT_QUOTES) );
	return xnpHex2NumEntities( str_replace( "&amp;#", "&#", htmlspecialchars( xnpChar2NumEntities( $str ), ENT_QUOTES ) ) );
}

function xnpHex2NumEntities ($str) {
	if (!preg_match("/&#x1?0?[0-9A-Fa-f]{1,4};/", $str)) {
		return $str;
	}
	$wk = explode("&", $str);
	$str2 = "";
	$i = 0;
	foreach ($wk as  $key => $value) {
		if ((substr($value, 0, 2) == "#x") && (substr_count($value, ";") > 0)) {
			$value1 = substr($value, 2, strpos($value, ";") - 1);
			$value2 = substr(strstr($value, ";"), 1);
			$unid = hexdec($value1);
			$str2 .= "&#".$unid.";";
			$str2 .= $value2;
		}
		else {
			if (($i == 0) && (substr($str, 0, 1) != "&")) {
				$str2 .= $value;
			}
			else {
				if ($value != "") {
					$str2 .= "&".$value;
				}
			}
		}
		$i++;
	}
	return $str2;
}

function xnpChar2NumEntities ($str) {
$ent_num_tbl = array(
160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,402,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,932,933,934,935,936,937,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,977,978,982,8226,8230,8242,8243,8254,8260,8472,8465,8476,8482,8501,8592,8593,8594,8595,8596,8629,8656,8657,8658,8659,8660,8704,8706,8707,8709,8711,8712,8713,8715,8719,8721,8722,8727,8730,8733,8734,8736,8743,8744,8745,8746,8747,8756,8764,8773,8776,8800,8801,8804,8805,8834,8835,8836,8838,8839,8853,8855,8869,8901,8968,8969,8970,8971,9001,9002,9674,9824,9827,9829,9830,34,38,60,62,338,339,352,353,376,710,732,8194,8195,8201,8204,8205,8206,8207,8211,8212,8216,8217,8218,8220,8221,8222,8224,8225,8240,8249,8250,8364
);
$ent_char_tbl = array(
"nbsp","iexcl","cent","pound","curren","yen","brvbar","sect","uml","copy","ordf","laquo","not","shy","reg","macr","deg","plusmn","sup2","sup3","acute","micro","para","middot","cedil","sup1","ordm","raquo","frac14","frac12","frac34","iquest","Agrave","Aacute","Acirc","Atilde","Auml","Aring","AElig","Ccedil","Egrave","Eacute","Ecirc","Euml","Igrave","Iacute","Icirc","Iuml","ETH","Ntilde","Ograve","Oacute","Ocirc","Otilde","Ouml","times","Oslash","Ugrave","Uacute","Ucirc","Uuml","Yacute","THORN","szlig","agrave","aacute","acirc","atilde","auml","aring","aelig","ccedil","egrave","eacute","ecirc","euml","igrave","iacute","icirc","iuml","eth","ntilde","ograve","oacute","ocirc","otilde","ouml","divide","oslash","ugrave","uacute","ucirc","uuml","yacute","thorn","yuml","fnof","Alpha","Beta","Gamma","Delta","Epsilon","Zeta","Eta","Theta","Iota","Kappa","Lambda","Mu","Nu","Xi","Omicron","Pi","Rho","Sigma","Tau","Upsilon","Phi","Chi","Psi","Omega","alpha","beta","gamma","delta","epsilon","zeta","eta","theta","iota","kappa","lambda","mu","nu","xi","omicron","pi","rho","sigmaf","sigma","tau","upsilon","phi","chi","psi","omega","thetasym","upsih","piv","bull","hellip","prime","Prime","oline","frasl","weierp","image","real","trade","alefsym","larr","uarr","rarr","darr","harr","crarr","lArr","uArr","rArr","dArr","hArr","forall","part","exist","empty","nabla","isin","notin","ni","prod","sum","minus","lowast","radic","prop","infin","ang","and","or","cap","cup","int","there4","sim","cong","asymp","ne","equiv","le","ge","sub","sup","nsub","sube","supe","oplus","otimes","perp","sdot","lceil","rceil","lfloor","rfloor","lang","rang","loz","spades","clubs","hearts","diams","quot","amp","lt","gt","OElig","oelig","Scaron","scaron","Yuml","circ","tilde","ensp","emsp","thinsp","zwnj","zwj","lrm","rlm","ndash","mdash","lsquo","rsquo","sbquo","ldquo","rdquo","bdquo","dagger","Dagger","permil","lsaquo","rsaquo","euro"
);
	for ($i = 0; $i < count($ent_char_tbl); $i++) {
		$str = str_replace( "&".$ent_char_tbl[$i], "&#".$ent_num_tbl[$i], $str );
	}
	return $str;
}

function encodeServer2Client ($str) {
	$str = str_replace( "&#", "&amp;#", $str);
	if (xnpChkServerLang()) {
//		if ( mb_detect_encoding( $str ) != 'UTF-8' ){
		if ( _CHARSET != 'UTF-8' ){

//			$str = mb_convert_encoding( $str, 'UTF-8', mb_detect_encoding( $str ) );
			$str = mb_convert_encoding( $str, 'UTF-8', _CHARSET );

			$str = xnpEntity2Utf8($str);
		}
		if (!xnpChkClientLang()) {
			$str = xnpUtf82Entity($str);
		}
	}
	else {
		if (xnpChkClientLang()) {
			$str = xnpEntity2Utf8($str);
		}
	}
	$str = str_replace( "&amp;#", "&#", $str);
	return $str;
}

function encodeClient2Server ($str) {
	$str = str_replace( "&#", "&amp;#", $str);
	if (xnpChkServerLang()) {
		if (_CHARSET != 'UTF-8') {
			$str = xnpUtf82Entity($str);
			if (_CHARSET == 'EUC-JP') {
				$str = xnpEntity2Eucjp ($str);
			}
			elseif (_CHARSET == 'Shift-JIS') {
				$str = xnpEntity2Sjis ($str);
			}
		}
	}
	else {
		$str = xnpUtf82Entity($str);
	}
	$str = str_replace( "&amp;#", "&#", $str);
	return $str;
}

function encodeServer2Meta ($str) {
	if (xnpChkServerLang()) {
//		if ( mb_detect_encoding( $str ) != 'UTF-8' ){
		if ( _CHARSET != 'UTF-8' ){
//			$str = mb_convert_encoding( $str, 'UTF-8', mb_detect_encoding( $str ) );
			$str = mb_convert_encoding( $str, 'UTF-8', _CHARSET );
		}
		$str = xnpEntity2Utf8( $str );
	}else if( _CHARSET == 'ISO-8859-1'){
		$str = utf8_encode( $str );
	}
	return $str;
}

function encodeMeta2Server ($str) {
	return encodeClient2Server($str);
}

function encodeMacSafari2Server ( $str ) {
	if ($str != '') {
		if (( substr_count( $_SERVER["HTTP_USER_AGENT"], "Mac" ) > 0 ) && ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Safari" ) > 0 )) {
			$str = str_replace( "&#", "&amp;#", $str);
			if (xnpChkServerLang ()) {
				if ( mb_detect_encoding( $str ) == 'UTF-8' ){
					if (_CHARSET != 'UTF-8') {
						$str = xnpUtf82Entity($str);
						if (_CHARSET == 'EUC-JP') {
							$str = xnpEntity2Eucjp ($str);
						}
					}
				}
			}
			else {
				if (_CHARSET != 'UTF-8') {
					$str = xnpUtf82Entity($str);
					if (_CHARSET == 'EUC-JP') {
						$str = xnpEntity2Eucjp ($str);
					}
				}
			}
			$str = str_replace( "&amp;#", "&#", $str);
		}
	}
	return $str;
}


/*
Convert Japanese encode from UTF-8 to numric decimal charcter entity references.
 -1byte UTF-8 -> US ASCII
 -2byte UTF-8 -> Western languages
 -3byte UTF-8 -> CJK etc.
 -4byte UTF-8 -> Surrogate
*/
function xnpUtf82Entity ($str) {
	if (($str == "") || ($str == NULL)){
		return $str;
	}
//	$wk = unpack("H*", $str);
	$str1 = $str;
	$value = bin2hex($str1);
	$str2 = "";
//	foreach ($wk as  $key => $value) {
		for ($i = 0; $i < strlen($value); $i += 2) {
			$chrx1 = hexdec(substr($value, $i, 2));
			$chrx2 = hexdec(substr($value, $i + 2, 2));
			$chrx3 = hexdec(substr($value, $i + 4, 2));
			$chrx4 = hexdec(substr($value, $i + 6, 2));
			if ($chrx1 >> 7 == 0) {
				$str2 .= pack("H*", (substr($value, $i, 2)));
			}
			elseif (($chrx1 >> 5 == 6) && ($chrx2 >> 6 == 2)) {
				$byte1 = $chrx1 & 31;
				$byte2 = $chrx2 & 63;
				$unix1 = $byte1 >> 2;
				$unix2 = (($byte1 & 3) << 6) | $byte2;
				$unix = sprintf("%02x",$unix1).sprintf("%02x",$unix2);
				$str2 .= "&#".hexdec($unix).";";
				$i += 2;
			}
			elseif (($chrx1 >> 4 == 14) && ($chrx2 >> 6 == 2) && ($chrx3 >> 6 == 2)) {
				$byte1 = $chrx1 & 15;
				$byte2 = $chrx2 & 63;
				$byte3 = $chrx3 & 63;
				$unix1 = ($byte1 << 4) | ($byte2 >> 2);
				$unix2 = (($byte2 & 3) << 6) | $byte3;
				$unix = sprintf("%02x",$unix1).sprintf("%02x",$unix2);
				$str2 .= "&#".hexdec($unix).";";
				$i += 4;
			}
			elseif (($chrx1 >> 3 == 30) && ($chrx2 >> 6 == 2) && ($chrx3 >> 6 == 2) && ($chrx4 >> 6 == 2)) {
				$byte1 = $chrx1 & 7;
				$byte2 = $chrx2 & 63;
				$byte3 = $chrx3 & 63;
				$byte4 = $chrx4 & 63;
				$scr = ($byte1 << 2) | (($byte2 & 48) >> 4);
// Surrogate
/*
				$scr--;
				$unix1 = 216 | (($scr && 12) >> 2);
				$unix2 = (($scr & 3) << 6) | (($byte3 && 48) >> 4);
				$unix = sprintf("%02x",$unix1).sprintf("%02x",$unix2);
				$str2 .= "&#".hexdec($unix).";";
				$unix1 = 220 | (($byte3 && 12) >> 2);
				$unix2 = (($byte3 && 3) << 6) | $byte4;
				$unix = sprintf("%02x",$unix1).sprintf("%02x",$unix2);
				$str2 .= "&#".hexdec($unix).";";
*/
// Scalar
				$unix1 = $scr;
				$unix2 = (($byte2 & 15) << 4) | (($byte3 && 60) >> 2);
				$unix3 = (($byte3 & 3) << 6) | ($byte4);
				$unix = sprintf("%02x",$unix1).sprintf("%02x",$unix2).sprintf("%02x",$unix3);
				$str2 .= "&#".hexdec($unix).";";
				$i += 6;
			}
			else {
				$str2 .= pack("H*", (substr($value, $i, 2)));
			}
		}
//	}
	return $str2;
}

/*
Convert Japanese encode from numric decimal charcter entity references to UTF-8.
Check Unicode bit pattern and convert to each byte length of UTF-8.
 -US ASCII 			-> 1byte UTF-8
 -Western languages	-> 2byte UTF-8
 -CJK etc.			-> 3byte UTF-8
 -Surrogate			-> 4byte UTF-8
*/
function xnpEntity2Utf8 ($str) {
	if (($str == "") || ($str == NULL)){
		return $str;
	}
	if (!preg_match("/&#\d{1,8};/", $str)) {
		return $str;
	}
	$wk = explode("&", $str);
	$str2 = "";
	$surrogate = "";
	$i = 0;
	foreach ($wk as  $key => $value) {
		if ((substr($value, 0, 1) == "#") && (substr_count($value, ";") > 0)) {
			$value1 = substr($value, 1, strpos($value, ";") - 1);
			$value2 = substr(strstr($value, ";"), 1);
			$unix = sprintf("%06x", $value1);
			$unid = hexdec($unix);
			$unid0 = hexdec(substr($unix, -6, 2));
			$unid1 = hexdec(substr($unix, -4, 2));
			$unid2 = hexdec(substr($unix, -2, 2));
			if (($unid < 0xD880) && ($surrogate != "")) {
				$str2 .= "&#".$surrogate.";";
				$surrogate = "";
			}
			if ($unid < 0x0080) {
				$str2 .= sprintf("%c", $unid2);
			}
			elseif ($unid < 0x0800) {
				$bit1 = 192 | (($unid1 & 7) << 2) | ($unid2 >> 6);
				$bit2 = 128 | ($unid2 & 63);
				$str2 .= sprintf("%c", $bit1).sprintf("%c", $bit2);
			}
			elseif ($unid < 0xD800) {
				$bit1 = 224 | ($unid1 >> 4);
				$bit2 = 128 | ((($unid1 & 15) << 2) | ($unid2 >> 6));
				$bit3 = 128 | ($unid2 & 63);
				$str2 .= sprintf("%c", $bit1).sprintf("%c", $bit2).sprintf("%c", $bit3);
			}
			elseif ($unid < 0xDC00) {
				if ($value2 == "") {
					$surrogate = $value1;
					$surrogate1 = $unid1;
					$surrogate2 = $unid2;
				}
				else {
					$str2 .= "&#".$value1.";";
				}
			}
			elseif ($unid <= 0xDFFF) {
				if ($surrogate == "") {
					$str2 .= "&#".$surrogate.";";
				}
				else {
					$scr = (($surrogate1 & 3) << 2) | ((surrogate2 &192) >> 6);
					$scr++;
					$bit1 = 240 | (($scr & 28) >> 2);
					$bit2 = 128 | (($scr & 3) << 4) | (($surrogate2 & 60) >> 2);
					$bit3 = 128 | (($surrogate2 & 3) << 4) | (($unid1 & 3) << 2) | (($unid2 & 192) >> 6);
					$bit4 = 128 | ($unid2 & 63);
					$str2 .= sprintf("%c", $bit1).sprintf("%c", $bit2).sprintf("%c", $bit3).sprintf("%c", $bit4);
				}
			}
			elseif ($unid <= 0xFFFF) {
				$bit1 = 224 | ($unid1 >> 4);
				$bit2 = 128 | ((($unid1 & 15) << 2) | ($unid2 >> 6));
				$bit3 = 128 | ($unid2 & 63);
				$str2 .= sprintf("%c", $bit1).sprintf("%c", $bit2).sprintf("%c", $bit3);
			}
			elseif ($unid <= 0x10FFFF) {
				$bit1 = 240 | ($unid0 >> 2);
				$bit2 = 128 | ((($unid0 & 3) << 4) | ($unid1 >> 4));
				$bit3 = 128 | ((($unid1 & 15) << 2) | ($unid2 >> 6));
				$bit4 = 128 | ($unid2 & 63);
				$str2 .= sprintf("%c", $bit1).sprintf("%c", $bit2).sprintf("%c", $bit3).sprintf("%c", $bit4);
			}
			$str2 .= $value2;
		}
		else {
			if ($surrogate != "") {
				$str2 .= "&#".$surrogate.";";
				$surrogate = "";
			}
			if (($i == 0) && (substr($str, 0, 1) != "&")) {
				$str2 .= $value;
			}
			else {
				if ($value != "") {
					$str2 .= "&".$value;
				}
			}
		}
		$i++;
	}
	return $str2;
}

$ucs2sjis = array( 
	0x00a2=>0x8191, 0x00a3=>0x8192, 0x00a5=>0x818f, 0x00a7=>0x8198, 0x00a8=>0x814e, 0x00ac=>0x81ca, 0x00b0=>0x818b, 0x00b1=>0x817d, 0x00b4=>0x814c, 0x00b6=>0x81f7, 0x00d7=>0x817e, 0x00f7=>0x8180, 0x0391=>0x839f, 0x0392=>0x83a0, 0x0393=>0x83a1, 0x0394=>0x83a2, 
	0x0395=>0x83a3, 0x0396=>0x83a4, 0x0397=>0x83a5, 0x0398=>0x83a6, 0x0399=>0x83a7, 0x039a=>0x83a8, 0x039b=>0x83a9, 0x039c=>0x83aa, 0x039d=>0x83ab, 0x039e=>0x83ac, 0x039f=>0x83ad, 0x03a0=>0x83ae, 0x03a1=>0x83af, 0x03a3=>0x83b0, 0x03a4=>0x83b1, 0x03a5=>0x83b2, 
	0x03a6=>0x83b3, 0x03a7=>0x83b4, 0x03a8=>0x83b5, 0x03a9=>0x83b6, 0x03b1=>0x83bf, 0x03b2=>0x83c0, 0x03b3=>0x83c1, 0x03b4=>0x83c2, 0x03b5=>0x83c3, 0x03b6=>0x83c4, 0x03b7=>0x83c5, 0x03b8=>0x83c6, 0x03b9=>0x83c7, 0x03ba=>0x83c8, 0x03bb=>0x83c9, 0x03bc=>0x83ca, 
	0x03bd=>0x83cb, 0x03be=>0x83cc, 0x03bf=>0x83cd, 0x03c0=>0x83ce, 0x03c1=>0x83cf, 0x03c3=>0x83d0, 0x03c4=>0x83d1, 0x03c5=>0x83d2, 0x03c6=>0x83d3, 0x03c7=>0x83d4, 0x03c8=>0x83d5, 0x03c9=>0x83d6, 0x0401=>0x8446, 0x0410=>0x8440, 0x0411=>0x8441, 0x0412=>0x8442, 
	0x0413=>0x8443, 0x0414=>0x8444, 0x0415=>0x8445, 0x0416=>0x8447, 0x0417=>0x8448, 0x0418=>0x8449, 0x0419=>0x844a, 0x041a=>0x844b, 0x041b=>0x844c, 0x041c=>0x844d, 0x041d=>0x844e, 0x041e=>0x844f, 0x041f=>0x8450, 0x0420=>0x8451, 0x0421=>0x8452, 0x0422=>0x8453, 
	0x0423=>0x8454, 0x0424=>0x8455, 0x0425=>0x8456, 0x0426=>0x8457, 0x0427=>0x8458, 0x0428=>0x8459, 0x0429=>0x845a, 0x042a=>0x845b, 0x042b=>0x845c, 0x042c=>0x845d, 0x042d=>0x845e, 0x042e=>0x845f, 0x042f=>0x8460, 0x0430=>0x8470, 0x0431=>0x8471, 0x0432=>0x8472, 
	0x0433=>0x8473, 0x0434=>0x8474, 0x0435=>0x8475, 0x0436=>0x8477, 0x0437=>0x8478, 0x0438=>0x8479, 0x0439=>0x847a, 0x043a=>0x847b, 0x043b=>0x847c, 0x043c=>0x847d, 0x043d=>0x847e, 0x043e=>0x8480, 0x043f=>0x8481, 0x0440=>0x8482, 0x0441=>0x8483, 0x0442=>0x8484, 
	0x0443=>0x8485, 0x0444=>0x8486, 0x0445=>0x8487, 0x0446=>0x8488, 0x0447=>0x8489, 0x0448=>0x848a, 0x0449=>0x848b, 0x044a=>0x848c, 0x044b=>0x848d, 0x044c=>0x848e, 0x044d=>0x848f, 0x044e=>0x8490, 0x044f=>0x8491, 0x0451=>0x8476, 0x2010=>0x815d, 0x2015=>0x815c, 
	0x2016=>0x8161, 0x2018=>0x8165, 0x2019=>0x8166, 0x201c=>0x8167, 0x201d=>0x8168, 0x2020=>0x81f5, 0x2021=>0x81f6, 0x2025=>0x8164, 0x2026=>0x8163, 0x2030=>0x81f1, 0x2032=>0x818c, 0x2033=>0x818d, 0x203b=>0x81a6, 0x203e=>0x8150, 0x2103=>0x818e, 0x212b=>0x81f0, 
	0x2190=>0x81a9, 0x2191=>0x81aa, 0x2192=>0x81a8, 0x2193=>0x81ab, 0x21d2=>0x81cb, 0x21d4=>0x81cc, 0x2200=>0x81cd, 0x2202=>0x81dd, 0x2203=>0x81ce, 0x2207=>0x81de, 0x2208=>0x81b8, 0x220b=>0x81b9, 0x2212=>0x817c, 0x221a=>0x81e3, 0x221d=>0x81e5, 0x221e=>0x8187, 
	0x2220=>0x81da, 0x2225=>0x8161, 0x2227=>0x81c8, 0x2228=>0x81c9, 0x2229=>0x81bf, 0x222a=>0x81be, 0x222b=>0x81e7, 0x222c=>0x81e8, 0x2234=>0x8188, 0x2235=>0x81e6, 0x223d=>0x81e4, 0x2252=>0x81e0, 0x2260=>0x8182, 0x2261=>0x81df, 0x2266=>0x8185, 0x2267=>0x8186, 
	0x226a=>0x81e1, 0x226b=>0x81e2, 0x2282=>0x81bc, 0x2283=>0x81bd, 0x2286=>0x81ba, 0x2287=>0x81bb, 0x22a5=>0x81db, 0x2312=>0x81dc, 0x2500=>0x849f, 0x2501=>0x84aa, 0x2502=>0x84a0, 0x2503=>0x84ab, 0x250c=>0x84a1, 0x250f=>0x84ac, 0x2510=>0x84a2, 0x2513=>0x84ad, 
	0x2514=>0x84a4, 0x2517=>0x84af, 0x2518=>0x84a3, 0x251b=>0x84ae, 0x251c=>0x84a5, 0x251d=>0x84ba, 0x2520=>0x84b5, 0x2523=>0x84b0, 0x2524=>0x84a7, 0x2525=>0x84bc, 0x2528=>0x84b7, 0x252b=>0x84b2, 0x252c=>0x84a6, 0x252f=>0x84b6, 0x2530=>0x84bb, 0x2533=>0x84b1, 
	0x2534=>0x84a8, 0x2537=>0x84b8, 0x2538=>0x84bd, 0x253b=>0x84b3, 0x253c=>0x84a9, 0x253f=>0x84b9, 0x2542=>0x84be, 0x254b=>0x84b4, 0x25a0=>0x81a1, 0x25a1=>0x81a0, 0x25b2=>0x81a3, 0x25b3=>0x81a2, 0x25bc=>0x81a5, 0x25bd=>0x81a4, 0x25c6=>0x819f, 0x25c7=>0x819e, 
	0x25cb=>0x819b, 0x25ce=>0x819d, 0x25cf=>0x819c, 0x25ef=>0x81fc, 0x2605=>0x819a, 0x2606=>0x8199, 0x2640=>0x818a, 0x2642=>0x8189, 0x266a=>0x81f4, 0x266d=>0x81f3, 0x266f=>0x81f2, 0x3000=>0x8140, 0x3001=>0x8141, 0x3002=>0x8142, 0x3003=>0x8156, 0x3005=>0x8158, 
	0x3006=>0x8159, 0x3007=>0x815a, 0x3008=>0x8171, 0x3009=>0x8172, 0x300a=>0x8173, 0x300b=>0x8174, 0x300c=>0x8175, 0x300d=>0x8176, 0x300e=>0x8177, 0x300f=>0x8178, 0x3010=>0x8179, 0x3011=>0x817a, 0x3012=>0x81a7, 0x3013=>0x81ac, 0x3014=>0x816b, 0x3015=>0x816c, 
	0x301c=>0x8160, 0x3041=>0x829f, 0x3042=>0x82a0, 0x3043=>0x82a1, 0x3044=>0x82a2, 0x3045=>0x82a3, 0x3046=>0x82a4, 0x3047=>0x82a5, 0x3048=>0x82a6, 0x3049=>0x82a7, 0x304a=>0x82a8, 0x304b=>0x82a9, 0x304c=>0x82aa, 0x304d=>0x82ab, 0x304e=>0x82ac, 0x304f=>0x82ad, 
	0x3050=>0x82ae, 0x3051=>0x82af, 0x3052=>0x82b0, 0x3053=>0x82b1, 0x3054=>0x82b2, 0x3055=>0x82b3, 0x3056=>0x82b4, 0x3057=>0x82b5, 0x3058=>0x82b6, 0x3059=>0x82b7, 0x305a=>0x82b8, 0x305b=>0x82b9, 0x305c=>0x82ba, 0x305d=>0x82bb, 0x305e=>0x82bc, 0x305f=>0x82bd, 
	0x3060=>0x82be, 0x3061=>0x82bf, 0x3062=>0x82c0, 0x3063=>0x82c1, 0x3064=>0x82c2, 0x3065=>0x82c3, 0x3066=>0x82c4, 0x3067=>0x82c5, 0x3068=>0x82c6, 0x3069=>0x82c7, 0x306a=>0x82c8, 0x306b=>0x82c9, 0x306c=>0x82ca, 0x306d=>0x82cb, 0x306e=>0x82cc, 0x306f=>0x82cd, 
	0x3070=>0x82ce, 0x3071=>0x82cf, 0x3072=>0x82d0, 0x3073=>0x82d1, 0x3074=>0x82d2, 0x3075=>0x82d3, 0x3076=>0x82d4, 0x3077=>0x82d5, 0x3078=>0x82d6, 0x3079=>0x82d7, 0x307a=>0x82d8, 0x307b=>0x82d9, 0x307c=>0x82da, 0x307d=>0x82db, 0x307e=>0x82dc, 0x307f=>0x82dd, 
	0x3080=>0x82de, 0x3081=>0x82df, 0x3082=>0x82e0, 0x3083=>0x82e1, 0x3084=>0x82e2, 0x3085=>0x82e3, 0x3086=>0x82e4, 0x3087=>0x82e5, 0x3088=>0x82e6, 0x3089=>0x82e7, 0x308a=>0x82e8, 0x308b=>0x82e9, 0x308c=>0x82ea, 0x308d=>0x82eb, 0x308e=>0x82ec, 0x308f=>0x82ed, 
	0x3090=>0x82ee, 0x3091=>0x82ef, 0x3092=>0x82f0, 0x3093=>0x82f1, 0x309b=>0x814a, 0x309c=>0x814b, 0x309d=>0x8154, 0x309e=>0x8155, 0x30a1=>0x8340, 0x30a2=>0x8341, 0x30a3=>0x8342, 0x30a4=>0x8343, 0x30a5=>0x8344, 0x30a6=>0x8345, 0x30a7=>0x8346, 0x30a8=>0x8347, 
	0x30a9=>0x8348, 0x30aa=>0x8349, 0x30ab=>0x834a, 0x30ac=>0x834b, 0x30ad=>0x834c, 0x30ae=>0x834d, 0x30af=>0x834e, 0x30b0=>0x834f, 0x30b1=>0x8350, 0x30b2=>0x8351, 0x30b3=>0x8352, 0x30b4=>0x8353, 0x30b5=>0x8354, 0x30b6=>0x8355, 0x30b7=>0x8356, 0x30b8=>0x8357, 
	0x30b9=>0x8358, 0x30ba=>0x8359, 0x30bb=>0x835a, 0x30bc=>0x835b, 0x30bd=>0x835c, 0x30be=>0x835d, 0x30bf=>0x835e, 0x30c0=>0x835f, 0x30c1=>0x8360, 0x30c2=>0x8361, 0x30c3=>0x8362, 0x30c4=>0x8363, 0x30c5=>0x8364, 0x30c6=>0x8365, 0x30c7=>0x8366, 0x30c8=>0x8367, 
	0x30c9=>0x8368, 0x30ca=>0x8369, 0x30cb=>0x836a, 0x30cc=>0x836b, 0x30cd=>0x836c, 0x30ce=>0x836d, 0x30cf=>0x836e, 0x30d0=>0x836f, 0x30d1=>0x8370, 0x30d2=>0x8371, 0x30d3=>0x8372, 0x30d4=>0x8373, 0x30d5=>0x8374, 0x30d6=>0x8375, 0x30d7=>0x8376, 0x30d8=>0x8377, 
	0x30d9=>0x8378, 0x30da=>0x8379, 0x30db=>0x837a, 0x30dc=>0x837b, 0x30dd=>0x837c, 0x30de=>0x837d, 0x30df=>0x837e, 0x30e0=>0x8380, 0x30e1=>0x8381, 0x30e2=>0x8382, 0x30e3=>0x8383, 0x30e4=>0x8384, 0x30e5=>0x8385, 0x30e6=>0x8386, 0x30e7=>0x8387, 0x30e8=>0x8388, 
	0x30e9=>0x8389, 0x30ea=>0x838a, 0x30eb=>0x838b, 0x30ec=>0x838c, 0x30ed=>0x838d, 0x30ee=>0x838e, 0x30ef=>0x838f, 0x30f0=>0x8390, 0x30f1=>0x8391, 0x30f2=>0x8392, 0x30f3=>0x8393, 0x30f4=>0x8394, 0x30f5=>0x8395, 0x30f6=>0x8396, 0x30fb=>0x8145, 0x30fc=>0x815b, 
	0x30fd=>0x8152, 0x30fe=>0x8153, 0x4e00=>0x88ea, 0x4e01=>0x929a, 0x4e03=>0x8eb5, 0x4e07=>0x969c, 0x4e08=>0x8fe4, 0x4e09=>0x8e4f, 0x4e0a=>0x8fe3, 0x4e0b=>0x89ba, 0x4e0d=>0x9573, 0x4e0e=>0x975e, 0x4e10=>0x98a0, 0x4e11=>0x894e, 0x4e14=>0x8a8e, 0x4e15=>0x98a1, 
	0x4e16=>0x90a2, 0x4e17=>0x99c0, 0x4e18=>0x8b75, 0x4e19=>0x95b8, 0x4e1e=>0x8fe5, 0x4e21=>0x97bc, 0x4e26=>0x95c0, 0x4e2a=>0x98a2, 0x4e2d=>0x9286, 0x4e31=>0x98a3, 0x4e32=>0x8bf8, 0x4e36=>0x98a4, 0x4e38=>0x8adb, 0x4e39=>0x924f, 0x4e3b=>0x8ee5, 0x4e3c=>0x98a5, 
	0x4e3f=>0x98a6, 0x4e42=>0x98a7, 0x4e43=>0x9454, 0x4e45=>0x8b76, 0x4e4b=>0x9456, 0x4e4d=>0x93e1, 0x4e4e=>0x8cc1, 0x4e4f=>0x9652, 0x4e55=>0xe568, 0x4e56=>0x98a8, 0x4e57=>0x8fe6, 0x4e58=>0x98a9, 0x4e59=>0x89b3, 0x4e5d=>0x8be3, 0x4e5e=>0x8cee, 0x4e5f=>0x96e7, 
	0x4e62=>0x9ba4, 0x4e71=>0x9790, 0x4e73=>0x93fb, 0x4e7e=>0x8aa3, 0x4e80=>0x8b54, 0x4e82=>0x98aa, 0x4e85=>0x98ab, 0x4e86=>0x97b9, 0x4e88=>0x975c, 0x4e89=>0x9188, 0x4e8a=>0x98ad, 0x4e8b=>0x8e96, 0x4e8c=>0x93f1, 0x4e8e=>0x98b0, 0x4e91=>0x895d, 0x4e92=>0x8cdd, 
	0x4e94=>0x8cdc, 0x4e95=>0x88e4, 0x4e98=>0x986a, 0x4e99=>0x9869, 0x4e9b=>0x8db1, 0x4e9c=>0x889f, 0x4e9e=>0x98b1, 0x4e9f=>0x98b2, 0x4ea0=>0x98b3, 0x4ea1=>0x9653, 0x4ea2=>0x98b4, 0x4ea4=>0x8cf0, 0x4ea5=>0x88e5, 0x4ea6=>0x9692, 0x4ea8=>0x8b9c, 0x4eab=>0x8b9d, 
	0x4eac=>0x8b9e, 0x4ead=>0x92e0, 0x4eae=>0x97ba, 0x4eb0=>0x98b5, 0x4eb3=>0x98b6, 0x4eb6=>0x98b7, 0x4eba=>0x906c, 0x4ec0=>0x8f59, 0x4ec1=>0x906d, 0x4ec2=>0x98bc, 0x4ec4=>0x98ba, 0x4ec6=>0x98bb, 0x4ec7=>0x8b77, 0x4eca=>0x8da1, 0x4ecb=>0x89ee, 0x4ecd=>0x98b9, 
	0x4ece=>0x98b8, 0x4ecf=>0x95a7, 0x4ed4=>0x8e65, 0x4ed5=>0x8e64, 0x4ed6=>0x91bc, 0x4ed7=>0x98bd, 0x4ed8=>0x9574, 0x4ed9=>0x90e5, 0x4edd=>0x8157, 0x4ede=>0x98be, 0x4edf=>0x98c0, 0x4ee3=>0x91e3, 0x4ee4=>0x97df, 0x4ee5=>0x88c8, 0x4eed=>0x98bf, 0x4eee=>0x89bc, 
	0x4ef0=>0x8bc2, 0x4ef2=>0x9287, 0x4ef6=>0x8c8f, 0x4ef7=>0x98c1, 0x4efb=>0x9443, 0x4f01=>0x8ae9, 0x4f09=>0x98c2, 0x4f0a=>0x88c9, 0x4f0d=>0x8cde, 0x4f0e=>0x8aea, 0x4f0f=>0x959a, 0x4f10=>0x94b0, 0x4f11=>0x8b78, 0x4f1a=>0x89ef, 0x4f1c=>0x98e5, 0x4f1d=>0x9360, 
	0x4f2f=>0x948c, 0x4f30=>0x98c4, 0x4f34=>0x94ba, 0x4f36=>0x97e0, 0x4f38=>0x904c, 0x4f3a=>0x8e66, 0x4f3c=>0x8e97, 0x4f3d=>0x89be, 0x4f43=>0x92cf, 0x4f46=>0x9241, 0x4f47=>0x98c8, 0x4f4d=>0x88ca, 0x4f4e=>0x92e1, 0x4f4f=>0x8f5a, 0x4f50=>0x8db2, 0x4f51=>0x9743, 
	0x4f53=>0x91cc, 0x4f55=>0x89bd, 0x4f57=>0x98c7, 0x4f59=>0x975d, 0x4f5a=>0x98c3, 0x4f5b=>0x98c5, 0x4f5c=>0x8dec, 0x4f5d=>0x98c6, 0x4f5e=>0x9b43, 0x4f69=>0x98ce, 0x4f6f=>0x98d1, 0x4f70=>0x98cf, 0x4f73=>0x89c0, 0x4f75=>0x95b9, 0x4f76=>0x98c9, 0x4f7b=>0x98cd, 
	0x4f7c=>0x8cf1, 0x4f7f=>0x8e67, 0x4f83=>0x8aa4, 0x4f86=>0x98d2, 0x4f88=>0x98ca, 0x4f8b=>0x97e1, 0x4f8d=>0x8e98, 0x4f8f=>0x98cb, 0x4f91=>0x98d0, 0x4f96=>0x98d3, 0x4f98=>0x98cc, 0x4f9b=>0x8b9f, 0x4f9d=>0x88cb, 0x4fa0=>0x8ba0, 0x4fa1=>0x89bf, 0x4fab=>0x9b44, 
	0x4fad=>0x9699, 0x4fae=>0x958e, 0x4faf=>0x8cf2, 0x4fb5=>0x904e, 0x4fb6=>0x97b5, 0x4fbf=>0x95d6, 0x4fc2=>0x8c57, 0x4fc3=>0x91a3, 0x4fc4=>0x89e2, 0x4fca=>0x8f72, 0x4fce=>0x98d7, 0x4fd0=>0x98dc, 0x4fd1=>0x98da, 0x4fd4=>0x98d5, 0x4fd7=>0x91ad, 0x4fd8=>0x98d8, 
	0x4fda=>0x98db, 0x4fdb=>0x98d9, 0x4fdd=>0x95db, 0x4fdf=>0x98d6, 0x4fe1=>0x904d, 0x4fe3=>0x9693, 0x4fe4=>0x98dd, 0x4fe5=>0x98de, 0x4fee=>0x8f43, 0x4fef=>0x98eb, 0x4ff3=>0x946f, 0x4ff5=>0x9555, 0x4ff6=>0x98e6, 0x4ff8=>0x95ee, 0x4ffa=>0x89b4, 0x4ffe=>0x98ea, 
	0x5005=>0x98e4, 0x5006=>0x98ed, 0x5009=>0x9171, 0x500b=>0x8cc2, 0x500d=>0x947b, 0x500f=>0xe0c5, 0x5011=>0x98ec, 0x5012=>0x937c, 0x5014=>0x98e1, 0x5016=>0x8cf4, 0x5019=>0x8cf3, 0x501a=>0x98df, 0x501f=>0x8ed8, 0x5021=>0x98e7, 0x5023=>0x95ed, 0x5024=>0x926c, 
	0x5025=>0x98e3, 0x5026=>0x8c91, 0x5028=>0x98e0, 0x5029=>0x98e8, 0x502a=>0x98e2, 0x502b=>0x97cf, 0x502c=>0x98e9, 0x502d=>0x9860, 0x5036=>0x8be4, 0x5039=>0x8c90, 0x5043=>0x98ee, 0x5047=>0x98ef, 0x5048=>0x98f3, 0x5049=>0x88cc, 0x504f=>0x95ce, 0x5050=>0x98f2, 
	0x5055=>0x98f1, 0x5056=>0x98f5, 0x505a=>0x98f4, 0x505c=>0x92e2, 0x5065=>0x8c92, 0x506c=>0x98f6, 0x5072=>0x8ec3, 0x5074=>0x91a4, 0x5075=>0x92e3, 0x5076=>0x8bf4, 0x5078=>0x98f7, 0x507d=>0x8b55, 0x5080=>0x98f8, 0x5085=>0x98fa, 0x508d=>0x9654, 0x5091=>0x8c86, 
	0x5098=>0x8e50, 0x5099=>0x94f5, 0x509a=>0x98f9, 0x50ac=>0x8dc3, 0x50ad=>0x9762, 0x50b2=>0x98fc, 0x50b3=>0x9942, 0x50b4=>0x98fb, 0x50b5=>0x8dc2, 0x50b7=>0x8f9d, 0x50be=>0x8c58, 0x50c2=>0x9943, 0x50c5=>0x8bcd, 0x50c9=>0x9940, 0x50ca=>0x9941, 0x50cd=>0x93ad, 
	0x50cf=>0x919c, 0x50d1=>0x8ba1, 0x50d5=>0x966c, 0x50d6=>0x9944, 0x50da=>0x97bb, 0x50de=>0x9945, 0x50e3=>0x9948, 0x50e5=>0x9946, 0x50e7=>0x916d, 0x50ed=>0x9947, 0x50ee=>0x9949, 0x50f5=>0x994b, 0x50f9=>0x994a, 0x50fb=>0x95c6, 0x5100=>0x8b56, 0x5101=>0x994d, 
	0x5102=>0x994e, 0x5104=>0x89ad, 0x5109=>0x994c, 0x5112=>0x8ef2, 0x5114=>0x9951, 0x5115=>0x9950, 0x5116=>0x994f, 0x5118=>0x98d4, 0x511a=>0x9952, 0x511f=>0x8f9e, 0x5121=>0x9953, 0x512a=>0x9744, 0x5132=>0x96d7, 0x5137=>0x9955, 0x513a=>0x9954, 0x513b=>0x9957, 
	0x513c=>0x9956, 0x513f=>0x9958, 0x5140=>0x9959, 0x5141=>0x88f2, 0x5143=>0x8cb3, 0x5144=>0x8c5a, 0x5145=>0x8f5b, 0x5146=>0x929b, 0x5147=>0x8ba2, 0x5148=>0x90e6, 0x5149=>0x8cf5, 0x514b=>0x8d8e, 0x514c=>0x995b, 0x514d=>0x96c6, 0x514e=>0x9365, 0x5150=>0x8e99, 
	0x5152=>0x995a, 0x5154=>0x995c, 0x515a=>0x937d, 0x515c=>0x8a95, 0x5162=>0x995d, 0x5165=>0x93fc, 0x5168=>0x9153, 0x5169=>0x995f, 0x516a=>0x9960, 0x516b=>0x94aa, 0x516c=>0x8cf6, 0x516d=>0x985a, 0x516e=>0x9961, 0x5171=>0x8ba4, 0x5175=>0x95ba, 0x5176=>0x91b4, 
	0x5177=>0x8bef, 0x5178=>0x9354, 0x517c=>0x8c93, 0x5180=>0x9962, 0x5182=>0x9963, 0x5185=>0x93e0, 0x5186=>0x897e, 0x5189=>0x9966, 0x518a=>0x8dfb, 0x518c=>0x9965, 0x518d=>0x8dc4, 0x518f=>0x9967, 0x5190=>0xe3ec, 0x5191=>0x9968, 0x5192=>0x9660, 0x5193=>0x9969, 
	0x5195=>0x996a, 0x5196=>0x996b, 0x5197=>0x8fe7, 0x5199=>0x8eca, 0x51a0=>0x8aa5, 0x51a2=>0x996e, 0x51a4=>0x996c, 0x51a5=>0x96bb, 0x51a6=>0x996d, 0x51a8=>0x9579, 0x51a9=>0x996f, 0x51aa=>0x9970, 0x51ab=>0x9971, 0x51ac=>0x937e, 0x51b0=>0x9975, 0x51b1=>0x9973, 
	0x51b2=>0x9974, 0x51b3=>0x9972, 0x51b4=>0x8de1, 0x51b5=>0x9976, 0x51b6=>0x96e8, 0x51b7=>0x97e2, 0x51bd=>0x9977, 0x51c4=>0x90a6, 0x51c5=>0x9978, 0x51c6=>0x8f79, 0x51c9=>0x9979, 0x51cb=>0x929c, 0x51cc=>0x97bd, 0x51cd=>0x9380, 0x51d6=>0x99c3, 0x51db=>0x997a, 
	0x51dc=>0xeaa3, 0x51dd=>0x8bc3, 0x51e0=>0x997b, 0x51e1=>0x967d, 0x51e6=>0x8f88, 0x51e7=>0x91fa, 0x51e9=>0x997d, 0x51ea=>0x93e2, 0x51ed=>0x997e, 0x51f0=>0x9980, 0x51f1=>0x8a4d, 0x51f5=>0x9981, 0x51f6=>0x8ba5, 0x51f8=>0x93ca, 0x51f9=>0x899a, 0x51fa=>0x8f6f, 
	0x51fd=>0x949f, 0x51fe=>0x9982, 0x5200=>0x9381, 0x5203=>0x906e, 0x5204=>0x9983, 0x5206=>0x95aa, 0x5207=>0x90d8, 0x5208=>0x8aa0, 0x520a=>0x8aa7, 0x520b=>0x9984, 0x520e=>0x9986, 0x5211=>0x8c59, 0x5214=>0x9985, 0x5217=>0x97f1, 0x521d=>0x8f89, 0x5224=>0x94bb, 
	0x5225=>0x95ca, 0x5227=>0x9987, 0x5229=>0x9798, 0x522a=>0x9988, 0x522e=>0x9989, 0x5230=>0x939e, 0x5233=>0x998a, 0x5236=>0x90a7, 0x5237=>0x8dfc, 0x5238=>0x8c94, 0x5239=>0x998b, 0x523a=>0x8e68, 0x523b=>0x8d8f, 0x5243=>0x92e4, 0x5244=>0x998d, 0x5247=>0x91a5, 
	0x524a=>0x8ded, 0x524b=>0x998e, 0x524c=>0x998f, 0x524d=>0x914f, 0x524f=>0x998c, 0x5254=>0x9991, 0x5256=>0x9655, 0x525b=>0x8d84, 0x525e=>0x9990, 0x5263=>0x8c95, 0x5264=>0x8ddc, 0x5265=>0x948d, 0x5269=>0x9994, 0x526a=>0x9992, 0x526f=>0x959b, 0x5270=>0x8fe8, 
	0x5271=>0x999b, 0x5272=>0x8a84, 0x5273=>0x9995, 0x5274=>0x9993, 0x5275=>0x916e, 0x527d=>0x9997, 0x527f=>0x9996, 0x5283=>0x8a63, 0x5287=>0x8c80, 0x5288=>0x999c, 0x5289=>0x97ab, 0x528d=>0x9998, 0x5291=>0x999d, 0x5292=>0x999a, 0x5294=>0x9999, 0x529b=>0x97cd, 
	0x529f=>0x8cf7, 0x52a0=>0x89c1, 0x52a3=>0x97f2, 0x52a9=>0x8f95, 0x52aa=>0x9377, 0x52ab=>0x8d85, 0x52ac=>0x99a0, 0x52ad=>0x99a1, 0x52b1=>0x97e3, 0x52b4=>0x984a, 0x52b5=>0x99a3, 0x52b9=>0x8cf8, 0x52bc=>0x99a2, 0x52be=>0x8a4e, 0x52c1=>0x99a4, 0x52c3=>0x9675, 
	0x52c5=>0x92ba, 0x52c7=>0x9745, 0x52c9=>0x95d7, 0x52cd=>0x99a5, 0x52d2=>0xe8d3, 0x52d5=>0x93ae, 0x52d7=>0x99a6, 0x52d8=>0x8aa8, 0x52d9=>0x96b1, 0x52dd=>0x8f9f, 0x52de=>0x99a7, 0x52df=>0x95e5, 0x52e0=>0x99ab, 0x52e2=>0x90a8, 0x52e3=>0x99a8, 0x52e4=>0x8bce, 
	0x52e6=>0x99a9, 0x52e7=>0x8aa9, 0x52f2=>0x8c4d, 0x52f3=>0x99ac, 0x52f5=>0x99ad, 0x52f8=>0x99ae, 0x52f9=>0x99af, 0x52fa=>0x8ed9, 0x52fe=>0x8cf9, 0x52ff=>0x96dc, 0x5301=>0x96e6, 0x5302=>0x93f5, 0x5305=>0x95ef, 0x5306=>0x99b0, 0x5308=>0x99b1, 0x530d=>0x99b3, 
	0x530f=>0x99b5, 0x5310=>0x99b4, 0x5315=>0x99b6, 0x5316=>0x89bb, 0x5317=>0x966b, 0x5319=>0x8dfa, 0x531a=>0x99b7, 0x531d=>0x9178, 0x5320=>0x8fa0, 0x5321=>0x8ba7, 0x5323=>0x99b8, 0x532a=>0x94d9, 0x532f=>0x99b9, 0x5331=>0x99ba, 0x5333=>0x99bb, 0x5338=>0x99bc, 
	0x5339=>0x9543, 0x533a=>0x8be6, 0x533b=>0x88e3, 0x533f=>0x93bd, 0x5340=>0x99bd, 0x5341=>0x8f5c, 0x5343=>0x90e7, 0x5345=>0x99bf, 0x5346=>0x99be, 0x5347=>0x8fa1, 0x5348=>0x8cdf, 0x5349=>0x99c1, 0x534a=>0x94bc, 0x534d=>0x99c2, 0x5351=>0x94da, 0x5352=>0x91b2, 
	0x5353=>0x91ec, 0x5354=>0x8ba6, 0x5357=>0x93ec, 0x5358=>0x9250, 0x535a=>0x948e, 0x535c=>0x966d, 0x535e=>0x99c4, 0x5360=>0x90e8, 0x5366=>0x8c54, 0x5369=>0x99c5, 0x536e=>0x99c6, 0x536f=>0x894b, 0x5370=>0x88f3, 0x5371=>0x8aeb, 0x5373=>0x91a6, 0x5374=>0x8b70, 
	0x5375=>0x9791, 0x5377=>0x99c9, 0x5378=>0x89b5, 0x537b=>0x99c8, 0x537f=>0x8ba8, 0x5382=>0x99ca, 0x5384=>0x96ef, 0x5396=>0x99cb, 0x5398=>0x97d0, 0x539a=>0x8cfa, 0x539f=>0x8cb4, 0x53a0=>0x99cc, 0x53a5=>0x99ce, 0x53a6=>0x99cd, 0x53a8=>0x907e, 0x53a9=>0x8958, 
	0x53ad=>0x897d, 0x53ae=>0x99cf, 0x53b0=>0x99d0, 0x53b3=>0x8cb5, 0x53b6=>0x99d1, 0x53bb=>0x8b8e, 0x53c2=>0x8e51, 0x53c3=>0x99d2, 0x53c8=>0x9694, 0x53c9=>0x8db3, 0x53ca=>0x8b79, 0x53cb=>0x9746, 0x53cc=>0x916f, 0x53cd=>0x94bd, 0x53ce=>0x8efb, 0x53d4=>0x8f66, 
	0x53d6=>0x8ee6, 0x53d7=>0x8ef3, 0x53d9=>0x8f96, 0x53db=>0x94be, 0x53df=>0x99d5, 0x53e1=>0x8962, 0x53e2=>0x9170, 0x53e3=>0x8cfb, 0x53e4=>0x8cc3, 0x53e5=>0x8be5, 0x53e8=>0x99d9, 0x53e9=>0x9240, 0x53ea=>0x91fc, 0x53eb=>0x8ba9, 0x53ec=>0x8fa2, 0x53ed=>0x99da, 
	0x53ee=>0x99d8, 0x53ef=>0x89c2, 0x53f0=>0x91e4, 0x53f1=>0x8eb6, 0x53f2=>0x8e6a, 0x53f3=>0x8945, 0x53f6=>0x8a90, 0x53f7=>0x8d86, 0x53f8=>0x8e69, 0x53fa=>0x99db, 0x5401=>0x99dc, 0x5403=>0x8b68, 0x5404=>0x8a65, 0x5408=>0x8d87, 0x5409=>0x8b67, 0x540a=>0x92dd, 
	0x540b=>0x8944, 0x540c=>0x93af, 0x540d=>0x96bc, 0x540e=>0x8d40, 0x540f=>0x9799, 0x5410=>0x9366, 0x5411=>0x8cfc, 0x541b=>0x8c4e, 0x541d=>0x99e5, 0x541f=>0x8be1, 0x5420=>0x9669, 0x5426=>0x94db, 0x5429=>0x99e4, 0x542b=>0x8adc, 0x542c=>0x99df, 0x542d=>0x99e0, 
	0x542e=>0x99e2, 0x5436=>0x99e3, 0x5438=>0x8b7a, 0x5439=>0x9081, 0x543b=>0x95ab, 0x543c=>0x99e1, 0x543d=>0x99dd, 0x543e=>0x8ce1, 0x5440=>0x99de, 0x5442=>0x9843, 0x5446=>0x95f0, 0x5448=>0x92e6, 0x5449=>0x8ce0, 0x544a=>0x8d90, 0x544e=>0x99e6, 0x5451=>0x93db, 
	0x545f=>0x99ea, 0x5468=>0x8efc, 0x546a=>0x8ef4, 0x5470=>0x99ed, 0x5471=>0x99eb, 0x5473=>0x96a1, 0x5475=>0x99e8, 0x5476=>0x99f1, 0x5477=>0x99ec, 0x547b=>0x99ef, 0x547c=>0x8cc4, 0x547d=>0x96bd, 0x5480=>0x99f0, 0x5484=>0x99f2, 0x5486=>0x99f4, 0x548b=>0x8dee, 
	0x548c=>0x9861, 0x548e=>0x99e9, 0x548f=>0x99e7, 0x5490=>0x99f3, 0x5492=>0x99ee, 0x54a2=>0x99f6, 0x54a4=>0x9a42, 0x54a5=>0x99f8, 0x54a8=>0x99fc, 0x54ab=>0x9a40, 0x54ac=>0x99f9, 0x54af=>0x9a5d, 0x54b2=>0x8de7, 0x54b3=>0x8a50, 0x54b8=>0x99f7, 0x54bc=>0x9a44, 
	0x54bd=>0x88f4, 0x54be=>0x9a43, 0x54c0=>0x88a3, 0x54c1=>0x9569, 0x54c2=>0x9a41, 0x54c4=>0x99fa, 0x54c7=>0x99f5, 0x54c8=>0x99fb, 0x54c9=>0x8dc6, 0x54d8=>0x9a45, 0x54e1=>0x88f5, 0x54e2=>0x9a4e, 0x54e5=>0x9a46, 0x54e6=>0x9a47, 0x54e8=>0x8fa3, 0x54e9=>0x9689, 
	0x54ed=>0x9a4c, 0x54ee=>0x9a4b, 0x54f2=>0x934e, 0x54fa=>0x9a4d, 0x54fd=>0x9a4a, 0x5504=>0x8953, 0x5506=>0x8db4, 0x5507=>0x904f, 0x550f=>0x9a48, 0x5510=>0x9382, 0x5514=>0x9a49, 0x5516=>0x88a0, 0x552e=>0x9a53, 0x552f=>0x9742, 0x5531=>0x8fa5, 0x5533=>0x9a59, 
	0x5538=>0x9a58, 0x5539=>0x9a4f, 0x553e=>0x91c1, 0x5540=>0x9a50, 0x5544=>0x91ed, 0x5545=>0x9a55, 0x5546=>0x8fa4, 0x554c=>0x9a52, 0x554f=>0x96e2, 0x5553=>0x8c5b, 0x5556=>0x9a56, 0x5557=>0x9a57, 0x555c=>0x9a54, 0x555d=>0x9a5a, 0x5563=>0x9a51, 0x557b=>0x9a60, 
	0x557c=>0x9a65, 0x557e=>0x9a61, 0x5580=>0x9a5c, 0x5583=>0x9a66, 0x5584=>0x9150, 0x5587=>0x9a68, 0x5589=>0x8d41, 0x558a=>0x9a5e, 0x558b=>0x929d, 0x5598=>0x9a62, 0x5599=>0x9a5b, 0x559a=>0x8aab, 0x559c=>0x8aec, 0x559d=>0x8a85, 0x559e=>0x9a63, 0x559f=>0x9a5f, 
	0x55a7=>0x8c96, 0x55a8=>0x9a69, 0x55a9=>0x9a67, 0x55aa=>0x9172, 0x55ab=>0x8b69, 0x55ac=>0x8baa, 0x55ae=>0x9a64, 0x55b0=>0x8bf2, 0x55b6=>0x8963, 0x55c4=>0x9a6d, 0x55c5=>0x9a6b, 0x55c7=>0x9aa5, 0x55d4=>0x9a70, 0x55da=>0x9a6a, 0x55dc=>0x9a6e, 0x55df=>0x9a6c, 
	0x55e3=>0x8e6b, 0x55e4=>0x9a6f, 0x55f7=>0x9a72, 0x55f9=>0x9a77, 0x55fd=>0x9a75, 0x55fe=>0x9a74, 0x5606=>0x9251, 0x5609=>0x89c3, 0x5614=>0x9a71, 0x5616=>0x9a73, 0x5617=>0x8fa6, 0x5618=>0x8952, 0x561b=>0x9a76, 0x5629=>0x89dc, 0x562f=>0x9a82, 0x5631=>0x8ffa, 
	0x5632=>0x9a7d, 0x5634=>0x9a7b, 0x5636=>0x9a7c, 0x5638=>0x9a7e, 0x5642=>0x895c, 0x564c=>0x9158, 0x564e=>0x9a78, 0x5650=>0x9a79, 0x565b=>0x8a9a, 0x5664=>0x9a81, 0x5668=>0x8aed, 0x566a=>0x9a84, 0x566b=>0x9a80, 0x566c=>0x9a83, 0x5674=>0x95ac, 0x5678=>0x93d3, 
	0x567a=>0x94b6, 0x5680=>0x9a86, 0x5686=>0x9a85, 0x5687=>0x8a64, 0x568a=>0x9a87, 0x568f=>0x9a8a, 0x5694=>0x9a89, 0x56a0=>0x9a88, 0x56a2=>0x9458, 0x56a5=>0x9a8b, 0x56ae=>0x9a8c, 0x56b4=>0x9a8e, 0x56b6=>0x9a8d, 0x56bc=>0x9a90, 0x56c0=>0x9a93, 0x56c1=>0x9a91, 
	0x56c2=>0x9a8f, 0x56c3=>0x9a92, 0x56c8=>0x9a94, 0x56ce=>0x9a95, 0x56d1=>0x9a96, 0x56d3=>0x9a97, 0x56d7=>0x9a98, 0x56d8=>0x9964, 0x56da=>0x8efa, 0x56db=>0x8e6c, 0x56de=>0x89f1, 0x56e0=>0x88f6, 0x56e3=>0x9263, 0x56ee=>0x9a99, 0x56f0=>0x8da2, 0x56f2=>0x88cd, 
	0x56f3=>0x907d, 0x56f9=>0x9a9a, 0x56fa=>0x8cc5, 0x56fd=>0x8d91, 0x56ff=>0x9a9c, 0x5700=>0x9a9b, 0x5703=>0x95de, 0x5704=>0x9a9d, 0x5708=>0x9a9f, 0x5709=>0x9a9e, 0x570b=>0x9aa0, 0x570d=>0x9aa1, 0x570f=>0x8c97, 0x5712=>0x8980, 0x5713=>0x9aa2, 0x5716=>0x9aa4, 
	0x5718=>0x9aa3, 0x571c=>0x9aa6, 0x571f=>0x9379, 0x5726=>0x9aa7, 0x5727=>0x88b3, 0x5728=>0x8ddd, 0x572d=>0x8c5c, 0x5730=>0x926e, 0x5737=>0x9aa8, 0x5738=>0x9aa9, 0x573b=>0x9aab, 0x5740=>0x9aac, 0x5742=>0x8de2, 0x5747=>0x8bcf, 0x574a=>0x9656, 0x574e=>0x9aaa, 
	0x574f=>0x9aad, 0x5750=>0x8dbf, 0x5751=>0x8d42, 0x5761=>0x9ab1, 0x5764=>0x8da3, 0x5766=>0x9252, 0x5769=>0x9aae, 0x576a=>0x92d8, 0x577f=>0x9ab2, 0x5782=>0x9082, 0x5788=>0x9ab0, 0x5789=>0x9ab3, 0x578b=>0x8c5e, 0x5793=>0x9ab4, 0x57a0=>0x9ab5, 0x57a2=>0x8d43, 
	0x57a3=>0x8a5f, 0x57a4=>0x9ab7, 0x57aa=>0x9ab8, 0x57b0=>0x9ab9, 0x57b3=>0x9ab6, 0x57c0=>0x9aaf, 0x57c3=>0x9aba, 0x57c6=>0x9abb, 0x57cb=>0x9684, 0x57ce=>0x8fe9, 0x57d2=>0x9abd, 0x57d3=>0x9abe, 0x57d4=>0x9abc, 0x57d6=>0x9ac0, 0x57dc=>0x9457, 0x57df=>0x88e6, 
	0x57e0=>0x9575, 0x57e3=>0x9ac1, 0x57f4=>0x8ffb, 0x57f7=>0x8eb7, 0x57f9=>0x947c, 0x57fa=>0x8aee, 0x57fc=>0x8de9, 0x5800=>0x9678, 0x5802=>0x93b0, 0x5805=>0x8c98, 0x5806=>0x91cd, 0x580a=>0x9abf, 0x580b=>0x9ac2, 0x5815=>0x91c2, 0x5819=>0x9ac3, 0x581d=>0x9ac4, 
	0x5821=>0x9ac6, 0x5824=>0x92e7, 0x582a=>0x8aac, 0x582f=>0xea9f, 0x5830=>0x8981, 0x5831=>0x95f1, 0x5834=>0x8fea, 0x5835=>0x9367, 0x583a=>0x8de4, 0x583d=>0x9acc, 0x5840=>0x95bb, 0x5841=>0x97db, 0x584a=>0x89f2, 0x584b=>0x9ac8, 0x5851=>0x9159, 0x5852=>0x9acb, 
	0x5854=>0x9383, 0x5857=>0x9368, 0x5858=>0x9384, 0x5859=>0x94b7, 0x585a=>0x92cb, 0x585e=>0x8dc7, 0x5862=>0x9ac7, 0x5869=>0x8996, 0x586b=>0x9355, 0x5870=>0x9ac9, 0x5872=>0x9ac5, 0x5875=>0x906f, 0x5879=>0x9acd, 0x587e=>0x8f6d, 0x5883=>0x8bab, 0x5885=>0x9ace, 
	0x5893=>0x95e6, 0x5897=>0x919d, 0x589c=>0x92c4, 0x589f=>0x9ad0, 0x58a8=>0x966e, 0x58ab=>0x9ad1, 0x58ae=>0x9ad6, 0x58b3=>0x95ad, 0x58b8=>0x9ad5, 0x58b9=>0x9acf, 0x58ba=>0x9ad2, 0x58bb=>0x9ad4, 0x58be=>0x8da4, 0x58c1=>0x95c7, 0x58c5=>0x9ad7, 0x58c7=>0x9264, 
	0x58ca=>0x89f3, 0x58cc=>0x8feb, 0x58d1=>0x9ad9, 0x58d3=>0x9ad8, 0x58d5=>0x8d88, 0x58d7=>0x9ada, 0x58d8=>0x9adc, 0x58d9=>0x9adb, 0x58dc=>0x9ade, 0x58de=>0x9ad3, 0x58df=>0x9ae0, 0x58e4=>0x9adf, 0x58e5=>0x9add, 0x58eb=>0x8e6d, 0x58ec=>0x9070, 0x58ee=>0x9173, 
	0x58ef=>0x9ae1, 0x58f0=>0x90ba, 0x58f1=>0x88eb, 0x58f2=>0x9484, 0x58f7=>0x92d9, 0x58f9=>0x9ae3, 0x58fa=>0x9ae2, 0x58fb=>0x9ae4, 0x58fc=>0x9ae5, 0x58fd=>0x9ae6, 0x5902=>0x9ae7, 0x5909=>0x95cf, 0x590a=>0x9ae8, 0x590f=>0x89c4, 0x5910=>0x9ae9, 0x5915=>0x975b, 
	0x5916=>0x8a4f, 0x5918=>0x99c7, 0x5919=>0x8f67, 0x591a=>0x91bd, 0x591b=>0x9aea, 0x591c=>0x96e9, 0x5922=>0x96b2, 0x5925=>0x9aec, 0x5927=>0x91e5, 0x5929=>0x9356, 0x592a=>0x91be, 0x592b=>0x9576, 0x592c=>0x9aed, 0x592d=>0x9aee, 0x592e=>0x899b, 0x5931=>0x8eb8, 
	0x5932=>0x9aef, 0x5937=>0x88ce, 0x5938=>0x9af0, 0x593e=>0x9af1, 0x5944=>0x8982, 0x5947=>0x8aef, 0x5948=>0x93de, 0x5949=>0x95f2, 0x594e=>0x9af5, 0x594f=>0x9174, 0x5950=>0x9af4, 0x5951=>0x8c5f, 0x5954=>0x967a, 0x5955=>0x9af3, 0x5957=>0x9385, 0x5958=>0x9af7, 
	0x595a=>0x9af6, 0x5960=>0x9af9, 0x5962=>0x9af8, 0x5965=>0x899c, 0x5967=>0x9afa, 0x5968=>0x8fa7, 0x5969=>0x9afc, 0x596a=>0x9244, 0x596c=>0x9afb, 0x596e=>0x95b1, 0x5973=>0x8f97, 0x5974=>0x937a, 0x5978=>0x9b40, 0x597d=>0x8d44, 0x5981=>0x9b41, 0x5982=>0x9440, 
	0x5983=>0x94dc, 0x5984=>0x96cf, 0x598a=>0x9444, 0x598d=>0x9b4a, 0x5993=>0x8b57, 0x5996=>0x9764, 0x5999=>0x96ad, 0x599b=>0x9baa, 0x599d=>0x9b42, 0x59a3=>0x9b45, 0x59a5=>0x91c3, 0x59a8=>0x9657, 0x59ac=>0x9369, 0x59b2=>0x9b46, 0x59b9=>0x9685, 0x59bb=>0x8dc8, 
	0x59be=>0x8fa8, 0x59c6=>0x9b47, 0x59c9=>0x8e6f, 0x59cb=>0x8e6e, 0x59d0=>0x88b7, 0x59d1=>0x8cc6, 0x59d3=>0x90a9, 0x59d4=>0x88cf, 0x59d9=>0x9b4b, 0x59da=>0x9b4c, 0x59dc=>0x9b49, 0x59e5=>0x8957, 0x59e6=>0x8aad, 0x59e8=>0x9b48, 0x59ea=>0x96c3, 0x59eb=>0x9550, 
	0x59f6=>0x88a6, 0x59fb=>0x88f7, 0x59ff=>0x8e70, 0x5a01=>0x88d0, 0x5a03=>0x88a1, 0x5a09=>0x9b51, 0x5a11=>0x9b4f, 0x5a18=>0x96ba, 0x5a1a=>0x9b52, 0x5a1c=>0x9b50, 0x5a1f=>0x9b4e, 0x5a20=>0x9050, 0x5a25=>0x9b4d, 0x5a29=>0x95d8, 0x5a2f=>0x8ce2, 0x5a35=>0x9b56, 
	0x5a36=>0x9b57, 0x5a3c=>0x8fa9, 0x5a40=>0x9b53, 0x5a41=>0x984b, 0x5a46=>0x946b, 0x5a49=>0x9b55, 0x5a5a=>0x8da5, 0x5a62=>0x9b58, 0x5a66=>0x9577, 0x5a6a=>0x9b59, 0x5a6c=>0x9b54, 0x5a7f=>0x96b9, 0x5a92=>0x947d, 0x5a9a=>0x9b5a, 0x5a9b=>0x9551, 0x5abc=>0x9b5b, 
	0x5abd=>0x9b5f, 0x5abe=>0x9b5c, 0x5ac1=>0x89c5, 0x5ac2=>0x9b5e, 0x5ac9=>0x8eb9, 0x5acb=>0x9b5d, 0x5acc=>0x8c99, 0x5ad0=>0x9b6b, 0x5ad6=>0x9b64, 0x5ad7=>0x9b61, 0x5ae1=>0x9284, 0x5ae3=>0x9b60, 0x5ae6=>0x9b62, 0x5ae9=>0x9b63, 0x5afa=>0x9b65, 0x5afb=>0x9b66, 
	0x5b09=>0x8af0, 0x5b0b=>0x9b68, 0x5b0c=>0x9b67, 0x5b16=>0x9b69, 0x5b22=>0x8fec, 0x5b2a=>0x9b6c, 0x5b2c=>0x92da, 0x5b30=>0x8964, 0x5b32=>0x9b6a, 0x5b36=>0x9b6d, 0x5b3e=>0x9b6e, 0x5b40=>0x9b71, 0x5b43=>0x9b6f, 0x5b45=>0x9b70, 0x5b50=>0x8e71, 0x5b51=>0x9b72, 
	0x5b54=>0x8d45, 0x5b55=>0x9b73, 0x5b57=>0x8e9a, 0x5b58=>0x91b6, 0x5b5a=>0x9b74, 0x5b5b=>0x9b75, 0x5b5c=>0x8e79, 0x5b5d=>0x8d46, 0x5b5f=>0x96d0, 0x5b63=>0x8b47, 0x5b64=>0x8cc7, 0x5b65=>0x9b76, 0x5b66=>0x8a77, 0x5b69=>0x9b77, 0x5b6b=>0x91b7, 0x5b70=>0x9b78, 
	0x5b71=>0x9ba1, 0x5b73=>0x9b79, 0x5b75=>0x9b7a, 0x5b78=>0x9b7b, 0x5b7a=>0x9b7d, 0x5b80=>0x9b7e, 0x5b83=>0x9b80, 0x5b85=>0x91ee, 0x5b87=>0x8946, 0x5b88=>0x8ee7, 0x5b89=>0x88c0, 0x5b8b=>0x9176, 0x5b8c=>0x8aae, 0x5b8d=>0x8eb3, 0x5b8f=>0x8d47, 0x5b95=>0x9386, 
	0x5b97=>0x8f40, 0x5b98=>0x8aaf, 0x5b99=>0x9288, 0x5b9a=>0x92e8, 0x5b9b=>0x88b6, 0x5b9c=>0x8b58, 0x5b9d=>0x95f3, 0x5b9f=>0x8ec0, 0x5ba2=>0x8b71, 0x5ba3=>0x90e9, 0x5ba4=>0x8eba, 0x5ba5=>0x9747, 0x5ba6=>0x9b81, 0x5bae=>0x8b7b, 0x5bb0=>0x8dc9, 0x5bb3=>0x8a51, 
	0x5bb4=>0x8983, 0x5bb5=>0x8faa, 0x5bb6=>0x89c6, 0x5bb8=>0x9b82, 0x5bb9=>0x9765, 0x5bbf=>0x8f68, 0x5bc2=>0x8ee2, 0x5bc3=>0x9b83, 0x5bc4=>0x8af1, 0x5bc5=>0x93d0, 0x5bc6=>0x96a7, 0x5bc7=>0x9b84, 0x5bc9=>0x9b85, 0x5bcc=>0x9578, 0x5bd0=>0x9b87, 0x5bd2=>0x8aa6, 
	0x5bd3=>0x8bf5, 0x5bd4=>0x9b86, 0x5bdb=>0x8ab0, 0x5bdd=>0x9051, 0x5bde=>0x9b8b, 0x5bdf=>0x8e40, 0x5be1=>0x89c7, 0x5be2=>0x9b8a, 0x5be4=>0x9b88, 0x5be5=>0x9b8c, 0x5be6=>0x9b89, 0x5be7=>0x944a, 0x5be8=>0x9ecb, 0x5be9=>0x9052, 0x5beb=>0x9b8d, 0x5bee=>0x97be, 
	0x5bf0=>0x9b8e, 0x5bf3=>0x9b90, 0x5bf5=>0x929e, 0x5bf6=>0x9b8f, 0x5bf8=>0x90a1, 0x5bfa=>0x8e9b, 0x5bfe=>0x91ce, 0x5bff=>0x8ef5, 0x5c01=>0x9595, 0x5c02=>0x90ea, 0x5c04=>0x8ecb, 0x5c05=>0x9b91, 0x5c06=>0x8fab, 0x5c07=>0x9b92, 0x5c08=>0x9b93, 0x5c09=>0x88d1, 
	0x5c0a=>0x91b8, 0x5c0b=>0x9071, 0x5c0d=>0x9b94, 0x5c0e=>0x93b1, 0x5c0f=>0x8fac, 0x5c11=>0x8fad, 0x5c13=>0x9b95, 0x5c16=>0x90eb, 0x5c1a=>0x8fae, 0x5c20=>0x9b96, 0x5c22=>0x9b97, 0x5c24=>0x96de, 0x5c28=>0x9b98, 0x5c2d=>0x8bc4, 0x5c31=>0x8f41, 0x5c38=>0x9b99, 
	0x5c39=>0x9b9a, 0x5c3a=>0x8eda, 0x5c3b=>0x904b, 0x5c3c=>0x93f2, 0x5c3d=>0x9073, 0x5c3e=>0x94f6, 0x5c3f=>0x9441, 0x5c40=>0x8bc7, 0x5c41=>0x9b9b, 0x5c45=>0x8b8f, 0x5c46=>0x9b9c, 0x5c48=>0x8bfc, 0x5c4a=>0x93cd, 0x5c4b=>0x89ae, 0x5c4d=>0x8e72, 0x5c4e=>0x9b9d, 
	0x5c4f=>0x9ba0, 0x5c50=>0x9b9f, 0x5c51=>0x8bfb, 0x5c53=>0x9b9e, 0x5c55=>0x9357, 0x5c5e=>0x91ae, 0x5c60=>0x936a, 0x5c61=>0x8ec6, 0x5c64=>0x9177, 0x5c65=>0x979a, 0x5c6c=>0x9ba2, 0x5c6e=>0x9ba3, 0x5c6f=>0x93d4, 0x5c71=>0x8e52, 0x5c76=>0x9ba5, 0x5c79=>0x9ba6, 
	0x5c8c=>0x9ba7, 0x5c90=>0x8af2, 0x5c91=>0x9ba8, 0x5c94=>0x9ba9, 0x5ca1=>0x89aa, 0x5ca8=>0x915a, 0x5ca9=>0x8ae2, 0x5cab=>0x9bab, 0x5cac=>0x96a6, 0x5cb1=>0x91d0, 0x5cb3=>0x8a78, 0x5cb6=>0x9bad, 0x5cb7=>0x9baf, 0x5cb8=>0x8add, 0x5cbb=>0x9bac, 0x5cbc=>0x9bae, 
	0x5cbe=>0x9bb1, 0x5cc5=>0x9bb0, 0x5cc7=>0x9bb2, 0x5cd9=>0x9bb3, 0x5ce0=>0x93bb, 0x5ce1=>0x8bac, 0x5ce8=>0x89e3, 0x5ce9=>0x9bb4, 0x5cea=>0x9bb9, 0x5ced=>0x9bb7, 0x5cef=>0x95f5, 0x5cf0=>0x95f4, 0x5cf6=>0x9387, 0x5cfa=>0x9bb6, 0x5cfb=>0x8f73, 0x5cfd=>0x9bb5, 
	0x5d07=>0x9092, 0x5d0b=>0x9bba, 0x5d0e=>0x8de8, 0x5d11=>0x9bc0, 0x5d14=>0x9bc1, 0x5d15=>0x9bbb, 0x5d16=>0x8a52, 0x5d17=>0x9bbc, 0x5d18=>0x9bc5, 0x5d19=>0x9bc4, 0x5d1a=>0x9bc3, 0x5d1b=>0x9bbf, 0x5d1f=>0x9bbe, 0x5d22=>0x9bc2, 0x5d29=>0x95f6, 0x5d4b=>0x9bc9, 
	0x5d4c=>0x9bc6, 0x5d4e=>0x9bc8, 0x5d50=>0x9792, 0x5d52=>0x9bc7, 0x5d5c=>0x9bbd, 0x5d69=>0x9093, 0x5d6c=>0x9bca, 0x5d6f=>0x8db5, 0x5d73=>0x9bcb, 0x5d76=>0x9bcc, 0x5d82=>0x9bcf, 0x5d84=>0x9bce, 0x5d87=>0x9bcd, 0x5d8b=>0x9388, 0x5d8c=>0x9bb8, 0x5d90=>0x9bd5, 
	0x5d9d=>0x9bd1, 0x5da2=>0x9bd0, 0x5dac=>0x9bd2, 0x5dae=>0x9bd3, 0x5db7=>0x9bd6, 0x5dba=>0x97e4, 0x5dbc=>0x9bd7, 0x5dbd=>0x9bd4, 0x5dc9=>0x9bd8, 0x5dcc=>0x8ade, 0x5dcd=>0x9bd9, 0x5dd2=>0x9bdb, 0x5dd3=>0x9bda, 0x5dd6=>0x9bdc, 0x5ddb=>0x9bdd, 0x5ddd=>0x90ec, 
	0x5dde=>0x8f42, 0x5de1=>0x8f84, 0x5de3=>0x9183, 0x5de5=>0x8d48, 0x5de6=>0x8db6, 0x5de7=>0x8d49, 0x5de8=>0x8b90, 0x5deb=>0x9bde, 0x5dee=>0x8db7, 0x5df1=>0x8cc8, 0x5df2=>0x9bdf, 0x5df3=>0x96a4, 0x5df4=>0x9462, 0x5df5=>0x9be0, 0x5df7=>0x8d4a, 0x5dfb=>0x8aaa, 
	0x5dfd=>0x9246, 0x5dfe=>0x8bd0, 0x5e02=>0x8e73, 0x5e03=>0x957a, 0x5e06=>0x94bf, 0x5e0b=>0x9be1, 0x5e0c=>0x8af3, 0x5e11=>0x9be4, 0x5e16=>0x929f, 0x5e19=>0x9be3, 0x5e1a=>0x9be2, 0x5e1b=>0x9be5, 0x5e1d=>0x92e9, 0x5e25=>0x9083, 0x5e2b=>0x8e74, 0x5e2d=>0x90c8, 
	0x5e2f=>0x91d1, 0x5e30=>0x8b41, 0x5e33=>0x92a0, 0x5e36=>0x9be6, 0x5e37=>0x9be7, 0x5e38=>0x8fed, 0x5e3d=>0x9658, 0x5e40=>0x9bea, 0x5e43=>0x9be9, 0x5e44=>0x9be8, 0x5e45=>0x959d, 0x5e47=>0x9bf1, 0x5e4c=>0x9679, 0x5e4e=>0x9beb, 0x5e54=>0x9bed, 0x5e55=>0x968b, 
	0x5e57=>0x9bec, 0x5e5f=>0x9bee, 0x5e61=>0x94a6, 0x5e62=>0x9bef, 0x5e63=>0x95bc, 0x5e64=>0x9bf0, 0x5e72=>0x8ab1, 0x5e73=>0x95bd, 0x5e74=>0x944e, 0x5e75=>0x9bf2, 0x5e76=>0x9bf3, 0x5e78=>0x8d4b, 0x5e79=>0x8ab2, 0x5e7a=>0x9bf4, 0x5e7b=>0x8cb6, 0x5e7c=>0x9763, 
	0x5e7d=>0x9748, 0x5e7e=>0x8af4, 0x5e7f=>0x9bf6, 0x5e81=>0x92a1, 0x5e83=>0x8d4c, 0x5e84=>0x8faf, 0x5e87=>0x94dd, 0x5e8a=>0x8fb0, 0x5e8f=>0x8f98, 0x5e95=>0x92ea, 0x5e96=>0x95f7, 0x5e97=>0x9358, 0x5e9a=>0x8d4d, 0x5e9c=>0x957b, 0x5ea0=>0x9bf7, 0x5ea6=>0x9378, 
	0x5ea7=>0x8dc0, 0x5eab=>0x8cc9, 0x5ead=>0x92eb, 0x5eb5=>0x88c1, 0x5eb6=>0x8f8e, 0x5eb7=>0x8d4e, 0x5eb8=>0x9766, 0x5ec1=>0x9bf8, 0x5ec2=>0x9bf9, 0x5ec3=>0x9470, 0x5ec8=>0x9bfa, 0x5ec9=>0x97f5, 0x5eca=>0x984c, 0x5ecf=>0x9bfc, 0x5ed0=>0x9bfb, 0x5ed3=>0x8a66, 
	0x5ed6=>0x9c40, 0x5eda=>0x9c43, 0x5edb=>0x9c44, 0x5edd=>0x9c42, 0x5edf=>0x955f, 0x5ee0=>0x8fb1, 0x5ee1=>0x9c46, 0x5ee2=>0x9c45, 0x5ee3=>0x9c41, 0x5ee8=>0x9c47, 0x5ee9=>0x9c48, 0x5eec=>0x9c49, 0x5ef0=>0x9c4c, 0x5ef1=>0x9c4a, 0x5ef3=>0x9c4b, 0x5ef4=>0x9c4d, 
	0x5ef6=>0x8984, 0x5ef7=>0x92ec, 0x5ef8=>0x9c4e, 0x5efa=>0x8c9a, 0x5efb=>0x89f4, 0x5efc=>0x9455, 0x5efe=>0x9c4f, 0x5eff=>0x93f9, 0x5f01=>0x95d9, 0x5f03=>0x9c50, 0x5f04=>0x984d, 0x5f09=>0x9c51, 0x5f0a=>0x95be, 0x5f0b=>0x9c54, 0x5f0c=>0x989f, 0x5f0d=>0x98af, 
	0x5f0f=>0x8eae, 0x5f10=>0x93f3, 0x5f11=>0x9c55, 0x5f13=>0x8b7c, 0x5f14=>0x92a2, 0x5f15=>0x88f8, 0x5f16=>0x9c56, 0x5f17=>0x95a4, 0x5f18=>0x8d4f, 0x5f1b=>0x926f, 0x5f1f=>0x92ed, 0x5f25=>0x96ed, 0x5f26=>0x8cb7, 0x5f27=>0x8cca, 0x5f29=>0x9c57, 0x5f2d=>0x9c58, 
	0x5f2f=>0x9c5e, 0x5f31=>0x8ee3, 0x5f35=>0x92a3, 0x5f37=>0x8bad, 0x5f38=>0x9c59, 0x5f3c=>0x954a, 0x5f3e=>0x9265, 0x5f41=>0x9c5a, 0x5f48=>0x9c5b, 0x5f4a=>0x8bae, 0x5f4c=>0x9c5c, 0x5f4e=>0x9c5d, 0x5f51=>0x9c5f, 0x5f53=>0x9396, 0x5f56=>0x9c60, 0x5f57=>0x9c61, 
	0x5f59=>0x9c62, 0x5f5c=>0x9c53, 0x5f5d=>0x9c52, 0x5f61=>0x9c63, 0x5f62=>0x8c60, 0x5f66=>0x9546, 0x5f69=>0x8dca, 0x5f6a=>0x9556, 0x5f6b=>0x92a4, 0x5f6c=>0x956a, 0x5f6d=>0x9c64, 0x5f70=>0x8fb2, 0x5f71=>0x8965, 0x5f73=>0x9c65, 0x5f77=>0x9c66, 0x5f79=>0x96f0, 
	0x5f7c=>0x94de, 0x5f7f=>0x9c69, 0x5f80=>0x899d, 0x5f81=>0x90aa, 0x5f82=>0x9c68, 0x5f83=>0x9c67, 0x5f84=>0x8c61, 0x5f85=>0x91d2, 0x5f87=>0x9c6d, 0x5f88=>0x9c6b, 0x5f8a=>0x9c6a, 0x5f8b=>0x97a5, 0x5f8c=>0x8ce3, 0x5f90=>0x8f99, 0x5f91=>0x9c6c, 0x5f92=>0x936b, 
	0x5f93=>0x8f5d, 0x5f97=>0x93be, 0x5f98=>0x9c70, 0x5f99=>0x9c6f, 0x5f9e=>0x9c6e, 0x5fa0=>0x9c71, 0x5fa1=>0x8ce4, 0x5fa8=>0x9c72, 0x5fa9=>0x959c, 0x5faa=>0x8f7a, 0x5fad=>0x9c73, 0x5fae=>0x94f7, 0x5fb3=>0x93bf, 0x5fb4=>0x92a5, 0x5fb9=>0x934f, 0x5fbc=>0x9c74, 
	0x5fbd=>0x8b4a, 0x5fc3=>0x9053, 0x5fc5=>0x954b, 0x5fcc=>0x8af5, 0x5fcd=>0x9445, 0x5fd6=>0x9c75, 0x5fd7=>0x8e75, 0x5fd8=>0x9659, 0x5fd9=>0x965a, 0x5fdc=>0x899e, 0x5fdd=>0x9c7a, 0x5fe0=>0x9289, 0x5fe4=>0x9c77, 0x5feb=>0x89f5, 0x5ff0=>0x9cab, 0x5ff1=>0x9c79, 
	0x5ff5=>0x944f, 0x5ff8=>0x9c78, 0x5ffb=>0x9c76, 0x5ffd=>0x8d9a, 0x5fff=>0x9c7c, 0x600e=>0x9c83, 0x600f=>0x9c89, 0x6010=>0x9c81, 0x6012=>0x937b, 0x6015=>0x9c86, 0x6016=>0x957c, 0x6019=>0x9c80, 0x601b=>0x9c85, 0x601c=>0x97e5, 0x601d=>0x8e76, 0x6020=>0x91d3, 
	0x6021=>0x9c7d, 0x6025=>0x8b7d, 0x6026=>0x9c88, 0x6027=>0x90ab, 0x6028=>0x8985, 0x6029=>0x9c82, 0x602a=>0x89f6, 0x602b=>0x9c87, 0x602f=>0x8baf, 0x6031=>0x9c84, 0x603a=>0x9c8a, 0x6041=>0x9c8c, 0x6042=>0x9c96, 0x6043=>0x9c94, 0x6046=>0x9c91, 0x604a=>0x9c90, 
	0x604b=>0x97f6, 0x604d=>0x9c92, 0x6050=>0x8bb0, 0x6052=>0x8d50, 0x6055=>0x8f9a, 0x6059=>0x9c99, 0x605a=>0x9c8b, 0x605f=>0x9c8f, 0x6060=>0x9c7e, 0x6062=>0x89f8, 0x6063=>0x9c93, 0x6064=>0x9c95, 0x6065=>0x9270, 0x6068=>0x8da6, 0x6069=>0x89b6, 0x606a=>0x9c8d, 
	0x606b=>0x9c98, 0x606c=>0x9c97, 0x606d=>0x8bb1, 0x606f=>0x91a7, 0x6070=>0x8a86, 0x6075=>0x8c62, 0x6077=>0x9c8e, 0x6081=>0x9c9a, 0x6083=>0x9c9d, 0x6084=>0x9c9f, 0x6089=>0x8ebb, 0x608b=>0x9ca5, 0x608c=>0x92ee, 0x608d=>0x9c9b, 0x6092=>0x9ca3, 0x6094=>0x89f7, 
	0x6096=>0x9ca1, 0x6097=>0x9ca2, 0x609a=>0x9c9e, 0x609b=>0x9ca0, 0x609f=>0x8ce5, 0x60a0=>0x9749, 0x60a3=>0x8ab3, 0x60a6=>0x8978, 0x60a7=>0x9ca4, 0x60a9=>0x9459, 0x60aa=>0x88ab, 0x60b2=>0x94df, 0x60b3=>0x9c7b, 0x60b4=>0x9caa, 0x60b5=>0x9cae, 0x60b6=>0x96e3, 
	0x60b8=>0x9ca7, 0x60bc=>0x9389, 0x60bd=>0x9cac, 0x60c5=>0x8fee, 0x60c6=>0x9cad, 0x60c7=>0x93d5, 0x60d1=>0x9866, 0x60d3=>0x9ca9, 0x60d8=>0x9caf, 0x60da=>0x8d9b, 0x60dc=>0x90c9, 0x60df=>0x88d2, 0x60e0=>0x9ca8, 0x60e1=>0x9ca6, 0x60e3=>0x9179, 0x60e7=>0x9c9c, 
	0x60e8=>0x8e53, 0x60f0=>0x91c4, 0x60f1=>0x9cbb, 0x60f3=>0x917a, 0x60f4=>0x9cb6, 0x60f6=>0x9cb3, 0x60f7=>0x9cb4, 0x60f9=>0x8ee4, 0x60fa=>0x9cb7, 0x60fb=>0x9cba, 0x6100=>0x9cb5, 0x6101=>0x8f44, 0x6103=>0x9cb8, 0x6106=>0x9cb2, 0x6108=>0x96fa, 0x6109=>0x96f9, 
	0x610d=>0x9cbc, 0x610e=>0x9cbd, 0x610f=>0x88d3, 0x6115=>0x9cb1, 0x611a=>0x8bf0, 0x611b=>0x88a4, 0x611f=>0x8ab4, 0x6121=>0x9cb9, 0x6127=>0x9cc1, 0x6128=>0x9cc0, 0x612c=>0x9cc5, 0x6134=>0x9cc6, 0x613c=>0x9cc4, 0x613d=>0x9cc7, 0x613e=>0x9cbf, 0x613f=>0x9cc3, 
	0x6142=>0x9cc8, 0x6144=>0x9cc9, 0x6147=>0x9cbe, 0x6148=>0x8e9c, 0x614a=>0x9cc2, 0x614b=>0x91d4, 0x614c=>0x8d51, 0x614d=>0x9cb0, 0x614e=>0x9054, 0x6153=>0x9cd6, 0x6155=>0x95e7, 0x6158=>0x9ccc, 0x6159=>0x9ccd, 0x615a=>0x9cce, 0x615d=>0x9cd5, 0x615f=>0x9cd4, 
	0x6162=>0x969d, 0x6163=>0x8ab5, 0x6165=>0x9cd2, 0x6167=>0x8c64, 0x6168=>0x8a53, 0x616b=>0x9ccf, 0x616e=>0x97b6, 0x616f=>0x9cd1, 0x6170=>0x88d4, 0x6171=>0x9cd3, 0x6173=>0x9cca, 0x6174=>0x9cd0, 0x6175=>0x9cd7, 0x6176=>0x8c63, 0x6177=>0x9ccb, 0x617e=>0x977c, 
	0x6182=>0x974a, 0x6187=>0x9cda, 0x618a=>0x9cde, 0x618e=>0x919e, 0x6190=>0x97f7, 0x6191=>0x9cdf, 0x6194=>0x9cdc, 0x6196=>0x9cd9, 0x6199=>0x9cd8, 0x619a=>0x9cdd, 0x61a4=>0x95ae, 0x61a7=>0x93b2, 0x61a9=>0x8c65, 0x61ab=>0x9ce0, 0x61ac=>0x9cdb, 0x61ae=>0x9ce1, 
	0x61b2=>0x8c9b, 0x61b6=>0x89af, 0x61ba=>0x9ce9, 0x61be=>0x8ab6, 0x61c3=>0x9ce7, 0x61c6=>0x9ce8, 0x61c7=>0x8da7, 0x61c8=>0x9ce6, 0x61c9=>0x9ce4, 0x61ca=>0x9ce3, 0x61cb=>0x9cea, 0x61cc=>0x9ce2, 0x61cd=>0x9cec, 0x61d0=>0x89f9, 0x61e3=>0x9cee, 0x61e6=>0x9ced, 
	0x61f2=>0x92a6, 0x61f4=>0x9cf1, 0x61f6=>0x9cef, 0x61f7=>0x9ce5, 0x61f8=>0x8c9c, 0x61fa=>0x9cf0, 0x61fc=>0x9cf4, 0x61fd=>0x9cf3, 0x61fe=>0x9cf5, 0x61ff=>0x9cf2, 0x6200=>0x9cf6, 0x6208=>0x9cf7, 0x6209=>0x9cf8, 0x620a=>0x95e8, 0x620c=>0x9cfa, 0x620d=>0x9cf9, 
	0x620e=>0x8f5e, 0x6210=>0x90ac, 0x6211=>0x89e4, 0x6212=>0x89fa, 0x6214=>0x9cfb, 0x6216=>0x88bd, 0x621a=>0x90ca, 0x621b=>0x9cfc, 0x621d=>0xe6c1, 0x621e=>0x9d40, 0x621f=>0x8c81, 0x6221=>0x9d41, 0x6226=>0x90ed, 0x622a=>0x9d42, 0x622e=>0x9d43, 0x622f=>0x8b59, 
	0x6230=>0x9d44, 0x6232=>0x9d45, 0x6233=>0x9d46, 0x6234=>0x91d5, 0x6238=>0x8ccb, 0x623b=>0x96df, 0x623f=>0x965b, 0x6240=>0x8f8a, 0x6241=>0x9d47, 0x6247=>0x90ee, 0x6248=>0xe7bb, 0x6249=>0x94e0, 0x624b=>0x8ee8, 0x624d=>0x8dcb, 0x624e=>0x9d48, 0x6253=>0x91c5, 
	0x6255=>0x95a5, 0x6258=>0x91ef, 0x625b=>0x9d4b, 0x625e=>0x9d49, 0x6260=>0x9d4c, 0x6263=>0x9d4a, 0x6268=>0x9d4d, 0x626e=>0x95af, 0x6271=>0x88b5, 0x6276=>0x957d, 0x6279=>0x94e1, 0x627c=>0x9d4e, 0x627e=>0x9d51, 0x627f=>0x8fb3, 0x6280=>0x8b5a, 0x6282=>0x9d4f, 
	0x6283=>0x9d56, 0x6284=>0x8fb4, 0x6289=>0x9d50, 0x628a=>0x9463, 0x6291=>0x977d, 0x6292=>0x9d52, 0x6293=>0x9d53, 0x6294=>0x9d57, 0x6295=>0x938a, 0x6296=>0x9d54, 0x6297=>0x8d52, 0x6298=>0x90dc, 0x629b=>0x9d65, 0x629c=>0x94b2, 0x629e=>0x91f0, 0x62ab=>0x94e2, 
	0x62ac=>0x9dab, 0x62b1=>0x95f8, 0x62b5=>0x92ef, 0x62b9=>0x9695, 0x62bb=>0x9d5a, 0x62bc=>0x899f, 0x62bd=>0x928a, 0x62c2=>0x9d63, 0x62c5=>0x9253, 0x62c6=>0x9d5d, 0x62c7=>0x9d64, 0x62c8=>0x9d5f, 0x62c9=>0x9d66, 0x62ca=>0x9d62, 0x62cc=>0x9d61, 0x62cd=>0x948f, 
	0x62cf=>0x9d5b, 0x62d0=>0x89fb, 0x62d1=>0x9d59, 0x62d2=>0x8b91, 0x62d3=>0x91f1, 0x62d4=>0x9d55, 0x62d7=>0x9d58, 0x62d8=>0x8d53, 0x62d9=>0x90d9, 0x62db=>0x8fb5, 0x62dc=>0x9d60, 0x62dd=>0x9471, 0x62e0=>0x8b92, 0x62e1=>0x8a67, 0x62ec=>0x8a87, 0x62ed=>0x9040, 
	0x62ee=>0x9d68, 0x62ef=>0x9d6d, 0x62f1=>0x9d69, 0x62f3=>0x8c9d, 0x62f5=>0x9d6e, 0x62f6=>0x8e41, 0x62f7=>0x8d89, 0x62fe=>0x8f45, 0x62ff=>0x9d5c, 0x6301=>0x8e9d, 0x6302=>0x9d6b, 0x6307=>0x8e77, 0x6308=>0x9d6c, 0x6309=>0x88c2, 0x630c=>0x9d67, 0x6311=>0x92a7, 
	0x6319=>0x8b93, 0x631f=>0x8bb2, 0x6327=>0x9d6a, 0x6328=>0x88a5, 0x632b=>0x8dc1, 0x632f=>0x9055, 0x633a=>0x92f0, 0x633d=>0x94d2, 0x633e=>0x9d70, 0x633f=>0x917d, 0x6349=>0x91a8, 0x634c=>0x8e4a, 0x634d=>0x9d71, 0x634f=>0x9d73, 0x6350=>0x9d6f, 0x6355=>0x95df, 
	0x6357=>0x92bb, 0x635c=>0x917b, 0x6367=>0x95f9, 0x6368=>0x8ecc, 0x6369=>0x9d80, 0x636b=>0x9d7e, 0x636e=>0x9098, 0x6372=>0x8c9e, 0x6376=>0x9d78, 0x6377=>0x8fb7, 0x637a=>0x93e6, 0x637b=>0x9450, 0x6380=>0x9d76, 0x6383=>0x917c, 0x6388=>0x8ef6, 0x6389=>0x9d7b, 
	0x638c=>0x8fb6, 0x638e=>0x9d75, 0x638f=>0x9d7a, 0x6392=>0x9472, 0x6396=>0x9d74, 0x6398=>0x8c40, 0x639b=>0x8a7c, 0x639f=>0x9d7c, 0x63a0=>0x97a9, 0x63a1=>0x8dcc, 0x63a2=>0x9254, 0x63a3=>0x9d79, 0x63a5=>0x90da, 0x63a7=>0x8d54, 0x63a8=>0x9084, 0x63a9=>0x8986, 
	0x63aa=>0x915b, 0x63ab=>0x9d77, 0x63ac=>0x8b64, 0x63b2=>0x8c66, 0x63b4=>0x92cd, 0x63b5=>0x9d7d, 0x63bb=>0x917e, 0x63be=>0x9d81, 0x63c0=>0x9d83, 0x63c3=>0x91b5, 0x63c4=>0x9d89, 0x63c6=>0x9d84, 0x63c9=>0x9d86, 0x63cf=>0x9560, 0x63d0=>0x92f1, 0x63d2=>0x9d87, 
	0x63d6=>0x974b, 0x63da=>0x9767, 0x63db=>0x8ab7, 0x63e1=>0x88ac, 0x63e3=>0x9d85, 0x63e9=>0x9d82, 0x63ee=>0x8af6, 0x63f4=>0x8987, 0x63f6=>0x9d88, 0x63fa=>0x9768, 0x6406=>0x9d8c, 0x640d=>0x91b9, 0x640f=>0x9d93, 0x6413=>0x9d8d, 0x6416=>0x9d8a, 0x6417=>0x9d91, 
	0x641c=>0x9d72, 0x6426=>0x9d8e, 0x6428=>0x9d92, 0x642c=>0x94c0, 0x642d=>0x938b, 0x6434=>0x9d8b, 0x6436=>0x9d8f, 0x643a=>0x8c67, 0x643e=>0x8def, 0x6442=>0x90db, 0x644e=>0x9d97, 0x6458=>0x9345, 0x6467=>0x9d94, 0x6469=>0x9680, 0x646f=>0x9d95, 0x6476=>0x9d96, 
	0x6478=>0x96cc, 0x647a=>0x90a0, 0x6483=>0x8c82, 0x6488=>0x9d9d, 0x6492=>0x8e54, 0x6493=>0x9d9a, 0x6495=>0x9d99, 0x649a=>0x9451, 0x649e=>0x93b3, 0x64a4=>0x9350, 0x64a5=>0x9d9b, 0x64a9=>0x9d9c, 0x64ab=>0x958f, 0x64ad=>0x9464, 0x64ae=>0x8e42, 0x64b0=>0x90ef, 
	0x64b2=>0x966f, 0x64b9=>0x8a68, 0x64bb=>0x9da3, 0x64bc=>0x9d9e, 0x64c1=>0x9769, 0x64c2=>0x9da5, 0x64c5=>0x9da1, 0x64c7=>0x9da2, 0x64cd=>0x9180, 0x64d2=>0x9da0, 0x64d4=>0x9d5e, 0x64d8=>0x9da4, 0x64da=>0x9d9f, 0x64e0=>0x9da9, 0x64e1=>0x9daa, 0x64e2=>0x9346, 
	0x64e3=>0x9dac, 0x64e6=>0x8e43, 0x64e7=>0x9da7, 0x64ec=>0x8b5b, 0x64ef=>0x9dad, 0x64f1=>0x9da6, 0x64f2=>0x9db1, 0x64f4=>0x9db0, 0x64f6=>0x9daf, 0x64fa=>0x9db2, 0x64fd=>0x9db4, 0x64fe=>0x8fef, 0x6500=>0x9db3, 0x6505=>0x9db7, 0x6518=>0x9db5, 0x651c=>0x9db6, 
	0x651d=>0x9d90, 0x6523=>0x9db9, 0x6524=>0x9db8, 0x652a=>0x9d98, 0x652b=>0x9dba, 0x652c=>0x9dae, 0x652f=>0x8e78, 0x6534=>0x9dbb, 0x6535=>0x9dbc, 0x6536=>0x9dbe, 0x6537=>0x9dbd, 0x6538=>0x9dbf, 0x6539=>0x89fc, 0x653b=>0x8d55, 0x653e=>0x95fa, 0x653f=>0x90ad, 
	0x6545=>0x8ccc, 0x6548=>0x9dc1, 0x654d=>0x9dc4, 0x654f=>0x9571, 0x6551=>0x8b7e, 0x6555=>0x9dc3, 0x6556=>0x9dc2, 0x6557=>0x9473, 0x6558=>0x9dc5, 0x6559=>0x8bb3, 0x655d=>0x9dc7, 0x655e=>0x9dc6, 0x6562=>0x8ab8, 0x6563=>0x8e55, 0x6566=>0x93d6, 0x656c=>0x8c68, 
	0x6570=>0x9094, 0x6572=>0x9dc8, 0x6574=>0x90ae, 0x6575=>0x9347, 0x6577=>0x957e, 0x6578=>0x9dc9, 0x6582=>0x9dca, 0x6583=>0x9dcb, 0x6587=>0x95b6, 0x6588=>0x9b7c, 0x6589=>0x90c4, 0x658c=>0x956b, 0x658e=>0x8dd6, 0x6590=>0x94e3, 0x6591=>0x94c1, 0x6597=>0x936c, 
	0x6599=>0x97bf, 0x659b=>0x9dcd, 0x659c=>0x8ece, 0x659f=>0x9dce, 0x65a1=>0x88b4, 0x65a4=>0x8bd2, 0x65a5=>0x90cb, 0x65a7=>0x9580, 0x65ab=>0x9dcf, 0x65ac=>0x8e61, 0x65ad=>0x9266, 0x65af=>0x8e7a, 0x65b0=>0x9056, 0x65b7=>0x9dd0, 0x65b9=>0x95fb, 0x65bc=>0x8997, 
	0x65bd=>0x8e7b, 0x65c1=>0x9dd3, 0x65c3=>0x9dd1, 0x65c4=>0x9dd4, 0x65c5=>0x97b7, 0x65c6=>0x9dd2, 0x65cb=>0x90f9, 0x65cc=>0x9dd5, 0x65cf=>0x91b0, 0x65d2=>0x9dd6, 0x65d7=>0x8af8, 0x65d9=>0x9dd8, 0x65db=>0x9dd7, 0x65e0=>0x9dd9, 0x65e1=>0x9dda, 0x65e2=>0x8af9, 
	0x65e5=>0x93fa, 0x65e6=>0x9255, 0x65e7=>0x8b8c, 0x65e8=>0x8e7c, 0x65e9=>0x9181, 0x65ec=>0x8f7b, 0x65ed=>0x88ae, 0x65f1=>0x9ddb, 0x65fa=>0x89a0, 0x65fb=>0x9ddf, 0x6602=>0x8d56, 0x6603=>0x9dde, 0x6606=>0x8da9, 0x6607=>0x8fb8, 0x660a=>0x9ddd, 0x660c=>0x8fb9, 
	0x660e=>0x96be, 0x660f=>0x8da8, 0x6613=>0x88d5, 0x6614=>0x90cc, 0x661c=>0x9de4, 0x661f=>0x90af, 0x6620=>0x8966, 0x6625=>0x8f74, 0x6627=>0x9686, 0x6628=>0x8df0, 0x662d=>0x8fba, 0x662f=>0x90a5, 0x6634=>0x9de3, 0x6635=>0x9de1, 0x6636=>0x9de2, 0x663c=>0x928b, 
	0x663f=>0x9e45, 0x6641=>0x9de8, 0x6642=>0x8e9e, 0x6643=>0x8d57, 0x6644=>0x9de6, 0x6649=>0x9de7, 0x664b=>0x9057, 0x664f=>0x9de5, 0x6652=>0x8e4e, 0x665d=>0x9dea, 0x665e=>0x9de9, 0x665f=>0x9dee, 0x6662=>0x9def, 0x6664=>0x9deb, 0x6666=>0x8a41, 0x6667=>0x9dec, 
	0x6668=>0x9ded, 0x6669=>0x94d3, 0x666e=>0x9581, 0x666f=>0x8c69, 0x6670=>0x9df0, 0x6674=>0x90b0, 0x6676=>0x8fbb, 0x667a=>0x9271, 0x6681=>0x8bc5, 0x6683=>0x9df1, 0x6684=>0x9df5, 0x6687=>0x89c9, 0x6688=>0x9df2, 0x6689=>0x9df4, 0x668e=>0x9df3, 0x6691=>0x8f8b, 
	0x6696=>0x9267, 0x6697=>0x88c3, 0x6698=>0x9df6, 0x669d=>0x9df7, 0x66a2=>0x92a8, 0x66a6=>0x97ef, 0x66ab=>0x8e62, 0x66ae=>0x95e9, 0x66b4=>0x965c, 0x66b8=>0x9e41, 0x66b9=>0x9df9, 0x66bc=>0x9dfc, 0x66be=>0x9dfb, 0x66c1=>0x9df8, 0x66c4=>0x9e40, 0x66c7=>0x93dc, 
	0x66c9=>0x9dfa, 0x66d6=>0x9e42, 0x66d9=>0x8f8c, 0x66da=>0x9e43, 0x66dc=>0x976a, 0x66dd=>0x9498, 0x66e0=>0x9e44, 0x66e6=>0x9e46, 0x66e9=>0x9e47, 0x66f0=>0x9e48, 0x66f2=>0x8bc8, 0x66f3=>0x8967, 0x66f4=>0x8d58, 0x66f5=>0x9e49, 0x66f7=>0x9e4a, 0x66f8=>0x8f91, 
	0x66f9=>0x9182, 0x66fc=>0x99d6, 0x66fd=>0x915d, 0x66fe=>0x915c, 0x66ff=>0x91d6, 0x6700=>0x8dc5, 0x6703=>0x98f0, 0x6708=>0x8c8e, 0x6709=>0x974c, 0x670b=>0x95fc, 0x670d=>0x959e, 0x670f=>0x9e4b, 0x6714=>0x8df1, 0x6715=>0x92bd, 0x6716=>0x9e4c, 0x6717=>0x984e, 
	0x671b=>0x965d, 0x671d=>0x92a9, 0x671e=>0x9e4d, 0x671f=>0x8afa, 0x6726=>0x9e4e, 0x6727=>0x9e4f, 0x6728=>0x96d8, 0x672a=>0x96a2, 0x672b=>0x9696, 0x672c=>0x967b, 0x672d=>0x8e44, 0x672e=>0x9e51, 0x6731=>0x8ee9, 0x6734=>0x9670, 0x6736=>0x9e53, 0x6737=>0x9e56, 
	0x6738=>0x9e55, 0x673a=>0x8af7, 0x673d=>0x8b80, 0x673f=>0x9e52, 0x6741=>0x9e54, 0x6746=>0x9e57, 0x6749=>0x9099, 0x674e=>0x979b, 0x674f=>0x88c7, 0x6750=>0x8dde, 0x6751=>0x91ba, 0x6753=>0x8edb, 0x6756=>0x8ff1, 0x6759=>0x9e5a, 0x675c=>0x936d, 0x675e=>0x9e58, 
	0x675f=>0x91a9, 0x6760=>0x9e59, 0x6761=>0x8ff0, 0x6762=>0x96db, 0x6763=>0x9e5b, 0x6764=>0x9e5c, 0x6765=>0x9788, 0x676a=>0x9e61, 0x676d=>0x8d59, 0x676f=>0x9474, 0x6770=>0x9e5e, 0x6771=>0x938c, 0x6772=>0x9ddc, 0x6773=>0x9de0, 0x6775=>0x8b6e, 0x6777=>0x9466, 
	0x677c=>0x9e60, 0x677e=>0x8fbc, 0x677f=>0x94c2, 0x6785=>0x9e66, 0x6787=>0x94f8, 0x6789=>0x9e5d, 0x678b=>0x9e63, 0x678c=>0x9e62, 0x6790=>0x90cd, 0x6795=>0x968d, 0x6797=>0x97d1, 0x679a=>0x9687, 0x679c=>0x89ca, 0x679d=>0x8e7d, 0x67a0=>0x9867, 0x67a1=>0x9e65, 
	0x67a2=>0x9095, 0x67a6=>0x9e64, 0x67a9=>0x9e5f, 0x67af=>0x8ccd, 0x67b3=>0x9e6b, 0x67b4=>0x9e69, 0x67b6=>0x89cb, 0x67b7=>0x9e67, 0x67b8=>0x9e6d, 0x67b9=>0x9e73, 0x67c1=>0x91c6, 0x67c4=>0x95bf, 0x67c6=>0x9e75, 0x67ca=>0x9541, 0x67ce=>0x9e74, 0x67cf=>0x9490, 
	0x67d0=>0x965e, 0x67d1=>0x8ab9, 0x67d3=>0x90f5, 0x67d4=>0x8f5f, 0x67d8=>0x92d1, 0x67da=>0x974d, 0x67dd=>0x9e70, 0x67de=>0x9e6f, 0x67e2=>0x9e71, 0x67e4=>0x9e6e, 0x67e7=>0x9e76, 0x67e9=>0x9e6c, 0x67ec=>0x9e6a, 0x67ee=>0x9e72, 0x67ef=>0x9e68, 0x67f1=>0x928c, 
	0x67f3=>0x96f6, 0x67f4=>0x8ec4, 0x67f5=>0x8df2, 0x67fb=>0x8db8, 0x67fe=>0x968f, 0x67ff=>0x8a60, 0x6802=>0x92cc, 0x6803=>0x93c8, 0x6804=>0x8968, 0x6813=>0x90f0, 0x6816=>0x90b2, 0x6817=>0x8c49, 0x681e=>0x9e78, 0x6821=>0x8d5a, 0x6822=>0x8a9c, 0x6829=>0x9e7a, 
	0x682a=>0x8a94, 0x682b=>0x9e81, 0x6832=>0x9e7d, 0x6834=>0x90f1, 0x6838=>0x8a6a, 0x6839=>0x8daa, 0x683c=>0x8a69, 0x683d=>0x8dcd, 0x6840=>0x9e7b, 0x6841=>0x8c85, 0x6842=>0x8c6a, 0x6843=>0x938d, 0x6846=>0x9e79, 0x6848=>0x88c4, 0x684d=>0x9e7c, 0x684e=>0x9e7e, 
	0x6850=>0x8bcb, 0x6851=>0x8c4b, 0x6853=>0x8aba, 0x6854=>0x8b6a, 0x6859=>0x9e82, 0x685c=>0x8df7, 0x685d=>0x9691, 0x685f=>0x8e56, 0x6863=>0x9e83, 0x6867=>0x954f, 0x6874=>0x9e8f, 0x6876=>0x89b1, 0x6877=>0x9e84, 0x687e=>0x9e95, 0x687f=>0x9e85, 0x6881=>0x97c0, 
	0x6883=>0x9e8c, 0x6885=>0x947e, 0x688d=>0x9e94, 0x688f=>0x9e87, 0x6893=>0x88b2, 0x6894=>0x9e89, 0x6897=>0x8d5b, 0x689b=>0x9e8b, 0x689d=>0x9e8a, 0x689f=>0x9e86, 0x68a0=>0x9e91, 0x68a2=>0x8fbd, 0x68a6=>0x9aeb, 0x68a7=>0x8ce6, 0x68a8=>0x979c, 0x68ad=>0x9e88, 
	0x68af=>0x92f2, 0x68b0=>0x8a42, 0x68b1=>0x8dab, 0x68b3=>0x9e80, 0x68b5=>0x9e90, 0x68b6=>0x8a81, 0x68b9=>0x9e8e, 0x68ba=>0x9e92, 0x68bc=>0x938e, 0x68c4=>0x8afc, 0x68c6=>0x9eb0, 0x68c9=>0x96c7, 0x68ca=>0x9e97, 0x68cb=>0x8afb, 0x68cd=>0x9e9e, 0x68d2=>0x965f, 
	0x68d4=>0x9e9f, 0x68d5=>0x9ea1, 0x68d7=>0x9ea5, 0x68d8=>0x9e99, 0x68da=>0x9249, 0x68df=>0x938f, 0x68e0=>0x9ea9, 0x68e1=>0x9e9c, 0x68e3=>0x9ea6, 0x68e7=>0x9ea0, 0x68ee=>0x9058, 0x68ef=>0x9eaa, 0x68f2=>0x90b1, 0x68f9=>0x9ea8, 0x68fa=>0x8abb, 0x6900=>0x986f, 
	0x6901=>0x9e96, 0x6904=>0x9ea4, 0x6905=>0x88d6, 0x6908=>0x9e98, 0x690b=>0x96b8, 0x690c=>0x9e9d, 0x690d=>0x9041, 0x690e=>0x92c5, 0x690f=>0x9e93, 0x6912=>0x9ea3, 0x6919=>0x909a, 0x691a=>0x9ead, 0x691b=>0x8a91, 0x691c=>0x8c9f, 0x6921=>0x9eaf, 0x6922=>0x9e9a, 
	0x6923=>0x9eae, 0x6925=>0x9ea7, 0x6926=>0x9e9b, 0x6928=>0x9eab, 0x692a=>0x9eac, 0x6930=>0x9ebd, 0x6934=>0x93cc, 0x6936=>0x9ea2, 0x6939=>0x9eb9, 0x693d=>0x9ebb, 0x693f=>0x92d6, 0x694a=>0x976b, 0x6953=>0x9596, 0x6954=>0x9eb6, 0x6955=>0x91c8, 0x6959=>0x9ebc, 
	0x695a=>0x915e, 0x695c=>0x9eb3, 0x695d=>0x9ec0, 0x695e=>0x9ebf, 0x6960=>0x93ed, 0x6961=>0x9ebe, 0x6962=>0x93e8, 0x696a=>0x9ec2, 0x696b=>0x9eb5, 0x696d=>0x8bc6, 0x696e=>0x9eb8, 0x696f=>0x8f7c, 0x6973=>0x9480, 0x6974=>0x9eba, 0x6975=>0x8bc9, 0x6977=>0x9eb2, 
	0x6978=>0x9eb4, 0x6979=>0x9eb1, 0x697c=>0x984f, 0x697d=>0x8a79, 0x697e=>0x9eb7, 0x6981=>0x9ec1, 0x6982=>0x8a54, 0x698a=>0x8de5, 0x698e=>0x897c, 0x6991=>0x9ed2, 0x6994=>0x9850, 0x6995=>0x9ed5, 0x699b=>0x9059, 0x699c=>0x9ed4, 0x69a0=>0x9ed3, 0x69a7=>0x9ed0, 
	0x69ae=>0x9ec4, 0x69b1=>0x9ee1, 0x69b2=>0x9ec3, 0x69b4=>0x9ed6, 0x69bb=>0x9ece, 0x69be=>0x9ec9, 0x69bf=>0x9ec6, 0x69c1=>0x9ec7, 0x69c3=>0x9ecf, 0x69c7=>0xeaa0, 0x69ca=>0x9ecc, 0x69cb=>0x8d5c, 0x69cc=>0x92c6, 0x69cd=>0x9184, 0x69ce=>0x9eca, 0x69d0=>0x9ec5, 
	0x69d3=>0x9ec8, 0x69d8=>0x976c, 0x69d9=>0x968a, 0x69dd=>0x9ecd, 0x69de=>0x9ed7, 0x69e7=>0x9edf, 0x69e8=>0x9ed8, 0x69eb=>0x9ee5, 0x69ed=>0x9ee3, 0x69f2=>0x9ede, 0x69f9=>0x9edd, 0x69fb=>0x92ce, 0x69fd=>0x9185, 0x69ff=>0x9edb, 0x6a02=>0x9ed9, 0x6a05=>0x9ee0, 
	0x6a0a=>0x9ee6, 0x6a0b=>0x94f3, 0x6a0c=>0x9eec, 0x6a12=>0x9ee7, 0x6a13=>0x9eea, 0x6a14=>0x9ee4, 0x6a17=>0x9294, 0x6a19=>0x9557, 0x6a1b=>0x9eda, 0x6a1e=>0x9ee2, 0x6a1f=>0x8fbe, 0x6a21=>0x96cd, 0x6a22=>0x9ef6, 0x6a23=>0x9ee9, 0x6a29=>0x8ca0, 0x6a2a=>0x89a1, 
	0x6a2b=>0x8a7e, 0x6a2e=>0x9ed1, 0x6a35=>0x8fbf, 0x6a36=>0x9eee, 0x6a38=>0x9ef5, 0x6a39=>0x8ef7, 0x6a3a=>0x8a92, 0x6a3d=>0x924d, 0x6a44=>0x9eeb, 0x6a47=>0x9ef0, 0x6a48=>0x9ef4, 0x6a4b=>0x8bb4, 0x6a58=>0x8b6b, 0x6a59=>0x9ef2, 0x6a5f=>0x8b40, 0x6a61=>0x93c9, 
	0x6a62=>0x9ef1, 0x6a66=>0x9ef3, 0x6a72=>0x9eed, 0x6a78=>0x9eef, 0x6a7f=>0x8a80, 0x6a80=>0x9268, 0x6a84=>0x9efa, 0x6a8d=>0x9ef8, 0x6a8e=>0x8ce7, 0x6a90=>0x9ef7, 0x6a97=>0x9f40, 0x6a9c=>0x9e77, 0x6aa0=>0x9ef9, 0x6aa2=>0x9efb, 0x6aa3=>0x9efc, 0x6aaa=>0x9f4b, 
	0x6aac=>0x9f47, 0x6aae=>0x9e8d, 0x6ab3=>0x9f46, 0x6ab8=>0x9f45, 0x6abb=>0x9f42, 0x6ac1=>0x9ee8, 0x6ac2=>0x9f44, 0x6ac3=>0x9f43, 0x6ad1=>0x9f49, 0x6ad3=>0x9845, 0x6ada=>0x9f4c, 0x6adb=>0x8bf9, 0x6ade=>0x9f48, 0x6adf=>0x9f4a, 0x6ae8=>0x94a5, 0x6aea=>0x9f4d, 
	0x6afa=>0x9f51, 0x6afb=>0x9f4e, 0x6b04=>0x9793, 0x6b05=>0x9f4f, 0x6b0a=>0x9edc, 0x6b12=>0x9f52, 0x6b16=>0x9f53, 0x6b1d=>0x8954, 0x6b1f=>0x9f55, 0x6b20=>0x8c87, 0x6b21=>0x8e9f, 0x6b23=>0x8bd3, 0x6b27=>0x89a2, 0x6b32=>0x977e, 0x6b37=>0x9f57, 0x6b38=>0x9f56, 
	0x6b39=>0x9f59, 0x6b3a=>0x8b5c, 0x6b3d=>0x8bd4, 0x6b3e=>0x8abc, 0x6b43=>0x9f5c, 0x6b47=>0x9f5b, 0x6b49=>0x9f5d, 0x6b4c=>0x89cc, 0x6b4e=>0x9256, 0x6b50=>0x9f5e, 0x6b53=>0x8abd, 0x6b54=>0x9f60, 0x6b59=>0x9f5f, 0x6b5b=>0x9f61, 0x6b5f=>0x9f62, 0x6b61=>0x9f63, 
	0x6b62=>0x8e7e, 0x6b63=>0x90b3, 0x6b64=>0x8d9f, 0x6b66=>0x9590, 0x6b69=>0x95e0, 0x6b6a=>0x9863, 0x6b6f=>0x8e95, 0x6b73=>0x8dce, 0x6b74=>0x97f0, 0x6b78=>0x9f64, 0x6b79=>0x9f65, 0x6b7b=>0x8e80, 0x6b7f=>0x9f66, 0x6b80=>0x9f67, 0x6b83=>0x9f69, 0x6b84=>0x9f68, 
	0x6b86=>0x9677, 0x6b89=>0x8f7d, 0x6b8a=>0x8eea, 0x6b8b=>0x8e63, 0x6b8d=>0x9f6a, 0x6b95=>0x9f6c, 0x6b96=>0x9042, 0x6b98=>0x9f6b, 0x6b9e=>0x9f6d, 0x6ba4=>0x9f6e, 0x6baa=>0x9f6f, 0x6bab=>0x9f70, 0x6baf=>0x9f71, 0x6bb1=>0x9f73, 0x6bb2=>0x9f72, 0x6bb3=>0x9f74, 
	0x6bb4=>0x89a3, 0x6bb5=>0x9269, 0x6bb7=>0x9f75, 0x6bba=>0x8e45, 0x6bbb=>0x8a6b, 0x6bbc=>0x9f76, 0x6bbf=>0x9361, 0x6bc0=>0x9aca, 0x6bc5=>0x8b42, 0x6bc6=>0x9f77, 0x6bcb=>0x9f78, 0x6bcd=>0x95ea, 0x6bce=>0x9688, 0x6bd2=>0x93c5, 0x6bd3=>0x9f79, 0x6bd4=>0x94e4, 
	0x6bd8=>0x94f9, 0x6bdb=>0x96d1, 0x6bdf=>0x9f7a, 0x6beb=>0x9f7c, 0x6bec=>0x9f7b, 0x6bef=>0x9f7e, 0x6bf3=>0x9f7d, 0x6c08=>0x9f81, 0x6c0f=>0x8e81, 0x6c11=>0x96af, 0x6c13=>0x9f82, 0x6c14=>0x9f83, 0x6c17=>0x8b43, 0x6c1b=>0x9f84, 0x6c23=>0x9f86, 0x6c24=>0x9f85, 
	0x6c34=>0x9085, 0x6c37=>0x9558, 0x6c38=>0x8969, 0x6c3e=>0x94c3, 0x6c40=>0x92f3, 0x6c41=>0x8f60, 0x6c42=>0x8b81, 0x6c4e=>0x94c4, 0x6c50=>0x8eac, 0x6c55=>0x9f88, 0x6c57=>0x8abe, 0x6c5a=>0x8998, 0x6c5d=>0x93f0, 0x6c5e=>0x9f87, 0x6c5f=>0x8d5d, 0x6c60=>0x9272, 
	0x6c62=>0x9f89, 0x6c68=>0x9f91, 0x6c6a=>0x9f8a, 0x6c70=>0x91bf, 0x6c72=>0x8b82, 0x6c73=>0x9f92, 0x6c7a=>0x8c88, 0x6c7d=>0x8b44, 0x6c7e=>0x9f90, 0x6c81=>0x9f8e, 0x6c82=>0x9f8b, 0x6c83=>0x9780, 0x6c88=>0x92be, 0x6c8c=>0x93d7, 0x6c8d=>0x9f8c, 0x6c90=>0x9f94, 
	0x6c92=>0x9f93, 0x6c93=>0x8c42, 0x6c96=>0x89ab, 0x6c99=>0x8db9, 0x6c9a=>0x9f8d, 0x6c9b=>0x9f8f, 0x6ca1=>0x9676, 0x6ca2=>0x91f2, 0x6cab=>0x9697, 0x6cae=>0x9f9c, 0x6cb1=>0x9f9d, 0x6cb3=>0x89cd, 0x6cb8=>0x95a6, 0x6cb9=>0x96fb, 0x6cba=>0x9f9f, 0x6cbb=>0x8ea1, 
	0x6cbc=>0x8fc0, 0x6cbd=>0x9f98, 0x6cbe=>0x9f9e, 0x6cbf=>0x8988, 0x6cc1=>0x8bb5, 0x6cc4=>0x9f95, 0x6cc5=>0x9f9a, 0x6cc9=>0x90f2, 0x6cca=>0x9491, 0x6ccc=>0x94e5, 0x6cd3=>0x9f97, 0x6cd5=>0x9640, 0x6cd7=>0x9f99, 0x6cd9=>0x9fa2, 0x6cdb=>0x9fa0, 0x6cdd=>0x9f9b, 
	0x6ce1=>0x9641, 0x6ce2=>0x9467, 0x6ce3=>0x8b83, 0x6ce5=>0x9344, 0x6ce8=>0x928d, 0x6cea=>0x9fa3, 0x6cef=>0x9fa1, 0x6cf0=>0x91d7, 0x6cf1=>0x9f96, 0x6cf3=>0x896a, 0x6d0b=>0x976d, 0x6d0c=>0x9fae, 0x6d12=>0x9fad, 0x6d17=>0x90f4, 0x6d19=>0x9faa, 0x6d1b=>0x978c, 
	0x6d1e=>0x93b4, 0x6d1f=>0x9fa4, 0x6d25=>0x92c3, 0x6d29=>0x896b, 0x6d2a=>0x8d5e, 0x6d2b=>0x9fa7, 0x6d32=>0x8f46, 0x6d33=>0x9fac, 0x6d35=>0x9fab, 0x6d36=>0x9fa6, 0x6d38=>0x9fa9, 0x6d3b=>0x8a88, 0x6d3d=>0x9fa8, 0x6d3e=>0x9468, 0x6d41=>0x97ac, 0x6d44=>0x8ff2, 
	0x6d45=>0x90f3, 0x6d59=>0x9fb4, 0x6d5a=>0x9fb2, 0x6d5c=>0x956c, 0x6d63=>0x9faf, 0x6d64=>0x9fb1, 0x6d66=>0x8959, 0x6d69=>0x8d5f, 0x6d6a=>0x9851, 0x6d6c=>0x8a5c, 0x6d6e=>0x9582, 0x6d74=>0x9781, 0x6d77=>0x8a43, 0x6d78=>0x905a, 0x6d79=>0x9fb3, 0x6d85=>0x9fb8, 
	0x6d88=>0x8fc1, 0x6d8c=>0x974f, 0x6d8e=>0x9fb5, 0x6d93=>0x9fb0, 0x6d95=>0x9fb6, 0x6d99=>0x97dc, 0x6d9b=>0x9393, 0x6d9c=>0x93c0, 0x6daf=>0x8a55, 0x6db2=>0x8974, 0x6db5=>0x9fbc, 0x6db8=>0x9fbf, 0x6dbc=>0x97c1, 0x6dc0=>0x9784, 0x6dc5=>0x9fc6, 0x6dc6=>0x9fc0, 
	0x6dc7=>0x9fbd, 0x6dcb=>0x97d2, 0x6dcc=>0x9fc3, 0x6dd1=>0x8f69, 0x6dd2=>0x9fc5, 0x6dd5=>0x9fca, 0x6dd8=>0x9391, 0x6dd9=>0x9fc8, 0x6dde=>0x9fc2, 0x6de1=>0x9257, 0x6de4=>0x9fc9, 0x6de6=>0x9fbe, 0x6de8=>0x9fc4, 0x6dea=>0x9fcb, 0x6deb=>0x88fa, 0x6dec=>0x9fc1, 
	0x6dee=>0x9fcc, 0x6df1=>0x905b, 0x6df3=>0x8f7e, 0x6df5=>0x95a3, 0x6df7=>0x8dac, 0x6df9=>0x9fb9, 0x6dfa=>0x9fc7, 0x6dfb=>0x9359, 0x6e05=>0x90b4, 0x6e07=>0x8a89, 0x6e08=>0x8dcf, 0x6e09=>0x8fc2, 0x6e0a=>0x9fbb, 0x6e0b=>0x8f61, 0x6e13=>0x8c6b, 0x6e15=>0x9fba, 
	0x6e19=>0x9fd0, 0x6e1a=>0x8f8d, 0x6e1b=>0x8cb8, 0x6e1d=>0x9fdf, 0x6e1f=>0x9fd9, 0x6e20=>0x8b94, 0x6e21=>0x936e, 0x6e23=>0x9fd4, 0x6e24=>0x9fdd, 0x6e25=>0x88ad, 0x6e26=>0x8951, 0x6e29=>0x89b7, 0x6e2b=>0x9fd6, 0x6e2c=>0x91aa, 0x6e2d=>0x9fcd, 0x6e2e=>0x9fcf, 
	0x6e2f=>0x8d60, 0x6e38=>0x9fe0, 0x6e3a=>0x9fdb, 0x6e3e=>0x9fd3, 0x6e43=>0x9fda, 0x6e4a=>0x96a9, 0x6e4d=>0x9fd8, 0x6e4e=>0x9fdc, 0x6e56=>0x8cce, 0x6e58=>0x8fc3, 0x6e5b=>0x9258, 0x6e5f=>0x9fd2, 0x6e67=>0x974e, 0x6e6b=>0x9fd5, 0x6e6e=>0x9fce, 0x6e6f=>0x9392, 
	0x6e72=>0x9fd1, 0x6e76=>0x9fd7, 0x6e7e=>0x9870, 0x6e7f=>0x8ebc, 0x6e80=>0x969e, 0x6e82=>0x9fe1, 0x6e8c=>0x94ac, 0x6e8f=>0x9fed, 0x6e90=>0x8cb9, 0x6e96=>0x8f80, 0x6e98=>0x9fe3, 0x6e9c=>0x97ad, 0x6e9d=>0x8d61, 0x6e9f=>0x9ff0, 0x6ea2=>0x88ec, 0x6ea5=>0x9fee, 
	0x6eaa=>0x9fe2, 0x6eaf=>0x9fe8, 0x6eb2=>0x9fea, 0x6eb6=>0x976e, 0x6eb7=>0x9fe5, 0x6eba=>0x934d, 0x6ebd=>0x9fe7, 0x6ec2=>0x9fef, 0x6ec4=>0x9fe9, 0x6ec5=>0x96c5, 0x6ec9=>0x9fe4, 0x6ecb=>0x8ea0, 0x6ecc=>0x9ffc, 0x6ed1=>0x8a8a, 0x6ed3=>0x9fe6, 0x6ed4=>0x9feb, 
	0x6ed5=>0x9fec, 0x6edd=>0x91ea, 0x6ede=>0x91d8, 0x6eec=>0x9ff4, 0x6eef=>0x9ffa, 0x6ef2=>0x9ff8, 0x6ef4=>0x9348, 0x6ef7=>0xe042, 0x6ef8=>0x9ff5, 0x6efe=>0x9ff6, 0x6eff=>0x9fde, 0x6f01=>0x8b99, 0x6f02=>0x9559, 0x6f06=>0x8ebd, 0x6f09=>0x8d97, 0x6f0f=>0x9852, 
	0x6f11=>0x9ff2, 0x6f13=>0xe041, 0x6f14=>0x8989, 0x6f15=>0x9186, 0x6f20=>0x9499, 0x6f22=>0x8abf, 0x6f23=>0x97f8, 0x6f2b=>0x969f, 0x6f2c=>0x92d0, 0x6f31=>0x9ff9, 0x6f32=>0x9ffb, 0x6f38=>0x9151, 0x6f3e=>0xe040, 0x6f3f=>0x9ff7, 0x6f41=>0x9ff1, 0x6f45=>0x8ac1, 
	0x6f54=>0x8c89, 0x6f58=>0xe04e, 0x6f5b=>0xe049, 0x6f5c=>0x90f6, 0x6f5f=>0x8a83, 0x6f64=>0x8f81, 0x6f66=>0xe052, 0x6f6d=>0xe04b, 0x6f6e=>0x92aa, 0x6f6f=>0xe048, 0x6f70=>0x92d7, 0x6f74=>0xe06b, 0x6f78=>0xe045, 0x6f7a=>0xe044, 0x6f7c=>0xe04d, 0x6f80=>0xe047, 
	0x6f81=>0xe046, 0x6f82=>0xe04c, 0x6f84=>0x909f, 0x6f86=>0xe043, 0x6f8e=>0xe04f, 0x6f91=>0xe050, 0x6f97=>0x8ac0, 0x6fa1=>0xe055, 0x6fa3=>0xe054, 0x6fa4=>0xe056, 0x6faa=>0xe059, 0x6fb1=>0x9362, 0x6fb3=>0xe053, 0x6fb9=>0xe057, 0x6fc0=>0x8c83, 0x6fc1=>0x91f7, 
	0x6fc2=>0xe051, 0x6fc3=>0x945a, 0x6fc6=>0xe058, 0x6fd4=>0xe05d, 0x6fd5=>0xe05b, 0x6fd8=>0xe05e, 0x6fdb=>0xe061, 0x6fdf=>0xe05a, 0x6fe0=>0x8d8a, 0x6fe1=>0x9447, 0x6fe4=>0x9fb7, 0x6feb=>0x9794, 0x6fec=>0xe05c, 0x6fee=>0xe060, 0x6fef=>0x91f3, 0x6ff1=>0xe05f, 
	0x6ff3=>0xe04a, 0x6ff6=>0xe889, 0x6ffa=>0xe064, 0x6ffe=>0xe068, 0x7001=>0xe066, 0x7009=>0xe062, 0x700b=>0xe063, 0x700f=>0xe067, 0x7011=>0xe065, 0x7015=>0x956d, 0x7018=>0xe06d, 0x701a=>0xe06a, 0x701b=>0xe069, 0x701d=>0xe06c, 0x701e=>0x93d2, 0x701f=>0xe06e, 
	0x7026=>0x9295, 0x7027=>0x91eb, 0x702c=>0x90a3, 0x7030=>0xe06f, 0x7032=>0xe071, 0x703e=>0xe070, 0x704c=>0x9ff3, 0x7051=>0xe072, 0x7058=>0x93e5, 0x7063=>0xe073, 0x706b=>0x89ce, 0x706f=>0x9394, 0x7070=>0x8a44, 0x7078=>0x8b84, 0x707c=>0x8edc, 0x707d=>0x8dd0, 
	0x7089=>0x9846, 0x708a=>0x9086, 0x708e=>0x898a, 0x7092=>0xe075, 0x7099=>0xe074, 0x70ac=>0xe078, 0x70ad=>0x9259, 0x70ae=>0xe07b, 0x70af=>0xe076, 0x70b3=>0xe07a, 0x70b8=>0xe079, 0x70b9=>0x935f, 0x70ba=>0x88d7, 0x70c8=>0x97f3, 0x70cb=>0xe07d, 0x70cf=>0x8947, 
	0x70d9=>0xe080, 0x70dd=>0xe07e, 0x70df=>0xe07c, 0x70f1=>0xe077, 0x70f9=>0x9642, 0x70fd=>0xe082, 0x7109=>0xe081, 0x7114=>0x898b, 0x7119=>0xe084, 0x711a=>0x95b0, 0x711c=>0xe083, 0x7121=>0x96b3, 0x7126=>0x8fc5, 0x7136=>0x9152, 0x713c=>0x8fc4, 0x7149=>0x97f9, 
	0x714c=>0xe08a, 0x714e=>0x90f7, 0x7155=>0xe086, 0x7156=>0xe08b, 0x7159=>0x898c, 0x7162=>0xe089, 0x7164=>0x9481, 0x7165=>0xe085, 0x7166=>0xe088, 0x7167=>0x8fc6, 0x7169=>0x94cf, 0x716c=>0xe08c, 0x716e=>0x8ecf, 0x717d=>0x90f8, 0x7184=>0xe08f, 0x7188=>0xe087, 
	0x718a=>0x8c46, 0x718f=>0xe08d, 0x7194=>0x976f, 0x7195=>0xe090, 0x7199=>0xeaa4, 0x719f=>0x8f6e, 0x71a8=>0xe091, 0x71ac=>0xe092, 0x71b1=>0x944d, 0x71b9=>0xe094, 0x71be=>0xe095, 0x71c3=>0x9452, 0x71c8=>0x9395, 0x71c9=>0xe097, 0x71ce=>0xe099, 0x71d0=>0x97d3, 
	0x71d2=>0xe096, 0x71d4=>0xe098, 0x71d5=>0x898d, 0x71d7=>0xe093, 0x71df=>0x9a7a, 0x71e0=>0xe09a, 0x71e5=>0x9187, 0x71e6=>0x8e57, 0x71e7=>0xe09c, 0x71ec=>0xe09b, 0x71ed=>0x9043, 0x71ee=>0x99d7, 0x71f5=>0xe09d, 0x71f9=>0xe09f, 0x71fb=>0xe08e, 0x71fc=>0xe09e, 
	0x71ff=>0xe0a0, 0x7206=>0x949a, 0x720d=>0xe0a1, 0x7210=>0xe0a2, 0x721b=>0xe0a3, 0x7228=>0xe0a4, 0x722a=>0x92dc, 0x722c=>0xe0a6, 0x722d=>0xe0a5, 0x7230=>0xe0a7, 0x7232=>0xe0a8, 0x7235=>0x8edd, 0x7236=>0x9583, 0x723a=>0x96ea, 0x723b=>0xe0a9, 0x723c=>0xe0aa, 
	0x723d=>0x9175, 0x723e=>0x8ea2, 0x723f=>0xe0ab, 0x7240=>0xe0ac, 0x7246=>0xe0ad, 0x7247=>0x95d0, 0x7248=>0x94c5, 0x724b=>0xe0ae, 0x724c=>0x9476, 0x7252=>0x92ab, 0x7258=>0xe0af, 0x7259=>0x89e5, 0x725b=>0x8b8d, 0x725d=>0x96c4, 0x725f=>0x96b4, 0x7261=>0x89b2, 
	0x7262=>0x9853, 0x7267=>0x9671, 0x7269=>0x95a8, 0x7272=>0x90b5, 0x7274=>0xe0b0, 0x7279=>0x93c1, 0x727d=>0x8ca1, 0x727e=>0xe0b1, 0x7280=>0x8dd2, 0x7281=>0xe0b3, 0x7282=>0xe0b2, 0x7287=>0xe0b4, 0x7292=>0xe0b5, 0x7296=>0xe0b6, 0x72a0=>0x8b5d, 0x72a2=>0xe0b7, 
	0x72a7=>0xe0b8, 0x72ac=>0x8ca2, 0x72af=>0x94c6, 0x72b2=>0xe0ba, 0x72b6=>0x8ff3, 0x72b9=>0xe0b9, 0x72c2=>0x8bb6, 0x72c3=>0xe0bb, 0x72c4=>0xe0bd, 0x72c6=>0xe0bc, 0x72ce=>0xe0be, 0x72d0=>0x8ccf, 0x72d2=>0xe0bf, 0x72d7=>0x8be7, 0x72d9=>0x915f, 0x72db=>0x8d9d, 
	0x72e0=>0xe0c1, 0x72e1=>0xe0c2, 0x72e2=>0xe0c0, 0x72e9=>0x8eeb, 0x72ec=>0x93c6, 0x72ed=>0x8bb7, 0x72f7=>0xe0c4, 0x72f8=>0x924b, 0x72f9=>0xe0c3, 0x72fc=>0x9854, 0x72fd=>0x9482, 0x730a=>0xe0c7, 0x7316=>0xe0c9, 0x7317=>0xe0c6, 0x731b=>0x96d2, 0x731c=>0xe0c8, 
	0x731d=>0xe0ca, 0x731f=>0x97c2, 0x7325=>0xe0ce, 0x7329=>0xe0cd, 0x732a=>0x9296, 0x732b=>0x944c, 0x732e=>0x8ca3, 0x732f=>0xe0cc, 0x7334=>0xe0cb, 0x7336=>0x9750, 0x7337=>0x9751, 0x733e=>0xe0cf, 0x733f=>0x898e, 0x7344=>0x8d96, 0x7345=>0x8e82, 0x734e=>0xe0d0, 
	0x734f=>0xe0d1, 0x7357=>0xe0d3, 0x7363=>0x8f62, 0x7368=>0xe0d5, 0x736a=>0xe0d4, 0x7370=>0xe0d6, 0x7372=>0x8a6c, 0x7375=>0xe0d8, 0x7378=>0xe0d7, 0x737a=>0xe0da, 0x737b=>0xe0d9, 0x7384=>0x8cba, 0x7387=>0x97a6, 0x7389=>0x8bca, 0x738b=>0x89a4, 0x7396=>0x8be8, 
	0x73a9=>0x8adf, 0x73b2=>0x97e6, 0x73b3=>0xe0dc, 0x73bb=>0xe0de, 0x73c0=>0xe0df, 0x73c2=>0x89cf, 0x73c8=>0xe0db, 0x73ca=>0x8e58, 0x73cd=>0x92bf, 0x73ce=>0xe0dd, 0x73de=>0xe0e2, 0x73e0=>0x8eec, 0x73e5=>0xe0e0, 0x73ea=>0x8c5d, 0x73ed=>0x94c7, 0x73ee=>0xe0e1, 
	0x73f1=>0xe0fc, 0x73f8=>0xe0e7, 0x73fe=>0x8cbb, 0x7403=>0x8b85, 0x7405=>0xe0e4, 0x7406=>0x979d, 0x7409=>0x97ae, 0x7422=>0x91f4, 0x7425=>0xe0e6, 0x7432=>0xe0e8, 0x7433=>0x97d4, 0x7434=>0x8bd5, 0x7435=>0x94fa, 0x7436=>0x9469, 0x743a=>0xe0e9, 0x743f=>0xe0eb, 
	0x7441=>0xe0ee, 0x7455=>0xe0ea, 0x7459=>0xe0ed, 0x745a=>0x8ce8, 0x745b=>0x896c, 0x745c=>0xe0ef, 0x745e=>0x9090, 0x745f=>0xe0ec, 0x7460=>0x97da, 0x7463=>0xe0f2, 0x7464=>0xeaa2, 0x7469=>0xe0f0, 0x746a=>0xe0f3, 0x746f=>0xe0e5, 0x7470=>0xe0f1, 0x7473=>0x8dba, 
	0x7476=>0xe0f4, 0x747e=>0xe0f5, 0x7483=>0x979e, 0x748b=>0xe0f6, 0x749e=>0xe0f7, 0x74a2=>0xe0e3, 0x74a7=>0xe0f8, 0x74b0=>0x8ac2, 0x74bd=>0x8ea3, 0x74ca=>0xe0f9, 0x74cf=>0xe0fa, 0x74d4=>0xe0fb, 0x74dc=>0x895a, 0x74e0=>0xe140, 0x74e2=>0x955a, 0x74e3=>0xe141, 
	0x74e6=>0x8aa2, 0x74e7=>0xe142, 0x74e9=>0xe143, 0x74ee=>0xe144, 0x74f0=>0xe146, 0x74f1=>0xe147, 0x74f2=>0xe145, 0x74f6=>0x9572, 0x74f7=>0xe149, 0x74f8=>0xe148, 0x7503=>0xe14b, 0x7504=>0xe14a, 0x7505=>0xe14c, 0x750c=>0xe14d, 0x750d=>0xe14f, 0x750e=>0xe14e, 
	0x7511=>0x8d99, 0x7513=>0xe151, 0x7515=>0xe150, 0x7518=>0x8ac3, 0x751a=>0x9072, 0x751c=>0x935b, 0x751e=>0xe152, 0x751f=>0x90b6, 0x7523=>0x8e59, 0x7525=>0x8999, 0x7526=>0xe153, 0x7528=>0x9770, 0x752b=>0x95e1, 0x752c=>0xe154, 0x7530=>0x9363, 0x7531=>0x9752, 
	0x7532=>0x8d62, 0x7533=>0x905c, 0x7537=>0x926a, 0x7538=>0x99b2, 0x753a=>0x92ac, 0x753b=>0x89e6, 0x753c=>0xe155, 0x7544=>0xe156, 0x7546=>0xe15b, 0x7549=>0xe159, 0x754a=>0xe158, 0x754b=>0x9dc0, 0x754c=>0x8a45, 0x754d=>0xe157, 0x754f=>0x88d8, 0x7551=>0x94a8, 
	0x7554=>0x94c8, 0x7559=>0x97af, 0x755a=>0xe15c, 0x755b=>0xe15a, 0x755c=>0x927b, 0x755d=>0x90a4, 0x7560=>0x94a9, 0x7562=>0x954c, 0x7564=>0xe15e, 0x7565=>0x97aa, 0x7566=>0x8c6c, 0x7567=>0xe15f, 0x7569=>0xe15d, 0x756a=>0x94d4, 0x756b=>0xe160, 0x756d=>0xe161, 
	0x7570=>0x88d9, 0x7573=>0x8ff4, 0x7574=>0xe166, 0x7576=>0xe163, 0x7577=>0x93eb, 0x7578=>0xe162, 0x757f=>0x8b45, 0x7582=>0xe169, 0x7586=>0xe164, 0x7587=>0xe165, 0x7589=>0xe168, 0x758a=>0xe167, 0x758b=>0x9544, 0x758e=>0x9161, 0x758f=>0x9160, 0x7591=>0x8b5e, 
	0x7594=>0xe16a, 0x759a=>0xe16b, 0x759d=>0xe16c, 0x75a3=>0xe16e, 0x75a5=>0xe16d, 0x75ab=>0x8975, 0x75b1=>0xe176, 0x75b2=>0x94e6, 0x75b3=>0xe170, 0x75b5=>0xe172, 0x75b8=>0xe174, 0x75b9=>0x905d, 0x75bc=>0xe175, 0x75bd=>0xe173, 0x75be=>0x8ebe, 0x75c2=>0xe16f, 
	0x75c3=>0xe171, 0x75c5=>0x9561, 0x75c7=>0x8fc7, 0x75ca=>0xe178, 0x75cd=>0xe177, 0x75d2=>0xe179, 0x75d4=>0x8ea4, 0x75d5=>0x8dad, 0x75d8=>0x9397, 0x75d9=>0xe17a, 0x75db=>0x92c9, 0x75de=>0xe17c, 0x75e2=>0x979f, 0x75e3=>0xe17b, 0x75e9=>0x9189, 0x75f0=>0xe182, 
	0x75f2=>0xe184, 0x75f3=>0xe185, 0x75f4=>0x9273, 0x75fa=>0xe183, 0x75fc=>0xe180, 0x75fe=>0xe17d, 0x75ff=>0xe17e, 0x7601=>0xe181, 0x7609=>0xe188, 0x760b=>0xe186, 0x760d=>0xe187, 0x761f=>0xe189, 0x7620=>0xe18b, 0x7621=>0xe18c, 0x7622=>0xe18d, 0x7624=>0xe18e, 
	0x7627=>0xe18a, 0x7630=>0xe190, 0x7634=>0xe18f, 0x763b=>0xe191, 0x7642=>0x97c3, 0x7646=>0xe194, 0x7647=>0xe192, 0x7648=>0xe193, 0x764c=>0x8ae0, 0x7652=>0x96fc, 0x7656=>0x95c8, 0x7658=>0xe196, 0x765c=>0xe195, 0x7661=>0xe197, 0x7662=>0xe198, 0x7667=>0xe19c, 
	0x7668=>0xe199, 0x7669=>0xe19a, 0x766a=>0xe19b, 0x766c=>0xe19d, 0x7670=>0xe19e, 0x7672=>0xe19f, 0x7676=>0xe1a0, 0x7678=>0xe1a1, 0x767a=>0x94ad, 0x767b=>0x936f, 0x767c=>0xe1a2, 0x767d=>0x9492, 0x767e=>0x9553, 0x7680=>0xe1a3, 0x7683=>0xe1a4, 0x7684=>0x9349, 
	0x7686=>0x8a46, 0x7687=>0x8d63, 0x7688=>0xe1a5, 0x768b=>0xe1a6, 0x768e=>0xe1a7, 0x7690=>0x8e48, 0x7693=>0xe1a9, 0x7696=>0xe1a8, 0x7699=>0xe1aa, 0x769a=>0xe1ab, 0x76ae=>0x94e7, 0x76b0=>0xe1ac, 0x76b4=>0xe1ad, 0x76b7=>0xea89, 0x76b8=>0xe1ae, 0x76b9=>0xe1af, 
	0x76ba=>0xe1b0, 0x76bf=>0x8e4d, 0x76c2=>0xe1b1, 0x76c3=>0x9475, 0x76c6=>0x967e, 0x76c8=>0x896d, 0x76ca=>0x8976, 0x76cd=>0xe1b2, 0x76d2=>0xe1b4, 0x76d6=>0xe1b3, 0x76d7=>0x9390, 0x76db=>0x90b7, 0x76dc=>0x9f58, 0x76de=>0xe1b5, 0x76df=>0x96bf, 0x76e1=>0xe1b6, 
	0x76e3=>0x8ac4, 0x76e4=>0x94d5, 0x76e5=>0xe1b7, 0x76e7=>0xe1b8, 0x76ea=>0xe1b9, 0x76ee=>0x96da, 0x76f2=>0x96d3, 0x76f4=>0x92bc, 0x76f8=>0x918a, 0x76fb=>0xe1bb, 0x76fe=>0x8f82, 0x7701=>0x8fc8, 0x7704=>0xe1be, 0x7707=>0xe1bd, 0x7708=>0xe1bc, 0x7709=>0x94fb, 
	0x770b=>0x8ac5, 0x770c=>0x8ca7, 0x771b=>0xe1c4, 0x771e=>0xe1c1, 0x771f=>0x905e, 0x7720=>0x96b0, 0x7724=>0xe1c0, 0x7725=>0xe1c2, 0x7726=>0xe1c3, 0x7729=>0xe1bf, 0x7737=>0xe1c5, 0x7738=>0xe1c6, 0x773a=>0x92ad, 0x773c=>0x8ae1, 0x7740=>0x9285, 0x7747=>0xe1c7, 
	0x775a=>0xe1c8, 0x775b=>0xe1cb, 0x7761=>0x9087, 0x7763=>0x93c2, 0x7765=>0xe1cc, 0x7766=>0x9672, 0x7768=>0xe1c9, 0x776b=>0xe1ca, 0x7779=>0xe1cf, 0x777e=>0xe1ce, 0x777f=>0xe1cd, 0x778b=>0xe1d1, 0x778e=>0xe1d0, 0x7791=>0xe1d2, 0x779e=>0xe1d4, 0x77a0=>0xe1d3, 
	0x77a5=>0x95cb, 0x77ac=>0x8f75, 0x77ad=>0x97c4, 0x77b0=>0xe1d5, 0x77b3=>0x93b5, 0x77b6=>0xe1d6, 0x77b9=>0xe1d7, 0x77bb=>0xe1db, 0x77bc=>0xe1d9, 0x77bd=>0xe1da, 0x77bf=>0xe1d8, 0x77c7=>0xe1dc, 0x77cd=>0xe1dd, 0x77d7=>0xe1de, 0x77da=>0xe1df, 0x77db=>0x96b5, 
	0x77dc=>0xe1e0, 0x77e2=>0x96ee, 0x77e3=>0xe1e1, 0x77e5=>0x926d, 0x77e7=>0x948a, 0x77e9=>0x8be9, 0x77ed=>0x925a, 0x77ee=>0xe1e2, 0x77ef=>0x8bb8, 0x77f3=>0x90ce, 0x77fc=>0xe1e3, 0x7802=>0x8dbb, 0x780c=>0xe1e4, 0x7812=>0xe1e5, 0x7814=>0x8ca4, 0x7815=>0x8dd3, 
	0x7820=>0xe1e7, 0x7825=>0x9375, 0x7826=>0x8dd4, 0x7827=>0x8b6d, 0x7832=>0x9643, 0x7834=>0x946a, 0x783a=>0x9376, 0x783f=>0x8d7b, 0x7845=>0xe1e9, 0x785d=>0x8fc9, 0x786b=>0x97b0, 0x786c=>0x8d64, 0x786f=>0x8ca5, 0x7872=>0x94a1, 0x7874=>0xe1eb, 0x787c=>0xe1ed, 
	0x7881=>0x8ce9, 0x7886=>0xe1ec, 0x7887=>0x92f4, 0x788c=>0xe1ef, 0x788d=>0x8a56, 0x788e=>0xe1ea, 0x7891=>0x94e8, 0x7893=>0x894f, 0x7895=>0x8dea, 0x7897=>0x9871, 0x789a=>0xe1ee, 0x78a3=>0xe1f0, 0x78a7=>0x95c9, 0x78a9=>0x90d7, 0x78aa=>0xe1f2, 0x78af=>0xe1f3, 
	0x78b5=>0xe1f1, 0x78ba=>0x8a6d, 0x78bc=>0xe1f9, 0x78be=>0xe1f8, 0x78c1=>0x8ea5, 0x78c5=>0xe1fa, 0x78c6=>0xe1f5, 0x78ca=>0xe1fb, 0x78cb=>0xe1f6, 0x78d0=>0x94d6, 0x78d1=>0xe1f4, 0x78d4=>0xe1f7, 0x78da=>0xe241, 0x78e7=>0xe240, 0x78e8=>0x9681, 0x78ec=>0xe1fc, 
	0x78ef=>0x88e9, 0x78f4=>0xe243, 0x78fd=>0xe242, 0x7901=>0x8fca, 0x7907=>0xe244, 0x790e=>0x9162, 0x7911=>0xe246, 0x7912=>0xe245, 0x7919=>0xe247, 0x7926=>0xe1e6, 0x792a=>0xe1e8, 0x792b=>0xe249, 0x792c=>0xe248, 0x793a=>0x8ea6, 0x793c=>0x97e7, 0x793e=>0x8ed0, 
	0x7940=>0xe24a, 0x7941=>0x8c56, 0x7947=>0x8b5f, 0x7948=>0x8b46, 0x7949=>0x8e83, 0x7950=>0x9753, 0x7953=>0xe250, 0x7955=>0xe24f, 0x7956=>0x9163, 0x7957=>0xe24c, 0x795a=>0xe24e, 0x795d=>0x8f6a, 0x795e=>0x905f, 0x795f=>0xe24d, 0x7960=>0xe24b, 0x7962=>0x9449, 
	0x7965=>0x8fcb, 0x7968=>0x955b, 0x796d=>0x8dd5, 0x7977=>0x9398, 0x797a=>0xe251, 0x797f=>0xe252, 0x7980=>0xe268, 0x7981=>0x8bd6, 0x7984=>0x985c, 0x7985=>0x9154, 0x798a=>0xe253, 0x798d=>0x89d0, 0x798e=>0x92f5, 0x798f=>0x959f, 0x799d=>0xe254, 0x79a6=>0x8b9a, 
	0x79a7=>0xe255, 0x79aa=>0xe257, 0x79ae=>0xe258, 0x79b0=>0x9448, 0x79b3=>0xe259, 0x79b9=>0xe25a, 0x79ba=>0xe25b, 0x79bd=>0x8bd7, 0x79be=>0x89d1, 0x79bf=>0x93c3, 0x79c0=>0x8f47, 0x79c1=>0x8e84, 0x79c9=>0xe25c, 0x79cb=>0x8f48, 0x79d1=>0x89c8, 0x79d2=>0x9562, 
	0x79d5=>0xe25d, 0x79d8=>0x94e9, 0x79df=>0x9164, 0x79e1=>0xe260, 0x79e3=>0xe261, 0x79e4=>0x9489, 0x79e6=>0x9060, 0x79e7=>0xe25e, 0x79e9=>0x9281, 0x79ec=>0xe25f, 0x79f0=>0x8fcc, 0x79fb=>0x88da, 0x7a00=>0x8b48, 0x7a08=>0xe262, 0x7a0b=>0x92f6, 0x7a0d=>0xe263, 
	0x7a0e=>0x90c5, 0x7a14=>0x96ab, 0x7a17=>0x9542, 0x7a18=>0xe264, 0x7a19=>0xe265, 0x7a1a=>0x9274, 0x7a1c=>0x97c5, 0x7a1f=>0xe267, 0x7a20=>0xe266, 0x7a2e=>0x8eed, 0x7a31=>0xe269, 0x7a32=>0x88ee, 0x7a37=>0xe26c, 0x7a3b=>0xe26a, 0x7a3c=>0x89d2, 0x7a3d=>0x8c6d, 
	0x7a3e=>0xe26b, 0x7a3f=>0x8d65, 0x7a40=>0x8d92, 0x7a42=>0x95e4, 0x7a43=>0xe26d, 0x7a46=>0x9673, 0x7a49=>0xe26f, 0x7a4d=>0x90cf, 0x7a4e=>0x896e, 0x7a4f=>0x89b8, 0x7a50=>0x88aa, 0x7a57=>0xe26e, 0x7a61=>0xe270, 0x7a62=>0xe271, 0x7a63=>0x8ff5, 0x7a69=>0xe272, 
	0x7a6b=>0x8a6e, 0x7a70=>0xe274, 0x7a74=>0x8c8a, 0x7a76=>0x8b86, 0x7a79=>0xe275, 0x7a7a=>0x8bf3, 0x7a7d=>0xe276, 0x7a7f=>0x90fa, 0x7a81=>0x93cb, 0x7a83=>0x90de, 0x7a84=>0x8df3, 0x7a88=>0xe277, 0x7a92=>0x9282, 0x7a93=>0x918b, 0x7a95=>0xe279, 0x7a96=>0xe27b, 
	0x7a97=>0xe278, 0x7a98=>0xe27a, 0x7a9f=>0x8c41, 0x7aa9=>0xe27c, 0x7aaa=>0x8c45, 0x7aae=>0x8b87, 0x7aaf=>0x9771, 0x7ab0=>0xe27e, 0x7ab6=>0xe280, 0x7aba=>0x894d, 0x7abf=>0xe283, 0x7ac3=>0x8a96, 0x7ac4=>0xe282, 0x7ac5=>0xe281, 0x7ac7=>0xe285, 0x7ac8=>0xe27d, 
	0x7aca=>0xe286, 0x7acb=>0x97a7, 0x7acd=>0xe287, 0x7acf=>0xe288, 0x7ad2=>0x9af2, 0x7ad3=>0xe28a, 0x7ad5=>0xe289, 0x7ad9=>0xe28b, 0x7ada=>0xe28c, 0x7adc=>0x97b3, 0x7add=>0xe28d, 0x7adf=>0xe8ed, 0x7ae0=>0x8fcd, 0x7ae1=>0xe28e, 0x7ae2=>0xe28f, 0x7ae3=>0x8f76, 
	0x7ae5=>0x93b6, 0x7ae6=>0xe290, 0x7aea=>0x9247, 0x7aed=>0xe291, 0x7aef=>0x925b, 0x7af0=>0xe292, 0x7af6=>0x8ba3, 0x7af8=>0x995e, 0x7af9=>0x927c, 0x7afa=>0x8eb1, 0x7aff=>0x8ac6, 0x7b02=>0xe293, 0x7b04=>0xe2a0, 0x7b06=>0xe296, 0x7b08=>0x8b88, 0x7b0a=>0xe295, 
	0x7b0b=>0xe2a2, 0x7b0f=>0xe294, 0x7b11=>0x8fce, 0x7b18=>0xe298, 0x7b19=>0xe299, 0x7b1b=>0x934a, 0x7b1e=>0xe29a, 0x7b20=>0x8a7d, 0x7b25=>0x9079, 0x7b26=>0x9584, 0x7b28=>0xe29c, 0x7b2c=>0x91e6, 0x7b33=>0xe297, 0x7b35=>0xe29b, 0x7b36=>0xe29d, 0x7b39=>0x8df9, 
	0x7b45=>0xe2a4, 0x7b46=>0x954d, 0x7b48=>0x94a4, 0x7b49=>0x9399, 0x7b4b=>0x8bd8, 0x7b4c=>0xe2a3, 0x7b4d=>0xe2a1, 0x7b4f=>0x94b3, 0x7b50=>0xe29e, 0x7b51=>0x927d, 0x7b52=>0x939b, 0x7b54=>0x939a, 0x7b56=>0x8df4, 0x7b5d=>0xe2b6, 0x7b65=>0xe2a6, 0x7b67=>0xe2a8, 
	0x7b6c=>0xe2ab, 0x7b6e=>0xe2ac, 0x7b70=>0xe2a9, 0x7b71=>0xe2aa, 0x7b74=>0xe2a7, 0x7b75=>0xe2a5, 0x7b7a=>0xe29f, 0x7b86=>0x95cd, 0x7b87=>0x89d3, 0x7b8b=>0xe2b3, 0x7b8d=>0xe2b0, 0x7b8f=>0xe2b5, 0x7b92=>0xe2b4, 0x7b94=>0x9493, 0x7b95=>0x96a5, 0x7b97=>0x8e5a, 
	0x7b98=>0xe2ae, 0x7b99=>0xe2b7, 0x7b9a=>0xe2b2, 0x7b9c=>0xe2b1, 0x7b9d=>0xe2ad, 0x7b9f=>0xe2af, 0x7ba1=>0x8ac7, 0x7baa=>0x925c, 0x7bad=>0x90fb, 0x7bb1=>0x94a0, 0x7bb4=>0xe2bc, 0x7bb8=>0x94a2, 0x7bc0=>0x90df, 0x7bc1=>0xe2b9, 0x7bc4=>0x94cd, 0x7bc6=>0xe2bd, 
	0x7bc7=>0x95d1, 0x7bc9=>0x927a, 0x7bcb=>0xe2b8, 0x7bcc=>0xe2ba, 0x7bcf=>0xe2bb, 0x7bdd=>0xe2be, 0x7be0=>0x8ec2, 0x7be4=>0x93c4, 0x7be5=>0xe2c3, 0x7be6=>0xe2c2, 0x7be9=>0xe2bf, 0x7bed=>0x9855, 0x7bf3=>0xe2c8, 0x7bf6=>0xe2cc, 0x7bf7=>0xe2c9, 0x7c00=>0xe2c5, 
	0x7c07=>0xe2c6, 0x7c0d=>0xe2cb, 0x7c11=>0xe2c0, 0x7c12=>0x99d3, 0x7c13=>0xe2c7, 0x7c14=>0xe2c1, 0x7c17=>0xe2ca, 0x7c1f=>0xe2d0, 0x7c21=>0x8ac8, 0x7c23=>0xe2cd, 0x7c27=>0xe2ce, 0x7c2a=>0xe2cf, 0x7c2b=>0xe2d2, 0x7c37=>0xe2d1, 0x7c38=>0x94f4, 0x7c3d=>0xe2d3, 
	0x7c3e=>0x97fa, 0x7c3f=>0x95eb, 0x7c40=>0xe2d8, 0x7c43=>0xe2d5, 0x7c4c=>0xe2d4, 0x7c4d=>0x90d0, 0x7c4f=>0xe2d7, 0x7c50=>0xe2d9, 0x7c54=>0xe2d6, 0x7c56=>0xe2dd, 0x7c58=>0xe2da, 0x7c5f=>0xe2db, 0x7c60=>0xe2c4, 0x7c64=>0xe2dc, 0x7c65=>0xe2de, 0x7c6c=>0xe2df, 
	0x7c73=>0x95c4, 0x7c75=>0xe2e0, 0x7c7e=>0x96e0, 0x7c81=>0x8bcc, 0x7c82=>0x8c48, 0x7c83=>0xe2e1, 0x7c89=>0x95b2, 0x7c8b=>0x9088, 0x7c8d=>0x96ae, 0x7c90=>0xe2e2, 0x7c92=>0x97b1, 0x7c95=>0x9494, 0x7c97=>0x9165, 0x7c98=>0x9453, 0x7c9b=>0x8f6c, 0x7c9f=>0x88be, 
	0x7ca1=>0xe2e7, 0x7ca2=>0xe2e5, 0x7ca4=>0xe2e3, 0x7ca5=>0x8a9f, 0x7ca7=>0x8fcf, 0x7ca8=>0xe2e8, 0x7cab=>0xe2e6, 0x7cad=>0xe2e4, 0x7cae=>0xe2ec, 0x7cb1=>0xe2eb, 0x7cb2=>0xe2ea, 0x7cb3=>0xe2e9, 0x7cb9=>0xe2ed, 0x7cbd=>0xe2ee, 0x7cbe=>0x90b8, 0x7cc0=>0xe2ef, 
	0x7cc2=>0xe2f1, 0x7cc5=>0xe2f0, 0x7cca=>0x8cd0, 0x7cce=>0x9157, 0x7cd2=>0xe2f3, 0x7cd6=>0x939c, 0x7cd8=>0xe2f2, 0x7cdc=>0xe2f4, 0x7cde=>0x95b3, 0x7cdf=>0x918c, 0x7ce0=>0x8d66, 0x7ce2=>0xe2f5, 0x7ce7=>0x97c6, 0x7cef=>0xe2f7, 0x7cf2=>0xe2f8, 0x7cf4=>0xe2f9, 
	0x7cf6=>0xe2fa, 0x7cf8=>0x8e85, 0x7cfa=>0xe2fb, 0x7cfb=>0x8c6e, 0x7cfe=>0x8b8a, 0x7d00=>0x8b49, 0x7d02=>0xe340, 0x7d04=>0x96f1, 0x7d05=>0x8d67, 0x7d06=>0xe2fc, 0x7d0a=>0xe343, 0x7d0b=>0x96e4, 0x7d0d=>0x945b, 0x7d10=>0x9552, 0x7d14=>0x8f83, 0x7d15=>0xe342, 
	0x7d17=>0x8ed1, 0x7d18=>0x8d68, 0x7d19=>0x8e86, 0x7d1a=>0x8b89, 0x7d1b=>0x95b4, 0x7d1c=>0xe341, 0x7d20=>0x9166, 0x7d21=>0x9661, 0x7d22=>0x8df5, 0x7d2b=>0x8e87, 0x7d2c=>0x92db, 0x7d2e=>0xe346, 0x7d2f=>0x97dd, 0x7d30=>0x8dd7, 0x7d32=>0xe347, 0x7d33=>0x9061, 
	0x7d35=>0xe349, 0x7d39=>0x8fd0, 0x7d3a=>0x8dae, 0x7d3f=>0xe348, 0x7d42=>0x8f49, 0x7d43=>0x8cbc, 0x7d44=>0x9167, 0x7d45=>0xe344, 0x7d46=>0xe34a, 0x7d4b=>0xe345, 0x7d4c=>0x8c6f, 0x7d4e=>0xe34d, 0x7d4f=>0xe351, 0x7d50=>0x8c8b, 0x7d56=>0xe34c, 0x7d5b=>0xe355, 
	0x7d5e=>0x8d69, 0x7d61=>0x978d, 0x7d62=>0x88ba, 0x7d63=>0xe352, 0x7d66=>0x8b8b, 0x7d68=>0xe34f, 0x7d6e=>0xe350, 0x7d71=>0x939d, 0x7d72=>0xe34e, 0x7d73=>0xe34b, 0x7d75=>0x8a47, 0x7d76=>0x90e2, 0x7d79=>0x8ca6, 0x7d7d=>0xe357, 0x7d89=>0xe354, 0x7d8f=>0xe356, 
	0x7d93=>0xe353, 0x7d99=>0x8c70, 0x7d9a=>0x91b1, 0x7d9b=>0xe358, 0x7d9c=>0x918e, 0x7d9f=>0xe365, 0x7da2=>0xe361, 0x7da3=>0xe35b, 0x7dab=>0xe35f, 0x7dac=>0x8ef8, 0x7dad=>0x88db, 0x7dae=>0xe35a, 0x7daf=>0xe362, 0x7db0=>0xe366, 0x7db1=>0x8d6a, 0x7db2=>0x96d4, 
	0x7db4=>0x92d4, 0x7db5=>0xe35c, 0x7db8=>0xe364, 0x7dba=>0xe359, 0x7dbb=>0x925d, 0x7dbd=>0xe35e, 0x7dbe=>0x88bb, 0x7dbf=>0x96c8, 0x7dc7=>0xe35d, 0x7dca=>0x8bd9, 0x7dcb=>0x94ea, 0x7dcf=>0x918d, 0x7dd1=>0x97ce, 0x7dd2=>0x8f8f, 0x7dd5=>0xe38e, 0x7dd8=>0xe367, 
	0x7dda=>0x90fc, 0x7ddc=>0xe363, 0x7ddd=>0xe368, 0x7dde=>0xe36a, 0x7de0=>0x92f7, 0x7de1=>0xe36d, 0x7de4=>0xe369, 0x7de8=>0x95d2, 0x7de9=>0x8ac9, 0x7dec=>0x96c9, 0x7def=>0x88dc, 0x7df2=>0xe36c, 0x7df4=>0x97fb, 0x7dfb=>0xe36b, 0x7e01=>0x898f, 0x7e04=>0x93ea, 
	0x7e05=>0xe36e, 0x7e09=>0xe375, 0x7e0a=>0xe36f, 0x7e0b=>0xe376, 0x7e12=>0xe372, 0x7e1b=>0x949b, 0x7e1e=>0x8ec8, 0x7e1f=>0xe374, 0x7e21=>0xe371, 0x7e22=>0xe377, 0x7e23=>0xe370, 0x7e26=>0x8f63, 0x7e2b=>0x9644, 0x7e2e=>0x8f6b, 0x7e31=>0xe373, 0x7e32=>0xe380, 
	0x7e35=>0xe37b, 0x7e37=>0xe37e, 0x7e39=>0xe37c, 0x7e3a=>0xe381, 0x7e3b=>0xe37a, 0x7e3d=>0xe360, 0x7e3e=>0x90d1, 0x7e41=>0x94c9, 0x7e43=>0xe37d, 0x7e46=>0xe378, 0x7e4a=>0x9140, 0x7e4b=>0x8c71, 0x7e4d=>0x8f4a, 0x7e54=>0x9044, 0x7e55=>0x9155, 0x7e56=>0xe384, 
	0x7e59=>0xe386, 0x7e5a=>0xe387, 0x7e5d=>0xe383, 0x7e5e=>0xe385, 0x7e66=>0xe379, 0x7e67=>0xe382, 0x7e69=>0xe38a, 0x7e6a=>0xe389, 0x7e6d=>0x969a, 0x7e70=>0x8c4a, 0x7e79=>0xe388, 0x7e7b=>0xe38c, 0x7e7c=>0xe38b, 0x7e7d=>0xe38f, 0x7e7f=>0xe391, 0x7e82=>0x8e5b, 
	0x7e83=>0xe38d, 0x7e88=>0xe392, 0x7e89=>0xe393, 0x7e8c=>0xe394, 0x7e8e=>0xe39a, 0x7e8f=>0x935a, 0x7e90=>0xe396, 0x7e92=>0xe395, 0x7e93=>0xe397, 0x7e94=>0xe398, 0x7e96=>0xe399, 0x7e9b=>0xe39b, 0x7e9c=>0xe39c, 0x7f36=>0x8aca, 0x7f38=>0xe39d, 0x7f3a=>0xe39e, 
	0x7f45=>0xe39f, 0x7f4c=>0xe3a0, 0x7f4d=>0xe3a1, 0x7f4e=>0xe3a2, 0x7f50=>0xe3a3, 0x7f51=>0xe3a4, 0x7f54=>0xe3a6, 0x7f55=>0xe3a5, 0x7f58=>0xe3a7, 0x7f5f=>0xe3a8, 0x7f60=>0xe3a9, 0x7f67=>0xe3ac, 0x7f68=>0xe3aa, 0x7f69=>0xe3ab, 0x7f6a=>0x8ddf, 0x7f6b=>0x8c72, 
	0x7f6e=>0x9275, 0x7f70=>0x94b1, 0x7f72=>0x8f90, 0x7f75=>0x946c, 0x7f77=>0x94eb, 0x7f78=>0xe3ad, 0x7f79=>0x9ceb, 0x7f82=>0xe3ae, 0x7f83=>0xe3b0, 0x7f85=>0x9785, 0x7f86=>0xe3af, 0x7f87=>0xe3b2, 0x7f88=>0xe3b1, 0x7f8a=>0x9772, 0x7f8c=>0xe3b3, 0x7f8e=>0x94fc, 
	0x7f94=>0xe3b4, 0x7f9a=>0xe3b7, 0x7f9d=>0xe3b6, 0x7f9e=>0xe3b5, 0x7fa3=>0xe3b8, 0x7fa4=>0x8c51, 0x7fa8=>0x9141, 0x7fa9=>0x8b60, 0x7fae=>0xe3bc, 0x7faf=>0xe3b9, 0x7fb2=>0xe3ba, 0x7fb6=>0xe3bd, 0x7fb8=>0xe3be, 0x7fb9=>0xe3bb, 0x7fbd=>0x8948, 0x7fc1=>0x89a5, 
	0x7fc5=>0xe3c0, 0x7fc6=>0xe3c1, 0x7fca=>0xe3c2, 0x7fcc=>0x9782, 0x7fd2=>0x8f4b, 0x7fd4=>0xe3c4, 0x7fd5=>0xe3c3, 0x7fe0=>0x9089, 0x7fe1=>0xe3c5, 0x7fe6=>0xe3c6, 0x7fe9=>0xe3c7, 0x7feb=>0x8ae3, 0x7ff0=>0x8acb, 0x7ff3=>0xe3c8, 0x7ff9=>0xe3c9, 0x7ffb=>0x967c, 
	0x7ffc=>0x9783, 0x8000=>0x9773, 0x8001=>0x9856, 0x8003=>0x8d6c, 0x8004=>0xe3cc, 0x8005=>0x8ed2, 0x8006=>0xe3cb, 0x800b=>0xe3cd, 0x800c=>0x8ea7, 0x8010=>0x91cf, 0x8012=>0xe3ce, 0x8015=>0x8d6b, 0x8017=>0x96d5, 0x8018=>0xe3cf, 0x8019=>0xe3d0, 0x801c=>0xe3d1, 
	0x8021=>0xe3d2, 0x8028=>0xe3d3, 0x8033=>0x8ea8, 0x8036=>0x96eb, 0x803b=>0xe3d5, 0x803d=>0x925e, 0x803f=>0xe3d4, 0x8046=>0xe3d7, 0x804a=>0xe3d6, 0x8052=>0xe3d8, 0x8056=>0x90b9, 0x8058=>0xe3d9, 0x805a=>0xe3da, 0x805e=>0x95b7, 0x805f=>0xe3db, 0x8061=>0x918f, 
	0x8062=>0xe3dc, 0x8068=>0xe3dd, 0x806f=>0x97fc, 0x8070=>0xe3e0, 0x8072=>0xe3df, 0x8073=>0xe3de, 0x8074=>0x92ae, 0x8076=>0xe3e1, 0x8077=>0x9045, 0x8079=>0xe3e2, 0x807d=>0xe3e3, 0x807e=>0x9857, 0x807f=>0xe3e4, 0x8084=>0xe3e5, 0x8085=>0xe3e7, 0x8086=>0xe3e6, 
	0x8087=>0x94a3, 0x8089=>0x93f7, 0x808b=>0x985d, 0x808c=>0x94a7, 0x8093=>0xe3e9, 0x8096=>0x8fd1, 0x8098=>0x9549, 0x809a=>0xe3ea, 0x809b=>0xe3e8, 0x809d=>0x8acc, 0x80a1=>0x8cd2, 0x80a2=>0x8e88, 0x80a5=>0x94ec, 0x80a9=>0x8ca8, 0x80aa=>0x9662, 0x80ac=>0xe3ed, 
	0x80ad=>0xe3eb, 0x80af=>0x8d6d, 0x80b1=>0x8d6e, 0x80b2=>0x88e7, 0x80b4=>0x8de6, 0x80ba=>0x9478, 0x80c3=>0x88dd, 0x80c4=>0xe3f2, 0x80c6=>0x925f, 0x80cc=>0x9477, 0x80ce=>0x91d9, 0x80d6=>0xe3f4, 0x80d9=>0xe3f0, 0x80da=>0xe3f3, 0x80db=>0xe3ee, 0x80dd=>0xe3f1, 
	0x80de=>0x9645, 0x80e1=>0x8cd3, 0x80e4=>0x88fb, 0x80e5=>0xe3ef, 0x80ef=>0xe3f6, 0x80f1=>0xe3f7, 0x80f4=>0x93b7, 0x80f8=>0x8bb9, 0x80fc=>0xe445, 0x80fd=>0x945c, 0x8102=>0x8e89, 0x8105=>0x8bba, 0x8106=>0x90c6, 0x8107=>0x9865, 0x8108=>0x96ac, 0x8109=>0xe3f5, 
	0x810a=>0x90d2, 0x811a=>0x8b72, 0x811b=>0xe3f8, 0x8123=>0xe3fa, 0x8129=>0xe3f9, 0x812f=>0xe3fb, 0x8131=>0x9245, 0x8133=>0x945d, 0x8139=>0x92af, 0x813e=>0xe442, 0x8146=>0xe441, 0x814b=>0xe3fc, 0x814e=>0x9074, 0x8150=>0x9585, 0x8151=>0xe444, 0x8153=>0xe443, 
	0x8154=>0x8d6f, 0x8155=>0x9872, 0x815f=>0xe454, 0x8165=>0xe448, 0x8166=>0xe449, 0x816b=>0x8eee, 0x816e=>0xe447, 0x8170=>0x8d98, 0x8171=>0xe446, 0x8174=>0xe44a, 0x8178=>0x92b0, 0x8179=>0x95a0, 0x817a=>0x9142, 0x817f=>0x91da, 0x8180=>0xe44e, 0x8182=>0xe44f, 
	0x8183=>0xe44b, 0x8188=>0xe44c, 0x818a=>0xe44d, 0x818f=>0x8d70, 0x8193=>0xe455, 0x8195=>0xe451, 0x819a=>0x9586, 0x819c=>0x968c, 0x819d=>0x9547, 0x81a0=>0xe450, 0x81a3=>0xe453, 0x81a4=>0xe452, 0x81a8=>0x9663, 0x81a9=>0xe456, 0x81b0=>0xe457, 0x81b3=>0x9156, 
	0x81b5=>0xe458, 0x81b8=>0xe45a, 0x81ba=>0xe45e, 0x81bd=>0xe45b, 0x81be=>0xe459, 0x81bf=>0x945e, 0x81c0=>0xe45c, 0x81c2=>0xe45d, 0x81c6=>0x89b0, 0x81c8=>0xe464, 0x81c9=>0xe45f, 0x81cd=>0xe460, 0x81d1=>0xe461, 0x81d3=>0x919f, 0x81d8=>0xe463, 0x81d9=>0xe462, 
	0x81da=>0xe465, 0x81df=>0xe466, 0x81e0=>0xe467, 0x81e3=>0x9062, 0x81e5=>0x89e7, 0x81e7=>0xe468, 0x81e8=>0x97d5, 0x81ea=>0x8ea9, 0x81ed=>0x8f4c, 0x81f3=>0x8e8a, 0x81f4=>0x9276, 0x81fa=>0xe469, 0x81fb=>0xe46a, 0x81fc=>0x8950, 0x81fe=>0xe46b, 0x8201=>0xe46c, 
	0x8202=>0xe46d, 0x8205=>0xe46e, 0x8207=>0xe46f, 0x8208=>0x8bbb, 0x8209=>0x9da8, 0x820a=>0xe470, 0x820c=>0x90e3, 0x820d=>0xe471, 0x820e=>0x8ec9, 0x8210=>0xe472, 0x8212=>0x98ae, 0x8216=>0xe473, 0x8217=>0x95dc, 0x8218=>0x8ada, 0x821b=>0x9143, 0x821c=>0x8f77, 
	0x821e=>0x9591, 0x821f=>0x8f4d, 0x8229=>0xe474, 0x822a=>0x8d71, 0x822b=>0xe475, 0x822c=>0x94ca, 0x822e=>0xe484, 0x8233=>0xe477, 0x8235=>0x91c7, 0x8236=>0x9495, 0x8237=>0x8cbd, 0x8238=>0xe476, 0x8239=>0x9144, 0x8240=>0xe478, 0x8247=>0x92f8, 0x8258=>0xe47a, 
	0x8259=>0xe479, 0x825a=>0xe47c, 0x825d=>0xe47b, 0x825f=>0xe47d, 0x8262=>0xe480, 0x8264=>0xe47e, 0x8266=>0x8acd, 0x8268=>0xe481, 0x826a=>0xe482, 0x826b=>0xe483, 0x826e=>0x8daf, 0x826f=>0x97c7, 0x8271=>0xe485, 0x8272=>0x9046, 0x8276=>0x8990, 0x8277=>0xe486, 
	0x8278=>0xe487, 0x827e=>0xe488, 0x828b=>0x88f0, 0x828d=>0xe489, 0x8292=>0xe48a, 0x8299=>0x9587, 0x829d=>0x8ec5, 0x829f=>0xe48c, 0x82a5=>0x8a48, 0x82a6=>0x88b0, 0x82ab=>0xe48b, 0x82ac=>0xe48e, 0x82ad=>0x946d, 0x82af=>0x9063, 0x82b1=>0x89d4, 0x82b3=>0x9646, 
	0x82b8=>0x8c7c, 0x82b9=>0x8bda, 0x82bb=>0xe48d, 0x82bd=>0x89e8, 0x82c5=>0x8aa1, 0x82d1=>0x8991, 0x82d2=>0xe492, 0x82d3=>0x97e8, 0x82d4=>0x91db, 0x82d7=>0x9563, 0x82d9=>0xe49e, 0x82db=>0x89d5, 0x82dc=>0xe49c, 0x82de=>0xe49a, 0x82df=>0xe491, 0x82e1=>0xe48f, 
	0x82e3=>0xe490, 0x82e5=>0x8ee1, 0x82e6=>0x8bea, 0x82e7=>0x9297, 0x82eb=>0x93cf, 0x82f1=>0x8970, 0x82f3=>0xe494, 0x82f4=>0xe493, 0x82f9=>0xe499, 0x82fa=>0xe495, 0x82fb=>0xe498, 0x8302=>0x96ce, 0x8303=>0xe497, 0x8304=>0x89d6, 0x8305=>0x8a9d, 0x8306=>0xe49b, 
	0x8309=>0xe49d, 0x830e=>0x8c73, 0x8316=>0xe4a1, 0x8317=>0xe4aa, 0x8318=>0xe4ab, 0x831c=>0x88a9, 0x8323=>0xe4b2, 0x8328=>0x88ef, 0x832b=>0xe4a9, 0x832f=>0xe4a8, 0x8331=>0xe4a3, 0x8332=>0xe4a2, 0x8334=>0xe4a0, 0x8335=>0xe49f, 0x8336=>0x9283, 0x8338=>0x91f9, 
	0x8339=>0xe4a5, 0x8340=>0xe4a4, 0x8345=>0xe4a7, 0x8349=>0x9190, 0x834a=>0x8c74, 0x834f=>0x8960, 0x8350=>0xe4a6, 0x8352=>0x8d72, 0x8358=>0x9191, 0x8373=>0xe4b8, 0x8375=>0xe4b9, 0x8377=>0x89d7, 0x837b=>0x89ac, 0x837c=>0xe4b6, 0x8385=>0xe4ac, 0x8387=>0xe4b4, 
	0x8389=>0xe4bb, 0x838a=>0xe4b5, 0x838e=>0xe4b3, 0x8393=>0xe496, 0x8396=>0xe4b1, 0x839a=>0xe4ad, 0x839e=>0x8ace, 0x839f=>0xe4af, 0x83a0=>0xe4ba, 0x83a2=>0xe4b0, 0x83a8=>0xe4bc, 0x83aa=>0xe4ae, 0x83ab=>0x949c, 0x83b1=>0x9789, 0x83b5=>0xe4b7, 0x83bd=>0xe4cd, 
	0x83c1=>0xe4c5, 0x83c5=>0x909b, 0x83ca=>0x8b65, 0x83cc=>0x8bdb, 0x83ce=>0xe4c0, 0x83d3=>0x89d9, 0x83d6=>0x8fd2, 0x83d8=>0xe4c3, 0x83dc=>0x8dd8, 0x83df=>0x9370, 0x83e0=>0xe4c8, 0x83e9=>0x95ec, 0x83eb=>0xe4bf, 0x83ef=>0x89d8, 0x83f0=>0x8cd4, 0x83f1=>0x9548, 
	0x83f2=>0xe4c9, 0x83f4=>0xe4bd, 0x83f7=>0xe4c6, 0x83fb=>0xe4d0, 0x83fd=>0xe4c1, 0x8403=>0xe4c2, 0x8404=>0x93b8, 0x8407=>0xe4c7, 0x840b=>0xe4c4, 0x840c=>0x9647, 0x840d=>0xe4ca, 0x840e=>0x88de, 0x8413=>0xe4be, 0x8420=>0xe4cc, 0x8422=>0xe4cb, 0x8429=>0x948b, 
	0x842a=>0xe4d2, 0x842c=>0xe4dd, 0x8431=>0x8a9e, 0x8435=>0xe4e0, 0x8438=>0xe4ce, 0x843c=>0xe4d3, 0x843d=>0x978e, 0x8446=>0xe4dc, 0x8449=>0x9774, 0x844e=>0x97a8, 0x8457=>0x9298, 0x845b=>0x8a8b, 0x8461=>0x9592, 0x8462=>0xe4e2, 0x8463=>0x939f, 0x8466=>0x88af, 
	0x8469=>0xe4db, 0x846b=>0xe4d7, 0x846c=>0x9192, 0x846d=>0xe4d1, 0x846e=>0xe4d9, 0x846f=>0xe4de, 0x8471=>0x944b, 0x8475=>0x88a8, 0x8477=>0xe4d6, 0x8479=>0xe4df, 0x847a=>0x9598, 0x8482=>0xe4da, 0x8484=>0xe4d5, 0x848b=>0x8fd3, 0x8490=>0x8f4e, 0x8494=>0x8eaa, 
	0x8499=>0x96d6, 0x849c=>0x9566, 0x849f=>0xe4e5, 0x84a1=>0xe4ee, 0x84ad=>0xe4d8, 0x84b2=>0x8a97, 0x84b8=>0x8ff6, 0x84b9=>0xe4e3, 0x84bb=>0xe4e8, 0x84bc=>0x9193, 0x84bf=>0xe4e4, 0x84c1=>0xe4eb, 0x84c4=>0x927e, 0x84c6=>0xe4ec, 0x84c9=>0x9775, 0x84ca=>0xe4e1, 
	0x84cb=>0x8a57, 0x84cd=>0xe4e7, 0x84d0=>0xe4ea, 0x84d1=>0x96aa, 0x84d6=>0xe4ed, 0x84d9=>0xe4e6, 0x84da=>0xe4e9, 0x84ec=>0x9648, 0x84ee=>0x9840, 0x84f4=>0xe4f1, 0x84fc=>0xe4f8, 0x84ff=>0xe4f0, 0x8500=>0x8ec1, 0x8506=>0xe4cf, 0x8511=>0x95cc, 0x8513=>0x96a0, 
	0x8514=>0xe4f7, 0x8515=>0xe4f6, 0x8517=>0xe4f2, 0x8518=>0xe4f3, 0x851a=>0x8955, 0x851f=>0xe4f5, 0x8521=>0xe4ef, 0x8526=>0x92d3, 0x852c=>0xe4f4, 0x852d=>0x88fc, 0x8535=>0x91a0, 0x853d=>0x95c1, 0x8540=>0xe4f9, 0x8541=>0xe540, 0x8543=>0x94d7, 0x8548=>0xe4fc, 
	0x8549=>0x8fd4, 0x854a=>0x8ec7, 0x854b=>0xe542, 0x854e=>0x8bbc, 0x8555=>0xe543, 0x8557=>0x9599, 0x8558=>0xe4fb, 0x855a=>0xe4d4, 0x8563=>0xe4fa, 0x8568=>0x986e, 0x8569=>0x93a0, 0x856a=>0x9593, 0x856d=>0xe54a, 0x8577=>0xe550, 0x857e=>0xe551, 0x8580=>0xe544, 
	0x8584=>0x9496, 0x8587=>0xe54e, 0x8588=>0xe546, 0x858a=>0xe548, 0x8590=>0xe552, 0x8591=>0xe547, 0x8594=>0xe54b, 0x8597=>0x8992, 0x8599=>0x93e3, 0x859b=>0xe54c, 0x859c=>0xe54f, 0x85a4=>0xe545, 0x85a6=>0x9145, 0x85a8=>0xe549, 0x85a9=>0x8e46, 0x85aa=>0x9064, 
	0x85ab=>0x8c4f, 0x85ac=>0x96f2, 0x85ae=>0x96f7, 0x85af=>0x8f92, 0x85b9=>0xe556, 0x85ba=>0xe554, 0x85c1=>0x986d, 0x85c9=>0xe553, 0x85cd=>0x9795, 0x85cf=>0xe555, 0x85d0=>0xe557, 0x85d5=>0xe558, 0x85dc=>0xe55b, 0x85dd=>0xe559, 0x85e4=>0x93a1, 0x85e5=>0xe55a, 
	0x85e9=>0x94cb, 0x85ea=>0xe54d, 0x85f7=>0x8f93, 0x85f9=>0xe55c, 0x85fa=>0xe561, 0x85fb=>0x9194, 0x85fe=>0xe560, 0x8602=>0xe541, 0x8606=>0xe562, 0x8607=>0x9168, 0x860a=>0xe55d, 0x860b=>0xe55f, 0x8613=>0xe55e, 0x8616=>0x9f50, 0x8617=>0x9f41, 0x861a=>0xe564, 
	0x8622=>0xe563, 0x862d=>0x9796, 0x862f=>0xe1ba, 0x8630=>0xe565, 0x863f=>0xe566, 0x864d=>0xe567, 0x864e=>0x8cd5, 0x8650=>0x8b73, 0x8654=>0xe569, 0x8655=>0x997c, 0x865a=>0x8b95, 0x865c=>0x97b8, 0x865e=>0x8bf1, 0x865f=>0xe56a, 0x8667=>0xe56b, 0x866b=>0x928e, 
	0x8671=>0xe56c, 0x8679=>0x93f8, 0x867b=>0x88b8, 0x868a=>0x89e1, 0x868b=>0xe571, 0x868c=>0xe572, 0x8693=>0xe56d, 0x8695=>0x8e5c, 0x86a3=>0xe56e, 0x86a4=>0x9461, 0x86a9=>0xe56f, 0x86aa=>0xe570, 0x86ab=>0xe57a, 0x86af=>0xe574, 0x86b0=>0xe577, 0x86b6=>0xe573, 
	0x86c4=>0xe575, 0x86c6=>0xe576, 0x86c7=>0x8ed6, 0x86c9=>0xe578, 0x86cb=>0x9260, 0x86cd=>0x8c75, 0x86ce=>0x8a61, 0x86d4=>0xe57b, 0x86d9=>0x8a5e, 0x86db=>0xe581, 0x86de=>0xe57c, 0x86df=>0xe580, 0x86e4=>0x94b8, 0x86e9=>0xe57d, 0x86ec=>0xe57e, 0x86ed=>0x9567, 
	0x86ee=>0x94d8, 0x86ef=>0xe582, 0x86f8=>0x91fb, 0x86f9=>0xe58c, 0x86fb=>0xe588, 0x86fe=>0x89e9, 0x8700=>0xe586, 0x8702=>0x9649, 0x8703=>0xe587, 0x8706=>0xe584, 0x8708=>0xe585, 0x8709=>0xe58a, 0x870a=>0xe58d, 0x870d=>0xe58b, 0x8711=>0xe589, 0x8712=>0xe583, 
	0x8718=>0x9277, 0x871a=>0xe594, 0x871c=>0x96a8, 0x8725=>0xe592, 0x8729=>0xe593, 0x8734=>0xe58e, 0x8737=>0xe590, 0x873b=>0xe591, 0x873f=>0xe58f, 0x8749=>0x90e4, 0x874b=>0x9858, 0x874c=>0xe598, 0x874e=>0xe599, 0x8753=>0xe59f, 0x8755=>0x9049, 0x8757=>0xe59b, 
	0x8759=>0xe59e, 0x875f=>0xe596, 0x8760=>0xe595, 0x8763=>0xe5a0, 0x8766=>0x89da, 0x8768=>0xe59c, 0x876a=>0xe5a1, 0x876e=>0xe59d, 0x8774=>0xe59a, 0x8776=>0x92b1, 0x8778=>0xe597, 0x877f=>0x9488, 0x8782=>0xe5a5, 0x878d=>0x975a, 0x879f=>0xe5a4, 0x87a2=>0xe5a3, 
	0x87ab=>0xe5ac, 0x87af=>0xe5a6, 0x87b3=>0xe5ae, 0x87ba=>0x9786, 0x87bb=>0xe5b1, 0x87bd=>0xe5a8, 0x87c0=>0xe5a9, 0x87c4=>0xe5ad, 0x87c6=>0xe5b0, 0x87c7=>0xe5af, 0x87cb=>0xe5a7, 0x87d0=>0xe5aa, 0x87d2=>0xe5bb, 0x87e0=>0xe5b4, 0x87ef=>0xe5b2, 0x87f2=>0xe5b3, 
	0x87f6=>0xe5b8, 0x87f7=>0xe5b9, 0x87f9=>0x8a49, 0x87fb=>0x8b61, 0x87fe=>0xe5b7, 0x8805=>0xe5a2, 0x880d=>0xe5b6, 0x880e=>0xe5ba, 0x880f=>0xe5b5, 0x8811=>0xe5bc, 0x8815=>0xe5be, 0x8816=>0xe5bd, 0x8821=>0xe5c0, 0x8822=>0xe5bf, 0x8823=>0xe579, 0x8827=>0xe5c4, 
	0x8831=>0xe5c1, 0x8836=>0xe5c2, 0x8839=>0xe5c3, 0x883b=>0xe5c5, 0x8840=>0x8c8c, 0x8842=>0xe5c7, 0x8844=>0xe5c6, 0x8846=>0x8f4f, 0x884c=>0x8d73, 0x884d=>0x9fa5, 0x8852=>0xe5c8, 0x8853=>0x8f70, 0x8857=>0x8a58, 0x8859=>0xe5c9, 0x885b=>0x8971, 0x885d=>0x8fd5, 
	0x885e=>0xe5ca, 0x8861=>0x8d74, 0x8862=>0xe5cb, 0x8863=>0x88df, 0x8868=>0x955c, 0x886b=>0xe5cc, 0x8870=>0x908a, 0x8872=>0xe5d3, 0x8875=>0xe5d0, 0x8877=>0x928f, 0x887d=>0xe5d1, 0x887e=>0xe5ce, 0x887f=>0x8bdc, 0x8881=>0xe5cd, 0x8882=>0xe5d4, 0x8888=>0x8c55, 
	0x888b=>0x91dc, 0x888d=>0xe5da, 0x8892=>0xe5d6, 0x8896=>0x91b3, 0x8897=>0xe5d5, 0x8899=>0xe5d8, 0x889e=>0xe5cf, 0x88a2=>0xe5d9, 0x88a4=>0xe5db, 0x88ab=>0x94ed, 0x88ae=>0xe5d7, 0x88b0=>0xe5dc, 0x88b1=>0xe5de, 0x88b4=>0x8cd1, 0x88b5=>0xe5d2, 0x88b7=>0x88bf, 
	0x88bf=>0xe5dd, 0x88c1=>0x8dd9, 0x88c2=>0x97f4, 0x88c3=>0xe5df, 0x88c4=>0xe5e0, 0x88c5=>0x9195, 0x88cf=>0x97a0, 0x88d4=>0xe5e1, 0x88d5=>0x9754, 0x88d8=>0xe5e2, 0x88d9=>0xe5e3, 0x88dc=>0x95e2, 0x88dd=>0xe5e4, 0x88df=>0x8dbe, 0x88e1=>0x97a1, 0x88e8=>0xe5e9, 
	0x88f2=>0xe5ea, 0x88f3=>0x8fd6, 0x88f4=>0xe5e8, 0x88f8=>0x9787, 0x88f9=>0xe5e5, 0x88fc=>0xe5e7, 0x88fd=>0x90bb, 0x88fe=>0x909e, 0x8902=>0xe5e6, 0x8904=>0xe5eb, 0x8907=>0x95a1, 0x890a=>0xe5ed, 0x890c=>0xe5ec, 0x8910=>0x8a8c, 0x8912=>0x964a, 0x8913=>0xe5ee, 
	0x891d=>0xe5fa, 0x891e=>0xe5f0, 0x8925=>0xe5f1, 0x892a=>0xe5f2, 0x892b=>0xe5f3, 0x8936=>0xe5f7, 0x8938=>0xe5f8, 0x893b=>0xe5f6, 0x8941=>0xe5f4, 0x8943=>0xe5ef, 0x8944=>0xe5f5, 0x894c=>0xe5f9, 0x894d=>0xe8b5, 0x8956=>0x89a6, 0x895e=>0xe5fc, 0x895f=>0x8bdd, 
	0x8960=>0xe5fb, 0x8964=>0xe641, 0x8966=>0xe640, 0x896a=>0xe643, 0x896d=>0xe642, 0x896f=>0xe644, 0x8972=>0x8f50, 0x8974=>0xe645, 0x8977=>0xe646, 0x897e=>0xe647, 0x897f=>0x90bc, 0x8981=>0x9776, 0x8983=>0xe648, 0x8986=>0x95a2, 0x8987=>0x9465, 0x8988=>0xe649, 
	0x898a=>0xe64a, 0x898b=>0x8ca9, 0x898f=>0x8b4b, 0x8993=>0xe64b, 0x8996=>0x8e8b, 0x8997=>0x9460, 0x8998=>0xe64c, 0x899a=>0x8a6f, 0x89a1=>0xe64d, 0x89a6=>0xe64f, 0x89a7=>0x9797, 0x89a9=>0xe64e, 0x89aa=>0x9065, 0x89ac=>0xe650, 0x89af=>0xe651, 0x89b2=>0xe652, 
	0x89b3=>0x8acf, 0x89ba=>0xe653, 0x89bd=>0xe654, 0x89bf=>0xe655, 0x89c0=>0xe656, 0x89d2=>0x8a70, 0x89da=>0xe657, 0x89dc=>0xe658, 0x89dd=>0xe659, 0x89e3=>0x89f0, 0x89e6=>0x9047, 0x89e7=>0xe65a, 0x89f4=>0xe65b, 0x89f8=>0xe65c, 0x8a00=>0x8cbe, 0x8a02=>0x92f9, 
	0x8a03=>0xe65d, 0x8a08=>0x8c76, 0x8a0a=>0x9075, 0x8a0c=>0xe660, 0x8a0e=>0x93a2, 0x8a10=>0xe65f, 0x8a13=>0x8c50, 0x8a16=>0xe65e, 0x8a17=>0x91f5, 0x8a18=>0x8b4c, 0x8a1b=>0xe661, 0x8a1d=>0xe662, 0x8a1f=>0x8fd7, 0x8a23=>0x8c8d, 0x8a25=>0xe663, 0x8a2a=>0x964b, 
	0x8a2d=>0x90dd, 0x8a31=>0x8b96, 0x8a33=>0x96f3, 0x8a34=>0x9169, 0x8a36=>0xe664, 0x8a3a=>0x9066, 0x8a3b=>0x9290, 0x8a3c=>0x8fd8, 0x8a41=>0xe665, 0x8a46=>0xe668, 0x8a48=>0xe669, 0x8a50=>0x8dbc, 0x8a51=>0x91c0, 0x8a52=>0xe667, 0x8a54=>0x8fd9, 0x8a55=>0x955d, 
	0x8a5b=>0xe666, 0x8a5e=>0x8e8c, 0x8a60=>0x8972, 0x8a62=>0xe66d, 0x8a63=>0x8c77, 0x8a66=>0x8e8e, 0x8a69=>0x8e8d, 0x8a6b=>0x986c, 0x8a6c=>0xe66c, 0x8a6d=>0xe66b, 0x8a6e=>0x9146, 0x8a70=>0x8b6c, 0x8a71=>0x9862, 0x8a72=>0x8a59, 0x8a73=>0x8fda, 0x8a7c=>0xe66a, 
	0x8a82=>0xe66f, 0x8a84=>0xe670, 0x8a85=>0xe66e, 0x8a87=>0x8cd6, 0x8a89=>0x975f, 0x8a8c=>0x8e8f, 0x8a8d=>0x9446, 0x8a91=>0xe673, 0x8a93=>0x90be, 0x8a95=>0x9261, 0x8a98=>0x9755, 0x8a9a=>0xe676, 0x8a9e=>0x8cea, 0x8aa0=>0x90bd, 0x8aa1=>0xe672, 0x8aa3=>0xe677, 
	0x8aa4=>0x8ceb, 0x8aa5=>0xe674, 0x8aa6=>0xe675, 0x8aa8=>0xe671, 0x8aac=>0x90e0, 0x8aad=>0x93c7, 0x8ab0=>0x924e, 0x8ab2=>0x89db, 0x8ab9=>0x94ee, 0x8abc=>0x8b62, 0x8abf=>0x92b2, 0x8ac2=>0xe67a, 0x8ac4=>0xe678, 0x8ac7=>0x926b, 0x8acb=>0x90bf, 0x8acc=>0x8ad0, 
	0x8acd=>0xe679, 0x8acf=>0x907a, 0x8ad2=>0x97c8, 0x8ad6=>0x985f, 0x8ada=>0xe67b, 0x8adb=>0xe687, 0x8adc=>0x92b3, 0x8ade=>0xe686, 0x8ae0=>0xe683, 0x8ae1=>0xe68b, 0x8ae2=>0xe684, 0x8ae4=>0xe680, 0x8ae6=>0x92fa, 0x8ae7=>0xe67e, 0x8aeb=>0xe67c, 0x8aed=>0x9740, 
	0x8aee=>0x8e90, 0x8af1=>0xe681, 0x8af3=>0xe67d, 0x8af7=>0xe685, 0x8af8=>0x8f94, 0x8afa=>0x8cbf, 0x8afe=>0x91f8, 0x8b00=>0x9664, 0x8b01=>0x8979, 0x8b02=>0x88e0, 0x8b04=>0x93a3, 0x8b07=>0xe689, 0x8b0c=>0xe688, 0x8b0e=>0x93e4, 0x8b10=>0xe68d, 0x8b14=>0xe682, 
	0x8b16=>0xe68c, 0x8b17=>0xe68e, 0x8b19=>0x8caa, 0x8b1a=>0xe68a, 0x8b1b=>0x8d75, 0x8b1d=>0x8ed3, 0x8b20=>0xe68f, 0x8b21=>0x9777, 0x8b26=>0xe692, 0x8b28=>0xe695, 0x8b2b=>0xe693, 0x8b2c=>0x9554, 0x8b33=>0xe690, 0x8b39=>0x8bde, 0x8b3e=>0xe694, 0x8b41=>0xe696, 
	0x8b49=>0xe69a, 0x8b4c=>0xe697, 0x8b4e=>0xe699, 0x8b4f=>0xe698, 0x8b56=>0xe69b, 0x8b58=>0x8eaf, 0x8b5a=>0xe69d, 0x8b5b=>0xe69c, 0x8b5c=>0x9588, 0x8b5f=>0xe69f, 0x8b66=>0x8c78, 0x8b6b=>0xe69e, 0x8b6c=>0xe6a0, 0x8b6f=>0xe6a1, 0x8b70=>0x8b63, 0x8b71=>0xe3bf, 
	0x8b72=>0x8ff7, 0x8b74=>0xe6a2, 0x8b77=>0x8cec, 0x8b7d=>0xe6a3, 0x8b80=>0xe6a4, 0x8b83=>0x8e5d, 0x8b8a=>0x9dcc, 0x8b8c=>0xe6a5, 0x8b8e=>0xe6a6, 0x8b90=>0x8f51, 0x8b92=>0xe6a7, 0x8b93=>0xe6a8, 0x8b96=>0xe6a9, 0x8b99=>0xe6aa, 0x8b9a=>0xe6ab, 0x8c37=>0x924a, 
	0x8c3a=>0xe6ac, 0x8c3f=>0xe6ae, 0x8c41=>0xe6ad, 0x8c46=>0x93a4, 0x8c48=>0xe6af, 0x8c4a=>0x964c, 0x8c4c=>0xe6b0, 0x8c4e=>0xe6b1, 0x8c50=>0xe6b2, 0x8c55=>0xe6b3, 0x8c5a=>0x93d8, 0x8c61=>0x8fdb, 0x8c62=>0xe6b4, 0x8c6a=>0x8d8b, 0x8c6b=>0x98ac, 0x8c6c=>0xe6b5, 
	0x8c78=>0xe6b6, 0x8c79=>0x955e, 0x8c7a=>0xe6b7, 0x8c7c=>0xe6bf, 0x8c82=>0xe6b8, 0x8c85=>0xe6ba, 0x8c89=>0xe6b9, 0x8c8a=>0xe6bb, 0x8c8c=>0x9665, 0x8c8d=>0xe6bc, 0x8c8e=>0xe6bd, 0x8c94=>0xe6be, 0x8c98=>0xe6c0, 0x8c9d=>0x8a4c, 0x8c9e=>0x92e5, 0x8ca0=>0x9589, 
	0x8ca1=>0x8de0, 0x8ca2=>0x8d76, 0x8ca7=>0x956e, 0x8ca8=>0x89dd, 0x8ca9=>0x94cc, 0x8caa=>0xe6c3, 0x8cab=>0x8ad1, 0x8cac=>0x90d3, 0x8cad=>0xe6c2, 0x8cae=>0xe6c7, 0x8caf=>0x9299, 0x8cb0=>0x96e1, 0x8cb2=>0xe6c5, 0x8cb3=>0xe6c6, 0x8cb4=>0x8b4d, 0x8cb6=>0xe6c8, 
	0x8cb7=>0x9483, 0x8cb8=>0x91dd, 0x8cbb=>0x94ef, 0x8cbc=>0x935c, 0x8cbd=>0xe6c4, 0x8cbf=>0x9666, 0x8cc0=>0x89ea, 0x8cc1=>0xe6ca, 0x8cc2=>0x9847, 0x8cc3=>0x92c0, 0x8cc4=>0x9864, 0x8cc7=>0x8e91, 0x8cc8=>0xe6c9, 0x8cca=>0x91af, 0x8ccd=>0xe6da, 0x8cce=>0x9147, 
	0x8cd1=>0x93f6, 0x8cd3=>0x956f, 0x8cda=>0xe6cd, 0x8cdb=>0x8e5e, 0x8cdc=>0x8e92, 0x8cde=>0x8fdc, 0x8ce0=>0x9485, 0x8ce2=>0x8cab, 0x8ce3=>0xe6cc, 0x8ce4=>0xe6cb, 0x8ce6=>0x958a, 0x8cea=>0x8ebf, 0x8ced=>0x9371, 0x8cfa=>0xe6cf, 0x8cfb=>0xe6d0, 0x8cfc=>0x8d77, 
	0x8cfd=>0xe6ce, 0x8d04=>0xe6d1, 0x8d05=>0xe6d2, 0x8d07=>0xe6d4, 0x8d08=>0x91a1, 0x8d0a=>0xe6d3, 0x8d0b=>0x8ae4, 0x8d0d=>0xe6d6, 0x8d0f=>0xe6d5, 0x8d10=>0xe6d7, 0x8d13=>0xe6d9, 0x8d14=>0xe6db, 0x8d16=>0xe6dc, 0x8d64=>0x90d4, 0x8d66=>0x8ecd, 0x8d67=>0xe6dd, 
	0x8d6b=>0x8a71, 0x8d6d=>0xe6de, 0x8d70=>0x9196, 0x8d71=>0xe6df, 0x8d73=>0xe6e0, 0x8d74=>0x958b, 0x8d77=>0x8b4e, 0x8d81=>0xe6e1, 0x8d85=>0x92b4, 0x8d8a=>0x897a, 0x8d99=>0xe6e2, 0x8da3=>0x8eef, 0x8da8=>0x9096, 0x8db3=>0x91ab, 0x8dba=>0xe6e5, 0x8dbe=>0xe6e4, 
	0x8dc2=>0xe6e3, 0x8dcb=>0xe6eb, 0x8dcc=>0xe6e9, 0x8dcf=>0xe6e6, 0x8dd6=>0xe6e8, 0x8dda=>0xe6e7, 0x8ddb=>0xe6ea, 0x8ddd=>0x8b97, 0x8ddf=>0xe6ee, 0x8de1=>0x90d5, 0x8de3=>0xe6ef, 0x8de8=>0x8cd7, 0x8dea=>0xe6ec, 0x8deb=>0xe6ed, 0x8def=>0x9848, 0x8df3=>0x92b5, 
	0x8df5=>0x9148, 0x8dfc=>0xe6f0, 0x8dff=>0xe6f3, 0x8e08=>0xe6f1, 0x8e09=>0xe6f2, 0x8e0a=>0x9778, 0x8e0f=>0x93a5, 0x8e10=>0xe6f6, 0x8e1d=>0xe6f4, 0x8e1e=>0xe6f5, 0x8e1f=>0xe6f7, 0x8e2a=>0xe748, 0x8e30=>0xe6fa, 0x8e34=>0xe6fb, 0x8e35=>0xe6f9, 0x8e42=>0xe6f8, 
	0x8e44=>0x92fb, 0x8e47=>0xe740, 0x8e48=>0xe744, 0x8e49=>0xe741, 0x8e4a=>0xe6fc, 0x8e4c=>0xe742, 0x8e50=>0xe743, 0x8e55=>0xe74a, 0x8e59=>0xe745, 0x8e5f=>0x90d6, 0x8e60=>0xe747, 0x8e63=>0xe749, 0x8e64=>0xe746, 0x8e72=>0xe74c, 0x8e74=>0x8f52, 0x8e76=>0xe74b, 
	0x8e7c=>0xe74d, 0x8e81=>0xe74e, 0x8e84=>0xe751, 0x8e85=>0xe750, 0x8e87=>0xe74f, 0x8e8a=>0xe753, 0x8e8b=>0xe752, 0x8e8d=>0x96f4, 0x8e91=>0xe755, 0x8e93=>0xe754, 0x8e94=>0xe756, 0x8e99=>0xe757, 0x8ea1=>0xe759, 0x8eaa=>0xe758, 0x8eab=>0x9067, 0x8eac=>0xe75a, 
	0x8eaf=>0x8beb, 0x8eb0=>0xe75b, 0x8eb1=>0xe75d, 0x8ebe=>0xe75e, 0x8ec5=>0xe75f, 0x8ec6=>0xe75c, 0x8ec8=>0xe760, 0x8eca=>0x8ed4, 0x8ecb=>0xe761, 0x8ecc=>0x8b4f, 0x8ecd=>0x8c52, 0x8ed2=>0x8cac, 0x8edb=>0xe762, 0x8edf=>0x93ee, 0x8ee2=>0x935d, 0x8ee3=>0xe763, 
	0x8eeb=>0xe766, 0x8ef8=>0x8eb2, 0x8efb=>0xe765, 0x8efc=>0xe764, 0x8efd=>0x8c79, 0x8efe=>0xe767, 0x8f03=>0x8a72, 0x8f05=>0xe769, 0x8f09=>0x8dda, 0x8f0a=>0xe768, 0x8f0c=>0xe771, 0x8f12=>0xe76b, 0x8f13=>0xe76d, 0x8f14=>0x95e3, 0x8f15=>0xe76a, 0x8f19=>0xe76c, 
	0x8f1b=>0xe770, 0x8f1c=>0xe76e, 0x8f1d=>0x8b50, 0x8f1f=>0xe76f, 0x8f26=>0xe772, 0x8f29=>0x9479, 0x8f2a=>0x97d6, 0x8f2f=>0x8f53, 0x8f33=>0xe773, 0x8f38=>0x9741, 0x8f39=>0xe775, 0x8f3b=>0xe774, 0x8f3e=>0xe778, 0x8f3f=>0x9760, 0x8f42=>0xe777, 0x8f44=>0x8a8d, 
	0x8f45=>0xe776, 0x8f46=>0xe77b, 0x8f49=>0xe77a, 0x8f4c=>0xe779, 0x8f4d=>0x9351, 0x8f4e=>0xe77c, 0x8f57=>0xe77d, 0x8f5c=>0xe77e, 0x8f5f=>0x8d8c, 0x8f61=>0x8c44, 0x8f62=>0xe780, 0x8f63=>0xe781, 0x8f64=>0xe782, 0x8f9b=>0x9068, 0x8f9c=>0xe783, 0x8f9e=>0x8eab, 
	0x8f9f=>0xe784, 0x8fa3=>0xe785, 0x8fa7=>0x999f, 0x8fa8=>0x999e, 0x8fad=>0xe786, 0x8fae=>0xe390, 0x8faf=>0xe787, 0x8fb0=>0x9243, 0x8fb1=>0x904a, 0x8fb2=>0x945f, 0x8fb7=>0xe788, 0x8fba=>0x95d3, 0x8fbb=>0x92d2, 0x8fbc=>0x8d9e, 0x8fbf=>0x9248, 0x8fc2=>0x8949, 
	0x8fc4=>0x9698, 0x8fc5=>0x9076, 0x8fce=>0x8c7d, 0x8fd1=>0x8bdf, 0x8fd4=>0x95d4, 0x8fda=>0xe789, 0x8fe2=>0xe78b, 0x8fe5=>0xe78a, 0x8fe6=>0x89de, 0x8fe9=>0x93f4, 0x8fea=>0xe78c, 0x8feb=>0x9497, 0x8fed=>0x9352, 0x8fef=>0xe78d, 0x8ff0=>0x8f71, 0x8ff4=>0xe78f, 
	0x8ff7=>0x96c0, 0x8ff8=>0xe79e, 0x8ff9=>0xe791, 0x8ffa=>0xe792, 0x8ffd=>0x92c7, 0x9000=>0x91de, 0x9001=>0x9197, 0x9003=>0x93a6, 0x9005=>0xe790, 0x9006=>0x8b74, 0x900b=>0xe799, 0x900d=>0xe796, 0x900e=>0xe7a3, 0x900f=>0x93a7, 0x9010=>0x9280, 0x9011=>0xe793, 
	0x9013=>0x92fc, 0x9014=>0x9372, 0x9015=>0xe794, 0x9016=>0xe798, 0x9017=>0x9080, 0x9019=>0x9487, 0x901a=>0x92ca, 0x901d=>0x90c0, 0x901e=>0xe797, 0x901f=>0x91ac, 0x9020=>0x91a2, 0x9021=>0xe795, 0x9022=>0x88a7, 0x9023=>0x9841, 0x9027=>0xe79a, 0x902e=>0x91df, 
	0x9031=>0x8f54, 0x9032=>0x9069, 0x9035=>0xe79c, 0x9036=>0xe79b, 0x9038=>0x88ed, 0x9039=>0xe79d, 0x903c=>0x954e, 0x903e=>0xe7a5, 0x9041=>0x93d9, 0x9042=>0x908b, 0x9045=>0x9278, 0x9047=>0x8bf6, 0x9049=>0xe7a4, 0x904a=>0x9756, 0x904b=>0x895e, 0x904d=>0x95d5, 
	0x904e=>0x89df, 0x904f=>0xe79f, 0x9050=>0xe7a0, 0x9051=>0xe7a1, 0x9052=>0xe7a2, 0x9053=>0x93b9, 0x9054=>0x9242, 0x9055=>0x88e1, 0x9056=>0xe7a6, 0x9058=>0xe7a7, 0x9059=>0xeaa1, 0x905c=>0x91bb, 0x905e=>0xe7a8, 0x9060=>0x8993, 0x9061=>0x916b, 0x9063=>0x8cad, 
	0x9065=>0x9779, 0x9068=>0xe7a9, 0x9069=>0x934b, 0x906d=>0x9198, 0x906e=>0x8ed5, 0x906f=>0xe7aa, 0x9072=>0xe7ad, 0x9075=>0x8f85, 0x9076=>0xe7ab, 0x9077=>0x914a, 0x9078=>0x9149, 0x907a=>0x88e2, 0x907c=>0x97c9, 0x907d=>0xe7af, 0x907f=>0x94f0, 0x9080=>0xe7b1, 
	0x9081=>0xe7b0, 0x9082=>0xe7ae, 0x9083=>0xe284, 0x9084=>0x8ad2, 0x9087=>0xe78e, 0x9089=>0xe7b3, 0x908a=>0xe7b2, 0x908f=>0xe7b4, 0x9091=>0x9757, 0x90a3=>0x93df, 0x90a6=>0x964d, 0x90a8=>0xe7b5, 0x90aa=>0x8ed7, 0x90af=>0xe7b6, 0x90b1=>0xe7b7, 0x90b5=>0xe7b8, 
	0x90b8=>0x9340, 0x90c1=>0x88e8, 0x90ca=>0x8d78, 0x90ce=>0x9859, 0x90db=>0xe7bc, 0x90e1=>0x8c53, 0x90e2=>0xe7b9, 0x90e4=>0xe7ba, 0x90e8=>0x9594, 0x90ed=>0x8a73, 0x90f5=>0x9758, 0x90f7=>0x8bbd, 0x90fd=>0x9373, 0x9102=>0xe7bd, 0x9112=>0xe7be, 0x9119=>0xe7bf, 
	0x912d=>0x9341, 0x9130=>0xe7c1, 0x9132=>0xe7c0, 0x9149=>0x93d1, 0x914a=>0xe7c2, 0x914b=>0x8f55, 0x914c=>0x8ede, 0x914d=>0x947a, 0x914e=>0x9291, 0x9152=>0x8ef0, 0x9154=>0x908c, 0x9156=>0xe7c3, 0x9158=>0xe7c4, 0x9162=>0x907c, 0x9163=>0xe7c5, 0x9165=>0xe7c6, 
	0x9169=>0xe7c7, 0x916a=>0x978f, 0x916c=>0x8f56, 0x9172=>0xe7c9, 0x9173=>0xe7c8, 0x9175=>0x8d79, 0x9177=>0x8d93, 0x9178=>0x8e5f, 0x9182=>0xe7cc, 0x9187=>0x8f86, 0x9189=>0xe7cb, 0x918b=>0xe7ca, 0x918d=>0x91e7, 0x9190=>0x8ced, 0x9192=>0x90c1, 0x9197=>0x94ae, 
	0x919c=>0x8f58, 0x91a2=>0xe7cd, 0x91a4=>0x8fdd, 0x91aa=>0xe7d0, 0x91ab=>0xe7ce, 0x91af=>0xe7cf, 0x91b4=>0xe7d2, 0x91b5=>0xe7d1, 0x91b8=>0x8ff8, 0x91ba=>0xe7d3, 0x91c0=>0xe7d4, 0x91c1=>0xe7d5, 0x91c6=>0x94ce, 0x91c7=>0x8dd1, 0x91c8=>0x8edf, 0x91c9=>0xe7d6, 
	0x91cb=>0xe7d7, 0x91cc=>0x97a2, 0x91cd=>0x8f64, 0x91ce=>0x96ec, 0x91cf=>0x97ca, 0x91d0=>0xe7d8, 0x91d1=>0x8be0, 0x91d6=>0xe7d9, 0x91d8=>0x9342, 0x91db=>0xe7dc, 0x91dc=>0x8a98, 0x91dd=>0x906a, 0x91df=>0xe7da, 0x91e1=>0xe7db, 0x91e3=>0x92de, 0x91e6=>0x9674, 
	0x91e7=>0x8bfa, 0x91f5=>0xe7de, 0x91f6=>0xe7df, 0x91fc=>0xe7dd, 0x91ff=>0xe7e1, 0x920d=>0x93dd, 0x920e=>0x8a62, 0x9211=>0xe7e5, 0x9214=>0xe7e2, 0x9215=>0xe7e4, 0x921e=>0xe7e0, 0x9229=>0xe86e, 0x922c=>0xe7e3, 0x9234=>0x97e9, 0x9237=>0x8cd8, 0x923f=>0xe7ed, 
	0x9244=>0x9353, 0x9245=>0xe7e8, 0x9248=>0xe7eb, 0x9249=>0xe7e9, 0x924b=>0xe7ee, 0x9250=>0xe7ef, 0x9257=>0xe7e7, 0x925a=>0xe7f4, 0x925b=>0x8994, 0x925e=>0xe7e6, 0x9262=>0x94ab, 0x9264=>0xe7ea, 0x9266=>0x8fde, 0x9271=>0x8d7a, 0x927e=>0x9667, 0x9280=>0x8be2, 
	0x9283=>0x8f65, 0x9285=>0x93ba, 0x9291=>0x914c, 0x9293=>0xe7f2, 0x9295=>0xe7ec, 0x9296=>0xe7f1, 0x9298=>0x96c1, 0x929a=>0x92b6, 0x929b=>0xe7f3, 0x929c=>0xe7f0, 0x92ad=>0x914b, 0x92b7=>0xe7f7, 0x92b9=>0xe7f6, 0x92cf=>0xe7f5, 0x92d2=>0x964e, 0x92e4=>0x8f9b, 
	0x92e9=>0xe7f8, 0x92ea=>0x95dd, 0x92ed=>0x8973, 0x92f2=>0x9565, 0x92f3=>0x9292, 0x92f8=>0x8b98, 0x92fa=>0xe7fa, 0x92fc=>0x8d7c, 0x9306=>0x8e4b, 0x930f=>0xe7f9, 0x9310=>0x908d, 0x9318=>0x908e, 0x9319=>0xe840, 0x931a=>0xe842, 0x9320=>0x8ff9, 0x9322=>0xe841, 
	0x9323=>0xe843, 0x9326=>0x8bd1, 0x9328=>0x9564, 0x932b=>0x8ee0, 0x932c=>0x9842, 0x932e=>0xe7fc, 0x932f=>0x8df6, 0x9332=>0x985e, 0x9335=>0xe845, 0x933a=>0xe844, 0x933b=>0xe846, 0x9344=>0xe7fb, 0x934b=>0x93e7, 0x934d=>0x9374, 0x9354=>0x92d5, 0x9356=>0xe84b, 
	0x935b=>0x9262, 0x935c=>0xe847, 0x9360=>0xe848, 0x936c=>0x8c4c, 0x936e=>0xe84a, 0x9375=>0x8cae, 0x937c=>0xe849, 0x937e=>0x8fdf, 0x938c=>0x8a99, 0x9394=>0xe84f, 0x9396=>0x8dbd, 0x9397=>0x9199, 0x939a=>0x92c8, 0x93a7=>0x8a5a, 0x93ac=>0xe84d, 0x93ad=>0xe84e, 
	0x93ae=>0x92c1, 0x93b0=>0xe84c, 0x93b9=>0xe850, 0x93c3=>0xe856, 0x93c8=>0xe859, 0x93d0=>0xe858, 0x93d1=>0x934c, 0x93d6=>0xe851, 0x93d7=>0xe852, 0x93d8=>0xe855, 0x93dd=>0xe857, 0x93e1=>0x8bbe, 0x93e4=>0xe85a, 0x93e5=>0xe854, 0x93e8=>0xe853, 0x9403=>0xe85e, 
	0x9407=>0xe85f, 0x9410=>0xe860, 0x9413=>0xe85d, 0x9414=>0xe85c, 0x9418=>0x8fe0, 0x9419=>0x93a8, 0x941a=>0xe85b, 0x9421=>0xe864, 0x942b=>0xe862, 0x9435=>0xe863, 0x9436=>0xe861, 0x9438=>0x91f6, 0x943a=>0xe865, 0x9441=>0xe866, 0x9444=>0xe868, 0x9451=>0x8ad3, 
	0x9452=>0xe867, 0x9453=>0x96f8, 0x945a=>0xe873, 0x945b=>0xe869, 0x945e=>0xe86c, 0x9460=>0xe86a, 0x9462=>0xe86b, 0x946a=>0xe86d, 0x9470=>0xe86f, 0x9475=>0xe870, 0x9477=>0xe871, 0x947c=>0xe874, 0x947d=>0xe872, 0x947e=>0xe875, 0x947f=>0xe877, 0x9481=>0xe876, 
	0x9577=>0x92b7, 0x9580=>0x96e5, 0x9582=>0xe878, 0x9583=>0x914d, 0x9587=>0xe879, 0x9589=>0x95c2, 0x958a=>0xe87a, 0x958b=>0x8a4a, 0x958f=>0x895b, 0x9591=>0x8ad5, 0x9593=>0x8ad4, 0x9594=>0xe87b, 0x9596=>0xe87c, 0x9598=>0xe87d, 0x9599=>0xe87e, 0x95a0=>0xe880, 
	0x95a2=>0x8ad6, 0x95a3=>0x8a74, 0x95a4=>0x8d7d, 0x95a5=>0x94b4, 0x95a7=>0xe882, 0x95a8=>0xe881, 0x95ad=>0xe883, 0x95b2=>0x897b, 0x95b9=>0xe886, 0x95bb=>0xe885, 0x95bc=>0xe884, 0x95be=>0xe887, 0x95c3=>0xe88a, 0x95c7=>0x88c5, 0x95ca=>0xe888, 0x95cc=>0xe88c, 
	0x95cd=>0xe88b, 0x95d4=>0xe88e, 0x95d5=>0xe88d, 0x95d6=>0xe88f, 0x95d8=>0x93ac, 0x95dc=>0xe890, 0x95e1=>0xe891, 0x95e2=>0xe893, 0x95e5=>0xe892, 0x961c=>0x958c, 0x9621=>0xe894, 0x9628=>0xe895, 0x962a=>0x8de3, 0x962e=>0xe896, 0x962f=>0xe897, 0x9632=>0x9668, 
	0x963b=>0x916a, 0x963f=>0x88a2, 0x9640=>0x91c9, 0x9642=>0xe898, 0x9644=>0x958d, 0x964b=>0xe89b, 0x964c=>0xe899, 0x964d=>0x8d7e, 0x964f=>0xe89a, 0x9650=>0x8cc0, 0x965b=>0x95c3, 0x965c=>0xe89d, 0x965d=>0xe89f, 0x965e=>0xe89e, 0x965f=>0xe8a0, 0x9662=>0x8940, 
	0x9663=>0x9077, 0x9664=>0x8f9c, 0x9665=>0x8ad7, 0x9666=>0xe8a1, 0x966a=>0x9486, 0x966c=>0xe8a3, 0x9670=>0x8941, 0x9672=>0xe8a2, 0x9673=>0x92c2, 0x9675=>0x97cb, 0x9676=>0x93a9, 0x9677=>0xe89c, 0x9678=>0x97a4, 0x967a=>0x8caf, 0x967d=>0x977a, 0x9685=>0x8bf7, 
	0x9686=>0x97b2, 0x9688=>0x8c47, 0x968a=>0x91e0, 0x968b=>0xe440, 0x968d=>0xe8a4, 0x968e=>0x8a4b, 0x968f=>0x908f, 0x9694=>0x8a75, 0x9695=>0xe8a6, 0x9697=>0xe8a7, 0x9698=>0xe8a5, 0x9699=>0x8c84, 0x969b=>0x8ddb, 0x969c=>0x8fe1, 0x96a0=>0x8942, 0x96a3=>0x97d7, 
	0x96a7=>0xe8a9, 0x96a8=>0xe7ac, 0x96aa=>0xe8a8, 0x96b0=>0xe8ac, 0x96b1=>0xe8aa, 0x96b2=>0xe8ab, 0x96b4=>0xe8ad, 0x96b6=>0xe8ae, 0x96b7=>0x97ea, 0x96b8=>0xe8af, 0x96b9=>0xe8b0, 0x96bb=>0x90c7, 0x96bc=>0x94b9, 0x96c0=>0x909d, 0x96c1=>0x8ae5, 0x96c4=>0x9759, 
	0x96c5=>0x89eb, 0x96c6=>0x8f57, 0x96c7=>0x8cd9, 0x96c9=>0xe8b3, 0x96cb=>0xe8b2, 0x96cc=>0x8e93, 0x96cd=>0xe8b4, 0x96ce=>0xe8b1, 0x96d1=>0x8e47, 0x96d5=>0xe8b8, 0x96d6=>0xe5ab, 0x96d9=>0x99d4, 0x96db=>0x9097, 0x96dc=>0xe8b6, 0x96e2=>0x97a3, 0x96e3=>0x93ef, 
	0x96e8=>0x894a, 0x96ea=>0x90e1, 0x96eb=>0x8eb4, 0x96f0=>0x95b5, 0x96f2=>0x895f, 0x96f6=>0x97eb, 0x96f7=>0x978b, 0x96f9=>0xe8b9, 0x96fb=>0x9364, 0x9700=>0x8ef9, 0x9704=>0xe8ba, 0x9706=>0xe8bb, 0x9707=>0x906b, 0x9708=>0xe8bc, 0x970a=>0x97ec, 0x970d=>0xe8b7, 
	0x970e=>0xe8be, 0x970f=>0xe8c0, 0x9711=>0xe8bf, 0x9713=>0xe8bd, 0x9716=>0xe8c1, 0x9719=>0xe8c2, 0x971c=>0x919a, 0x971e=>0x89e0, 0x9724=>0xe8c3, 0x9727=>0x96b6, 0x972a=>0xe8c4, 0x9730=>0xe8c5, 0x9732=>0x9849, 0x9738=>0x9e50, 0x9739=>0xe8c6, 0x973d=>0xe8c7, 
	0x973e=>0xe8c8, 0x9742=>0xe8cc, 0x9744=>0xe8c9, 0x9746=>0xe8ca, 0x9748=>0xe8cb, 0x9749=>0xe8cd, 0x9752=>0x90c2, 0x9756=>0x96f5, 0x9759=>0x90c3, 0x975c=>0xe8ce, 0x975e=>0x94f1, 0x9760=>0xe8cf, 0x9761=>0xea72, 0x9762=>0x96ca, 0x9764=>0xe8d0, 0x9766=>0xe8d1, 
	0x9768=>0xe8d2, 0x9769=>0x8a76, 0x976b=>0xe8d4, 0x976d=>0x9078, 0x9771=>0xe8d5, 0x9774=>0x8c43, 0x9779=>0xe8d6, 0x977a=>0xe8da, 0x977c=>0xe8d8, 0x9781=>0xe8d9, 0x9784=>0x8a93, 0x9785=>0xe8d7, 0x9786=>0xe8db, 0x978b=>0xe8dc, 0x978d=>0x88c6, 0x978f=>0xe8dd, 
	0x9790=>0xe8de, 0x9798=>0x8fe2, 0x979c=>0xe8df, 0x97a0=>0x8b66, 0x97a3=>0xe8e2, 0x97a6=>0xe8e1, 0x97a8=>0xe8e0, 0x97ab=>0xe691, 0x97ad=>0x95da, 0x97b3=>0xe8e3, 0x97b4=>0xe8e4, 0x97c3=>0xe8e5, 0x97c6=>0xe8e6, 0x97c8=>0xe8e7, 0x97cb=>0xe8e8, 0x97d3=>0x8ad8, 
	0x97dc=>0xe8e9, 0x97ed=>0xe8ea, 0x97ee=>0x9442, 0x97f2=>0xe8ec, 0x97f3=>0x89b9, 0x97f5=>0xe8ef, 0x97f6=>0xe8ee, 0x97fb=>0x8943, 0x97ff=>0x8bbf, 0x9801=>0x95c5, 0x9802=>0x92b8, 0x9803=>0x8da0, 0x9805=>0x8d80, 0x9806=>0x8f87, 0x9808=>0x907b, 0x980c=>0xe8f1, 
	0x980f=>0xe8f0, 0x9810=>0x9761, 0x9811=>0x8ae6, 0x9812=>0x94d0, 0x9813=>0x93da, 0x9817=>0x909c, 0x9818=>0x97cc, 0x981a=>0x8c7a, 0x9821=>0xe8f4, 0x9824=>0xe8f3, 0x982c=>0x966a, 0x982d=>0x93aa, 0x9834=>0x896f, 0x9837=>0xe8f5, 0x9838=>0xe8f2, 0x983b=>0x9570, 
	0x983c=>0x978a, 0x983d=>0xe8f6, 0x9846=>0xe8f7, 0x984b=>0xe8f9, 0x984c=>0x91e8, 0x984d=>0x8a7a, 0x984e=>0x8a7b, 0x984f=>0xe8f8, 0x9854=>0x8ae7, 0x9855=>0x8cb0, 0x9858=>0x8ae8, 0x985b=>0x935e, 0x985e=>0x97de, 0x9867=>0x8cda, 0x986b=>0xe8fa, 0x986f=>0xe8fb, 
	0x9870=>0xe8fc, 0x9871=>0xe940, 0x9873=>0xe942, 0x9874=>0xe941, 0x98a8=>0x9597, 0x98aa=>0xe943, 0x98af=>0xe944, 0x98b1=>0xe945, 0x98b6=>0xe946, 0x98c3=>0xe948, 0x98c4=>0xe947, 0x98c6=>0xe949, 0x98db=>0x94f2, 0x98dc=>0xe3ca, 0x98df=>0x9048, 0x98e2=>0x8b51, 
	0x98e9=>0xe94a, 0x98eb=>0xe94b, 0x98ed=>0x99aa, 0x98ee=>0x9f5a, 0x98ef=>0x94d1, 0x98f2=>0x88f9, 0x98f4=>0x88b9, 0x98fc=>0x8e94, 0x98fd=>0x964f, 0x98fe=>0x8ffc, 0x9903=>0xe94c, 0x9905=>0x96dd, 0x9909=>0xe94d, 0x990a=>0x977b, 0x990c=>0x8961, 0x9910=>0x8e60, 
	0x9912=>0xe94e, 0x9913=>0x89ec, 0x9914=>0xe94f, 0x9918=>0xe950, 0x991d=>0xe952, 0x991e=>0xe953, 0x9920=>0xe955, 0x9921=>0xe951, 0x9924=>0xe954, 0x9928=>0x8ad9, 0x992c=>0xe956, 0x992e=>0xe957, 0x993d=>0xe958, 0x993e=>0xe959, 0x9942=>0xe95a, 0x9945=>0xe95c, 
	0x9949=>0xe95b, 0x994b=>0xe95e, 0x994c=>0xe961, 0x9950=>0xe95d, 0x9951=>0xe95f, 0x9952=>0xe960, 0x9955=>0xe962, 0x9957=>0x8bc0, 0x9996=>0x8ef1, 0x9997=>0xe963, 0x9998=>0xe964, 0x9999=>0x8d81, 0x99a5=>0xe965, 0x99a8=>0x8a5d, 0x99ac=>0x946e, 0x99ad=>0xe966, 
	0x99ae=>0xe967, 0x99b3=>0x9279, 0x99b4=>0x93e9, 0x99bc=>0xe968, 0x99c1=>0x949d, 0x99c4=>0x91ca, 0x99c5=>0x8977, 0x99c6=>0x8bec, 0x99c8=>0x8bed, 0x99d0=>0x9293, 0x99d1=>0xe96d, 0x99d2=>0x8bee, 0x99d5=>0x89ed, 0x99d8=>0xe96c, 0x99db=>0xe96a, 0x99dd=>0xe96b, 
	0x99df=>0xe969, 0x99e2=>0xe977, 0x99ed=>0xe96e, 0x99ee=>0xe96f, 0x99f1=>0xe970, 0x99f2=>0xe971, 0x99f8=>0xe973, 0x99fb=>0xe972, 0x99ff=>0x8f78, 0x9a01=>0xe974, 0x9a05=>0xe976, 0x9a0e=>0x8b52, 0x9a0f=>0xe975, 0x9a12=>0x919b, 0x9a13=>0x8cb1, 0x9a19=>0xe978, 
	0x9a28=>0x91cb, 0x9a2b=>0xe979, 0x9a30=>0x93ab, 0x9a37=>0xe97a, 0x9a3e=>0xe980, 0x9a40=>0xe97d, 0x9a42=>0xe97c, 0x9a43=>0xe97e, 0x9a45=>0xe97b, 0x9a4d=>0xe982, 0x9a55=>0xe981, 0x9a57=>0xe984, 0x9a5a=>0x8bc1, 0x9a5b=>0xe983, 0x9a5f=>0xe985, 0x9a62=>0xe986, 
	0x9a64=>0xe988, 0x9a65=>0xe987, 0x9a69=>0xe989, 0x9a6a=>0xe98b, 0x9a6b=>0xe98a, 0x9aa8=>0x8d9c, 0x9aad=>0xe98c, 0x9ab0=>0xe98d, 0x9ab8=>0x8a5b, 0x9abc=>0xe98e, 0x9ac0=>0xe98f, 0x9ac4=>0x9091, 0x9acf=>0xe990, 0x9ad1=>0xe991, 0x9ad3=>0xe992, 0x9ad4=>0xe993, 
	0x9ad8=>0x8d82, 0x9ade=>0xe994, 0x9adf=>0xe995, 0x9ae2=>0xe996, 0x9ae3=>0xe997, 0x9ae6=>0xe998, 0x9aea=>0x94af, 0x9aeb=>0xe99a, 0x9aed=>0x9545, 0x9aee=>0xe99b, 0x9aef=>0xe999, 0x9af1=>0xe99d, 0x9af4=>0xe99c, 0x9af7=>0xe99e, 0x9afb=>0xe99f, 0x9b06=>0xe9a0, 
	0x9b18=>0xe9a1, 0x9b1a=>0xe9a2, 0x9b1f=>0xe9a3, 0x9b22=>0xe9a4, 0x9b23=>0xe9a5, 0x9b25=>0xe9a6, 0x9b27=>0xe9a7, 0x9b28=>0xe9a8, 0x9b29=>0xe9a9, 0x9b2a=>0xe9aa, 0x9b2e=>0xe9ab, 0x9b2f=>0xe9ac, 0x9b31=>0x9f54, 0x9b32=>0xe9ad, 0x9b3b=>0xe2f6, 0x9b3c=>0x8b53, 
	0x9b41=>0x8a40, 0x9b42=>0x8db0, 0x9b43=>0xe9af, 0x9b44=>0xe9ae, 0x9b45=>0x96a3, 0x9b4d=>0xe9b1, 0x9b4e=>0xe9b2, 0x9b4f=>0xe9b0, 0x9b51=>0xe9b3, 0x9b54=>0x9682, 0x9b58=>0xe9b4, 0x9b5a=>0x8b9b, 0x9b6f=>0x9844, 0x9b74=>0xe9b5, 0x9b83=>0xe9b7, 0x9b8e=>0x88bc, 
	0x9b91=>0xe9b8, 0x9b92=>0x95a9, 0x9b93=>0xe9b6, 0x9b96=>0xe9b9, 0x9b97=>0xe9ba, 0x9b9f=>0xe9bb, 0x9ba0=>0xe9bc, 0x9ba8=>0xe9bd, 0x9baa=>0x968e, 0x9bab=>0x8e4c, 0x9bad=>0x8df8, 0x9bae=>0x914e, 0x9bb4=>0xe9be, 0x9bb9=>0xe9c1, 0x9bc0=>0xe9bf, 0x9bc6=>0xe9c2, 
	0x9bc9=>0x8cef, 0x9bca=>0xe9c0, 0x9bcf=>0xe9c3, 0x9bd1=>0xe9c4, 0x9bd2=>0xe9c5, 0x9bd4=>0xe9c9, 0x9bd6=>0x8e49, 0x9bdb=>0x91e2, 0x9be1=>0xe9ca, 0x9be2=>0xe9c7, 0x9be3=>0xe9c6, 0x9be4=>0xe9c8, 0x9be8=>0x8c7e, 0x9bf0=>0xe9ce, 0x9bf1=>0xe9cd, 0x9bf2=>0xe9cc, 
	0x9bf5=>0x88b1, 0x9c04=>0xe9d8, 0x9c06=>0xe9d4, 0x9c08=>0xe9d5, 0x9c09=>0xe9d1, 0x9c0a=>0xe9d7, 0x9c0c=>0xe9d3, 0x9c0d=>0x8a82, 0x9c10=>0x986b, 0x9c12=>0xe9d6, 0x9c13=>0xe9d2, 0x9c14=>0xe9d0, 0x9c15=>0xe9cf, 0x9c1b=>0xe9da, 0x9c21=>0xe9dd, 0x9c24=>0xe9dc, 
	0x9c25=>0xe9db, 0x9c2d=>0x9568, 0x9c2e=>0xe9d9, 0x9c2f=>0x88f1, 0x9c30=>0xe9de, 0x9c32=>0xe9e0, 0x9c39=>0x8a8f, 0x9c3a=>0xe9cb, 0x9c3b=>0x8956, 0x9c3e=>0xe9e2, 0x9c46=>0xe9e1, 0x9c47=>0xe9df, 0x9c48=>0x924c, 0x9c52=>0x9690, 0x9c57=>0x97d8, 0x9c5a=>0xe9e3, 
	0x9c60=>0xe9e4, 0x9c67=>0xe9e5, 0x9c76=>0xe9e6, 0x9c78=>0xe9e7, 0x9ce5=>0x92b9, 0x9ce7=>0xe9e8, 0x9ce9=>0x94b5, 0x9ceb=>0xe9ed, 0x9cec=>0xe9e9, 0x9cf0=>0xe9ea, 0x9cf3=>0x9650, 0x9cf4=>0x96c2, 0x9cf6=>0x93ce, 0x9d03=>0xe9ee, 0x9d06=>0xe9ef, 0x9d07=>0x93bc, 
	0x9d08=>0xe9ec, 0x9d09=>0xe9eb, 0x9d0e=>0x89a8, 0x9d12=>0xe9f7, 0x9d15=>0xe9f6, 0x9d1b=>0x8995, 0x9d1f=>0xe9f4, 0x9d23=>0xe9f3, 0x9d26=>0xe9f1, 0x9d28=>0x8a9b, 0x9d2a=>0xe9f0, 0x9d2b=>0x8eb0, 0x9d2c=>0x89a7, 0x9d3b=>0x8d83, 0x9d3e=>0xe9fa, 0x9d3f=>0xe9f9, 
	0x9d41=>0xe9f8, 0x9d44=>0xe9f5, 0x9d46=>0xe9fb, 0x9d48=>0xe9fc, 0x9d50=>0xea44, 0x9d51=>0xea43, 0x9d59=>0xea45, 0x9d5c=>0x894c, 0x9d5d=>0xea40, 0x9d5e=>0xea41, 0x9d60=>0x8d94, 0x9d61=>0x96b7, 0x9d64=>0xea42, 0x9d6c=>0x9651, 0x9d6f=>0xea4a, 0x9d72=>0xea46, 
	0x9d7a=>0xea4b, 0x9d87=>0xea48, 0x9d89=>0xea47, 0x9d8f=>0x8c7b, 0x9d9a=>0xea4c, 0x9da4=>0xea4d, 0x9da9=>0xea4e, 0x9dab=>0xea49, 0x9daf=>0xe9f2, 0x9db2=>0xea4f, 0x9db4=>0x92df, 0x9db8=>0xea53, 0x9dba=>0xea54, 0x9dbb=>0xea52, 0x9dc1=>0xea51, 0x9dc2=>0xea57, 
	0x9dc4=>0xea50, 0x9dc6=>0xea55, 0x9dcf=>0xea56, 0x9dd3=>0xea59, 0x9dd9=>0xea58, 0x9de6=>0xea5b, 0x9ded=>0xea5c, 0x9def=>0xea5d, 0x9df2=>0x9868, 0x9df8=>0xea5a, 0x9df9=>0x91e9, 0x9dfa=>0x8deb, 0x9dfd=>0xea5e, 0x9e1a=>0xea5f, 0x9e1b=>0xea60, 0x9e1e=>0xea61, 
	0x9e75=>0xea62, 0x9e78=>0x8cb2, 0x9e79=>0xea63, 0x9e7d=>0xea64, 0x9e7f=>0x8ead, 0x9e81=>0xea65, 0x9e88=>0xea66, 0x9e8b=>0xea67, 0x9e8c=>0xea68, 0x9e91=>0xea6b, 0x9e92=>0xea69, 0x9e93=>0x985b, 0x9e95=>0xea6a, 0x9e97=>0x97ed, 0x9e9d=>0xea6c, 0x9e9f=>0x97d9, 
	0x9ea5=>0xea6d, 0x9ea6=>0x949e, 0x9ea9=>0xea6e, 0x9eaa=>0xea70, 0x9ead=>0xea71, 0x9eb8=>0xea6f, 0x9eb9=>0x8d8d, 0x9eba=>0x96cb, 0x9ebb=>0x9683, 0x9ebc=>0x9bf5, 0x9ebe=>0x9f80, 0x9ebf=>0x969b, 0x9ec4=>0x89a9, 0x9ecc=>0xea73, 0x9ecd=>0x8b6f, 0x9ece=>0xea74, 
	0x9ecf=>0xea75, 0x9ed0=>0xea76, 0x9ed2=>0x8d95, 0x9ed4=>0xea77, 0x9ed8=>0xe0d2, 0x9ed9=>0x96d9, 0x9edb=>0x91e1, 0x9edc=>0xea78, 0x9edd=>0xea7a, 0x9ede=>0xea79, 0x9ee0=>0xea7b, 0x9ee5=>0xea7c, 0x9ee8=>0xea7d, 0x9eef=>0xea7e, 0x9ef4=>0xea80, 0x9ef6=>0xea81, 
	0x9ef7=>0xea82, 0x9ef9=>0xea83, 0x9efb=>0xea84, 0x9efc=>0xea85, 0x9efd=>0xea86, 0x9f07=>0xea87, 0x9f08=>0xea88, 0x9f0e=>0x9343, 0x9f13=>0x8cdb, 0x9f15=>0xea8a, 0x9f20=>0x916c, 0x9f21=>0xea8b, 0x9f2c=>0xea8c, 0x9f3b=>0x9540, 0x9f3e=>0xea8d, 0x9f4a=>0xea8e, 
	0x9f4b=>0xe256, 0x9f4e=>0xe6d8, 0x9f4f=>0xe8eb, 0x9f52=>0xea8f, 0x9f54=>0xea90, 0x9f5f=>0xea92, 0x9f60=>0xea93, 0x9f61=>0xea94, 0x9f62=>0x97ee, 0x9f63=>0xea91, 0x9f66=>0xea95, 0x9f67=>0xea96, 0x9f6a=>0xea98, 0x9f6c=>0xea97, 0x9f72=>0xea9a, 0x9f76=>0xea9b, 
	0x9f77=>0xea99, 0x9f8d=>0x97b4, 0x9f95=>0xea9c, 0x9f9c=>0xea9d, 0x9f9d=>0xe273, 0x9fa0=>0xea9e, 0xff01=>0x8149, 0xff03=>0x8194, 0xff04=>0x8190, 0xff05=>0x8193, 0xff06=>0x8195, 0xff08=>0x8169, 0xff09=>0x816a, 0xff0a=>0x8196, 0xff0b=>0x817b, 0xff0c=>0x8143, 
	0xff0d=>0x817c, 0xff0e=>0x8144, 0xff0f=>0x815e, 0xff10=>0x824f, 0xff11=>0x8250, 0xff12=>0x8251, 0xff13=>0x8252, 0xff14=>0x8253, 0xff15=>0x8254, 0xff16=>0x8255, 0xff17=>0x8256, 0xff18=>0x8257, 0xff19=>0x8258, 0xff1a=>0x8146, 0xff1b=>0x8147, 0xff1c=>0x8183, 
	0xff1d=>0x8181, 0xff1e=>0x8184, 0xff1f=>0x8148, 0xff20=>0x8197, 0xff21=>0x8260, 0xff22=>0x8261, 0xff23=>0x8262, 0xff24=>0x8263, 0xff25=>0x8264, 0xff26=>0x8265, 0xff27=>0x8266, 0xff28=>0x8267, 0xff29=>0x8268, 0xff2a=>0x8269, 0xff2b=>0x826a, 0xff2c=>0x826b, 
	0xff2d=>0x826c, 0xff2e=>0x826d, 0xff2f=>0x826e, 0xff30=>0x826f, 0xff31=>0x8270, 0xff32=>0x8271, 0xff33=>0x8272, 0xff34=>0x8273, 0xff35=>0x8274, 0xff36=>0x8275, 0xff37=>0x8276, 0xff38=>0x8277, 0xff39=>0x8278, 0xff3a=>0x8279, 0xff3b=>0x816d, 0xff3c=>0x815f, 
	0xff3d=>0x816e, 0xff3e=>0x814f, 0xff3f=>0x8151, 0xff40=>0x814d, 0xff41=>0x8281, 0xff42=>0x8282, 0xff43=>0x8283, 0xff44=>0x8284, 0xff45=>0x8285, 0xff46=>0x8286, 0xff47=>0x8287, 0xff48=>0x8288, 0xff49=>0x8289, 0xff4a=>0x828a, 0xff4b=>0x828b, 0xff4c=>0x828c, 
	0xff4d=>0x828d, 0xff4e=>0x828e, 0xff4f=>0x828f, 0xff50=>0x8290, 0xff51=>0x8291, 0xff52=>0x8292, 0xff53=>0x8293, 0xff54=>0x8294, 0xff55=>0x8295, 0xff56=>0x8296, 0xff57=>0x8297, 0xff58=>0x8298, 0xff59=>0x8299, 0xff5a=>0x829a, 0xff5b=>0x816f, 0xff5c=>0x8162, 
	0xff5d=>0x8170, 0xff5e=>0x8160, 0xffe0=>0x8191, 0xffe1=>0x8192, 0xffe2=>0x81ca, 0xffe3=>0x8150, 0xffe5=>0x818f, 
);

/*
Convert Japanese encode from numric decimal charcter entity references to Shift-JIS.
 -JIS X 0201 (alphabet, numbers, punctuations and halfwide Kana)
 -JIS X 0213 1 (Japanese Graphic Character Set for Information Interchange, Plane 1)
 -JIS X 0213 2 (Japanese Graphic Character Set for Information Interchange, Plane 2)
*/
function xnpEntity2Sjis ($str) {
	if (($str == '') || ($str == NULL)){
		return $str;
	}
	if (!preg_match("/&#\d{1,8};/", $str)) {
		return $str;
	}
	$wk = explode("&", $str);
	$str2 = array();
	$i = 0;
	global $ucs2sjis;
	foreach ($wk as  $key => $value) {
		if ((substr($value, 0, 1) == "#") && (substr_count($value, ";") > 0)) {
			$value1 = (int)substr($value, 1, strpos($value, ";") - 1);
			$value2 = substr(strstr($value, ";"), 1);
			
			if ( isset( $ucs2sjis[$value1] ) ){
				$code = $ucs2sjis[$value1];
				$str2[] = chr($code/256) . chr($code%256);
			}
			else if ( $value1 < 0x0080 ){
				$str2[] = chr($value1);
			}
			else {
				$str2[] = "&#$value1;";
			}
			$str2[] = $value2;
		}
		else {
			if (($i == 0) && (substr($str, 0, 1) != "&")) {
				$str2[] = $value;
			}
			else {
				if ($value != "") {
					$str2[] = "&".$value;
				}
			}
		}
		$i++;
	}
	return implode( '', $str2 );
}


$ucs2euc = array( 
	0x00a2=>0xa1f1, 0x00a3=>0xa1f2, 0x00a7=>0xa1f8, 0x00a8=>0xa1af, 0x00ac=>0xa2cc, 0x00b0=>0xa1eb, 0x00b1=>0xa1de, 0x00b4=>0xa1ad, 0x00b6=>0xa2f9, 0x00d7=>0xa1df, 0x00f7=>0xa1e0, 0x0391=>0xa6a1, 0x0392=>0xa6a2, 0x0393=>0xa6a3, 0x0394=>0xa6a4, 0x0395=>0xa6a5, 
	0x0396=>0xa6a6, 0x0397=>0xa6a7, 0x0398=>0xa6a8, 0x0399=>0xa6a9, 0x039a=>0xa6aa, 0x039b=>0xa6ab, 0x039c=>0xa6ac, 0x039d=>0xa6ad, 0x039e=>0xa6ae, 0x039f=>0xa6af, 0x03a0=>0xa6b0, 0x03a1=>0xa6b1, 0x03a3=>0xa6b2, 0x03a4=>0xa6b3, 0x03a5=>0xa6b4, 0x03a6=>0xa6b5, 
	0x03a7=>0xa6b6, 0x03a8=>0xa6b7, 0x03a9=>0xa6b8, 0x03b1=>0xa6c1, 0x03b2=>0xa6c2, 0x03b3=>0xa6c3, 0x03b4=>0xa6c4, 0x03b5=>0xa6c5, 0x03b6=>0xa6c6, 0x03b7=>0xa6c7, 0x03b8=>0xa6c8, 0x03b9=>0xa6c9, 0x03ba=>0xa6ca, 0x03bb=>0xa6cb, 0x03bc=>0xa6cc, 0x03bd=>0xa6cd, 
	0x03be=>0xa6ce, 0x03bf=>0xa6cf, 0x03c0=>0xa6d0, 0x03c1=>0xa6d1, 0x03c3=>0xa6d2, 0x03c4=>0xa6d3, 0x03c5=>0xa6d4, 0x03c6=>0xa6d5, 0x03c7=>0xa6d6, 0x03c8=>0xa6d7, 0x03c9=>0xa6d8, 0x0401=>0xa7a7, 0x0410=>0xa7a1, 0x0411=>0xa7a2, 0x0412=>0xa7a3, 0x0413=>0xa7a4, 
	0x0414=>0xa7a5, 0x0415=>0xa7a6, 0x0416=>0xa7a8, 0x0417=>0xa7a9, 0x0418=>0xa7aa, 0x0419=>0xa7ab, 0x041a=>0xa7ac, 0x041b=>0xa7ad, 0x041c=>0xa7ae, 0x041d=>0xa7af, 0x041e=>0xa7b0, 0x041f=>0xa7b1, 0x0420=>0xa7b2, 0x0421=>0xa7b3, 0x0422=>0xa7b4, 0x0423=>0xa7b5, 
	0x0424=>0xa7b6, 0x0425=>0xa7b7, 0x0426=>0xa7b8, 0x0427=>0xa7b9, 0x0428=>0xa7ba, 0x0429=>0xa7bb, 0x042a=>0xa7bc, 0x042b=>0xa7bd, 0x042c=>0xa7be, 0x042d=>0xa7bf, 0x042e=>0xa7c0, 0x042f=>0xa7c1, 0x0430=>0xa7d1, 0x0431=>0xa7d2, 0x0432=>0xa7d3, 0x0433=>0xa7d4, 
	0x0434=>0xa7d5, 0x0435=>0xa7d6, 0x0436=>0xa7d8, 0x0437=>0xa7d9, 0x0438=>0xa7da, 0x0439=>0xa7db, 0x043a=>0xa7dc, 0x043b=>0xa7dd, 0x043c=>0xa7de, 0x043d=>0xa7df, 0x043e=>0xa7e0, 0x043f=>0xa7e1, 0x0440=>0xa7e2, 0x0441=>0xa7e3, 0x0442=>0xa7e4, 0x0443=>0xa7e5, 
	0x0444=>0xa7e6, 0x0445=>0xa7e7, 0x0446=>0xa7e8, 0x0447=>0xa7e9, 0x0448=>0xa7ea, 0x0449=>0xa7eb, 0x044a=>0xa7ec, 0x044b=>0xa7ed, 0x044c=>0xa7ee, 0x044d=>0xa7ef, 0x044e=>0xa7f0, 0x044f=>0xa7f1, 0x0451=>0xa7d7, 0x2010=>0xa1be, 0x2015=>0xa1bd, 0x2016=>0xa1c2, 
	0x2018=>0xa1c6, 0x2019=>0xa1c7, 0x201c=>0xa1c8, 0x201d=>0xa1c9, 0x2020=>0xa2f7, 0x2021=>0xa2f8, 0x2025=>0xa1c5, 0x2026=>0xa1c4, 0x2030=>0xa2f3, 0x2032=>0xa1ec, 0x2033=>0xa1ed, 0x203b=>0xa2a8, 0x2103=>0xa1ee, 0x212b=>0xa2f2, 0x2190=>0xa2ab, 0x2191=>0xa2ac, 
	0x2192=>0xa2aa, 0x2193=>0xa2ad, 0x21d2=>0xa2cd, 0x21d4=>0xa2ce, 0x2200=>0xa2cf, 0x2202=>0xa2df, 0x2203=>0xa2d0, 0x2207=>0xa2e0, 0x2208=>0xa2ba, 0x220b=>0xa2bb, 0x2212=>0xa1dd, 0x221a=>0xa2e5, 0x221d=>0xa2e7, 0x221e=>0xa1e7, 0x2220=>0xa2dc, 0x2225=>0xa1c2, 
	0x2227=>0xa2ca, 0x2228=>0xa2cb, 0x2229=>0xa2c1, 0x222a=>0xa2c0, 0x222b=>0xa2e9, 0x222c=>0xa2ea, 0x2234=>0xa1e8, 0x2235=>0xa2e8, 0x223d=>0xa2e6, 0x2252=>0xa2e2, 0x2260=>0xa1e2, 0x2261=>0xa2e1, 0x2266=>0xa1e5, 0x2267=>0xa1e6, 0x226a=>0xa2e3, 0x226b=>0xa2e4, 
	0x2282=>0xa2be, 0x2283=>0xa2bf, 0x2286=>0xa2bc, 0x2287=>0xa2bd, 0x22a5=>0xa2dd, 0x2312=>0xa2de, 0x2500=>0xa8a1, 0x2501=>0xa8ac, 0x2502=>0xa8a2, 0x2503=>0xa8ad, 0x250c=>0xa8a3, 0x250f=>0xa8ae, 0x2510=>0xa8a4, 0x2513=>0xa8af, 0x2514=>0xa8a6, 0x2517=>0xa8b1, 
	0x2518=>0xa8a5, 0x251b=>0xa8b0, 0x251c=>0xa8a7, 0x251d=>0xa8bc, 0x2520=>0xa8b7, 0x2523=>0xa8b2, 0x2524=>0xa8a9, 0x2525=>0xa8be, 0x2528=>0xa8b9, 0x252b=>0xa8b4, 0x252c=>0xa8a8, 0x252f=>0xa8b8, 0x2530=>0xa8bd, 0x2533=>0xa8b3, 0x2534=>0xa8aa, 0x2537=>0xa8ba, 
	0x2538=>0xa8bf, 0x253b=>0xa8b5, 0x253c=>0xa8ab, 0x253f=>0xa8bb, 0x2542=>0xa8c0, 0x254b=>0xa8b6, 0x25a0=>0xa2a3, 0x25a1=>0xa2a2, 0x25b2=>0xa2a5, 0x25b3=>0xa2a4, 0x25bc=>0xa2a7, 0x25bd=>0xa2a6, 0x25c6=>0xa2a1, 0x25c7=>0xa1fe, 0x25cb=>0xa1fb, 0x25ce=>0xa1fd, 
	0x25cf=>0xa1fc, 0x25ef=>0xa2fe, 0x2605=>0xa1fa, 0x2606=>0xa1f9, 0x2640=>0xa1ea, 0x2642=>0xa1e9, 0x266a=>0xa2f6, 0x266d=>0xa2f5, 0x266f=>0xa2f4, 0x3000=>0xa1a1, 0x3001=>0xa1a2, 0x3002=>0xa1a3, 0x3003=>0xa1b7, 0x3005=>0xa1b9, 0x3006=>0xa1ba, 0x3007=>0xa1bb, 
	0x3008=>0xa1d2, 0x3009=>0xa1d3, 0x300a=>0xa1d4, 0x300b=>0xa1d5, 0x300c=>0xa1d6, 0x300d=>0xa1d7, 0x300e=>0xa1d8, 0x300f=>0xa1d9, 0x3010=>0xa1da, 0x3011=>0xa1db, 0x3012=>0xa2a9, 0x3013=>0xa2ae, 0x3014=>0xa1cc, 0x3015=>0xa1cd, 0x301c=>0xa1c1, 0x3041=>0xa4a1, 
	0x3042=>0xa4a2, 0x3043=>0xa4a3, 0x3044=>0xa4a4, 0x3045=>0xa4a5, 0x3046=>0xa4a6, 0x3047=>0xa4a7, 0x3048=>0xa4a8, 0x3049=>0xa4a9, 0x304a=>0xa4aa, 0x304b=>0xa4ab, 0x304c=>0xa4ac, 0x304d=>0xa4ad, 0x304e=>0xa4ae, 0x304f=>0xa4af, 0x3050=>0xa4b0, 0x3051=>0xa4b1, 
	0x3052=>0xa4b2, 0x3053=>0xa4b3, 0x3054=>0xa4b4, 0x3055=>0xa4b5, 0x3056=>0xa4b6, 0x3057=>0xa4b7, 0x3058=>0xa4b8, 0x3059=>0xa4b9, 0x305a=>0xa4ba, 0x305b=>0xa4bb, 0x305c=>0xa4bc, 0x305d=>0xa4bd, 0x305e=>0xa4be, 0x305f=>0xa4bf, 0x3060=>0xa4c0, 0x3061=>0xa4c1, 
	0x3062=>0xa4c2, 0x3063=>0xa4c3, 0x3064=>0xa4c4, 0x3065=>0xa4c5, 0x3066=>0xa4c6, 0x3067=>0xa4c7, 0x3068=>0xa4c8, 0x3069=>0xa4c9, 0x306a=>0xa4ca, 0x306b=>0xa4cb, 0x306c=>0xa4cc, 0x306d=>0xa4cd, 0x306e=>0xa4ce, 0x306f=>0xa4cf, 0x3070=>0xa4d0, 0x3071=>0xa4d1, 
	0x3072=>0xa4d2, 0x3073=>0xa4d3, 0x3074=>0xa4d4, 0x3075=>0xa4d5, 0x3076=>0xa4d6, 0x3077=>0xa4d7, 0x3078=>0xa4d8, 0x3079=>0xa4d9, 0x307a=>0xa4da, 0x307b=>0xa4db, 0x307c=>0xa4dc, 0x307d=>0xa4dd, 0x307e=>0xa4de, 0x307f=>0xa4df, 0x3080=>0xa4e0, 0x3081=>0xa4e1, 
	0x3082=>0xa4e2, 0x3083=>0xa4e3, 0x3084=>0xa4e4, 0x3085=>0xa4e5, 0x3086=>0xa4e6, 0x3087=>0xa4e7, 0x3088=>0xa4e8, 0x3089=>0xa4e9, 0x308a=>0xa4ea, 0x308b=>0xa4eb, 0x308c=>0xa4ec, 0x308d=>0xa4ed, 0x308e=>0xa4ee, 0x308f=>0xa4ef, 0x3090=>0xa4f0, 0x3091=>0xa4f1, 
	0x3092=>0xa4f2, 0x3093=>0xa4f3, 0x309b=>0xa1ab, 0x309c=>0xa1ac, 0x309d=>0xa1b5, 0x309e=>0xa1b6, 0x30a1=>0xa5a1, 0x30a2=>0xa5a2, 0x30a3=>0xa5a3, 0x30a4=>0xa5a4, 0x30a5=>0xa5a5, 0x30a6=>0xa5a6, 0x30a7=>0xa5a7, 0x30a8=>0xa5a8, 0x30a9=>0xa5a9, 0x30aa=>0xa5aa, 
	0x30ab=>0xa5ab, 0x30ac=>0xa5ac, 0x30ad=>0xa5ad, 0x30ae=>0xa5ae, 0x30af=>0xa5af, 0x30b0=>0xa5b0, 0x30b1=>0xa5b1, 0x30b2=>0xa5b2, 0x30b3=>0xa5b3, 0x30b4=>0xa5b4, 0x30b5=>0xa5b5, 0x30b6=>0xa5b6, 0x30b7=>0xa5b7, 0x30b8=>0xa5b8, 0x30b9=>0xa5b9, 0x30ba=>0xa5ba, 
	0x30bb=>0xa5bb, 0x30bc=>0xa5bc, 0x30bd=>0xa5bd, 0x30be=>0xa5be, 0x30bf=>0xa5bf, 0x30c0=>0xa5c0, 0x30c1=>0xa5c1, 0x30c2=>0xa5c2, 0x30c3=>0xa5c3, 0x30c4=>0xa5c4, 0x30c5=>0xa5c5, 0x30c6=>0xa5c6, 0x30c7=>0xa5c7, 0x30c8=>0xa5c8, 0x30c9=>0xa5c9, 0x30ca=>0xa5ca, 
	0x30cb=>0xa5cb, 0x30cc=>0xa5cc, 0x30cd=>0xa5cd, 0x30ce=>0xa5ce, 0x30cf=>0xa5cf, 0x30d0=>0xa5d0, 0x30d1=>0xa5d1, 0x30d2=>0xa5d2, 0x30d3=>0xa5d3, 0x30d4=>0xa5d4, 0x30d5=>0xa5d5, 0x30d6=>0xa5d6, 0x30d7=>0xa5d7, 0x30d8=>0xa5d8, 0x30d9=>0xa5d9, 0x30da=>0xa5da, 
	0x30db=>0xa5db, 0x30dc=>0xa5dc, 0x30dd=>0xa5dd, 0x30de=>0xa5de, 0x30df=>0xa5df, 0x30e0=>0xa5e0, 0x30e1=>0xa5e1, 0x30e2=>0xa5e2, 0x30e3=>0xa5e3, 0x30e4=>0xa5e4, 0x30e5=>0xa5e5, 0x30e6=>0xa5e6, 0x30e7=>0xa5e7, 0x30e8=>0xa5e8, 0x30e9=>0xa5e9, 0x30ea=>0xa5ea, 
	0x30eb=>0xa5eb, 0x30ec=>0xa5ec, 0x30ed=>0xa5ed, 0x30ee=>0xa5ee, 0x30ef=>0xa5ef, 0x30f0=>0xa5f0, 0x30f1=>0xa5f1, 0x30f2=>0xa5f2, 0x30f3=>0xa5f3, 0x30f4=>0xa5f4, 0x30f5=>0xa5f5, 0x30f6=>0xa5f6, 0x30fb=>0xa1a6, 0x30fc=>0xa1bc, 0x30fd=>0xa1b3, 0x30fe=>0xa1b4, 
	0x4e00=>0xb0ec, 0x4e01=>0xc3fa, 0x4e03=>0xbcb7, 0x4e07=>0xcbfc, 0x4e08=>0xbee6, 0x4e09=>0xbbb0, 0x4e0a=>0xbee5, 0x4e0b=>0xb2bc, 0x4e0d=>0xc9d4, 0x4e0e=>0xcdbf, 0x4e10=>0xd0a2, 0x4e11=>0xb1af, 0x4e14=>0xb3ee, 0x4e15=>0xd0a3, 0x4e16=>0xc0a4, 0x4e17=>0xd2c2, 
	0x4e18=>0xb5d6, 0x4e19=>0xcaba, 0x4e1e=>0xbee7, 0x4e21=>0xcebe, 0x4e26=>0xcac2, 0x4e2a=>0xd0a4, 0x4e2d=>0xc3e6, 0x4e31=>0xd0a5, 0x4e32=>0xb6fa, 0x4e36=>0xd0a6, 0x4e38=>0xb4dd, 0x4e39=>0xc3b0, 0x4e3b=>0xbce7, 0x4e3c=>0xd0a7, 0x4e3f=>0xd0a8, 0x4e42=>0xd0a9, 
	0x4e43=>0xc7b5, 0x4e45=>0xb5d7, 0x4e4b=>0xc7b7, 0x4e4d=>0xc6e3, 0x4e4e=>0xb8c3, 0x4e4f=>0xcbb3, 0x4e55=>0xe9c9, 0x4e56=>0xd0aa, 0x4e57=>0xbee8, 0x4e58=>0xd0ab, 0x4e59=>0xb2b5, 0x4e5d=>0xb6e5, 0x4e5e=>0xb8f0, 0x4e5f=>0xcce9, 0x4e62=>0xd6a6, 0x4e71=>0xcdf0, 
	0x4e73=>0xc6fd, 0x4e7e=>0xb4a5, 0x4e80=>0xb5b5, 0x4e82=>0xd0ac, 0x4e85=>0xd0ad, 0x4e86=>0xcebb, 0x4e88=>0xcdbd, 0x4e89=>0xc1e8, 0x4e8a=>0xd0af, 0x4e8b=>0xbbf6, 0x4e8c=>0xc6f3, 0x4e8e=>0xd0b2, 0x4e91=>0xb1be, 0x4e92=>0xb8df, 0x4e94=>0xb8de, 0x4e95=>0xb0e6, 
	0x4e98=>0xcfcb, 0x4e99=>0xcfca, 0x4e9b=>0xbab3, 0x4e9c=>0xb0a1, 0x4e9e=>0xd0b3, 0x4e9f=>0xd0b4, 0x4ea0=>0xd0b5, 0x4ea1=>0xcbb4, 0x4ea2=>0xd0b6, 0x4ea4=>0xb8f2, 0x4ea5=>0xb0e7, 0x4ea6=>0xcbf2, 0x4ea8=>0xb5fc, 0x4eab=>0xb5fd, 0x4eac=>0xb5fe, 0x4ead=>0xc4e2, 
	0x4eae=>0xcebc, 0x4eb0=>0xd0b7, 0x4eb3=>0xd0b8, 0x4eb6=>0xd0b9, 0x4eba=>0xbfcd, 0x4ec0=>0xbdba, 0x4ec1=>0xbfce, 0x4ec2=>0xd0be, 0x4ec4=>0xd0bc, 0x4ec6=>0xd0bd, 0x4ec7=>0xb5d8, 0x4eca=>0xbaa3, 0x4ecb=>0xb2f0, 0x4ecd=>0xd0bb, 0x4ece=>0xd0ba, 0x4ecf=>0xcaa9, 
	0x4ed4=>0xbbc6, 0x4ed5=>0xbbc5, 0x4ed6=>0xc2be, 0x4ed7=>0xd0bf, 0x4ed8=>0xc9d5, 0x4ed9=>0xc0e7, 0x4edd=>0xa1b8, 0x4ede=>0xd0c0, 0x4edf=>0xd0c2, 0x4ee3=>0xc2e5, 0x4ee4=>0xcee1, 0x4ee5=>0xb0ca, 0x4eed=>0xd0c1, 0x4eee=>0xb2be, 0x4ef0=>0xb6c4, 0x4ef2=>0xc3e7, 
	0x4ef6=>0xb7ef, 0x4ef7=>0xd0c3, 0x4efb=>0xc7a4, 0x4f01=>0xb4eb, 0x4f09=>0xd0c4, 0x4f0a=>0xb0cb, 0x4f0d=>0xb8e0, 0x4f0e=>0xb4ec, 0x4f0f=>0xc9fa, 0x4f10=>0xc8b2, 0x4f11=>0xb5d9, 0x4f1a=>0xb2f1, 0x4f1c=>0xd0e7, 0x4f1d=>0xc5c1, 0x4f2f=>0xc7ec, 0x4f30=>0xd0c6, 
	0x4f34=>0xc8bc, 0x4f36=>0xcee2, 0x4f38=>0xbfad, 0x4f3a=>0xbbc7, 0x4f3c=>0xbbf7, 0x4f3d=>0xb2c0, 0x4f43=>0xc4d1, 0x4f46=>0xc3a2, 0x4f47=>0xd0ca, 0x4f4d=>0xb0cc, 0x4f4e=>0xc4e3, 0x4f4f=>0xbdbb, 0x4f50=>0xbab4, 0x4f51=>0xcda4, 0x4f53=>0xc2ce, 0x4f55=>0xb2bf, 
	0x4f57=>0xd0c9, 0x4f59=>0xcdbe, 0x4f5a=>0xd0c5, 0x4f5b=>0xd0c7, 0x4f5c=>0xbaee, 0x4f5d=>0xd0c8, 0x4f5e=>0xd5a4, 0x4f69=>0xd0d0, 0x4f6f=>0xd0d3, 0x4f70=>0xd0d1, 0x4f73=>0xb2c2, 0x4f75=>0xcabb, 0x4f76=>0xd0cb, 0x4f7b=>0xd0cf, 0x4f7c=>0xb8f3, 0x4f7f=>0xbbc8, 
	0x4f83=>0xb4a6, 0x4f86=>0xd0d4, 0x4f88=>0xd0cc, 0x4f8b=>0xcee3, 0x4f8d=>0xbbf8, 0x4f8f=>0xd0cd, 0x4f91=>0xd0d2, 0x4f96=>0xd0d5, 0x4f98=>0xd0ce, 0x4f9b=>0xb6a1, 0x4f9d=>0xb0cd, 0x4fa0=>0xb6a2, 0x4fa1=>0xb2c1, 0x4fab=>0xd5a5, 0x4fad=>0xcbf9, 0x4fae=>0xc9ee, 
	0x4faf=>0xb8f4, 0x4fb5=>0xbfaf, 0x4fb6=>0xceb7, 0x4fbf=>0xcad8, 0x4fc2=>0xb7b8, 0x4fc3=>0xc2a5, 0x4fc4=>0xb2e4, 0x4fca=>0xbdd3, 0x4fce=>0xd0d9, 0x4fd0=>0xd0de, 0x4fd1=>0xd0dc, 0x4fd4=>0xd0d7, 0x4fd7=>0xc2af, 0x4fd8=>0xd0da, 0x4fda=>0xd0dd, 0x4fdb=>0xd0db, 
	0x4fdd=>0xcadd, 0x4fdf=>0xd0d8, 0x4fe1=>0xbfae, 0x4fe3=>0xcbf3, 0x4fe4=>0xd0df, 0x4fe5=>0xd0e0, 0x4fee=>0xbda4, 0x4fef=>0xd0ed, 0x4ff3=>0xc7d0, 0x4ff5=>0xc9b6, 0x4ff6=>0xd0e8, 0x4ff8=>0xcaf0, 0x4ffa=>0xb2b6, 0x4ffe=>0xd0ec, 0x5005=>0xd0e6, 0x5006=>0xd0ef, 
	0x5009=>0xc1d2, 0x500b=>0xb8c4, 0x500d=>0xc7dc, 0x500f=>0xe0c7, 0x5011=>0xd0ee, 0x5012=>0xc5dd, 0x5014=>0xd0e3, 0x5016=>0xb8f6, 0x5019=>0xb8f5, 0x501a=>0xd0e1, 0x501f=>0xbcda, 0x5021=>0xd0e9, 0x5023=>0xcaef, 0x5024=>0xc3cd, 0x5025=>0xd0e5, 0x5026=>0xb7f1, 
	0x5028=>0xd0e2, 0x5029=>0xd0ea, 0x502a=>0xd0e4, 0x502b=>0xced1, 0x502c=>0xd0eb, 0x502d=>0xcfc1, 0x5036=>0xb6e6, 0x5039=>0xb7f0, 0x5043=>0xd0f0, 0x5047=>0xd0f1, 0x5048=>0xd0f5, 0x5049=>0xb0ce, 0x504f=>0xcad0, 0x5050=>0xd0f4, 0x5055=>0xd0f3, 0x5056=>0xd0f7, 
	0x505a=>0xd0f6, 0x505c=>0xc4e4, 0x5065=>0xb7f2, 0x506c=>0xd0f8, 0x5072=>0xbcc5, 0x5074=>0xc2a6, 0x5075=>0xc4e5, 0x5076=>0xb6f6, 0x5078=>0xd0f9, 0x507d=>0xb5b6, 0x5080=>0xd0fa, 0x5085=>0xd0fc, 0x508d=>0xcbb5, 0x5091=>0xb7e6, 0x5098=>0xbbb1, 0x5099=>0xc8f7, 
	0x509a=>0xd0fb, 0x50ac=>0xbac5, 0x50ad=>0xcdc3, 0x50b2=>0xd0fe, 0x50b3=>0xd1a3, 0x50b4=>0xd0fd, 0x50b5=>0xbac4, 0x50b7=>0xbdfd, 0x50be=>0xb7b9, 0x50c2=>0xd1a4, 0x50c5=>0xb6cf, 0x50c9=>0xd1a1, 0x50ca=>0xd1a2, 0x50cd=>0xc6af, 0x50cf=>0xc1fc, 0x50d1=>0xb6a3, 
	0x50d5=>0xcbcd, 0x50d6=>0xd1a5, 0x50da=>0xcebd, 0x50de=>0xd1a6, 0x50e3=>0xd1a9, 0x50e5=>0xd1a7, 0x50e7=>0xc1ce, 0x50ed=>0xd1a8, 0x50ee=>0xd1aa, 0x50f5=>0xd1ac, 0x50f9=>0xd1ab, 0x50fb=>0xcac8, 0x5100=>0xb5b7, 0x5101=>0xd1ae, 0x5102=>0xd1af, 0x5104=>0xb2af, 
	0x5109=>0xd1ad, 0x5112=>0xbcf4, 0x5114=>0xd1b2, 0x5115=>0xd1b1, 0x5116=>0xd1b0, 0x5118=>0xd0d6, 0x511a=>0xd1b3, 0x511f=>0xbdfe, 0x5121=>0xd1b4, 0x512a=>0xcda5, 0x5132=>0xccd9, 0x5137=>0xd1b6, 0x513a=>0xd1b5, 0x513b=>0xd1b8, 0x513c=>0xd1b7, 0x513f=>0xd1b9, 
	0x5140=>0xd1ba, 0x5141=>0xb0f4, 0x5143=>0xb8b5, 0x5144=>0xb7bb, 0x5145=>0xbdbc, 0x5146=>0xc3fb, 0x5147=>0xb6a4, 0x5148=>0xc0e8, 0x5149=>0xb8f7, 0x514b=>0xb9ee, 0x514c=>0xd1bc, 0x514d=>0xccc8, 0x514e=>0xc5c6, 0x5150=>0xbbf9, 0x5152=>0xd1bb, 0x5154=>0xd1bd, 
	0x515a=>0xc5de, 0x515c=>0xb3f5, 0x5162=>0xd1be, 0x5165=>0xc6fe, 0x5168=>0xc1b4, 0x5169=>0xd1c0, 0x516a=>0xd1c1, 0x516b=>0xc8ac, 0x516c=>0xb8f8, 0x516d=>0xcfbb, 0x516e=>0xd1c2, 0x5171=>0xb6a6, 0x5175=>0xcabc, 0x5176=>0xc2b6, 0x5177=>0xb6f1, 0x5178=>0xc5b5, 
	0x517c=>0xb7f3, 0x5180=>0xd1c3, 0x5182=>0xd1c4, 0x5185=>0xc6e2, 0x5186=>0xb1df, 0x5189=>0xd1c7, 0x518a=>0xbafd, 0x518c=>0xd1c6, 0x518d=>0xbac6, 0x518f=>0xd1c8, 0x5190=>0xe6ee, 0x5191=>0xd1c9, 0x5192=>0xcbc1, 0x5193=>0xd1ca, 0x5195=>0xd1cb, 0x5196=>0xd1cc, 
	0x5197=>0xbee9, 0x5199=>0xbccc, 0x51a0=>0xb4a7, 0x51a2=>0xd1cf, 0x51a4=>0xd1cd, 0x51a5=>0xccbd, 0x51a6=>0xd1ce, 0x51a8=>0xc9da, 0x51a9=>0xd1d0, 0x51aa=>0xd1d1, 0x51ab=>0xd1d2, 0x51ac=>0xc5df, 0x51b0=>0xd1d6, 0x51b1=>0xd1d4, 0x51b2=>0xd1d5, 0x51b3=>0xd1d3, 
	0x51b4=>0xbae3, 0x51b5=>0xd1d7, 0x51b6=>0xccea, 0x51b7=>0xcee4, 0x51bd=>0xd1d8, 0x51c4=>0xc0a8, 0x51c5=>0xd1d9, 0x51c6=>0xbdda, 0x51c9=>0xd1da, 0x51cb=>0xc3fc, 0x51cc=>0xcebf, 0x51cd=>0xc5e0, 0x51d6=>0xd2c5, 0x51db=>0xd1db, 0x51dc=>0xf4a5, 0x51dd=>0xb6c5, 
	0x51e0=>0xd1dc, 0x51e1=>0xcbde, 0x51e6=>0xbde8, 0x51e7=>0xc2fc, 0x51e9=>0xd1de, 0x51ea=>0xc6e4, 0x51ed=>0xd1df, 0x51f0=>0xd1e0, 0x51f1=>0xb3ae, 0x51f5=>0xd1e1, 0x51f6=>0xb6a7, 0x51f8=>0xc6cc, 0x51f9=>0xb1fa, 0x51fa=>0xbdd0, 0x51fd=>0xc8a1, 0x51fe=>0xd1e2, 
	0x5200=>0xc5e1, 0x5203=>0xbfcf, 0x5204=>0xd1e3, 0x5206=>0xcaac, 0x5207=>0xc0da, 0x5208=>0xb4a2, 0x520a=>0xb4a9, 0x520b=>0xd1e4, 0x520e=>0xd1e6, 0x5211=>0xb7ba, 0x5214=>0xd1e5, 0x5217=>0xcef3, 0x521d=>0xbde9, 0x5224=>0xc8bd, 0x5225=>0xcacc, 0x5227=>0xd1e7, 
	0x5229=>0xcdf8, 0x522a=>0xd1e8, 0x522e=>0xd1e9, 0x5230=>0xc5fe, 0x5233=>0xd1ea, 0x5236=>0xc0a9, 0x5237=>0xbafe, 0x5238=>0xb7f4, 0x5239=>0xd1eb, 0x523a=>0xbbc9, 0x523b=>0xb9ef, 0x5243=>0xc4e6, 0x5244=>0xd1ed, 0x5247=>0xc2a7, 0x524a=>0xbaef, 0x524b=>0xd1ee, 
	0x524c=>0xd1ef, 0x524d=>0xc1b0, 0x524f=>0xd1ec, 0x5254=>0xd1f1, 0x5256=>0xcbb6, 0x525b=>0xb9e4, 0x525e=>0xd1f0, 0x5263=>0xb7f5, 0x5264=>0xbade, 0x5265=>0xc7ed, 0x5269=>0xd1f4, 0x526a=>0xd1f2, 0x526f=>0xc9fb, 0x5270=>0xbeea, 0x5271=>0xd1fb, 0x5272=>0xb3e4, 
	0x5273=>0xd1f5, 0x5274=>0xd1f3, 0x5275=>0xc1cf, 0x527d=>0xd1f7, 0x527f=>0xd1f6, 0x5283=>0xb3c4, 0x5287=>0xb7e0, 0x5288=>0xd1fc, 0x5289=>0xcead, 0x528d=>0xd1f8, 0x5291=>0xd1fd, 0x5292=>0xd1fa, 0x5294=>0xd1f9, 0x529b=>0xcecf, 0x529f=>0xb8f9, 0x52a0=>0xb2c3, 
	0x52a3=>0xcef4, 0x52a9=>0xbdf5, 0x52aa=>0xc5d8, 0x52ab=>0xb9e5, 0x52ac=>0xd2a2, 0x52ad=>0xd2a3, 0x52b1=>0xcee5, 0x52b4=>0xcfab, 0x52b5=>0xd2a5, 0x52b9=>0xb8fa, 0x52bc=>0xd2a4, 0x52be=>0xb3af, 0x52c1=>0xd2a6, 0x52c3=>0xcbd6, 0x52c5=>0xc4bc, 0x52c7=>0xcda6, 
	0x52c9=>0xcad9, 0x52cd=>0xd2a7, 0x52d2=>0xf0d5, 0x52d5=>0xc6b0, 0x52d7=>0xd2a8, 0x52d8=>0xb4aa, 0x52d9=>0xccb3, 0x52dd=>0xbea1, 0x52de=>0xd2a9, 0x52df=>0xcae7, 0x52e0=>0xd2ad, 0x52e2=>0xc0aa, 0x52e3=>0xd2aa, 0x52e4=>0xb6d0, 0x52e6=>0xd2ab, 0x52e7=>0xb4ab, 
	0x52f2=>0xb7ae, 0x52f3=>0xd2ae, 0x52f5=>0xd2af, 0x52f8=>0xd2b0, 0x52f9=>0xd2b1, 0x52fa=>0xbcdb, 0x52fe=>0xb8fb, 0x52ff=>0xccde, 0x5301=>0xcce8, 0x5302=>0xc6f7, 0x5305=>0xcaf1, 0x5306=>0xd2b2, 0x5308=>0xd2b3, 0x530d=>0xd2b5, 0x530f=>0xd2b7, 0x5310=>0xd2b6, 
	0x5315=>0xd2b8, 0x5316=>0xb2bd, 0x5317=>0xcbcc, 0x5319=>0xbafc, 0x531a=>0xd2b9, 0x531d=>0xc1d9, 0x5320=>0xbea2, 0x5321=>0xb6a9, 0x5323=>0xd2ba, 0x532a=>0xc8db, 0x532f=>0xd2bb, 0x5331=>0xd2bc, 0x5333=>0xd2bd, 0x5338=>0xd2be, 0x5339=>0xc9a4, 0x533a=>0xb6e8, 
	0x533b=>0xb0e5, 0x533f=>0xc6bf, 0x5340=>0xd2bf, 0x5341=>0xbdbd, 0x5343=>0xc0e9, 0x5345=>0xd2c1, 0x5346=>0xd2c0, 0x5347=>0xbea3, 0x5348=>0xb8e1, 0x5349=>0xd2c3, 0x534a=>0xc8be, 0x534d=>0xd2c4, 0x5351=>0xc8dc, 0x5352=>0xc2b4, 0x5353=>0xc2ee, 0x5354=>0xb6a8, 
	0x5357=>0xc6ee, 0x5358=>0xc3b1, 0x535a=>0xc7ee, 0x535c=>0xcbce, 0x535e=>0xd2c6, 0x5360=>0xc0ea, 0x5366=>0xb7b5, 0x5369=>0xd2c7, 0x536e=>0xd2c8, 0x536f=>0xb1ac, 0x5370=>0xb0f5, 0x5371=>0xb4ed, 0x5373=>0xc2a8, 0x5374=>0xb5d1, 0x5375=>0xcdf1, 0x5377=>0xd2cb, 
	0x5378=>0xb2b7, 0x537b=>0xd2ca, 0x537f=>0xb6aa, 0x5382=>0xd2cc, 0x5384=>0xccf1, 0x5396=>0xd2cd, 0x5398=>0xced2, 0x539a=>0xb8fc, 0x539f=>0xb8b6, 0x53a0=>0xd2ce, 0x53a5=>0xd2d0, 0x53a6=>0xd2cf, 0x53a8=>0xbfdf, 0x53a9=>0xb1b9, 0x53ad=>0xb1de, 0x53ae=>0xd2d1, 
	0x53b0=>0xd2d2, 0x53b3=>0xb8b7, 0x53b6=>0xd2d3, 0x53bb=>0xb5ee, 0x53c2=>0xbbb2, 0x53c3=>0xd2d4, 0x53c8=>0xcbf4, 0x53c9=>0xbab5, 0x53ca=>0xb5da, 0x53cb=>0xcda7, 0x53cc=>0xc1d0, 0x53cd=>0xc8bf, 0x53ce=>0xbcfd, 0x53d4=>0xbdc7, 0x53d6=>0xbce8, 0x53d7=>0xbcf5, 
	0x53d9=>0xbdf6, 0x53db=>0xc8c0, 0x53df=>0xd2d7, 0x53e1=>0xb1c3, 0x53e2=>0xc1d1, 0x53e3=>0xb8fd, 0x53e4=>0xb8c5, 0x53e5=>0xb6e7, 0x53e8=>0xd2db, 0x53e9=>0xc3a1, 0x53ea=>0xc2fe, 0x53eb=>0xb6ab, 0x53ec=>0xbea4, 0x53ed=>0xd2dc, 0x53ee=>0xd2da, 0x53ef=>0xb2c4, 
	0x53f0=>0xc2e6, 0x53f1=>0xbcb8, 0x53f2=>0xbbcb, 0x53f3=>0xb1a6, 0x53f6=>0xb3f0, 0x53f7=>0xb9e6, 0x53f8=>0xbbca, 0x53fa=>0xd2dd, 0x5401=>0xd2de, 0x5403=>0xb5c9, 0x5404=>0xb3c6, 0x5408=>0xb9e7, 0x5409=>0xb5c8, 0x540a=>0xc4df, 0x540b=>0xb1a5, 0x540c=>0xc6b1, 
	0x540d=>0xccbe, 0x540e=>0xb9a1, 0x540f=>0xcdf9, 0x5410=>0xc5c7, 0x5411=>0xb8fe, 0x541b=>0xb7af, 0x541d=>0xd2e7, 0x541f=>0xb6e3, 0x5420=>0xcbca, 0x5426=>0xc8dd, 0x5429=>0xd2e6, 0x542b=>0xb4de, 0x542c=>0xd2e1, 0x542d=>0xd2e2, 0x542e=>0xd2e4, 0x5436=>0xd2e5, 
	0x5438=>0xb5db, 0x5439=>0xbfe1, 0x543b=>0xcaad, 0x543c=>0xd2e3, 0x543d=>0xd2df, 0x543e=>0xb8e3, 0x5440=>0xd2e0, 0x5442=>0xcfa4, 0x5446=>0xcaf2, 0x5448=>0xc4e8, 0x5449=>0xb8e2, 0x544a=>0xb9f0, 0x544e=>0xd2e8, 0x5451=>0xc6dd, 0x545f=>0xd2ec, 0x5468=>0xbcfe, 
	0x546a=>0xbcf6, 0x5470=>0xd2ef, 0x5471=>0xd2ed, 0x5473=>0xcca3, 0x5475=>0xd2ea, 0x5476=>0xd2f3, 0x5477=>0xd2ee, 0x547b=>0xd2f1, 0x547c=>0xb8c6, 0x547d=>0xccbf, 0x5480=>0xd2f2, 0x5484=>0xd2f4, 0x5486=>0xd2f6, 0x548b=>0xbaf0, 0x548c=>0xcfc2, 0x548e=>0xd2eb, 
	0x548f=>0xd2e9, 0x5490=>0xd2f5, 0x5492=>0xd2f0, 0x54a2=>0xd2f8, 0x54a4=>0xd3a3, 0x54a5=>0xd2fa, 0x54a8=>0xd2fe, 0x54ab=>0xd3a1, 0x54ac=>0xd2fb, 0x54af=>0xd3be, 0x54b2=>0xbae9, 0x54b3=>0xb3b1, 0x54b8=>0xd2f9, 0x54bc=>0xd3a5, 0x54bd=>0xb0f6, 0x54be=>0xd3a4, 
	0x54c0=>0xb0a5, 0x54c1=>0xc9ca, 0x54c2=>0xd3a2, 0x54c4=>0xd2fc, 0x54c7=>0xd2f7, 0x54c8=>0xd2fd, 0x54c9=>0xbac8, 0x54d8=>0xd3a6, 0x54e1=>0xb0f7, 0x54e2=>0xd3af, 0x54e5=>0xd3a7, 0x54e6=>0xd3a8, 0x54e8=>0xbea5, 0x54e9=>0xcbe9, 0x54ed=>0xd3ad, 0x54ee=>0xd3ac, 
	0x54f2=>0xc5af, 0x54fa=>0xd3ae, 0x54fd=>0xd3ab, 0x5504=>0xb1b4, 0x5506=>0xbab6, 0x5507=>0xbfb0, 0x550f=>0xd3a9, 0x5510=>0xc5e2, 0x5514=>0xd3aa, 0x5516=>0xb0a2, 0x552e=>0xd3b4, 0x552f=>0xcda3, 0x5531=>0xbea7, 0x5533=>0xd3ba, 0x5538=>0xd3b9, 0x5539=>0xd3b0, 
	0x553e=>0xc2c3, 0x5540=>0xd3b1, 0x5544=>0xc2ef, 0x5545=>0xd3b6, 0x5546=>0xbea6, 0x554c=>0xd3b3, 0x554f=>0xcce4, 0x5553=>0xb7bc, 0x5556=>0xd3b7, 0x5557=>0xd3b8, 0x555c=>0xd3b5, 0x555d=>0xd3bb, 0x5563=>0xd3b2, 0x557b=>0xd3c1, 0x557c=>0xd3c6, 0x557e=>0xd3c2, 
	0x5580=>0xd3bd, 0x5583=>0xd3c7, 0x5584=>0xc1b1, 0x5587=>0xd3c9, 0x5589=>0xb9a2, 0x558a=>0xd3bf, 0x558b=>0xc3fd, 0x5598=>0xd3c3, 0x5599=>0xd3bc, 0x559a=>0xb4ad, 0x559c=>0xb4ee, 0x559d=>0xb3e5, 0x559e=>0xd3c4, 0x559f=>0xd3c0, 0x55a7=>0xb7f6, 0x55a8=>0xd3ca, 
	0x55a9=>0xd3c8, 0x55aa=>0xc1d3, 0x55ab=>0xb5ca, 0x55ac=>0xb6ac, 0x55ae=>0xd3c5, 0x55b0=>0xb6f4, 0x55b6=>0xb1c4, 0x55c4=>0xd3ce, 0x55c5=>0xd3cc, 0x55c7=>0xd4a7, 0x55d4=>0xd3d1, 0x55da=>0xd3cb, 0x55dc=>0xd3cf, 0x55df=>0xd3cd, 0x55e3=>0xbbcc, 0x55e4=>0xd3d0, 
	0x55f7=>0xd3d3, 0x55f9=>0xd3d8, 0x55fd=>0xd3d6, 0x55fe=>0xd3d5, 0x5606=>0xc3b2, 0x5609=>0xb2c5, 0x5614=>0xd3d2, 0x5616=>0xd3d4, 0x5617=>0xbea8, 0x5618=>0xb1b3, 0x561b=>0xd3d7, 0x5629=>0xb2de, 0x562f=>0xd3e2, 0x5631=>0xbefc, 0x5632=>0xd3de, 0x5634=>0xd3dc, 
	0x5636=>0xd3dd, 0x5638=>0xd3df, 0x5642=>0xb1bd, 0x564c=>0xc1b9, 0x564e=>0xd3d9, 0x5650=>0xd3da, 0x565b=>0xb3fa, 0x5664=>0xd3e1, 0x5668=>0xb4ef, 0x566a=>0xd3e4, 0x566b=>0xd3e0, 0x566c=>0xd3e3, 0x5674=>0xcaae, 0x5678=>0xc6d5, 0x567a=>0xc8b8, 0x5680=>0xd3e6, 
	0x5686=>0xd3e5, 0x5687=>0xb3c5, 0x568a=>0xd3e7, 0x568f=>0xd3ea, 0x5694=>0xd3e9, 0x56a0=>0xd3e8, 0x56a2=>0xc7b9, 0x56a5=>0xd3eb, 0x56ae=>0xd3ec, 0x56b4=>0xd3ee, 0x56b6=>0xd3ed, 0x56bc=>0xd3f0, 0x56c0=>0xd3f3, 0x56c1=>0xd3f1, 0x56c2=>0xd3ef, 0x56c3=>0xd3f2, 
	0x56c8=>0xd3f4, 0x56ce=>0xd3f5, 0x56d1=>0xd3f6, 0x56d3=>0xd3f7, 0x56d7=>0xd3f8, 0x56d8=>0xd1c5, 0x56da=>0xbcfc, 0x56db=>0xbbcd, 0x56de=>0xb2f3, 0x56e0=>0xb0f8, 0x56e3=>0xc3c4, 0x56ee=>0xd3f9, 0x56f0=>0xbaa4, 0x56f2=>0xb0cf, 0x56f3=>0xbfde, 0x56f9=>0xd3fa, 
	0x56fa=>0xb8c7, 0x56fd=>0xb9f1, 0x56ff=>0xd3fc, 0x5700=>0xd3fb, 0x5703=>0xcae0, 0x5704=>0xd3fd, 0x5708=>0xd4a1, 0x5709=>0xd3fe, 0x570b=>0xd4a2, 0x570d=>0xd4a3, 0x570f=>0xb7f7, 0x5712=>0xb1e0, 0x5713=>0xd4a4, 0x5716=>0xd4a6, 0x5718=>0xd4a5, 0x571c=>0xd4a8, 
	0x571f=>0xc5da, 0x5726=>0xd4a9, 0x5727=>0xb0b5, 0x5728=>0xbadf, 0x572d=>0xb7bd, 0x5730=>0xc3cf, 0x5737=>0xd4aa, 0x5738=>0xd4ab, 0x573b=>0xd4ad, 0x5740=>0xd4ae, 0x5742=>0xbae4, 0x5747=>0xb6d1, 0x574a=>0xcbb7, 0x574e=>0xd4ac, 0x574f=>0xd4af, 0x5750=>0xbac1, 
	0x5751=>0xb9a3, 0x5761=>0xd4b3, 0x5764=>0xbaa5, 0x5766=>0xc3b3, 0x5769=>0xd4b0, 0x576a=>0xc4da, 0x577f=>0xd4b4, 0x5782=>0xbfe2, 0x5788=>0xd4b2, 0x5789=>0xd4b5, 0x578b=>0xb7bf, 0x5793=>0xd4b6, 0x57a0=>0xd4b7, 0x57a2=>0xb9a4, 0x57a3=>0xb3c0, 0x57a4=>0xd4b9, 
	0x57aa=>0xd4ba, 0x57b0=>0xd4bb, 0x57b3=>0xd4b8, 0x57c0=>0xd4b1, 0x57c3=>0xd4bc, 0x57c6=>0xd4bd, 0x57cb=>0xcbe4, 0x57ce=>0xbeeb, 0x57d2=>0xd4bf, 0x57d3=>0xd4c0, 0x57d4=>0xd4be, 0x57d6=>0xd4c2, 0x57dc=>0xc7b8, 0x57df=>0xb0e8, 0x57e0=>0xc9d6, 0x57e3=>0xd4c3, 
	0x57f4=>0xbefd, 0x57f7=>0xbcb9, 0x57f9=>0xc7dd, 0x57fa=>0xb4f0, 0x57fc=>0xbaeb, 0x5800=>0xcbd9, 0x5802=>0xc6b2, 0x5805=>0xb7f8, 0x5806=>0xc2cf, 0x580a=>0xd4c1, 0x580b=>0xd4c4, 0x5815=>0xc2c4, 0x5819=>0xd4c5, 0x581d=>0xd4c6, 0x5821=>0xd4c8, 0x5824=>0xc4e9, 
	0x582a=>0xb4ae, 0x582f=>0xf4a1, 0x5830=>0xb1e1, 0x5831=>0xcaf3, 0x5834=>0xbeec, 0x5835=>0xc5c8, 0x583a=>0xbae6, 0x583d=>0xd4ce, 0x5840=>0xcabd, 0x5841=>0xcedd, 0x584a=>0xb2f4, 0x584b=>0xd4ca, 0x5851=>0xc1ba, 0x5852=>0xd4cd, 0x5854=>0xc5e3, 0x5857=>0xc5c9, 
	0x5858=>0xc5e4, 0x5859=>0xc8b9, 0x585a=>0xc4cd, 0x585e=>0xbac9, 0x5862=>0xd4c9, 0x5869=>0xb1f6, 0x586b=>0xc5b6, 0x5870=>0xd4cb, 0x5872=>0xd4c7, 0x5875=>0xbfd0, 0x5879=>0xd4cf, 0x587e=>0xbdce, 0x5883=>0xb6ad, 0x5885=>0xd4d0, 0x5893=>0xcae8, 0x5897=>0xc1fd, 
	0x589c=>0xc4c6, 0x589f=>0xd4d2, 0x58a8=>0xcbcf, 0x58ab=>0xd4d3, 0x58ae=>0xd4d8, 0x58b3=>0xcaaf, 0x58b8=>0xd4d7, 0x58b9=>0xd4d1, 0x58ba=>0xd4d4, 0x58bb=>0xd4d6, 0x58be=>0xbaa6, 0x58c1=>0xcac9, 0x58c5=>0xd4d9, 0x58c7=>0xc3c5, 0x58ca=>0xb2f5, 0x58cc=>0xbeed, 
	0x58d1=>0xd4db, 0x58d3=>0xd4da, 0x58d5=>0xb9e8, 0x58d7=>0xd4dc, 0x58d8=>0xd4de, 0x58d9=>0xd4dd, 0x58dc=>0xd4e0, 0x58de=>0xd4d5, 0x58df=>0xd4e2, 0x58e4=>0xd4e1, 0x58e5=>0xd4df, 0x58eb=>0xbbce, 0x58ec=>0xbfd1, 0x58ee=>0xc1d4, 0x58ef=>0xd4e3, 0x58f0=>0xc0bc, 
	0x58f1=>0xb0ed, 0x58f2=>0xc7e4, 0x58f7=>0xc4db, 0x58f9=>0xd4e5, 0x58fa=>0xd4e4, 0x58fb=>0xd4e6, 0x58fc=>0xd4e7, 0x58fd=>0xd4e8, 0x5902=>0xd4e9, 0x5909=>0xcad1, 0x590a=>0xd4ea, 0x590f=>0xb2c6, 0x5910=>0xd4eb, 0x5915=>0xcdbc, 0x5916=>0xb3b0, 0x5918=>0xd2c9, 
	0x5919=>0xbdc8, 0x591a=>0xc2bf, 0x591b=>0xd4ec, 0x591c=>0xcceb, 0x5922=>0xccb4, 0x5925=>0xd4ee, 0x5927=>0xc2e7, 0x5929=>0xc5b7, 0x592a=>0xc2c0, 0x592b=>0xc9d7, 0x592c=>0xd4ef, 0x592d=>0xd4f0, 0x592e=>0xb1fb, 0x5931=>0xbcba, 0x5932=>0xd4f1, 0x5937=>0xb0d0, 
	0x5938=>0xd4f2, 0x593e=>0xd4f3, 0x5944=>0xb1e2, 0x5947=>0xb4f1, 0x5948=>0xc6e0, 0x5949=>0xcaf4, 0x594e=>0xd4f7, 0x594f=>0xc1d5, 0x5950=>0xd4f6, 0x5951=>0xb7c0, 0x5954=>0xcbdb, 0x5955=>0xd4f5, 0x5957=>0xc5e5, 0x5958=>0xd4f9, 0x595a=>0xd4f8, 0x5960=>0xd4fb, 
	0x5962=>0xd4fa, 0x5965=>0xb1fc, 0x5967=>0xd4fc, 0x5968=>0xbea9, 0x5969=>0xd4fe, 0x596a=>0xc3a5, 0x596c=>0xd4fd, 0x596e=>0xcab3, 0x5973=>0xbdf7, 0x5974=>0xc5db, 0x5978=>0xd5a1, 0x597d=>0xb9a5, 0x5981=>0xd5a2, 0x5982=>0xc7a1, 0x5983=>0xc8de, 0x5984=>0xccd1, 
	0x598a=>0xc7a5, 0x598d=>0xd5ab, 0x5993=>0xb5b8, 0x5996=>0xcdc5, 0x5999=>0xccaf, 0x599b=>0xd6ac, 0x599d=>0xd5a3, 0x59a3=>0xd5a6, 0x59a5=>0xc2c5, 0x59a8=>0xcbb8, 0x59ac=>0xc5ca, 0x59b2=>0xd5a7, 0x59b9=>0xcbe5, 0x59bb=>0xbaca, 0x59be=>0xbeaa, 0x59c6=>0xd5a8, 
	0x59c9=>0xbbd0, 0x59cb=>0xbbcf, 0x59d0=>0xb0b9, 0x59d1=>0xb8c8, 0x59d3=>0xc0ab, 0x59d4=>0xb0d1, 0x59d9=>0xd5ac, 0x59da=>0xd5ad, 0x59dc=>0xd5aa, 0x59e5=>0xb1b8, 0x59e6=>0xb4af, 0x59e8=>0xd5a9, 0x59ea=>0xccc5, 0x59eb=>0xc9b1, 0x59f6=>0xb0a8, 0x59fb=>0xb0f9, 
	0x59ff=>0xbbd1, 0x5a01=>0xb0d2, 0x5a03=>0xb0a3, 0x5a09=>0xd5b2, 0x5a11=>0xd5b0, 0x5a18=>0xccbc, 0x5a1a=>0xd5b3, 0x5a1c=>0xd5b1, 0x5a1f=>0xd5af, 0x5a20=>0xbfb1, 0x5a25=>0xd5ae, 0x5a29=>0xcada, 0x5a2f=>0xb8e4, 0x5a35=>0xd5b7, 0x5a36=>0xd5b8, 0x5a3c=>0xbeab, 
	0x5a40=>0xd5b4, 0x5a41=>0xcfac, 0x5a46=>0xc7cc, 0x5a49=>0xd5b6, 0x5a5a=>0xbaa7, 0x5a62=>0xd5b9, 0x5a66=>0xc9d8, 0x5a6a=>0xd5ba, 0x5a6c=>0xd5b5, 0x5a7f=>0xccbb, 0x5a92=>0xc7de, 0x5a9a=>0xd5bb, 0x5a9b=>0xc9b2, 0x5abc=>0xd5bc, 0x5abd=>0xd5c0, 0x5abe=>0xd5bd, 
	0x5ac1=>0xb2c7, 0x5ac2=>0xd5bf, 0x5ac9=>0xbcbb, 0x5acb=>0xd5be, 0x5acc=>0xb7f9, 0x5ad0=>0xd5cc, 0x5ad6=>0xd5c5, 0x5ad7=>0xd5c2, 0x5ae1=>0xc3e4, 0x5ae3=>0xd5c1, 0x5ae6=>0xd5c3, 0x5ae9=>0xd5c4, 0x5afa=>0xd5c6, 0x5afb=>0xd5c7, 0x5b09=>0xb4f2, 0x5b0b=>0xd5c9, 
	0x5b0c=>0xd5c8, 0x5b16=>0xd5ca, 0x5b22=>0xbeee, 0x5b2a=>0xd5cd, 0x5b2c=>0xc4dc, 0x5b30=>0xb1c5, 0x5b32=>0xd5cb, 0x5b36=>0xd5ce, 0x5b3e=>0xd5cf, 0x5b40=>0xd5d2, 0x5b43=>0xd5d0, 0x5b45=>0xd5d1, 0x5b50=>0xbbd2, 0x5b51=>0xd5d3, 0x5b54=>0xb9a6, 0x5b55=>0xd5d4, 
	0x5b57=>0xbbfa, 0x5b58=>0xc2b8, 0x5b5a=>0xd5d5, 0x5b5b=>0xd5d6, 0x5b5c=>0xbbda, 0x5b5d=>0xb9a7, 0x5b5f=>0xccd2, 0x5b63=>0xb5a8, 0x5b64=>0xb8c9, 0x5b65=>0xd5d7, 0x5b66=>0xb3d8, 0x5b69=>0xd5d8, 0x5b6b=>0xc2b9, 0x5b70=>0xd5d9, 0x5b71=>0xd6a3, 0x5b73=>0xd5da, 
	0x5b75=>0xd5db, 0x5b78=>0xd5dc, 0x5b7a=>0xd5de, 0x5b80=>0xd5df, 0x5b83=>0xd5e0, 0x5b85=>0xc2f0, 0x5b87=>0xb1a7, 0x5b88=>0xbce9, 0x5b89=>0xb0c2, 0x5b8b=>0xc1d7, 0x5b8c=>0xb4b0, 0x5b8d=>0xbcb5, 0x5b8f=>0xb9a8, 0x5b95=>0xc5e6, 0x5b97=>0xbda1, 0x5b98=>0xb4b1, 
	0x5b99=>0xc3e8, 0x5b9a=>0xc4ea, 0x5b9b=>0xb0b8, 0x5b9c=>0xb5b9, 0x5b9d=>0xcaf5, 0x5b9f=>0xbcc2, 0x5ba2=>0xb5d2, 0x5ba3=>0xc0eb, 0x5ba4=>0xbcbc, 0x5ba5=>0xcda8, 0x5ba6=>0xd5e1, 0x5bae=>0xb5dc, 0x5bb0=>0xbacb, 0x5bb3=>0xb3b2, 0x5bb4=>0xb1e3, 0x5bb5=>0xbeac, 
	0x5bb6=>0xb2c8, 0x5bb8=>0xd5e2, 0x5bb9=>0xcdc6, 0x5bbf=>0xbdc9, 0x5bc2=>0xbce4, 0x5bc3=>0xd5e3, 0x5bc4=>0xb4f3, 0x5bc5=>0xc6d2, 0x5bc6=>0xcca9, 0x5bc7=>0xd5e4, 0x5bc9=>0xd5e5, 0x5bcc=>0xc9d9, 0x5bd0=>0xd5e7, 0x5bd2=>0xb4a8, 0x5bd3=>0xb6f7, 0x5bd4=>0xd5e6, 
	0x5bdb=>0xb4b2, 0x5bdd=>0xbfb2, 0x5bde=>0xd5eb, 0x5bdf=>0xbba1, 0x5be1=>0xb2c9, 0x5be2=>0xd5ea, 0x5be4=>0xd5e8, 0x5be5=>0xd5ec, 0x5be6=>0xd5e9, 0x5be7=>0xc7ab, 0x5be8=>0xdccd, 0x5be9=>0xbfb3, 0x5beb=>0xd5ed, 0x5bee=>0xcec0, 0x5bf0=>0xd5ee, 0x5bf3=>0xd5f0, 
	0x5bf5=>0xc3fe, 0x5bf6=>0xd5ef, 0x5bf8=>0xc0a3, 0x5bfa=>0xbbfb, 0x5bfe=>0xc2d0, 0x5bff=>0xbcf7, 0x5c01=>0xc9f5, 0x5c02=>0xc0ec, 0x5c04=>0xbccd, 0x5c05=>0xd5f1, 0x5c06=>0xbead, 0x5c07=>0xd5f2, 0x5c08=>0xd5f3, 0x5c09=>0xb0d3, 0x5c0a=>0xc2ba, 0x5c0b=>0xbfd2, 
	0x5c0d=>0xd5f4, 0x5c0e=>0xc6b3, 0x5c0f=>0xbeae, 0x5c11=>0xbeaf, 0x5c13=>0xd5f5, 0x5c16=>0xc0ed, 0x5c1a=>0xbeb0, 0x5c20=>0xd5f6, 0x5c22=>0xd5f7, 0x5c24=>0xcce0, 0x5c28=>0xd5f8, 0x5c2d=>0xb6c6, 0x5c31=>0xbda2, 0x5c38=>0xd5f9, 0x5c39=>0xd5fa, 0x5c3a=>0xbcdc, 
	0x5c3b=>0xbfac, 0x5c3c=>0xc6f4, 0x5c3d=>0xbfd4, 0x5c3e=>0xc8f8, 0x5c3f=>0xc7a2, 0x5c40=>0xb6c9, 0x5c41=>0xd5fb, 0x5c45=>0xb5ef, 0x5c46=>0xd5fc, 0x5c48=>0xb6fe, 0x5c4a=>0xc6cf, 0x5c4b=>0xb2b0, 0x5c4d=>0xbbd3, 0x5c4e=>0xd5fd, 0x5c4f=>0xd6a2, 0x5c50=>0xd6a1, 
	0x5c51=>0xb6fd, 0x5c53=>0xd5fe, 0x5c55=>0xc5b8, 0x5c5e=>0xc2b0, 0x5c60=>0xc5cb, 0x5c61=>0xbcc8, 0x5c64=>0xc1d8, 0x5c65=>0xcdfa, 0x5c6c=>0xd6a4, 0x5c6e=>0xd6a5, 0x5c6f=>0xc6d6, 0x5c71=>0xbbb3, 0x5c76=>0xd6a7, 0x5c79=>0xd6a8, 0x5c8c=>0xd6a9, 0x5c90=>0xb4f4, 
	0x5c91=>0xd6aa, 0x5c94=>0xd6ab, 0x5ca1=>0xb2ac, 0x5ca8=>0xc1bb, 0x5ca9=>0xb4e4, 0x5cab=>0xd6ad, 0x5cac=>0xcca8, 0x5cb1=>0xc2d2, 0x5cb3=>0xb3d9, 0x5cb6=>0xd6af, 0x5cb7=>0xd6b1, 0x5cb8=>0xb4df, 0x5cbb=>0xd6ae, 0x5cbc=>0xd6b0, 0x5cbe=>0xd6b3, 0x5cc5=>0xd6b2, 
	0x5cc7=>0xd6b4, 0x5cd9=>0xd6b5, 0x5ce0=>0xc6bd, 0x5ce1=>0xb6ae, 0x5ce8=>0xb2e5, 0x5ce9=>0xd6b6, 0x5cea=>0xd6bb, 0x5ced=>0xd6b9, 0x5cef=>0xcaf7, 0x5cf0=>0xcaf6, 0x5cf6=>0xc5e7, 0x5cfa=>0xd6b8, 0x5cfb=>0xbdd4, 0x5cfd=>0xd6b7, 0x5d07=>0xbff2, 0x5d0b=>0xd6bc, 
	0x5d0e=>0xbaea, 0x5d11=>0xd6c2, 0x5d14=>0xd6c3, 0x5d15=>0xd6bd, 0x5d16=>0xb3b3, 0x5d17=>0xd6be, 0x5d18=>0xd6c7, 0x5d19=>0xd6c6, 0x5d1a=>0xd6c5, 0x5d1b=>0xd6c1, 0x5d1f=>0xd6c0, 0x5d22=>0xd6c4, 0x5d29=>0xcaf8, 0x5d4b=>0xd6cb, 0x5d4c=>0xd6c8, 0x5d4e=>0xd6ca, 
	0x5d50=>0xcdf2, 0x5d52=>0xd6c9, 0x5d5c=>0xd6bf, 0x5d69=>0xbff3, 0x5d6c=>0xd6cc, 0x5d6f=>0xbab7, 0x5d73=>0xd6cd, 0x5d76=>0xd6ce, 0x5d82=>0xd6d1, 0x5d84=>0xd6d0, 0x5d87=>0xd6cf, 0x5d8b=>0xc5e8, 0x5d8c=>0xd6ba, 0x5d90=>0xd6d7, 0x5d9d=>0xd6d3, 0x5da2=>0xd6d2, 
	0x5dac=>0xd6d4, 0x5dae=>0xd6d5, 0x5db7=>0xd6d8, 0x5dba=>0xcee6, 0x5dbc=>0xd6d9, 0x5dbd=>0xd6d6, 0x5dc9=>0xd6da, 0x5dcc=>0xb4e0, 0x5dcd=>0xd6db, 0x5dd2=>0xd6dd, 0x5dd3=>0xd6dc, 0x5dd6=>0xd6de, 0x5ddb=>0xd6df, 0x5ddd=>0xc0ee, 0x5dde=>0xbda3, 0x5de1=>0xbde4, 
	0x5de3=>0xc1e3, 0x5de5=>0xb9a9, 0x5de6=>0xbab8, 0x5de7=>0xb9aa, 0x5de8=>0xb5f0, 0x5deb=>0xd6e0, 0x5dee=>0xbab9, 0x5df1=>0xb8ca, 0x5df2=>0xd6e1, 0x5df3=>0xcca6, 0x5df4=>0xc7c3, 0x5df5=>0xd6e2, 0x5df7=>0xb9ab, 0x5dfb=>0xb4ac, 0x5dfd=>0xc3a7, 0x5dfe=>0xb6d2, 
	0x5e02=>0xbbd4, 0x5e03=>0xc9db, 0x5e06=>0xc8c1, 0x5e0b=>0xd6e3, 0x5e0c=>0xb4f5, 0x5e11=>0xd6e6, 0x5e16=>0xc4a1, 0x5e19=>0xd6e5, 0x5e1a=>0xd6e4, 0x5e1b=>0xd6e7, 0x5e1d=>0xc4eb, 0x5e25=>0xbfe3, 0x5e2b=>0xbbd5, 0x5e2d=>0xc0ca, 0x5e2f=>0xc2d3, 0x5e30=>0xb5a2, 
	0x5e33=>0xc4a2, 0x5e36=>0xd6e8, 0x5e37=>0xd6e9, 0x5e38=>0xbeef, 0x5e3d=>0xcbb9, 0x5e40=>0xd6ec, 0x5e43=>0xd6eb, 0x5e44=>0xd6ea, 0x5e45=>0xc9fd, 0x5e47=>0xd6f3, 0x5e4c=>0xcbda, 0x5e4e=>0xd6ed, 0x5e54=>0xd6ef, 0x5e55=>0xcbeb, 0x5e57=>0xd6ee, 0x5e5f=>0xd6f0, 
	0x5e61=>0xc8a8, 0x5e62=>0xd6f1, 0x5e63=>0xcabe, 0x5e64=>0xd6f2, 0x5e72=>0xb4b3, 0x5e73=>0xcabf, 0x5e74=>0xc7af, 0x5e75=>0xd6f4, 0x5e76=>0xd6f5, 0x5e78=>0xb9ac, 0x5e79=>0xb4b4, 0x5e7a=>0xd6f6, 0x5e7b=>0xb8b8, 0x5e7c=>0xcdc4, 0x5e7d=>0xcda9, 0x5e7e=>0xb4f6, 
	0x5e7f=>0xd6f8, 0x5e81=>0xc4a3, 0x5e83=>0xb9ad, 0x5e84=>0xbeb1, 0x5e87=>0xc8df, 0x5e8a=>0xbeb2, 0x5e8f=>0xbdf8, 0x5e95=>0xc4ec, 0x5e96=>0xcaf9, 0x5e97=>0xc5b9, 0x5e9a=>0xb9ae, 0x5e9c=>0xc9dc, 0x5ea0=>0xd6f9, 0x5ea6=>0xc5d9, 0x5ea7=>0xbac2, 0x5eab=>0xb8cb, 
	0x5ead=>0xc4ed, 0x5eb5=>0xb0c3, 0x5eb6=>0xbdee, 0x5eb7=>0xb9af, 0x5eb8=>0xcdc7, 0x5ec1=>0xd6fa, 0x5ec2=>0xd6fb, 0x5ec3=>0xc7d1, 0x5ec8=>0xd6fc, 0x5ec9=>0xcef7, 0x5eca=>0xcfad, 0x5ecf=>0xd6fe, 0x5ed0=>0xd6fd, 0x5ed3=>0xb3c7, 0x5ed6=>0xd7a1, 0x5eda=>0xd7a4, 
	0x5edb=>0xd7a5, 0x5edd=>0xd7a3, 0x5edf=>0xc9c0, 0x5ee0=>0xbeb3, 0x5ee1=>0xd7a7, 0x5ee2=>0xd7a6, 0x5ee3=>0xd7a2, 0x5ee8=>0xd7a8, 0x5ee9=>0xd7a9, 0x5eec=>0xd7aa, 0x5ef0=>0xd7ad, 0x5ef1=>0xd7ab, 0x5ef3=>0xd7ac, 0x5ef4=>0xd7ae, 0x5ef6=>0xb1e4, 0x5ef7=>0xc4ee, 
	0x5ef8=>0xd7af, 0x5efa=>0xb7fa, 0x5efb=>0xb2f6, 0x5efc=>0xc7b6, 0x5efe=>0xd7b0, 0x5eff=>0xc6fb, 0x5f01=>0xcadb, 0x5f03=>0xd7b1, 0x5f04=>0xcfae, 0x5f09=>0xd7b2, 0x5f0a=>0xcac0, 0x5f0b=>0xd7b5, 0x5f0c=>0xd0a1, 0x5f0d=>0xd0b1, 0x5f0f=>0xbcb0, 0x5f10=>0xc6f5, 
	0x5f11=>0xd7b6, 0x5f13=>0xb5dd, 0x5f14=>0xc4a4, 0x5f15=>0xb0fa, 0x5f16=>0xd7b7, 0x5f17=>0xcaa6, 0x5f18=>0xb9b0, 0x5f1b=>0xc3d0, 0x5f1f=>0xc4ef, 0x5f25=>0xccef, 0x5f26=>0xb8b9, 0x5f27=>0xb8cc, 0x5f29=>0xd7b8, 0x5f2d=>0xd7b9, 0x5f2f=>0xd7bf, 0x5f31=>0xbce5, 
	0x5f35=>0xc4a5, 0x5f37=>0xb6af, 0x5f38=>0xd7ba, 0x5f3c=>0xc9ab, 0x5f3e=>0xc3c6, 0x5f41=>0xd7bb, 0x5f48=>0xd7bc, 0x5f4a=>0xb6b0, 0x5f4c=>0xd7bd, 0x5f4e=>0xd7be, 0x5f51=>0xd7c0, 0x5f53=>0xc5f6, 0x5f56=>0xd7c1, 0x5f57=>0xd7c2, 0x5f59=>0xd7c3, 0x5f5c=>0xd7b4, 
	0x5f5d=>0xd7b3, 0x5f61=>0xd7c4, 0x5f62=>0xb7c1, 0x5f66=>0xc9a7, 0x5f69=>0xbacc, 0x5f6a=>0xc9b7, 0x5f6b=>0xc4a6, 0x5f6c=>0xc9cb, 0x5f6d=>0xd7c5, 0x5f70=>0xbeb4, 0x5f71=>0xb1c6, 0x5f73=>0xd7c6, 0x5f77=>0xd7c7, 0x5f79=>0xccf2, 0x5f7c=>0xc8e0, 0x5f7f=>0xd7ca, 
	0x5f80=>0xb1fd, 0x5f81=>0xc0ac, 0x5f82=>0xd7c9, 0x5f83=>0xd7c8, 0x5f84=>0xb7c2, 0x5f85=>0xc2d4, 0x5f87=>0xd7ce, 0x5f88=>0xd7cc, 0x5f8a=>0xd7cb, 0x5f8b=>0xcea7, 0x5f8c=>0xb8e5, 0x5f90=>0xbdf9, 0x5f91=>0xd7cd, 0x5f92=>0xc5cc, 0x5f93=>0xbdbe, 0x5f97=>0xc6c0, 
	0x5f98=>0xd7d1, 0x5f99=>0xd7d0, 0x5f9e=>0xd7cf, 0x5fa0=>0xd7d2, 0x5fa1=>0xb8e6, 0x5fa8=>0xd7d3, 0x5fa9=>0xc9fc, 0x5faa=>0xbddb, 0x5fad=>0xd7d4, 0x5fae=>0xc8f9, 0x5fb3=>0xc6c1, 0x5fb4=>0xc4a7, 0x5fb9=>0xc5b0, 0x5fbc=>0xd7d5, 0x5fbd=>0xb5ab, 0x5fc3=>0xbfb4, 
	0x5fc5=>0xc9ac, 0x5fcc=>0xb4f7, 0x5fcd=>0xc7a6, 0x5fd6=>0xd7d6, 0x5fd7=>0xbbd6, 0x5fd8=>0xcbba, 0x5fd9=>0xcbbb, 0x5fdc=>0xb1fe, 0x5fdd=>0xd7db, 0x5fe0=>0xc3e9, 0x5fe4=>0xd7d8, 0x5feb=>0xb2f7, 0x5ff0=>0xd8ad, 0x5ff1=>0xd7da, 0x5ff5=>0xc7b0, 0x5ff8=>0xd7d9, 
	0x5ffb=>0xd7d7, 0x5ffd=>0xb9fa, 0x5fff=>0xd7dd, 0x600e=>0xd7e3, 0x600f=>0xd7e9, 0x6010=>0xd7e1, 0x6012=>0xc5dc, 0x6015=>0xd7e6, 0x6016=>0xc9dd, 0x6019=>0xd7e0, 0x601b=>0xd7e5, 0x601c=>0xcee7, 0x601d=>0xbbd7, 0x6020=>0xc2d5, 0x6021=>0xd7de, 0x6025=>0xb5de, 
	0x6026=>0xd7e8, 0x6027=>0xc0ad, 0x6028=>0xb1e5, 0x6029=>0xd7e2, 0x602a=>0xb2f8, 0x602b=>0xd7e7, 0x602f=>0xb6b1, 0x6031=>0xd7e4, 0x603a=>0xd7ea, 0x6041=>0xd7ec, 0x6042=>0xd7f6, 0x6043=>0xd7f4, 0x6046=>0xd7f1, 0x604a=>0xd7f0, 0x604b=>0xcef8, 0x604d=>0xd7f2, 
	0x6050=>0xb6b2, 0x6052=>0xb9b1, 0x6055=>0xbdfa, 0x6059=>0xd7f9, 0x605a=>0xd7eb, 0x605f=>0xd7ef, 0x6060=>0xd7df, 0x6062=>0xb2fa, 0x6063=>0xd7f3, 0x6064=>0xd7f5, 0x6065=>0xc3d1, 0x6068=>0xbaa8, 0x6069=>0xb2b8, 0x606a=>0xd7ed, 0x606b=>0xd7f8, 0x606c=>0xd7f7, 
	0x606d=>0xb6b3, 0x606f=>0xc2a9, 0x6070=>0xb3e6, 0x6075=>0xb7c3, 0x6077=>0xd7ee, 0x6081=>0xd7fa, 0x6083=>0xd7fd, 0x6084=>0xd8a1, 0x6089=>0xbcbd, 0x608b=>0xd8a7, 0x608c=>0xc4f0, 0x608d=>0xd7fb, 0x6092=>0xd8a5, 0x6094=>0xb2f9, 0x6096=>0xd8a3, 0x6097=>0xd8a4, 
	0x609a=>0xd7fe, 0x609b=>0xd8a2, 0x609f=>0xb8e7, 0x60a0=>0xcdaa, 0x60a3=>0xb4b5, 0x60a6=>0xb1d9, 0x60a7=>0xd8a6, 0x60a9=>0xc7ba, 0x60aa=>0xb0ad, 0x60b2=>0xc8e1, 0x60b3=>0xd7dc, 0x60b4=>0xd8ac, 0x60b5=>0xd8b0, 0x60b6=>0xcce5, 0x60b8=>0xd8a9, 0x60bc=>0xc5e9, 
	0x60bd=>0xd8ae, 0x60c5=>0xbef0, 0x60c6=>0xd8af, 0x60c7=>0xc6d7, 0x60d1=>0xcfc7, 0x60d3=>0xd8ab, 0x60d8=>0xd8b1, 0x60da=>0xb9fb, 0x60dc=>0xc0cb, 0x60df=>0xb0d4, 0x60e0=>0xd8aa, 0x60e1=>0xd8a8, 0x60e3=>0xc1da, 0x60e7=>0xd7fc, 0x60e8=>0xbbb4, 0x60f0=>0xc2c6, 
	0x60f1=>0xd8bd, 0x60f3=>0xc1db, 0x60f4=>0xd8b8, 0x60f6=>0xd8b5, 0x60f7=>0xd8b6, 0x60f9=>0xbce6, 0x60fa=>0xd8b9, 0x60fb=>0xd8bc, 0x6100=>0xd8b7, 0x6101=>0xbda5, 0x6103=>0xd8ba, 0x6106=>0xd8b4, 0x6108=>0xccfc, 0x6109=>0xccfb, 0x610d=>0xd8be, 0x610e=>0xd8bf, 
	0x610f=>0xb0d5, 0x6115=>0xd8b3, 0x611a=>0xb6f2, 0x611b=>0xb0a6, 0x611f=>0xb4b6, 0x6121=>0xd8bb, 0x6127=>0xd8c3, 0x6128=>0xd8c2, 0x612c=>0xd8c7, 0x6134=>0xd8c8, 0x613c=>0xd8c6, 0x613d=>0xd8c9, 0x613e=>0xd8c1, 0x613f=>0xd8c5, 0x6142=>0xd8ca, 0x6144=>0xd8cb, 
	0x6147=>0xd8c0, 0x6148=>0xbbfc, 0x614a=>0xd8c4, 0x614b=>0xc2d6, 0x614c=>0xb9b2, 0x614d=>0xd8b2, 0x614e=>0xbfb5, 0x6153=>0xd8d8, 0x6155=>0xcae9, 0x6158=>0xd8ce, 0x6159=>0xd8cf, 0x615a=>0xd8d0, 0x615d=>0xd8d7, 0x615f=>0xd8d6, 0x6162=>0xcbfd, 0x6163=>0xb4b7, 
	0x6165=>0xd8d4, 0x6167=>0xb7c5, 0x6168=>0xb3b4, 0x616b=>0xd8d1, 0x616e=>0xceb8, 0x616f=>0xd8d3, 0x6170=>0xb0d6, 0x6171=>0xd8d5, 0x6173=>0xd8cc, 0x6174=>0xd8d2, 0x6175=>0xd8d9, 0x6176=>0xb7c4, 0x6177=>0xd8cd, 0x617e=>0xcddd, 0x6182=>0xcdab, 0x6187=>0xd8dc, 
	0x618a=>0xd8e0, 0x618e=>0xc1fe, 0x6190=>0xcef9, 0x6191=>0xd8e1, 0x6194=>0xd8de, 0x6196=>0xd8db, 0x6199=>0xd8da, 0x619a=>0xd8df, 0x61a4=>0xcab0, 0x61a7=>0xc6b4, 0x61a9=>0xb7c6, 0x61ab=>0xd8e2, 0x61ac=>0xd8dd, 0x61ae=>0xd8e3, 0x61b2=>0xb7fb, 0x61b6=>0xb2b1, 
	0x61ba=>0xd8eb, 0x61be=>0xb4b8, 0x61c3=>0xd8e9, 0x61c6=>0xd8ea, 0x61c7=>0xbaa9, 0x61c8=>0xd8e8, 0x61c9=>0xd8e6, 0x61ca=>0xd8e5, 0x61cb=>0xd8ec, 0x61cc=>0xd8e4, 0x61cd=>0xd8ee, 0x61d0=>0xb2fb, 0x61e3=>0xd8f0, 0x61e6=>0xd8ef, 0x61f2=>0xc4a8, 0x61f4=>0xd8f3, 
	0x61f6=>0xd8f1, 0x61f7=>0xd8e7, 0x61f8=>0xb7fc, 0x61fa=>0xd8f2, 0x61fc=>0xd8f6, 0x61fd=>0xd8f5, 0x61fe=>0xd8f7, 0x61ff=>0xd8f4, 0x6200=>0xd8f8, 0x6208=>0xd8f9, 0x6209=>0xd8fa, 0x620a=>0xcaea, 0x620c=>0xd8fc, 0x620d=>0xd8fb, 0x620e=>0xbdbf, 0x6210=>0xc0ae, 
	0x6211=>0xb2e6, 0x6212=>0xb2fc, 0x6214=>0xd8fd, 0x6216=>0xb0bf, 0x621a=>0xc0cc, 0x621b=>0xd8fe, 0x621d=>0xecc3, 0x621e=>0xd9a1, 0x621f=>0xb7e1, 0x6221=>0xd9a2, 0x6226=>0xc0ef, 0x622a=>0xd9a3, 0x622e=>0xd9a4, 0x622f=>0xb5ba, 0x6230=>0xd9a5, 0x6232=>0xd9a6, 
	0x6233=>0xd9a7, 0x6234=>0xc2d7, 0x6238=>0xb8cd, 0x623b=>0xcce1, 0x623f=>0xcbbc, 0x6240=>0xbdea, 0x6241=>0xd9a8, 0x6247=>0xc0f0, 0x6248=>0xeebd, 0x6249=>0xc8e2, 0x624b=>0xbcea, 0x624d=>0xbacd, 0x624e=>0xd9a9, 0x6253=>0xc2c7, 0x6255=>0xcaa7, 0x6258=>0xc2f1, 
	0x625b=>0xd9ac, 0x625e=>0xd9aa, 0x6260=>0xd9ad, 0x6263=>0xd9ab, 0x6268=>0xd9ae, 0x626e=>0xcab1, 0x6271=>0xb0b7, 0x6276=>0xc9de, 0x6279=>0xc8e3, 0x627c=>0xd9af, 0x627e=>0xd9b2, 0x627f=>0xbeb5, 0x6280=>0xb5bb, 0x6282=>0xd9b0, 0x6283=>0xd9b7, 0x6284=>0xbeb6, 
	0x6289=>0xd9b1, 0x628a=>0xc7c4, 0x6291=>0xcdde, 0x6292=>0xd9b3, 0x6293=>0xd9b4, 0x6294=>0xd9b8, 0x6295=>0xc5ea, 0x6296=>0xd9b5, 0x6297=>0xb9b3, 0x6298=>0xc0de, 0x629b=>0xd9c6, 0x629c=>0xc8b4, 0x629e=>0xc2f2, 0x62ab=>0xc8e4, 0x62ac=>0xdaad, 0x62b1=>0xcafa, 
	0x62b5=>0xc4f1, 0x62b9=>0xcbf5, 0x62bb=>0xd9bb, 0x62bc=>0xb2a1, 0x62bd=>0xc3ea, 0x62c2=>0xd9c4, 0x62c5=>0xc3b4, 0x62c6=>0xd9be, 0x62c7=>0xd9c5, 0x62c8=>0xd9c0, 0x62c9=>0xd9c7, 0x62ca=>0xd9c3, 0x62cc=>0xd9c2, 0x62cd=>0xc7ef, 0x62cf=>0xd9bc, 0x62d0=>0xb2fd, 
	0x62d1=>0xd9ba, 0x62d2=>0xb5f1, 0x62d3=>0xc2f3, 0x62d4=>0xd9b6, 0x62d7=>0xd9b9, 0x62d8=>0xb9b4, 0x62d9=>0xc0db, 0x62db=>0xbeb7, 0x62dc=>0xd9c1, 0x62dd=>0xc7d2, 0x62e0=>0xb5f2, 0x62e1=>0xb3c8, 0x62ec=>0xb3e7, 0x62ed=>0xbfa1, 0x62ee=>0xd9c9, 0x62ef=>0xd9ce, 
	0x62f1=>0xd9ca, 0x62f3=>0xb7fd, 0x62f5=>0xd9cf, 0x62f6=>0xbba2, 0x62f7=>0xb9e9, 0x62fe=>0xbda6, 0x62ff=>0xd9bd, 0x6301=>0xbbfd, 0x6302=>0xd9cc, 0x6307=>0xbbd8, 0x6308=>0xd9cd, 0x6309=>0xb0c4, 0x630c=>0xd9c8, 0x6311=>0xc4a9, 0x6319=>0xb5f3, 0x631f=>0xb6b4, 
	0x6327=>0xd9cb, 0x6328=>0xb0a7, 0x632b=>0xbac3, 0x632f=>0xbfb6, 0x633a=>0xc4f2, 0x633d=>0xc8d4, 0x633e=>0xd9d1, 0x633f=>0xc1de, 0x6349=>0xc2aa, 0x634c=>0xbbab, 0x634d=>0xd9d2, 0x634f=>0xd9d4, 0x6350=>0xd9d0, 0x6355=>0xcae1, 0x6357=>0xc4bd, 0x635c=>0xc1dc, 
	0x6367=>0xcafb, 0x6368=>0xbcce, 0x6369=>0xd9e0, 0x636b=>0xd9df, 0x636e=>0xbff8, 0x6372=>0xb7fe, 0x6376=>0xd9d9, 0x6377=>0xbeb9, 0x637a=>0xc6e8, 0x637b=>0xc7b1, 0x6380=>0xd9d7, 0x6383=>0xc1dd, 0x6388=>0xbcf8, 0x6389=>0xd9dc, 0x638c=>0xbeb8, 0x638e=>0xd9d6, 
	0x638f=>0xd9db, 0x6392=>0xc7d3, 0x6396=>0xd9d5, 0x6398=>0xb7a1, 0x639b=>0xb3dd, 0x639f=>0xd9dd, 0x63a0=>0xceab, 0x63a1=>0xbace, 0x63a2=>0xc3b5, 0x63a3=>0xd9da, 0x63a5=>0xc0dc, 0x63a7=>0xb9b5, 0x63a8=>0xbfe4, 0x63a9=>0xb1e6, 0x63aa=>0xc1bc, 0x63ab=>0xd9d8, 
	0x63ac=>0xb5c5, 0x63b2=>0xb7c7, 0x63b4=>0xc4cf, 0x63b5=>0xd9de, 0x63bb=>0xc1df, 0x63be=>0xd9e1, 0x63c0=>0xd9e3, 0x63c3=>0xc2b7, 0x63c4=>0xd9e9, 0x63c6=>0xd9e4, 0x63c9=>0xd9e6, 0x63cf=>0xc9c1, 0x63d0=>0xc4f3, 0x63d2=>0xd9e7, 0x63d6=>0xcdac, 0x63da=>0xcdc8, 
	0x63db=>0xb4b9, 0x63e1=>0xb0ae, 0x63e3=>0xd9e5, 0x63e9=>0xd9e2, 0x63ee=>0xb4f8, 0x63f4=>0xb1e7, 0x63f6=>0xd9e8, 0x63fa=>0xcdc9, 0x6406=>0xd9ec, 0x640d=>0xc2bb, 0x640f=>0xd9f3, 0x6413=>0xd9ed, 0x6416=>0xd9ea, 0x6417=>0xd9f1, 0x641c=>0xd9d3, 0x6426=>0xd9ee, 
	0x6428=>0xd9f2, 0x642c=>0xc8c2, 0x642d=>0xc5eb, 0x6434=>0xd9eb, 0x6436=>0xd9ef, 0x643a=>0xb7c8, 0x643e=>0xbaf1, 0x6442=>0xc0dd, 0x644e=>0xd9f7, 0x6458=>0xc5a6, 0x6467=>0xd9f4, 0x6469=>0xcbe0, 0x646f=>0xd9f5, 0x6476=>0xd9f6, 0x6478=>0xccce, 0x647a=>0xc0a2, 
	0x6483=>0xb7e2, 0x6488=>0xd9fd, 0x6492=>0xbbb5, 0x6493=>0xd9fa, 0x6495=>0xd9f9, 0x649a=>0xc7b2, 0x649e=>0xc6b5, 0x64a4=>0xc5b1, 0x64a5=>0xd9fb, 0x64a9=>0xd9fc, 0x64ab=>0xc9ef, 0x64ad=>0xc7c5, 0x64ae=>0xbba3, 0x64b0=>0xc0f1, 0x64b2=>0xcbd0, 0x64b9=>0xb3c9, 
	0x64bb=>0xdaa5, 0x64bc=>0xd9fe, 0x64c1=>0xcdca, 0x64c2=>0xdaa7, 0x64c5=>0xdaa3, 0x64c7=>0xdaa4, 0x64cd=>0xc1e0, 0x64d2=>0xdaa2, 0x64d4=>0xd9bf, 0x64d8=>0xdaa6, 0x64da=>0xdaa1, 0x64e0=>0xdaab, 0x64e1=>0xdaac, 0x64e2=>0xc5a7, 0x64e3=>0xdaae, 0x64e6=>0xbba4, 
	0x64e7=>0xdaa9, 0x64ec=>0xb5bc, 0x64ef=>0xdaaf, 0x64f1=>0xdaa8, 0x64f2=>0xdab3, 0x64f4=>0xdab2, 0x64f6=>0xdab1, 0x64fa=>0xdab4, 0x64fd=>0xdab6, 0x64fe=>0xbef1, 0x6500=>0xdab5, 0x6505=>0xdab9, 0x6518=>0xdab7, 0x651c=>0xdab8, 0x651d=>0xd9f0, 0x6523=>0xdabb, 
	0x6524=>0xdaba, 0x652a=>0xd9f8, 0x652b=>0xdabc, 0x652c=>0xdab0, 0x652f=>0xbbd9, 0x6534=>0xdabd, 0x6535=>0xdabe, 0x6536=>0xdac0, 0x6537=>0xdabf, 0x6538=>0xdac1, 0x6539=>0xb2fe, 0x653b=>0xb9b6, 0x653e=>0xcafc, 0x653f=>0xc0af, 0x6545=>0xb8ce, 0x6548=>0xdac3, 
	0x654d=>0xdac6, 0x654f=>0xc9d2, 0x6551=>0xb5df, 0x6555=>0xdac5, 0x6556=>0xdac4, 0x6557=>0xc7d4, 0x6558=>0xdac7, 0x6559=>0xb6b5, 0x655d=>0xdac9, 0x655e=>0xdac8, 0x6562=>0xb4ba, 0x6563=>0xbbb6, 0x6566=>0xc6d8, 0x656c=>0xb7c9, 0x6570=>0xbff4, 0x6572=>0xdaca, 
	0x6574=>0xc0b0, 0x6575=>0xc5a8, 0x6577=>0xc9df, 0x6578=>0xdacb, 0x6582=>0xdacc, 0x6583=>0xdacd, 0x6587=>0xcab8, 0x6588=>0xd5dd, 0x6589=>0xc0c6, 0x658c=>0xc9cc, 0x658e=>0xbad8, 0x6590=>0xc8e5, 0x6591=>0xc8c3, 0x6597=>0xc5cd, 0x6599=>0xcec1, 0x659b=>0xdacf, 
	0x659c=>0xbcd0, 0x659f=>0xdad0, 0x65a1=>0xb0b6, 0x65a4=>0xb6d4, 0x65a5=>0xc0cd, 0x65a7=>0xc9e0, 0x65ab=>0xdad1, 0x65ac=>0xbbc2, 0x65ad=>0xc3c7, 0x65af=>0xbbdb, 0x65b0=>0xbfb7, 0x65b7=>0xdad2, 0x65b9=>0xcafd, 0x65bc=>0xb1f7, 0x65bd=>0xbbdc, 0x65c1=>0xdad5, 
	0x65c3=>0xdad3, 0x65c4=>0xdad6, 0x65c5=>0xceb9, 0x65c6=>0xdad4, 0x65cb=>0xc0fb, 0x65cc=>0xdad7, 0x65cf=>0xc2b2, 0x65d2=>0xdad8, 0x65d7=>0xb4fa, 0x65d9=>0xdada, 0x65db=>0xdad9, 0x65e0=>0xdadb, 0x65e1=>0xdadc, 0x65e2=>0xb4fb, 0x65e5=>0xc6fc, 0x65e6=>0xc3b6, 
	0x65e7=>0xb5ec, 0x65e8=>0xbbdd, 0x65e9=>0xc1e1, 0x65ec=>0xbddc, 0x65ed=>0xb0b0, 0x65f1=>0xdadd, 0x65fa=>0xb2a2, 0x65fb=>0xdae1, 0x6602=>0xb9b7, 0x6603=>0xdae0, 0x6606=>0xbaab, 0x6607=>0xbeba, 0x660a=>0xdadf, 0x660c=>0xbebb, 0x660e=>0xccc0, 0x660f=>0xbaaa, 
	0x6613=>0xb0d7, 0x6614=>0xc0ce, 0x661c=>0xdae6, 0x661f=>0xc0b1, 0x6620=>0xb1c7, 0x6625=>0xbdd5, 0x6627=>0xcbe6, 0x6628=>0xbaf2, 0x662d=>0xbebc, 0x662f=>0xc0a7, 0x6634=>0xdae5, 0x6635=>0xdae3, 0x6636=>0xdae4, 0x663c=>0xc3eb, 0x663f=>0xdba6, 0x6641=>0xdaea, 
	0x6642=>0xbbfe, 0x6643=>0xb9b8, 0x6644=>0xdae8, 0x6649=>0xdae9, 0x664b=>0xbfb8, 0x664f=>0xdae7, 0x6652=>0xbbaf, 0x665d=>0xdaec, 0x665e=>0xdaeb, 0x665f=>0xdaf0, 0x6662=>0xdaf1, 0x6664=>0xdaed, 0x6666=>0xb3a2, 0x6667=>0xdaee, 0x6668=>0xdaef, 0x6669=>0xc8d5, 
	0x666e=>0xc9e1, 0x666f=>0xb7ca, 0x6670=>0xdaf2, 0x6674=>0xc0b2, 0x6676=>0xbebd, 0x667a=>0xc3d2, 0x6681=>0xb6c7, 0x6683=>0xdaf3, 0x6684=>0xdaf7, 0x6687=>0xb2cb, 0x6688=>0xdaf4, 0x6689=>0xdaf6, 0x668e=>0xdaf5, 0x6691=>0xbdeb, 0x6696=>0xc3c8, 0x6697=>0xb0c5, 
	0x6698=>0xdaf8, 0x669d=>0xdaf9, 0x66a2=>0xc4aa, 0x66a6=>0xcef1, 0x66ab=>0xbbc3, 0x66ae=>0xcaeb, 0x66b4=>0xcbbd, 0x66b8=>0xdba2, 0x66b9=>0xdafb, 0x66bc=>0xdafe, 0x66be=>0xdafd, 0x66c1=>0xdafa, 0x66c4=>0xdba1, 0x66c7=>0xc6de, 0x66c9=>0xdafc, 0x66d6=>0xdba3, 
	0x66d9=>0xbdec, 0x66da=>0xdba4, 0x66dc=>0xcdcb, 0x66dd=>0xc7f8, 0x66e0=>0xdba5, 0x66e6=>0xdba7, 0x66e9=>0xdba8, 0x66f0=>0xdba9, 0x66f2=>0xb6ca, 0x66f3=>0xb1c8, 0x66f4=>0xb9b9, 0x66f5=>0xdbaa, 0x66f7=>0xdbab, 0x66f8=>0xbdf1, 0x66f9=>0xc1e2, 0x66fc=>0xd2d8, 
	0x66fd=>0xc1be, 0x66fe=>0xc1bd, 0x66ff=>0xc2d8, 0x6700=>0xbac7, 0x6703=>0xd0f2, 0x6708=>0xb7ee, 0x6709=>0xcdad, 0x670b=>0xcafe, 0x670d=>0xc9fe, 0x670f=>0xdbac, 0x6714=>0xbaf3, 0x6715=>0xc4bf, 0x6716=>0xdbad, 0x6717=>0xcfaf, 0x671b=>0xcbbe, 0x671d=>0xc4ab, 
	0x671e=>0xdbae, 0x671f=>0xb4fc, 0x6726=>0xdbaf, 0x6727=>0xdbb0, 0x6728=>0xccda, 0x672a=>0xcca4, 0x672b=>0xcbf6, 0x672c=>0xcbdc, 0x672d=>0xbba5, 0x672e=>0xdbb2, 0x6731=>0xbceb, 0x6734=>0xcbd1, 0x6736=>0xdbb4, 0x6737=>0xdbb7, 0x6738=>0xdbb6, 0x673a=>0xb4f9, 
	0x673d=>0xb5e0, 0x673f=>0xdbb3, 0x6741=>0xdbb5, 0x6746=>0xdbb8, 0x6749=>0xbff9, 0x674e=>0xcdfb, 0x674f=>0xb0c9, 0x6750=>0xbae0, 0x6751=>0xc2bc, 0x6753=>0xbcdd, 0x6756=>0xbef3, 0x6759=>0xdbbb, 0x675c=>0xc5ce, 0x675e=>0xdbb9, 0x675f=>0xc2ab, 0x6760=>0xdbba, 
	0x6761=>0xbef2, 0x6762=>0xccdd, 0x6763=>0xdbbc, 0x6764=>0xdbbd, 0x6765=>0xcde8, 0x676a=>0xdbc2, 0x676d=>0xb9ba, 0x676f=>0xc7d5, 0x6770=>0xdbbf, 0x6771=>0xc5ec, 0x6772=>0xdade, 0x6773=>0xdae2, 0x6775=>0xb5cf, 0x6777=>0xc7c7, 0x677c=>0xdbc1, 0x677e=>0xbebe, 
	0x677f=>0xc8c4, 0x6785=>0xdbc7, 0x6787=>0xc8fa, 0x6789=>0xdbbe, 0x678b=>0xdbc4, 0x678c=>0xdbc3, 0x6790=>0xc0cf, 0x6795=>0xcbed, 0x6797=>0xced3, 0x679a=>0xcbe7, 0x679c=>0xb2cc, 0x679d=>0xbbde, 0x67a0=>0xcfc8, 0x67a1=>0xdbc6, 0x67a2=>0xbff5, 0x67a6=>0xdbc5, 
	0x67a9=>0xdbc0, 0x67af=>0xb8cf, 0x67b3=>0xdbcc, 0x67b4=>0xdbca, 0x67b6=>0xb2cd, 0x67b7=>0xdbc8, 0x67b8=>0xdbce, 0x67b9=>0xdbd4, 0x67c1=>0xc2c8, 0x67c4=>0xcac1, 0x67c6=>0xdbd6, 0x67ca=>0xc9a2, 0x67ce=>0xdbd5, 0x67cf=>0xc7f0, 0x67d0=>0xcbbf, 0x67d1=>0xb4bb, 
	0x67d3=>0xc0f7, 0x67d4=>0xbdc0, 0x67d8=>0xc4d3, 0x67da=>0xcdae, 0x67dd=>0xdbd1, 0x67de=>0xdbd0, 0x67e2=>0xdbd2, 0x67e4=>0xdbcf, 0x67e7=>0xdbd7, 0x67e9=>0xdbcd, 0x67ec=>0xdbcb, 0x67ee=>0xdbd3, 0x67ef=>0xdbc9, 0x67f1=>0xc3ec, 0x67f3=>0xccf8, 0x67f4=>0xbcc6, 
	0x67f5=>0xbaf4, 0x67fb=>0xbaba, 0x67fe=>0xcbef, 0x67ff=>0xb3c1, 0x6802=>0xc4ce, 0x6803=>0xc6ca, 0x6804=>0xb1c9, 0x6813=>0xc0f2, 0x6816=>0xc0b4, 0x6817=>0xb7aa, 0x681e=>0xdbd9, 0x6821=>0xb9bb, 0x6822=>0xb3fc, 0x6829=>0xdbdb, 0x682a=>0xb3f4, 0x682b=>0xdbe1, 
	0x6832=>0xdbde, 0x6834=>0xc0f3, 0x6838=>0xb3cb, 0x6839=>0xbaac, 0x683c=>0xb3ca, 0x683d=>0xbacf, 0x6840=>0xdbdc, 0x6841=>0xb7e5, 0x6842=>0xb7cb, 0x6843=>0xc5ed, 0x6846=>0xdbda, 0x6848=>0xb0c6, 0x684d=>0xdbdd, 0x684e=>0xdbdf, 0x6850=>0xb6cd, 0x6851=>0xb7ac, 
	0x6853=>0xb4bc, 0x6854=>0xb5cb, 0x6859=>0xdbe2, 0x685c=>0xbaf9, 0x685d=>0xcbf1, 0x685f=>0xbbb7, 0x6863=>0xdbe3, 0x6867=>0xc9b0, 0x6874=>0xdbef, 0x6876=>0xb2b3, 0x6877=>0xdbe4, 0x687e=>0xdbf5, 0x687f=>0xdbe5, 0x6881=>0xcec2, 0x6883=>0xdbec, 0x6885=>0xc7df, 
	0x688d=>0xdbf4, 0x688f=>0xdbe7, 0x6893=>0xb0b4, 0x6894=>0xdbe9, 0x6897=>0xb9bc, 0x689b=>0xdbeb, 0x689d=>0xdbea, 0x689f=>0xdbe6, 0x68a0=>0xdbf1, 0x68a2=>0xbebf, 0x68a6=>0xd4ed, 0x68a7=>0xb8e8, 0x68a8=>0xcdfc, 0x68ad=>0xdbe8, 0x68af=>0xc4f4, 0x68b0=>0xb3a3, 
	0x68b1=>0xbaad, 0x68b3=>0xdbe0, 0x68b5=>0xdbf0, 0x68b6=>0xb3e1, 0x68b9=>0xdbee, 0x68ba=>0xdbf2, 0x68bc=>0xc5ee, 0x68c4=>0xb4fe, 0x68c6=>0xdcb2, 0x68c9=>0xccc9, 0x68ca=>0xdbf7, 0x68cb=>0xb4fd, 0x68cd=>0xdbfe, 0x68d2=>0xcbc0, 0x68d4=>0xdca1, 0x68d5=>0xdca3, 
	0x68d7=>0xdca7, 0x68d8=>0xdbf9, 0x68da=>0xc3aa, 0x68df=>0xc5ef, 0x68e0=>0xdcab, 0x68e1=>0xdbfc, 0x68e3=>0xdca8, 0x68e7=>0xdca2, 0x68ee=>0xbfb9, 0x68ef=>0xdcac, 0x68f2=>0xc0b3, 0x68f9=>0xdcaa, 0x68fa=>0xb4bd, 0x6900=>0xcfd0, 0x6901=>0xdbf6, 0x6904=>0xdca6, 
	0x6905=>0xb0d8, 0x6908=>0xdbf8, 0x690b=>0xccba, 0x690c=>0xdbfd, 0x690d=>0xbfa2, 0x690e=>0xc4c7, 0x690f=>0xdbf3, 0x6912=>0xdca5, 0x6919=>0xbffa, 0x691a=>0xdcaf, 0x691b=>0xb3f1, 0x691c=>0xb8a1, 0x6921=>0xdcb1, 0x6922=>0xdbfa, 0x6923=>0xdcb0, 0x6925=>0xdca9, 
	0x6926=>0xdbfb, 0x6928=>0xdcad, 0x692a=>0xdcae, 0x6930=>0xdcbf, 0x6934=>0xc6ce, 0x6936=>0xdca4, 0x6939=>0xdcbb, 0x693d=>0xdcbd, 0x693f=>0xc4d8, 0x694a=>0xcdcc, 0x6953=>0xc9f6, 0x6954=>0xdcb8, 0x6955=>0xc2ca, 0x6959=>0xdcbe, 0x695a=>0xc1bf, 0x695c=>0xdcb5, 
	0x695d=>0xdcc2, 0x695e=>0xdcc1, 0x6960=>0xc6ef, 0x6961=>0xdcc0, 0x6962=>0xc6ea, 0x696a=>0xdcc4, 0x696b=>0xdcb7, 0x696d=>0xb6c8, 0x696e=>0xdcba, 0x696f=>0xbddd, 0x6973=>0xc7e0, 0x6974=>0xdcbc, 0x6975=>0xb6cb, 0x6977=>0xdcb4, 0x6978=>0xdcb6, 0x6979=>0xdcb3, 
	0x697c=>0xcfb0, 0x697d=>0xb3da, 0x697e=>0xdcb9, 0x6981=>0xdcc3, 0x6982=>0xb3b5, 0x698a=>0xbae7, 0x698e=>0xb1dd, 0x6991=>0xdcd4, 0x6994=>0xcfb1, 0x6995=>0xdcd7, 0x699b=>0xbfba, 0x699c=>0xdcd6, 0x69a0=>0xdcd5, 0x69a7=>0xdcd2, 0x69ae=>0xdcc6, 0x69b1=>0xdce3, 
	0x69b2=>0xdcc5, 0x69b4=>0xdcd8, 0x69bb=>0xdcd0, 0x69be=>0xdccb, 0x69bf=>0xdcc8, 0x69c1=>0xdcc9, 0x69c3=>0xdcd1, 0x69c7=>0xf4a2, 0x69ca=>0xdcce, 0x69cb=>0xb9bd, 0x69cc=>0xc4c8, 0x69cd=>0xc1e4, 0x69ce=>0xdccc, 0x69d0=>0xdcc7, 0x69d3=>0xdcca, 0x69d8=>0xcdcd, 
	0x69d9=>0xcbea, 0x69dd=>0xdccf, 0x69de=>0xdcd9, 0x69e7=>0xdce1, 0x69e8=>0xdcda, 0x69eb=>0xdce7, 0x69ed=>0xdce5, 0x69f2=>0xdce0, 0x69f9=>0xdcdf, 0x69fb=>0xc4d0, 0x69fd=>0xc1e5, 0x69ff=>0xdcdd, 0x6a02=>0xdcdb, 0x6a05=>0xdce2, 0x6a0a=>0xdce8, 0x6a0b=>0xc8f5, 
	0x6a0c=>0xdcee, 0x6a12=>0xdce9, 0x6a13=>0xdcec, 0x6a14=>0xdce6, 0x6a17=>0xc3f4, 0x6a19=>0xc9b8, 0x6a1b=>0xdcdc, 0x6a1e=>0xdce4, 0x6a1f=>0xbec0, 0x6a21=>0xcccf, 0x6a22=>0xdcf8, 0x6a23=>0xdceb, 0x6a29=>0xb8a2, 0x6a2a=>0xb2a3, 0x6a2b=>0xb3df, 0x6a2e=>0xdcd3, 
	0x6a35=>0xbec1, 0x6a36=>0xdcf0, 0x6a38=>0xdcf7, 0x6a39=>0xbcf9, 0x6a3a=>0xb3f2, 0x6a3d=>0xc3ae, 0x6a44=>0xdced, 0x6a47=>0xdcf2, 0x6a48=>0xdcf6, 0x6a4b=>0xb6b6, 0x6a58=>0xb5cc, 0x6a59=>0xdcf4, 0x6a5f=>0xb5a1, 0x6a61=>0xc6cb, 0x6a62=>0xdcf3, 0x6a66=>0xdcf5, 
	0x6a72=>0xdcef, 0x6a78=>0xdcf1, 0x6a7f=>0xb3e0, 0x6a80=>0xc3c9, 0x6a84=>0xdcfc, 0x6a8d=>0xdcfa, 0x6a8e=>0xb8e9, 0x6a90=>0xdcf9, 0x6a97=>0xdda1, 0x6a9c=>0xdbd8, 0x6aa0=>0xdcfb, 0x6aa2=>0xdcfd, 0x6aa3=>0xdcfe, 0x6aaa=>0xddac, 0x6aac=>0xdda8, 0x6aae=>0xdbed, 
	0x6ab3=>0xdda7, 0x6ab8=>0xdda6, 0x6abb=>0xdda3, 0x6ac1=>0xdcea, 0x6ac2=>0xdda5, 0x6ac3=>0xdda4, 0x6ad1=>0xddaa, 0x6ad3=>0xcfa6, 0x6ada=>0xddad, 0x6adb=>0xb6fb, 0x6ade=>0xdda9, 0x6adf=>0xddab, 0x6ae8=>0xc8a7, 0x6aea=>0xddae, 0x6afa=>0xddb2, 0x6afb=>0xddaf, 
	0x6b04=>0xcdf3, 0x6b05=>0xddb0, 0x6b0a=>0xdcde, 0x6b12=>0xddb3, 0x6b16=>0xddb4, 0x6b1d=>0xb1b5, 0x6b1f=>0xddb6, 0x6b20=>0xb7e7, 0x6b21=>0xbca1, 0x6b23=>0xb6d5, 0x6b27=>0xb2a4, 0x6b32=>0xcddf, 0x6b37=>0xddb8, 0x6b38=>0xddb7, 0x6b39=>0xddba, 0x6b3a=>0xb5bd, 
	0x6b3d=>0xb6d6, 0x6b3e=>0xb4be, 0x6b43=>0xddbd, 0x6b47=>0xddbc, 0x6b49=>0xddbe, 0x6b4c=>0xb2ce, 0x6b4e=>0xc3b7, 0x6b50=>0xddbf, 0x6b53=>0xb4bf, 0x6b54=>0xddc1, 0x6b59=>0xddc0, 0x6b5b=>0xddc2, 0x6b5f=>0xddc3, 0x6b61=>0xddc4, 0x6b62=>0xbbdf, 0x6b63=>0xc0b5, 
	0x6b64=>0xbaa1, 0x6b66=>0xc9f0, 0x6b69=>0xcae2, 0x6b6a=>0xcfc4, 0x6b6f=>0xbbf5, 0x6b73=>0xbad0, 0x6b74=>0xcef2, 0x6b78=>0xddc5, 0x6b79=>0xddc6, 0x6b7b=>0xbbe0, 0x6b7f=>0xddc7, 0x6b80=>0xddc8, 0x6b83=>0xddca, 0x6b84=>0xddc9, 0x6b86=>0xcbd8, 0x6b89=>0xbdde, 
	0x6b8a=>0xbcec, 0x6b8b=>0xbbc4, 0x6b8d=>0xddcb, 0x6b95=>0xddcd, 0x6b96=>0xbfa3, 0x6b98=>0xddcc, 0x6b9e=>0xddce, 0x6ba4=>0xddcf, 0x6baa=>0xddd0, 0x6bab=>0xddd1, 0x6baf=>0xddd2, 0x6bb1=>0xddd4, 0x6bb2=>0xddd3, 0x6bb3=>0xddd5, 0x6bb4=>0xb2a5, 0x6bb5=>0xc3ca, 
	0x6bb7=>0xddd6, 0x6bba=>0xbba6, 0x6bbb=>0xb3cc, 0x6bbc=>0xddd7, 0x6bbf=>0xc5c2, 0x6bc0=>0xd4cc, 0x6bc5=>0xb5a3, 0x6bc6=>0xddd8, 0x6bcb=>0xddd9, 0x6bcd=>0xcaec, 0x6bce=>0xcbe8, 0x6bd2=>0xc6c7, 0x6bd3=>0xddda, 0x6bd4=>0xc8e6, 0x6bd8=>0xc8fb, 0x6bdb=>0xccd3, 
	0x6bdf=>0xdddb, 0x6beb=>0xdddd, 0x6bec=>0xdddc, 0x6bef=>0xdddf, 0x6bf3=>0xddde, 0x6c08=>0xdde1, 0x6c0f=>0xbbe1, 0x6c11=>0xccb1, 0x6c13=>0xdde2, 0x6c14=>0xdde3, 0x6c17=>0xb5a4, 0x6c1b=>0xdde4, 0x6c23=>0xdde6, 0x6c24=>0xdde5, 0x6c34=>0xbfe5, 0x6c37=>0xc9b9, 
	0x6c38=>0xb1ca, 0x6c3e=>0xc8c5, 0x6c40=>0xc4f5, 0x6c41=>0xbdc1, 0x6c42=>0xb5e1, 0x6c4e=>0xc8c6, 0x6c50=>0xbcae, 0x6c55=>0xdde8, 0x6c57=>0xb4c0, 0x6c5a=>0xb1f8, 0x6c5d=>0xc6f2, 0x6c5e=>0xdde7, 0x6c5f=>0xb9be, 0x6c60=>0xc3d3, 0x6c62=>0xdde9, 0x6c68=>0xddf1, 
	0x6c6a=>0xddea, 0x6c70=>0xc2c1, 0x6c72=>0xb5e2, 0x6c73=>0xddf2, 0x6c7a=>0xb7e8, 0x6c7d=>0xb5a5, 0x6c7e=>0xddf0, 0x6c81=>0xddee, 0x6c82=>0xddeb, 0x6c83=>0xcde0, 0x6c88=>0xc4c0, 0x6c8c=>0xc6d9, 0x6c8d=>0xddec, 0x6c90=>0xddf4, 0x6c92=>0xddf3, 0x6c93=>0xb7a3, 
	0x6c96=>0xb2ad, 0x6c99=>0xbabb, 0x6c9a=>0xdded, 0x6c9b=>0xddef, 0x6ca1=>0xcbd7, 0x6ca2=>0xc2f4, 0x6cab=>0xcbf7, 0x6cae=>0xddfc, 0x6cb1=>0xddfd, 0x6cb3=>0xb2cf, 0x6cb8=>0xcaa8, 0x6cb9=>0xccfd, 0x6cba=>0xdea1, 0x6cbb=>0xbca3, 0x6cbc=>0xbec2, 0x6cbd=>0xddf8, 
	0x6cbe=>0xddfe, 0x6cbf=>0xb1e8, 0x6cc1=>0xb6b7, 0x6cc4=>0xddf5, 0x6cc5=>0xddfa, 0x6cc9=>0xc0f4, 0x6cca=>0xc7f1, 0x6ccc=>0xc8e7, 0x6cd3=>0xddf7, 0x6cd5=>0xcba1, 0x6cd7=>0xddf9, 0x6cd9=>0xdea4, 0x6cdb=>0xdea2, 0x6cdd=>0xddfb, 0x6ce1=>0xcba2, 0x6ce2=>0xc7c8, 
	0x6ce3=>0xb5e3, 0x6ce5=>0xc5a5, 0x6ce8=>0xc3ed, 0x6cea=>0xdea5, 0x6cef=>0xdea3, 0x6cf0=>0xc2d9, 0x6cf1=>0xddf6, 0x6cf3=>0xb1cb, 0x6d0b=>0xcdce, 0x6d0c=>0xdeb0, 0x6d12=>0xdeaf, 0x6d17=>0xc0f6, 0x6d19=>0xdeac, 0x6d1b=>0xcdec, 0x6d1e=>0xc6b6, 0x6d1f=>0xdea6, 
	0x6d25=>0xc4c5, 0x6d29=>0xb1cc, 0x6d2a=>0xb9bf, 0x6d2b=>0xdea9, 0x6d32=>0xbda7, 0x6d33=>0xdeae, 0x6d35=>0xdead, 0x6d36=>0xdea8, 0x6d38=>0xdeab, 0x6d3b=>0xb3e8, 0x6d3d=>0xdeaa, 0x6d3e=>0xc7c9, 0x6d41=>0xceae, 0x6d44=>0xbef4, 0x6d45=>0xc0f5, 0x6d59=>0xdeb6, 
	0x6d5a=>0xdeb4, 0x6d5c=>0xc9cd, 0x6d63=>0xdeb1, 0x6d64=>0xdeb3, 0x6d66=>0xb1ba, 0x6d69=>0xb9c0, 0x6d6a=>0xcfb2, 0x6d6c=>0xb3bd, 0x6d6e=>0xc9e2, 0x6d74=>0xcde1, 0x6d77=>0xb3a4, 0x6d78=>0xbfbb, 0x6d79=>0xdeb5, 0x6d85=>0xdeba, 0x6d88=>0xbec3, 0x6d8c=>0xcdb0, 
	0x6d8e=>0xdeb7, 0x6d93=>0xdeb2, 0x6d95=>0xdeb8, 0x6d99=>0xcede, 0x6d9b=>0xc5f3, 0x6d9c=>0xc6c2, 0x6daf=>0xb3b6, 0x6db2=>0xb1d5, 0x6db5=>0xdebe, 0x6db8=>0xdec1, 0x6dbc=>0xcec3, 0x6dc0=>0xcde4, 0x6dc5=>0xdec8, 0x6dc6=>0xdec2, 0x6dc7=>0xdebf, 0x6dcb=>0xced4, 
	0x6dcc=>0xdec5, 0x6dd1=>0xbdca, 0x6dd2=>0xdec7, 0x6dd5=>0xdecc, 0x6dd8=>0xc5f1, 0x6dd9=>0xdeca, 0x6dde=>0xdec4, 0x6de1=>0xc3b8, 0x6de4=>0xdecb, 0x6de6=>0xdec0, 0x6de8=>0xdec6, 0x6dea=>0xdecd, 0x6deb=>0xb0fc, 0x6dec=>0xdec3, 0x6dee=>0xdece, 0x6df1=>0xbfbc, 
	0x6df3=>0xbddf, 0x6df5=>0xcaa5, 0x6df7=>0xbaae, 0x6df9=>0xdebb, 0x6dfa=>0xdec9, 0x6dfb=>0xc5ba, 0x6e05=>0xc0b6, 0x6e07=>0xb3e9, 0x6e08=>0xbad1, 0x6e09=>0xbec4, 0x6e0a=>0xdebd, 0x6e0b=>0xbdc2, 0x6e13=>0xb7cc, 0x6e15=>0xdebc, 0x6e19=>0xded2, 0x6e1a=>0xbded, 
	0x6e1b=>0xb8ba, 0x6e1d=>0xdee1, 0x6e1f=>0xdedb, 0x6e20=>0xb5f4, 0x6e21=>0xc5cf, 0x6e23=>0xded6, 0x6e24=>0xdedf, 0x6e25=>0xb0af, 0x6e26=>0xb1b2, 0x6e29=>0xb2b9, 0x6e2b=>0xded8, 0x6e2c=>0xc2ac, 0x6e2d=>0xdecf, 0x6e2e=>0xded1, 0x6e2f=>0xb9c1, 0x6e38=>0xdee2, 
	0x6e3a=>0xdedd, 0x6e3e=>0xded5, 0x6e43=>0xdedc, 0x6e4a=>0xccab, 0x6e4d=>0xdeda, 0x6e4e=>0xdede, 0x6e56=>0xb8d0, 0x6e58=>0xbec5, 0x6e5b=>0xc3b9, 0x6e5f=>0xded4, 0x6e67=>0xcdaf, 0x6e6b=>0xded7, 0x6e6e=>0xded0, 0x6e6f=>0xc5f2, 0x6e72=>0xded3, 0x6e76=>0xded9, 
	0x6e7e=>0xcfd1, 0x6e7f=>0xbcbe, 0x6e80=>0xcbfe, 0x6e82=>0xdee3, 0x6e8c=>0xc8ae, 0x6e8f=>0xdeef, 0x6e90=>0xb8bb, 0x6e96=>0xbde0, 0x6e98=>0xdee5, 0x6e9c=>0xceaf, 0x6e9d=>0xb9c2, 0x6e9f=>0xdef2, 0x6ea2=>0xb0ee, 0x6ea5=>0xdef0, 0x6eaa=>0xdee4, 0x6eaf=>0xdeea, 
	0x6eb2=>0xdeec, 0x6eb6=>0xcdcf, 0x6eb7=>0xdee7, 0x6eba=>0xc5ae, 0x6ebd=>0xdee9, 0x6ec2=>0xdef1, 0x6ec4=>0xdeeb, 0x6ec5=>0xccc7, 0x6ec9=>0xdee6, 0x6ecb=>0xbca2, 0x6ecc=>0xdefe, 0x6ed1=>0xb3ea, 0x6ed3=>0xdee8, 0x6ed4=>0xdeed, 0x6ed5=>0xdeee, 0x6edd=>0xc2ec, 
	0x6ede=>0xc2da, 0x6eec=>0xdef6, 0x6eef=>0xdefc, 0x6ef2=>0xdefa, 0x6ef4=>0xc5a9, 0x6ef7=>0xdfa3, 0x6ef8=>0xdef7, 0x6efe=>0xdef8, 0x6eff=>0xdee0, 0x6f01=>0xb5f9, 0x6f02=>0xc9ba, 0x6f06=>0xbcbf, 0x6f09=>0xb9f7, 0x6f0f=>0xcfb3, 0x6f11=>0xdef4, 0x6f13=>0xdfa2, 
	0x6f14=>0xb1e9, 0x6f15=>0xc1e6, 0x6f20=>0xc7f9, 0x6f22=>0xb4c1, 0x6f23=>0xcefa, 0x6f2b=>0xcca1, 0x6f2c=>0xc4d2, 0x6f31=>0xdefb, 0x6f32=>0xdefd, 0x6f38=>0xc1b2, 0x6f3e=>0xdfa1, 0x6f3f=>0xdef9, 0x6f41=>0xdef3, 0x6f45=>0xb4c3, 0x6f54=>0xb7e9, 0x6f58=>0xdfaf, 
	0x6f5b=>0xdfaa, 0x6f5c=>0xc0f8, 0x6f5f=>0xb3e3, 0x6f64=>0xbde1, 0x6f66=>0xdfb3, 0x6f6d=>0xdfac, 0x6f6e=>0xc4ac, 0x6f6f=>0xdfa9, 0x6f70=>0xc4d9, 0x6f74=>0xdfcc, 0x6f78=>0xdfa6, 0x6f7a=>0xdfa5, 0x6f7c=>0xdfae, 0x6f80=>0xdfa8, 0x6f81=>0xdfa7, 0x6f82=>0xdfad, 
	0x6f84=>0xc0a1, 0x6f86=>0xdfa4, 0x6f8e=>0xdfb0, 0x6f91=>0xdfb1, 0x6f97=>0xb4c2, 0x6fa1=>0xdfb6, 0x6fa3=>0xdfb5, 0x6fa4=>0xdfb7, 0x6faa=>0xdfba, 0x6fb1=>0xc5c3, 0x6fb3=>0xdfb4, 0x6fb9=>0xdfb8, 0x6fc0=>0xb7e3, 0x6fc1=>0xc2f9, 0x6fc2=>0xdfb2, 0x6fc3=>0xc7bb, 
	0x6fc6=>0xdfb9, 0x6fd4=>0xdfbe, 0x6fd5=>0xdfbc, 0x6fd8=>0xdfbf, 0x6fdb=>0xdfc2, 0x6fdf=>0xdfbb, 0x6fe0=>0xb9ea, 0x6fe1=>0xc7a8, 0x6fe4=>0xdeb9, 0x6feb=>0xcdf4, 0x6fec=>0xdfbd, 0x6fee=>0xdfc1, 0x6fef=>0xc2f5, 0x6ff1=>0xdfc0, 0x6ff3=>0xdfab, 0x6ff6=>0xefe9, 
	0x6ffa=>0xdfc5, 0x6ffe=>0xdfc9, 0x7001=>0xdfc7, 0x7009=>0xdfc3, 0x700b=>0xdfc4, 0x700f=>0xdfc8, 0x7011=>0xdfc6, 0x7015=>0xc9ce, 0x7018=>0xdfce, 0x701a=>0xdfcb, 0x701b=>0xdfca, 0x701d=>0xdfcd, 0x701e=>0xc6d4, 0x701f=>0xdfcf, 0x7026=>0xc3f5, 0x7027=>0xc2ed, 
	0x702c=>0xc0a5, 0x7030=>0xdfd0, 0x7032=>0xdfd2, 0x703e=>0xdfd1, 0x704c=>0xdef5, 0x7051=>0xdfd3, 0x7058=>0xc6e7, 0x7063=>0xdfd4, 0x706b=>0xb2d0, 0x706f=>0xc5f4, 0x7070=>0xb3a5, 0x7078=>0xb5e4, 0x707c=>0xbcde, 0x707d=>0xbad2, 0x7089=>0xcfa7, 0x708a=>0xbfe6, 
	0x708e=>0xb1ea, 0x7092=>0xdfd6, 0x7099=>0xdfd5, 0x70ac=>0xdfd9, 0x70ad=>0xc3ba, 0x70ae=>0xdfdc, 0x70af=>0xdfd7, 0x70b3=>0xdfdb, 0x70b8=>0xdfda, 0x70b9=>0xc5c0, 0x70ba=>0xb0d9, 0x70c8=>0xcef5, 0x70cb=>0xdfde, 0x70cf=>0xb1a8, 0x70d9=>0xdfe0, 0x70dd=>0xdfdf, 
	0x70df=>0xdfdd, 0x70f1=>0xdfd8, 0x70f9=>0xcba3, 0x70fd=>0xdfe2, 0x7109=>0xdfe1, 0x7114=>0xb1eb, 0x7119=>0xdfe4, 0x711a=>0xcab2, 0x711c=>0xdfe3, 0x7121=>0xccb5, 0x7126=>0xbec7, 0x7136=>0xc1b3, 0x713c=>0xbec6, 0x7149=>0xcefb, 0x714c=>0xdfea, 0x714e=>0xc0f9, 
	0x7155=>0xdfe6, 0x7156=>0xdfeb, 0x7159=>0xb1ec, 0x7162=>0xdfe9, 0x7164=>0xc7e1, 0x7165=>0xdfe5, 0x7166=>0xdfe8, 0x7167=>0xbec8, 0x7169=>0xc8d1, 0x716c=>0xdfec, 0x716e=>0xbcd1, 0x717d=>0xc0fa, 0x7184=>0xdfef, 0x7188=>0xdfe7, 0x718a=>0xb7a7, 0x718f=>0xdfed, 
	0x7194=>0xcdd0, 0x7195=>0xdff0, 0x7199=>0xf4a6, 0x719f=>0xbdcf, 0x71a8=>0xdff1, 0x71ac=>0xdff2, 0x71b1=>0xc7ae, 0x71b9=>0xdff4, 0x71be=>0xdff5, 0x71c3=>0xc7b3, 0x71c8=>0xc5f5, 0x71c9=>0xdff7, 0x71ce=>0xdff9, 0x71d0=>0xced5, 0x71d2=>0xdff6, 0x71d4=>0xdff8, 
	0x71d5=>0xb1ed, 0x71d7=>0xdff3, 0x71df=>0xd3db, 0x71e0=>0xdffa, 0x71e5=>0xc1e7, 0x71e6=>0xbbb8, 0x71e7=>0xdffc, 0x71ec=>0xdffb, 0x71ed=>0xbfa4, 0x71ee=>0xd2d9, 0x71f5=>0xdffd, 0x71f9=>0xe0a1, 0x71fb=>0xdfee, 0x71fc=>0xdffe, 0x71ff=>0xe0a2, 0x7206=>0xc7fa, 
	0x720d=>0xe0a3, 0x7210=>0xe0a4, 0x721b=>0xe0a5, 0x7228=>0xe0a6, 0x722a=>0xc4de, 0x722c=>0xe0a8, 0x722d=>0xe0a7, 0x7230=>0xe0a9, 0x7232=>0xe0aa, 0x7235=>0xbcdf, 0x7236=>0xc9e3, 0x723a=>0xccec, 0x723b=>0xe0ab, 0x723c=>0xe0ac, 0x723d=>0xc1d6, 0x723e=>0xbca4, 
	0x723f=>0xe0ad, 0x7240=>0xe0ae, 0x7246=>0xe0af, 0x7247=>0xcad2, 0x7248=>0xc8c7, 0x724b=>0xe0b0, 0x724c=>0xc7d7, 0x7252=>0xc4ad, 0x7258=>0xe0b1, 0x7259=>0xb2e7, 0x725b=>0xb5ed, 0x725d=>0xccc6, 0x725f=>0xccb6, 0x7261=>0xb2b4, 0x7262=>0xcfb4, 0x7267=>0xcbd2, 
	0x7269=>0xcaaa, 0x7272=>0xc0b7, 0x7274=>0xe0b2, 0x7279=>0xc6c3, 0x727d=>0xb8a3, 0x727e=>0xe0b3, 0x7280=>0xbad4, 0x7281=>0xe0b5, 0x7282=>0xe0b4, 0x7287=>0xe0b6, 0x7292=>0xe0b7, 0x7296=>0xe0b8, 0x72a0=>0xb5be, 0x72a2=>0xe0b9, 0x72a7=>0xe0ba, 0x72ac=>0xb8a4, 
	0x72af=>0xc8c8, 0x72b2=>0xe0bc, 0x72b6=>0xbef5, 0x72b9=>0xe0bb, 0x72c2=>0xb6b8, 0x72c3=>0xe0bd, 0x72c4=>0xe0bf, 0x72c6=>0xe0be, 0x72ce=>0xe0c0, 0x72d0=>0xb8d1, 0x72d2=>0xe0c1, 0x72d7=>0xb6e9, 0x72d9=>0xc1c0, 0x72db=>0xb9fd, 0x72e0=>0xe0c3, 0x72e1=>0xe0c4, 
	0x72e2=>0xe0c2, 0x72e9=>0xbced, 0x72ec=>0xc6c8, 0x72ed=>0xb6b9, 0x72f7=>0xe0c6, 0x72f8=>0xc3ac, 0x72f9=>0xe0c5, 0x72fc=>0xcfb5, 0x72fd=>0xc7e2, 0x730a=>0xe0c9, 0x7316=>0xe0cb, 0x7317=>0xe0c8, 0x731b=>0xccd4, 0x731c=>0xe0ca, 0x731d=>0xe0cc, 0x731f=>0xcec4, 
	0x7325=>0xe0d0, 0x7329=>0xe0cf, 0x732a=>0xc3f6, 0x732b=>0xc7ad, 0x732e=>0xb8a5, 0x732f=>0xe0ce, 0x7334=>0xe0cd, 0x7336=>0xcdb1, 0x7337=>0xcdb2, 0x733e=>0xe0d1, 0x733f=>0xb1ee, 0x7344=>0xb9f6, 0x7345=>0xbbe2, 0x734e=>0xe0d2, 0x734f=>0xe0d3, 0x7357=>0xe0d5, 
	0x7363=>0xbdc3, 0x7368=>0xe0d7, 0x736a=>0xe0d6, 0x7370=>0xe0d8, 0x7372=>0xb3cd, 0x7375=>0xe0da, 0x7378=>0xe0d9, 0x737a=>0xe0dc, 0x737b=>0xe0db, 0x7384=>0xb8bc, 0x7387=>0xcea8, 0x7389=>0xb6cc, 0x738b=>0xb2a6, 0x7396=>0xb6ea, 0x73a9=>0xb4e1, 0x73b2=>0xcee8, 
	0x73b3=>0xe0de, 0x73bb=>0xe0e0, 0x73c0=>0xe0e1, 0x73c2=>0xb2d1, 0x73c8=>0xe0dd, 0x73ca=>0xbbb9, 0x73cd=>0xc4c1, 0x73ce=>0xe0df, 0x73de=>0xe0e4, 0x73e0=>0xbcee, 0x73e5=>0xe0e2, 0x73ea=>0xb7be, 0x73ed=>0xc8c9, 0x73ee=>0xe0e3, 0x73f1=>0xe0fe, 0x73f8=>0xe0e9, 
	0x73fe=>0xb8bd, 0x7403=>0xb5e5, 0x7405=>0xe0e6, 0x7406=>0xcdfd, 0x7409=>0xceb0, 0x7422=>0xc2f6, 0x7425=>0xe0e8, 0x7432=>0xe0ea, 0x7433=>0xced6, 0x7434=>0xb6d7, 0x7435=>0xc8fc, 0x7436=>0xc7ca, 0x743a=>0xe0eb, 0x743f=>0xe0ed, 0x7441=>0xe0f0, 0x7455=>0xe0ec, 
	0x7459=>0xe0ef, 0x745a=>0xb8ea, 0x745b=>0xb1cd, 0x745c=>0xe0f1, 0x745e=>0xbff0, 0x745f=>0xe0ee, 0x7460=>0xcedc, 0x7463=>0xe0f4, 0x7464=>0xf4a4, 0x7469=>0xe0f2, 0x746a=>0xe0f5, 0x746f=>0xe0e7, 0x7470=>0xe0f3, 0x7473=>0xbabc, 0x7476=>0xe0f6, 0x747e=>0xe0f7, 
	0x7483=>0xcdfe, 0x748b=>0xe0f8, 0x749e=>0xe0f9, 0x74a2=>0xe0e5, 0x74a7=>0xe0fa, 0x74b0=>0xb4c4, 0x74bd=>0xbca5, 0x74ca=>0xe0fb, 0x74cf=>0xe0fc, 0x74d4=>0xe0fd, 0x74dc=>0xb1bb, 0x74e0=>0xe1a1, 0x74e2=>0xc9bb, 0x74e3=>0xe1a2, 0x74e6=>0xb4a4, 0x74e7=>0xe1a3, 
	0x74e9=>0xe1a4, 0x74ee=>0xe1a5, 0x74f0=>0xe1a7, 0x74f1=>0xe1a8, 0x74f2=>0xe1a6, 0x74f6=>0xc9d3, 0x74f7=>0xe1aa, 0x74f8=>0xe1a9, 0x7503=>0xe1ac, 0x7504=>0xe1ab, 0x7505=>0xe1ad, 0x750c=>0xe1ae, 0x750d=>0xe1b0, 0x750e=>0xe1af, 0x7511=>0xb9f9, 0x7513=>0xe1b2, 
	0x7515=>0xe1b1, 0x7518=>0xb4c5, 0x751a=>0xbfd3, 0x751c=>0xc5bc, 0x751e=>0xe1b3, 0x751f=>0xc0b8, 0x7523=>0xbbba, 0x7525=>0xb1f9, 0x7526=>0xe1b4, 0x7528=>0xcdd1, 0x752b=>0xcae3, 0x752c=>0xe1b5, 0x7530=>0xc5c4, 0x7531=>0xcdb3, 0x7532=>0xb9c3, 0x7533=>0xbfbd, 
	0x7537=>0xc3cb, 0x7538=>0xd2b4, 0x753a=>0xc4ae, 0x753b=>0xb2e8, 0x753c=>0xe1b6, 0x7544=>0xe1b7, 0x7546=>0xe1bc, 0x7549=>0xe1ba, 0x754a=>0xe1b9, 0x754b=>0xdac2, 0x754c=>0xb3a6, 0x754d=>0xe1b8, 0x754f=>0xb0da, 0x7551=>0xc8aa, 0x7554=>0xc8ca, 0x7559=>0xceb1, 
	0x755a=>0xe1bd, 0x755b=>0xe1bb, 0x755c=>0xc3dc, 0x755d=>0xc0a6, 0x7560=>0xc8ab, 0x7562=>0xc9ad, 0x7564=>0xe1bf, 0x7565=>0xceac, 0x7566=>0xb7cd, 0x7567=>0xe1c0, 0x7569=>0xe1be, 0x756a=>0xc8d6, 0x756b=>0xe1c1, 0x756d=>0xe1c2, 0x7570=>0xb0db, 0x7573=>0xbef6, 
	0x7574=>0xe1c7, 0x7576=>0xe1c4, 0x7577=>0xc6ed, 0x7578=>0xe1c3, 0x757f=>0xb5a6, 0x7582=>0xe1ca, 0x7586=>0xe1c5, 0x7587=>0xe1c6, 0x7589=>0xe1c9, 0x758a=>0xe1c8, 0x758b=>0xc9a5, 0x758e=>0xc1c2, 0x758f=>0xc1c1, 0x7591=>0xb5bf, 0x7594=>0xe1cb, 0x759a=>0xe1cc, 
	0x759d=>0xe1cd, 0x75a3=>0xe1cf, 0x75a5=>0xe1ce, 0x75ab=>0xb1d6, 0x75b1=>0xe1d7, 0x75b2=>0xc8e8, 0x75b3=>0xe1d1, 0x75b5=>0xe1d3, 0x75b8=>0xe1d5, 0x75b9=>0xbfbe, 0x75bc=>0xe1d6, 0x75bd=>0xe1d4, 0x75be=>0xbcc0, 0x75c2=>0xe1d0, 0x75c3=>0xe1d2, 0x75c5=>0xc9c2, 
	0x75c7=>0xbec9, 0x75ca=>0xe1d9, 0x75cd=>0xe1d8, 0x75d2=>0xe1da, 0x75d4=>0xbca6, 0x75d5=>0xbaaf, 0x75d8=>0xc5f7, 0x75d9=>0xe1db, 0x75db=>0xc4cb, 0x75de=>0xe1dd, 0x75e2=>0xcea1, 0x75e3=>0xe1dc, 0x75e9=>0xc1e9, 0x75f0=>0xe1e2, 0x75f2=>0xe1e4, 0x75f3=>0xe1e5, 
	0x75f4=>0xc3d4, 0x75fa=>0xe1e3, 0x75fc=>0xe1e0, 0x75fe=>0xe1de, 0x75ff=>0xe1df, 0x7601=>0xe1e1, 0x7609=>0xe1e8, 0x760b=>0xe1e6, 0x760d=>0xe1e7, 0x761f=>0xe1e9, 0x7620=>0xe1eb, 0x7621=>0xe1ec, 0x7622=>0xe1ed, 0x7624=>0xe1ee, 0x7627=>0xe1ea, 0x7630=>0xe1f0, 
	0x7634=>0xe1ef, 0x763b=>0xe1f1, 0x7642=>0xcec5, 0x7646=>0xe1f4, 0x7647=>0xe1f2, 0x7648=>0xe1f3, 0x764c=>0xb4e2, 0x7652=>0xccfe, 0x7656=>0xcaca, 0x7658=>0xe1f6, 0x765c=>0xe1f5, 0x7661=>0xe1f7, 0x7662=>0xe1f8, 0x7667=>0xe1fc, 0x7668=>0xe1f9, 0x7669=>0xe1fa, 
	0x766a=>0xe1fb, 0x766c=>0xe1fd, 0x7670=>0xe1fe, 0x7672=>0xe2a1, 0x7676=>0xe2a2, 0x7678=>0xe2a3, 0x767a=>0xc8af, 0x767b=>0xc5d0, 0x767c=>0xe2a4, 0x767d=>0xc7f2, 0x767e=>0xc9b4, 0x7680=>0xe2a5, 0x7683=>0xe2a6, 0x7684=>0xc5aa, 0x7686=>0xb3a7, 0x7687=>0xb9c4, 
	0x7688=>0xe2a7, 0x768b=>0xe2a8, 0x768e=>0xe2a9, 0x7690=>0xbba9, 0x7693=>0xe2ab, 0x7696=>0xe2aa, 0x7699=>0xe2ac, 0x769a=>0xe2ad, 0x76ae=>0xc8e9, 0x76b0=>0xe2ae, 0x76b4=>0xe2af, 0x76b7=>0xf3e9, 0x76b8=>0xe2b0, 0x76b9=>0xe2b1, 0x76ba=>0xe2b2, 0x76bf=>0xbbae, 
	0x76c2=>0xe2b3, 0x76c3=>0xc7d6, 0x76c6=>0xcbdf, 0x76c8=>0xb1ce, 0x76ca=>0xb1d7, 0x76cd=>0xe2b4, 0x76d2=>0xe2b6, 0x76d6=>0xe2b5, 0x76d7=>0xc5f0, 0x76db=>0xc0b9, 0x76dc=>0xddb9, 0x76de=>0xe2b7, 0x76df=>0xccc1, 0x76e1=>0xe2b8, 0x76e3=>0xb4c6, 0x76e4=>0xc8d7, 
	0x76e5=>0xe2b9, 0x76e7=>0xe2ba, 0x76ea=>0xe2bb, 0x76ee=>0xccdc, 0x76f2=>0xccd5, 0x76f4=>0xc4be, 0x76f8=>0xc1ea, 0x76fb=>0xe2bd, 0x76fe=>0xbde2, 0x7701=>0xbeca, 0x7704=>0xe2c0, 0x7707=>0xe2bf, 0x7708=>0xe2be, 0x7709=>0xc8fd, 0x770b=>0xb4c7, 0x770c=>0xb8a9, 
	0x771b=>0xe2c6, 0x771e=>0xe2c3, 0x771f=>0xbfbf, 0x7720=>0xccb2, 0x7724=>0xe2c2, 0x7725=>0xe2c4, 0x7726=>0xe2c5, 0x7729=>0xe2c1, 0x7737=>0xe2c7, 0x7738=>0xe2c8, 0x773a=>0xc4af, 0x773c=>0xb4e3, 0x7740=>0xc3e5, 0x7747=>0xe2c9, 0x775a=>0xe2ca, 0x775b=>0xe2cd, 
	0x7761=>0xbfe7, 0x7763=>0xc6c4, 0x7765=>0xe2ce, 0x7766=>0xcbd3, 0x7768=>0xe2cb, 0x776b=>0xe2cc, 0x7779=>0xe2d1, 0x777e=>0xe2d0, 0x777f=>0xe2cf, 0x778b=>0xe2d3, 0x778e=>0xe2d2, 0x7791=>0xe2d4, 0x779e=>0xe2d6, 0x77a0=>0xe2d5, 0x77a5=>0xcacd, 0x77ac=>0xbdd6, 
	0x77ad=>0xcec6, 0x77b0=>0xe2d7, 0x77b3=>0xc6b7, 0x77b6=>0xe2d8, 0x77b9=>0xe2d9, 0x77bb=>0xe2dd, 0x77bc=>0xe2db, 0x77bd=>0xe2dc, 0x77bf=>0xe2da, 0x77c7=>0xe2de, 0x77cd=>0xe2df, 0x77d7=>0xe2e0, 0x77da=>0xe2e1, 0x77db=>0xccb7, 0x77dc=>0xe2e2, 0x77e2=>0xccf0, 
	0x77e3=>0xe2e3, 0x77e5=>0xc3ce, 0x77e7=>0xc7ea, 0x77e9=>0xb6eb, 0x77ed=>0xc3bb, 0x77ee=>0xe2e4, 0x77ef=>0xb6ba, 0x77f3=>0xc0d0, 0x77fc=>0xe2e5, 0x7802=>0xbabd, 0x780c=>0xe2e6, 0x7812=>0xe2e7, 0x7814=>0xb8a6, 0x7815=>0xbad5, 0x7820=>0xe2e9, 0x7825=>0xc5d6, 
	0x7826=>0xbad6, 0x7827=>0xb5ce, 0x7832=>0xcba4, 0x7834=>0xc7cb, 0x783a=>0xc5d7, 0x783f=>0xb9dc, 0x7845=>0xe2eb, 0x785d=>0xbecb, 0x786b=>0xceb2, 0x786c=>0xb9c5, 0x786f=>0xb8a7, 0x7872=>0xc8a3, 0x7874=>0xe2ed, 0x787c=>0xe2ef, 0x7881=>0xb8eb, 0x7886=>0xe2ee, 
	0x7887=>0xc4f6, 0x788c=>0xe2f1, 0x788d=>0xb3b7, 0x788e=>0xe2ec, 0x7891=>0xc8ea, 0x7893=>0xb1b0, 0x7895=>0xbaec, 0x7897=>0xcfd2, 0x789a=>0xe2f0, 0x78a3=>0xe2f2, 0x78a7=>0xcacb, 0x78a9=>0xc0d9, 0x78aa=>0xe2f4, 0x78af=>0xe2f5, 0x78b5=>0xe2f3, 0x78ba=>0xb3ce, 
	0x78bc=>0xe2fb, 0x78be=>0xe2fa, 0x78c1=>0xbca7, 0x78c5=>0xe2fc, 0x78c6=>0xe2f7, 0x78ca=>0xe2fd, 0x78cb=>0xe2f8, 0x78d0=>0xc8d8, 0x78d1=>0xe2f6, 0x78d4=>0xe2f9, 0x78da=>0xe3a2, 0x78e7=>0xe3a1, 0x78e8=>0xcbe1, 0x78ec=>0xe2fe, 0x78ef=>0xb0eb, 0x78f4=>0xe3a4, 
	0x78fd=>0xe3a3, 0x7901=>0xbecc, 0x7907=>0xe3a5, 0x790e=>0xc1c3, 0x7911=>0xe3a7, 0x7912=>0xe3a6, 0x7919=>0xe3a8, 0x7926=>0xe2e8, 0x792a=>0xe2ea, 0x792b=>0xe3aa, 0x792c=>0xe3a9, 0x793a=>0xbca8, 0x793c=>0xcee9, 0x793e=>0xbcd2, 0x7940=>0xe3ab, 0x7941=>0xb7b7, 
	0x7947=>0xb5c0, 0x7948=>0xb5a7, 0x7949=>0xbbe3, 0x7950=>0xcdb4, 0x7953=>0xe3b1, 0x7955=>0xe3b0, 0x7956=>0xc1c4, 0x7957=>0xe3ad, 0x795a=>0xe3af, 0x795d=>0xbdcb, 0x795e=>0xbfc0, 0x795f=>0xe3ae, 0x7960=>0xe3ac, 0x7962=>0xc7aa, 0x7965=>0xbecd, 0x7968=>0xc9bc, 
	0x796d=>0xbad7, 0x7977=>0xc5f8, 0x797a=>0xe3b2, 0x797f=>0xe3b3, 0x7980=>0xe3c9, 0x7981=>0xb6d8, 0x7984=>0xcfbd, 0x7985=>0xc1b5, 0x798a=>0xe3b4, 0x798d=>0xb2d2, 0x798e=>0xc4f7, 0x798f=>0xcaa1, 0x799d=>0xe3b5, 0x79a6=>0xb5fa, 0x79a7=>0xe3b6, 0x79aa=>0xe3b8, 
	0x79ae=>0xe3b9, 0x79b0=>0xc7a9, 0x79b3=>0xe3ba, 0x79b9=>0xe3bb, 0x79ba=>0xe3bc, 0x79bd=>0xb6d9, 0x79be=>0xb2d3, 0x79bf=>0xc6c5, 0x79c0=>0xbda8, 0x79c1=>0xbbe4, 0x79c9=>0xe3bd, 0x79cb=>0xbda9, 0x79d1=>0xb2ca, 0x79d2=>0xc9c3, 0x79d5=>0xe3be, 0x79d8=>0xc8eb, 
	0x79df=>0xc1c5, 0x79e1=>0xe3c1, 0x79e3=>0xe3c2, 0x79e4=>0xc7e9, 0x79e6=>0xbfc1, 0x79e7=>0xe3bf, 0x79e9=>0xc3e1, 0x79ec=>0xe3c0, 0x79f0=>0xbece, 0x79fb=>0xb0dc, 0x7a00=>0xb5a9, 0x7a08=>0xe3c3, 0x7a0b=>0xc4f8, 0x7a0d=>0xe3c4, 0x7a0e=>0xc0c7, 0x7a14=>0xccad, 
	0x7a17=>0xc9a3, 0x7a18=>0xe3c5, 0x7a19=>0xe3c6, 0x7a1a=>0xc3d5, 0x7a1c=>0xcec7, 0x7a1f=>0xe3c8, 0x7a20=>0xe3c7, 0x7a2e=>0xbcef, 0x7a31=>0xe3ca, 0x7a32=>0xb0f0, 0x7a37=>0xe3cd, 0x7a3b=>0xe3cb, 0x7a3c=>0xb2d4, 0x7a3d=>0xb7ce, 0x7a3e=>0xe3cc, 0x7a3f=>0xb9c6, 
	0x7a40=>0xb9f2, 0x7a42=>0xcae6, 0x7a43=>0xe3ce, 0x7a46=>0xcbd4, 0x7a49=>0xe3d0, 0x7a4d=>0xc0d1, 0x7a4e=>0xb1cf, 0x7a4f=>0xb2ba, 0x7a50=>0xb0ac, 0x7a57=>0xe3cf, 0x7a61=>0xe3d1, 0x7a62=>0xe3d2, 0x7a63=>0xbef7, 0x7a69=>0xe3d3, 0x7a6b=>0xb3cf, 0x7a70=>0xe3d5, 
	0x7a74=>0xb7ea, 0x7a76=>0xb5e6, 0x7a79=>0xe3d6, 0x7a7a=>0xb6f5, 0x7a7d=>0xe3d7, 0x7a7f=>0xc0fc, 0x7a81=>0xc6cd, 0x7a83=>0xc0e0, 0x7a84=>0xbaf5, 0x7a88=>0xe3d8, 0x7a92=>0xc3e2, 0x7a93=>0xc1eb, 0x7a95=>0xe3da, 0x7a96=>0xe3dc, 0x7a97=>0xe3d9, 0x7a98=>0xe3db, 
	0x7a9f=>0xb7a2, 0x7aa9=>0xe3dd, 0x7aaa=>0xb7a6, 0x7aae=>0xb5e7, 0x7aaf=>0xcdd2, 0x7ab0=>0xe3df, 0x7ab6=>0xe3e0, 0x7aba=>0xb1ae, 0x7abf=>0xe3e3, 0x7ac3=>0xb3f6, 0x7ac4=>0xe3e2, 0x7ac5=>0xe3e1, 0x7ac7=>0xe3e5, 0x7ac8=>0xe3de, 0x7aca=>0xe3e6, 0x7acb=>0xcea9, 
	0x7acd=>0xe3e7, 0x7acf=>0xe3e8, 0x7ad2=>0xd4f4, 0x7ad3=>0xe3ea, 0x7ad5=>0xe3e9, 0x7ad9=>0xe3eb, 0x7ada=>0xe3ec, 0x7adc=>0xceb5, 0x7add=>0xe3ed, 0x7adf=>0xf0ef, 0x7ae0=>0xbecf, 0x7ae1=>0xe3ee, 0x7ae2=>0xe3ef, 0x7ae3=>0xbdd7, 0x7ae5=>0xc6b8, 0x7ae6=>0xe3f0, 
	0x7aea=>0xc3a8, 0x7aed=>0xe3f1, 0x7aef=>0xc3bc, 0x7af0=>0xe3f2, 0x7af6=>0xb6a5, 0x7af8=>0xd1bf, 0x7af9=>0xc3dd, 0x7afa=>0xbcb3, 0x7aff=>0xb4c8, 0x7b02=>0xe3f3, 0x7b04=>0xe4a2, 0x7b06=>0xe3f6, 0x7b08=>0xb5e8, 0x7b0a=>0xe3f5, 0x7b0b=>0xe4a4, 0x7b0f=>0xe3f4, 
	0x7b11=>0xbed0, 0x7b18=>0xe3f8, 0x7b19=>0xe3f9, 0x7b1b=>0xc5ab, 0x7b1e=>0xe3fa, 0x7b20=>0xb3de, 0x7b25=>0xbfda, 0x7b26=>0xc9e4, 0x7b28=>0xe3fc, 0x7b2c=>0xc2e8, 0x7b33=>0xe3f7, 0x7b35=>0xe3fb, 0x7b36=>0xe3fd, 0x7b39=>0xbafb, 0x7b45=>0xe4a6, 0x7b46=>0xc9ae, 
	0x7b48=>0xc8a6, 0x7b49=>0xc5f9, 0x7b4b=>0xb6da, 0x7b4c=>0xe4a5, 0x7b4d=>0xe4a3, 0x7b4f=>0xc8b5, 0x7b50=>0xe3fe, 0x7b51=>0xc3de, 0x7b52=>0xc5fb, 0x7b54=>0xc5fa, 0x7b56=>0xbaf6, 0x7b5d=>0xe4b8, 0x7b65=>0xe4a8, 0x7b67=>0xe4aa, 0x7b6c=>0xe4ad, 0x7b6e=>0xe4ae, 
	0x7b70=>0xe4ab, 0x7b71=>0xe4ac, 0x7b74=>0xe4a9, 0x7b75=>0xe4a7, 0x7b7a=>0xe4a1, 0x7b86=>0xcacf, 0x7b87=>0xb2d5, 0x7b8b=>0xe4b5, 0x7b8d=>0xe4b2, 0x7b8f=>0xe4b7, 0x7b92=>0xe4b6, 0x7b94=>0xc7f3, 0x7b95=>0xcca7, 0x7b97=>0xbbbb, 0x7b98=>0xe4b0, 0x7b99=>0xe4b9, 
	0x7b9a=>0xe4b4, 0x7b9c=>0xe4b3, 0x7b9d=>0xe4af, 0x7b9f=>0xe4b1, 0x7ba1=>0xb4c9, 0x7baa=>0xc3bd, 0x7bad=>0xc0fd, 0x7bb1=>0xc8a2, 0x7bb4=>0xe4be, 0x7bb8=>0xc8a4, 0x7bc0=>0xc0e1, 0x7bc1=>0xe4bb, 0x7bc4=>0xc8cf, 0x7bc6=>0xe4bf, 0x7bc7=>0xcad3, 0x7bc9=>0xc3db, 
	0x7bcb=>0xe4ba, 0x7bcc=>0xe4bc, 0x7bcf=>0xe4bd, 0x7bdd=>0xe4c0, 0x7be0=>0xbcc4, 0x7be4=>0xc6c6, 0x7be5=>0xe4c5, 0x7be6=>0xe4c4, 0x7be9=>0xe4c1, 0x7bed=>0xcfb6, 0x7bf3=>0xe4ca, 0x7bf6=>0xe4ce, 0x7bf7=>0xe4cb, 0x7c00=>0xe4c7, 0x7c07=>0xe4c8, 0x7c0d=>0xe4cd, 
	0x7c11=>0xe4c2, 0x7c12=>0xd2d5, 0x7c13=>0xe4c9, 0x7c14=>0xe4c3, 0x7c17=>0xe4cc, 0x7c1f=>0xe4d2, 0x7c21=>0xb4ca, 0x7c23=>0xe4cf, 0x7c27=>0xe4d0, 0x7c2a=>0xe4d1, 0x7c2b=>0xe4d4, 0x7c37=>0xe4d3, 0x7c38=>0xc8f6, 0x7c3d=>0xe4d5, 0x7c3e=>0xcefc, 0x7c3f=>0xcaed, 
	0x7c40=>0xe4da, 0x7c43=>0xe4d7, 0x7c4c=>0xe4d6, 0x7c4d=>0xc0d2, 0x7c4f=>0xe4d9, 0x7c50=>0xe4db, 0x7c54=>0xe4d8, 0x7c56=>0xe4df, 0x7c58=>0xe4dc, 0x7c5f=>0xe4dd, 0x7c60=>0xe4c6, 0x7c64=>0xe4de, 0x7c65=>0xe4e0, 0x7c6c=>0xe4e1, 0x7c73=>0xcac6, 0x7c75=>0xe4e2, 
	0x7c7e=>0xcce2, 0x7c81=>0xb6ce, 0x7c82=>0xb7a9, 0x7c83=>0xe4e3, 0x7c89=>0xcab4, 0x7c8b=>0xbfe8, 0x7c8d=>0xccb0, 0x7c90=>0xe4e4, 0x7c92=>0xceb3, 0x7c95=>0xc7f4, 0x7c97=>0xc1c6, 0x7c98=>0xc7b4, 0x7c9b=>0xbdcd, 0x7c9f=>0xb0c0, 0x7ca1=>0xe4e9, 0x7ca2=>0xe4e7, 
	0x7ca4=>0xe4e5, 0x7ca5=>0xb4a1, 0x7ca7=>0xbed1, 0x7ca8=>0xe4ea, 0x7cab=>0xe4e8, 0x7cad=>0xe4e6, 0x7cae=>0xe4ee, 0x7cb1=>0xe4ed, 0x7cb2=>0xe4ec, 0x7cb3=>0xe4eb, 0x7cb9=>0xe4ef, 0x7cbd=>0xe4f0, 0x7cbe=>0xc0ba, 0x7cc0=>0xe4f1, 0x7cc2=>0xe4f3, 0x7cc5=>0xe4f2, 
	0x7cca=>0xb8d2, 0x7cce=>0xc1b8, 0x7cd2=>0xe4f5, 0x7cd6=>0xc5fc, 0x7cd8=>0xe4f4, 0x7cdc=>0xe4f6, 0x7cde=>0xcab5, 0x7cdf=>0xc1ec, 0x7ce0=>0xb9c7, 0x7ce2=>0xe4f7, 0x7ce7=>0xcec8, 0x7cef=>0xe4f9, 0x7cf2=>0xe4fa, 0x7cf4=>0xe4fb, 0x7cf6=>0xe4fc, 0x7cf8=>0xbbe5, 
	0x7cfa=>0xe4fd, 0x7cfb=>0xb7cf, 0x7cfe=>0xb5ea, 0x7d00=>0xb5aa, 0x7d02=>0xe5a1, 0x7d04=>0xccf3, 0x7d05=>0xb9c8, 0x7d06=>0xe4fe, 0x7d0a=>0xe5a4, 0x7d0b=>0xcce6, 0x7d0d=>0xc7bc, 0x7d10=>0xc9b3, 0x7d14=>0xbde3, 0x7d15=>0xe5a3, 0x7d17=>0xbcd3, 0x7d18=>0xb9c9, 
	0x7d19=>0xbbe6, 0x7d1a=>0xb5e9, 0x7d1b=>0xcab6, 0x7d1c=>0xe5a2, 0x7d20=>0xc1c7, 0x7d21=>0xcbc2, 0x7d22=>0xbaf7, 0x7d2b=>0xbbe7, 0x7d2c=>0xc4dd, 0x7d2e=>0xe5a7, 0x7d2f=>0xcedf, 0x7d30=>0xbad9, 0x7d32=>0xe5a8, 0x7d33=>0xbfc2, 0x7d35=>0xe5aa, 0x7d39=>0xbed2, 
	0x7d3a=>0xbab0, 0x7d3f=>0xe5a9, 0x7d42=>0xbdaa, 0x7d43=>0xb8be, 0x7d44=>0xc1c8, 0x7d45=>0xe5a5, 0x7d46=>0xe5ab, 0x7d4b=>0xe5a6, 0x7d4c=>0xb7d0, 0x7d4e=>0xe5ae, 0x7d4f=>0xe5b2, 0x7d50=>0xb7eb, 0x7d56=>0xe5ad, 0x7d5b=>0xe5b6, 0x7d5e=>0xb9ca, 0x7d61=>0xcded, 
	0x7d62=>0xb0bc, 0x7d63=>0xe5b3, 0x7d66=>0xb5eb, 0x7d68=>0xe5b0, 0x7d6e=>0xe5b1, 0x7d71=>0xc5fd, 0x7d72=>0xe5af, 0x7d73=>0xe5ac, 0x7d75=>0xb3a8, 0x7d76=>0xc0e4, 0x7d79=>0xb8a8, 0x7d7d=>0xe5b8, 0x7d89=>0xe5b5, 0x7d8f=>0xe5b7, 0x7d93=>0xe5b4, 0x7d99=>0xb7d1, 
	0x7d9a=>0xc2b3, 0x7d9b=>0xe5b9, 0x7d9c=>0xc1ee, 0x7d9f=>0xe5c6, 0x7da2=>0xe5c2, 0x7da3=>0xe5bc, 0x7dab=>0xe5c0, 0x7dac=>0xbcfa, 0x7dad=>0xb0dd, 0x7dae=>0xe5bb, 0x7daf=>0xe5c3, 0x7db0=>0xe5c7, 0x7db1=>0xb9cb, 0x7db2=>0xccd6, 0x7db4=>0xc4d6, 0x7db5=>0xe5bd, 
	0x7db8=>0xe5c5, 0x7dba=>0xe5ba, 0x7dbb=>0xc3be, 0x7dbd=>0xe5bf, 0x7dbe=>0xb0bd, 0x7dbf=>0xccca, 0x7dc7=>0xe5be, 0x7dca=>0xb6db, 0x7dcb=>0xc8ec, 0x7dcf=>0xc1ed, 0x7dd1=>0xced0, 0x7dd2=>0xbdef, 0x7dd5=>0xe5ee, 0x7dd8=>0xe5c8, 0x7dda=>0xc0fe, 0x7ddc=>0xe5c4, 
	0x7ddd=>0xe5c9, 0x7dde=>0xe5cb, 0x7de0=>0xc4f9, 0x7de1=>0xe5ce, 0x7de4=>0xe5ca, 0x7de8=>0xcad4, 0x7de9=>0xb4cb, 0x7dec=>0xcccb, 0x7def=>0xb0de, 0x7df2=>0xe5cd, 0x7df4=>0xcefd, 0x7dfb=>0xe5cc, 0x7e01=>0xb1ef, 0x7e04=>0xc6ec, 0x7e05=>0xe5cf, 0x7e09=>0xe5d6, 
	0x7e0a=>0xe5d0, 0x7e0b=>0xe5d7, 0x7e12=>0xe5d3, 0x7e1b=>0xc7fb, 0x7e1e=>0xbcca, 0x7e1f=>0xe5d5, 0x7e21=>0xe5d2, 0x7e22=>0xe5d8, 0x7e23=>0xe5d1, 0x7e26=>0xbdc4, 0x7e2b=>0xcba5, 0x7e2e=>0xbdcc, 0x7e31=>0xe5d4, 0x7e32=>0xe5e0, 0x7e35=>0xe5dc, 0x7e37=>0xe5df, 
	0x7e39=>0xe5dd, 0x7e3a=>0xe5e1, 0x7e3b=>0xe5db, 0x7e3d=>0xe5c1, 0x7e3e=>0xc0d3, 0x7e41=>0xc8cb, 0x7e43=>0xe5de, 0x7e46=>0xe5d9, 0x7e4a=>0xc1a1, 0x7e4b=>0xb7d2, 0x7e4d=>0xbdab, 0x7e54=>0xbfa5, 0x7e55=>0xc1b6, 0x7e56=>0xe5e4, 0x7e59=>0xe5e6, 0x7e5a=>0xe5e7, 
	0x7e5d=>0xe5e3, 0x7e5e=>0xe5e5, 0x7e66=>0xe5da, 0x7e67=>0xe5e2, 0x7e69=>0xe5ea, 0x7e6a=>0xe5e9, 0x7e6d=>0xcbfa, 0x7e70=>0xb7ab, 0x7e79=>0xe5e8, 0x7e7b=>0xe5ec, 0x7e7c=>0xe5eb, 0x7e7d=>0xe5ef, 0x7e7f=>0xe5f1, 0x7e82=>0xbbbc, 0x7e83=>0xe5ed, 0x7e88=>0xe5f2, 
	0x7e89=>0xe5f3, 0x7e8c=>0xe5f4, 0x7e8e=>0xe5fa, 0x7e8f=>0xc5bb, 0x7e90=>0xe5f6, 0x7e92=>0xe5f5, 0x7e93=>0xe5f7, 0x7e94=>0xe5f8, 0x7e96=>0xe5f9, 0x7e9b=>0xe5fb, 0x7e9c=>0xe5fc, 0x7f36=>0xb4cc, 0x7f38=>0xe5fd, 0x7f3a=>0xe5fe, 0x7f45=>0xe6a1, 0x7f4c=>0xe6a2, 
	0x7f4d=>0xe6a3, 0x7f4e=>0xe6a4, 0x7f50=>0xe6a5, 0x7f51=>0xe6a6, 0x7f54=>0xe6a8, 0x7f55=>0xe6a7, 0x7f58=>0xe6a9, 0x7f5f=>0xe6aa, 0x7f60=>0xe6ab, 0x7f67=>0xe6ae, 0x7f68=>0xe6ac, 0x7f69=>0xe6ad, 0x7f6a=>0xbae1, 0x7f6b=>0xb7d3, 0x7f6e=>0xc3d6, 0x7f70=>0xc8b3, 
	0x7f72=>0xbdf0, 0x7f75=>0xc7cd, 0x7f77=>0xc8ed, 0x7f78=>0xe6af, 0x7f79=>0xd8ed, 0x7f82=>0xe6b0, 0x7f83=>0xe6b2, 0x7f85=>0xcde5, 0x7f86=>0xe6b1, 0x7f87=>0xe6b4, 0x7f88=>0xe6b3, 0x7f8a=>0xcdd3, 0x7f8c=>0xe6b5, 0x7f8e=>0xc8fe, 0x7f94=>0xe6b6, 0x7f9a=>0xe6b9, 
	0x7f9d=>0xe6b8, 0x7f9e=>0xe6b7, 0x7fa3=>0xe6ba, 0x7fa4=>0xb7b2, 0x7fa8=>0xc1a2, 0x7fa9=>0xb5c1, 0x7fae=>0xe6be, 0x7faf=>0xe6bb, 0x7fb2=>0xe6bc, 0x7fb6=>0xe6bf, 0x7fb8=>0xe6c0, 0x7fb9=>0xe6bd, 0x7fbd=>0xb1a9, 0x7fc1=>0xb2a7, 0x7fc5=>0xe6c2, 0x7fc6=>0xe6c3, 
	0x7fca=>0xe6c4, 0x7fcc=>0xcde2, 0x7fd2=>0xbdac, 0x7fd4=>0xe6c6, 0x7fd5=>0xe6c5, 0x7fe0=>0xbfe9, 0x7fe1=>0xe6c7, 0x7fe6=>0xe6c8, 0x7fe9=>0xe6c9, 0x7feb=>0xb4e5, 0x7ff0=>0xb4cd, 0x7ff3=>0xe6ca, 0x7ff9=>0xe6cb, 0x7ffb=>0xcbdd, 0x7ffc=>0xcde3, 0x8000=>0xcdd4, 
	0x8001=>0xcfb7, 0x8003=>0xb9cd, 0x8004=>0xe6ce, 0x8005=>0xbcd4, 0x8006=>0xe6cd, 0x800b=>0xe6cf, 0x800c=>0xbca9, 0x8010=>0xc2d1, 0x8012=>0xe6d0, 0x8015=>0xb9cc, 0x8017=>0xccd7, 0x8018=>0xe6d1, 0x8019=>0xe6d2, 0x801c=>0xe6d3, 0x8021=>0xe6d4, 0x8028=>0xe6d5, 
	0x8033=>0xbcaa, 0x8036=>0xcced, 0x803b=>0xe6d7, 0x803d=>0xc3bf, 0x803f=>0xe6d6, 0x8046=>0xe6d9, 0x804a=>0xe6d8, 0x8052=>0xe6da, 0x8056=>0xc0bb, 0x8058=>0xe6db, 0x805a=>0xe6dc, 0x805e=>0xcab9, 0x805f=>0xe6dd, 0x8061=>0xc1ef, 0x8062=>0xe6de, 0x8068=>0xe6df, 
	0x806f=>0xcefe, 0x8070=>0xe6e2, 0x8072=>0xe6e1, 0x8073=>0xe6e0, 0x8074=>0xc4b0, 0x8076=>0xe6e3, 0x8077=>0xbfa6, 0x8079=>0xe6e4, 0x807d=>0xe6e5, 0x807e=>0xcfb8, 0x807f=>0xe6e6, 0x8084=>0xe6e7, 0x8085=>0xe6e9, 0x8086=>0xe6e8, 0x8087=>0xc8a5, 0x8089=>0xc6f9, 
	0x808b=>0xcfbe, 0x808c=>0xc8a9, 0x8093=>0xe6eb, 0x8096=>0xbed3, 0x8098=>0xc9aa, 0x809a=>0xe6ec, 0x809b=>0xe6ea, 0x809d=>0xb4ce, 0x80a1=>0xb8d4, 0x80a2=>0xbbe8, 0x80a5=>0xc8ee, 0x80a9=>0xb8aa, 0x80aa=>0xcbc3, 0x80ac=>0xe6ef, 0x80ad=>0xe6ed, 0x80af=>0xb9ce, 
	0x80b1=>0xb9cf, 0x80b2=>0xb0e9, 0x80b4=>0xbae8, 0x80ba=>0xc7d9, 0x80c3=>0xb0df, 0x80c4=>0xe6f4, 0x80c6=>0xc3c0, 0x80cc=>0xc7d8, 0x80ce=>0xc2db, 0x80d6=>0xe6f6, 0x80d9=>0xe6f2, 0x80da=>0xe6f5, 0x80db=>0xe6f0, 0x80dd=>0xe6f3, 0x80de=>0xcba6, 0x80e1=>0xb8d5, 
	0x80e4=>0xb0fd, 0x80e5=>0xe6f1, 0x80ef=>0xe6f8, 0x80f1=>0xe6f9, 0x80f4=>0xc6b9, 0x80f8=>0xb6bb, 0x80fc=>0xe7a6, 0x80fd=>0xc7bd, 0x8102=>0xbbe9, 0x8105=>0xb6bc, 0x8106=>0xc0c8, 0x8107=>0xcfc6, 0x8108=>0xccae, 0x8109=>0xe6f7, 0x810a=>0xc0d4, 0x811a=>0xb5d3, 
	0x811b=>0xe6fa, 0x8123=>0xe6fc, 0x8129=>0xe6fb, 0x812f=>0xe6fd, 0x8131=>0xc3a6, 0x8133=>0xc7be, 0x8139=>0xc4b1, 0x813e=>0xe7a3, 0x8146=>0xe7a2, 0x814b=>0xe6fe, 0x814e=>0xbfd5, 0x8150=>0xc9e5, 0x8151=>0xe7a5, 0x8153=>0xe7a4, 0x8154=>0xb9d0, 0x8155=>0xcfd3, 
	0x815f=>0xe7b5, 0x8165=>0xe7a9, 0x8166=>0xe7aa, 0x816b=>0xbcf0, 0x816e=>0xe7a8, 0x8170=>0xb9f8, 0x8171=>0xe7a7, 0x8174=>0xe7ab, 0x8178=>0xc4b2, 0x8179=>0xcaa2, 0x817a=>0xc1a3, 0x817f=>0xc2dc, 0x8180=>0xe7af, 0x8182=>0xe7b0, 0x8183=>0xe7ac, 0x8188=>0xe7ad, 
	0x818a=>0xe7ae, 0x818f=>0xb9d1, 0x8193=>0xe7b6, 0x8195=>0xe7b2, 0x819a=>0xc9e6, 0x819c=>0xcbec, 0x819d=>0xc9a8, 0x81a0=>0xe7b1, 0x81a3=>0xe7b4, 0x81a4=>0xe7b3, 0x81a8=>0xcbc4, 0x81a9=>0xe7b7, 0x81b0=>0xe7b8, 0x81b3=>0xc1b7, 0x81b5=>0xe7b9, 0x81b8=>0xe7bb, 
	0x81ba=>0xe7bf, 0x81bd=>0xe7bc, 0x81be=>0xe7ba, 0x81bf=>0xc7bf, 0x81c0=>0xe7bd, 0x81c2=>0xe7be, 0x81c6=>0xb2b2, 0x81c8=>0xe7c5, 0x81c9=>0xe7c0, 0x81cd=>0xe7c1, 0x81d1=>0xe7c2, 0x81d3=>0xc2a1, 0x81d8=>0xe7c4, 0x81d9=>0xe7c3, 0x81da=>0xe7c6, 0x81df=>0xe7c7, 
	0x81e0=>0xe7c8, 0x81e3=>0xbfc3, 0x81e5=>0xb2e9, 0x81e7=>0xe7c9, 0x81e8=>0xced7, 0x81ea=>0xbcab, 0x81ed=>0xbdad, 0x81f3=>0xbbea, 0x81f4=>0xc3d7, 0x81fa=>0xe7ca, 0x81fb=>0xe7cb, 0x81fc=>0xb1b1, 0x81fe=>0xe7cc, 0x8201=>0xe7cd, 0x8202=>0xe7ce, 0x8205=>0xe7cf, 
	0x8207=>0xe7d0, 0x8208=>0xb6bd, 0x8209=>0xdaaa, 0x820a=>0xe7d1, 0x820c=>0xc0e5, 0x820d=>0xe7d2, 0x820e=>0xbccb, 0x8210=>0xe7d3, 0x8212=>0xd0b0, 0x8216=>0xe7d4, 0x8217=>0xcade, 0x8218=>0xb4dc, 0x821b=>0xc1a4, 0x821c=>0xbdd8, 0x821e=>0xc9f1, 0x821f=>0xbdae, 
	0x8229=>0xe7d5, 0x822a=>0xb9d2, 0x822b=>0xe7d6, 0x822c=>0xc8cc, 0x822e=>0xe7e4, 0x8233=>0xe7d8, 0x8235=>0xc2c9, 0x8236=>0xc7f5, 0x8237=>0xb8bf, 0x8238=>0xe7d7, 0x8239=>0xc1a5, 0x8240=>0xe7d9, 0x8247=>0xc4fa, 0x8258=>0xe7db, 0x8259=>0xe7da, 0x825a=>0xe7dd, 
	0x825d=>0xe7dc, 0x825f=>0xe7de, 0x8262=>0xe7e0, 0x8264=>0xe7df, 0x8266=>0xb4cf, 0x8268=>0xe7e1, 0x826a=>0xe7e2, 0x826b=>0xe7e3, 0x826e=>0xbab1, 0x826f=>0xcec9, 0x8271=>0xe7e5, 0x8272=>0xbfa7, 0x8276=>0xb1f0, 0x8277=>0xe7e6, 0x8278=>0xe7e7, 0x827e=>0xe7e8, 
	0x828b=>0xb0f2, 0x828d=>0xe7e9, 0x8292=>0xe7ea, 0x8299=>0xc9e7, 0x829d=>0xbcc7, 0x829f=>0xe7ec, 0x82a5=>0xb3a9, 0x82a6=>0xb0b2, 0x82ab=>0xe7eb, 0x82ac=>0xe7ee, 0x82ad=>0xc7ce, 0x82af=>0xbfc4, 0x82b1=>0xb2d6, 0x82b3=>0xcba7, 0x82b8=>0xb7dd, 0x82b9=>0xb6dc, 
	0x82bb=>0xe7ed, 0x82bd=>0xb2ea, 0x82c5=>0xb4a3, 0x82d1=>0xb1f1, 0x82d2=>0xe7f2, 0x82d3=>0xceea, 0x82d4=>0xc2dd, 0x82d7=>0xc9c4, 0x82d9=>0xe7fe, 0x82db=>0xb2d7, 0x82dc=>0xe7fc, 0x82de=>0xe7fa, 0x82df=>0xe7f1, 0x82e1=>0xe7ef, 0x82e3=>0xe7f0, 0x82e5=>0xbce3, 
	0x82e6=>0xb6ec, 0x82e7=>0xc3f7, 0x82eb=>0xc6d1, 0x82f1=>0xb1d1, 0x82f3=>0xe7f4, 0x82f4=>0xe7f3, 0x82f9=>0xe7f9, 0x82fa=>0xe7f5, 0x82fb=>0xe7f8, 0x8302=>0xccd0, 0x8303=>0xe7f7, 0x8304=>0xb2d8, 0x8305=>0xb3fd, 0x8306=>0xe7fb, 0x8309=>0xe7fd, 0x830e=>0xb7d4, 
	0x8316=>0xe8a3, 0x8317=>0xe8ac, 0x8318=>0xe8ad, 0x831c=>0xb0ab, 0x8323=>0xe8b4, 0x8328=>0xb0f1, 0x832b=>0xe8ab, 0x832f=>0xe8aa, 0x8331=>0xe8a5, 0x8332=>0xe8a4, 0x8334=>0xe8a2, 0x8335=>0xe8a1, 0x8336=>0xc3e3, 0x8338=>0xc2fb, 0x8339=>0xe8a7, 0x8340=>0xe8a6, 
	0x8345=>0xe8a9, 0x8349=>0xc1f0, 0x834a=>0xb7d5, 0x834f=>0xb1c1, 0x8350=>0xe8a8, 0x8352=>0xb9d3, 0x8358=>0xc1f1, 0x8373=>0xe8ba, 0x8375=>0xe8bb, 0x8377=>0xb2d9, 0x837b=>0xb2ae, 0x837c=>0xe8b8, 0x8385=>0xe8ae, 0x8387=>0xe8b6, 0x8389=>0xe8bd, 0x838a=>0xe8b7, 
	0x838e=>0xe8b5, 0x8393=>0xe7f6, 0x8396=>0xe8b3, 0x839a=>0xe8af, 0x839e=>0xb4d0, 0x839f=>0xe8b1, 0x83a0=>0xe8bc, 0x83a2=>0xe8b2, 0x83a8=>0xe8be, 0x83aa=>0xe8b0, 0x83ab=>0xc7fc, 0x83b1=>0xcde9, 0x83b5=>0xe8b9, 0x83bd=>0xe8cf, 0x83c1=>0xe8c7, 0x83c5=>0xbffb, 
	0x83ca=>0xb5c6, 0x83cc=>0xb6dd, 0x83ce=>0xe8c2, 0x83d3=>0xb2db, 0x83d6=>0xbed4, 0x83d8=>0xe8c5, 0x83dc=>0xbada, 0x83df=>0xc5d1, 0x83e0=>0xe8ca, 0x83e9=>0xcaee, 0x83eb=>0xe8c1, 0x83ef=>0xb2da, 0x83f0=>0xb8d6, 0x83f1=>0xc9a9, 0x83f2=>0xe8cb, 0x83f4=>0xe8bf, 
	0x83f7=>0xe8c8, 0x83fb=>0xe8d2, 0x83fd=>0xe8c3, 0x8403=>0xe8c4, 0x8404=>0xc6ba, 0x8407=>0xe8c9, 0x840b=>0xe8c6, 0x840c=>0xcba8, 0x840d=>0xe8cc, 0x840e=>0xb0e0, 0x8413=>0xe8c0, 0x8420=>0xe8ce, 0x8422=>0xe8cd, 0x8429=>0xc7eb, 0x842a=>0xe8d4, 0x842c=>0xe8df, 
	0x8431=>0xb3fe, 0x8435=>0xe8e2, 0x8438=>0xe8d0, 0x843c=>0xe8d5, 0x843d=>0xcdee, 0x8446=>0xe8de, 0x8449=>0xcdd5, 0x844e=>0xceaa, 0x8457=>0xc3f8, 0x845b=>0xb3eb, 0x8461=>0xc9f2, 0x8462=>0xe8e4, 0x8463=>0xc6a1, 0x8466=>0xb0b1, 0x8469=>0xe8dd, 0x846b=>0xe8d9, 
	0x846c=>0xc1f2, 0x846d=>0xe8d3, 0x846e=>0xe8db, 0x846f=>0xe8e0, 0x8471=>0xc7ac, 0x8475=>0xb0aa, 0x8477=>0xe8d8, 0x8479=>0xe8e1, 0x847a=>0xc9f8, 0x8482=>0xe8dc, 0x8484=>0xe8d7, 0x848b=>0xbed5, 0x8490=>0xbdaf, 0x8494=>0xbcac, 0x8499=>0xccd8, 0x849c=>0xc9c7, 
	0x849f=>0xe8e7, 0x84a1=>0xe8f0, 0x84ad=>0xe8da, 0x84b2=>0xb3f7, 0x84b8=>0xbef8, 0x84b9=>0xe8e5, 0x84bb=>0xe8ea, 0x84bc=>0xc1f3, 0x84bf=>0xe8e6, 0x84c1=>0xe8ed, 0x84c4=>0xc3df, 0x84c6=>0xe8ee, 0x84c9=>0xcdd6, 0x84ca=>0xe8e3, 0x84cb=>0xb3b8, 0x84cd=>0xe8e9, 
	0x84d0=>0xe8ec, 0x84d1=>0xccac, 0x84d6=>0xe8ef, 0x84d9=>0xe8e8, 0x84da=>0xe8eb, 0x84ec=>0xcba9, 0x84ee=>0xcfa1, 0x84f4=>0xe8f3, 0x84fc=>0xe8fa, 0x84ff=>0xe8f2, 0x8500=>0xbcc3, 0x8506=>0xe8d1, 0x8511=>0xcace, 0x8513=>0xcca2, 0x8514=>0xe8f9, 0x8515=>0xe8f8, 
	0x8517=>0xe8f4, 0x8518=>0xe8f5, 0x851a=>0xb1b6, 0x851f=>0xe8f7, 0x8521=>0xe8f1, 0x8526=>0xc4d5, 0x852c=>0xe8f6, 0x852d=>0xb0fe, 0x8535=>0xc2a2, 0x853d=>0xcac3, 0x8540=>0xe8fb, 0x8541=>0xe9a1, 0x8543=>0xc8d9, 0x8548=>0xe8fe, 0x8549=>0xbed6, 0x854a=>0xbcc9, 
	0x854b=>0xe9a3, 0x854e=>0xb6be, 0x8555=>0xe9a4, 0x8557=>0xc9f9, 0x8558=>0xe8fd, 0x855a=>0xe8d6, 0x8563=>0xe8fc, 0x8568=>0xcfcf, 0x8569=>0xc6a2, 0x856a=>0xc9f3, 0x856d=>0xe9ab, 0x8577=>0xe9b1, 0x857e=>0xe9b2, 0x8580=>0xe9a5, 0x8584=>0xc7f6, 0x8587=>0xe9af, 
	0x8588=>0xe9a7, 0x858a=>0xe9a9, 0x8590=>0xe9b3, 0x8591=>0xe9a8, 0x8594=>0xe9ac, 0x8597=>0xb1f2, 0x8599=>0xc6e5, 0x859b=>0xe9ad, 0x859c=>0xe9b0, 0x85a4=>0xe9a6, 0x85a6=>0xc1a6, 0x85a8=>0xe9aa, 0x85a9=>0xbba7, 0x85aa=>0xbfc5, 0x85ab=>0xb7b0, 0x85ac=>0xccf4, 
	0x85ae=>0xccf9, 0x85af=>0xbdf2, 0x85b9=>0xe9b7, 0x85ba=>0xe9b5, 0x85c1=>0xcfce, 0x85c9=>0xe9b4, 0x85cd=>0xcdf5, 0x85cf=>0xe9b6, 0x85d0=>0xe9b8, 0x85d5=>0xe9b9, 0x85dc=>0xe9bc, 0x85dd=>0xe9ba, 0x85e4=>0xc6a3, 0x85e5=>0xe9bb, 0x85e9=>0xc8cd, 0x85ea=>0xe9ae, 
	0x85f7=>0xbdf3, 0x85f9=>0xe9bd, 0x85fa=>0xe9c2, 0x85fb=>0xc1f4, 0x85fe=>0xe9c1, 0x8602=>0xe9a2, 0x8606=>0xe9c3, 0x8607=>0xc1c9, 0x860a=>0xe9be, 0x860b=>0xe9c0, 0x8613=>0xe9bf, 0x8616=>0xddb1, 0x8617=>0xdda2, 0x861a=>0xe9c5, 0x8622=>0xe9c4, 0x862d=>0xcdf6, 
	0x862f=>0xe2bc, 0x8630=>0xe9c6, 0x863f=>0xe9c7, 0x864d=>0xe9c8, 0x864e=>0xb8d7, 0x8650=>0xb5d4, 0x8654=>0xe9ca, 0x8655=>0xd1dd, 0x865a=>0xb5f5, 0x865c=>0xceba, 0x865e=>0xb6f3, 0x865f=>0xe9cb, 0x8667=>0xe9cc, 0x866b=>0xc3ee, 0x8671=>0xe9cd, 0x8679=>0xc6fa, 
	0x867b=>0xb0ba, 0x868a=>0xb2e3, 0x868b=>0xe9d2, 0x868c=>0xe9d3, 0x8693=>0xe9ce, 0x8695=>0xbbbd, 0x86a3=>0xe9cf, 0x86a4=>0xc7c2, 0x86a9=>0xe9d0, 0x86aa=>0xe9d1, 0x86ab=>0xe9db, 0x86af=>0xe9d5, 0x86b0=>0xe9d8, 0x86b6=>0xe9d4, 0x86c4=>0xe9d6, 0x86c6=>0xe9d7, 
	0x86c7=>0xbcd8, 0x86c9=>0xe9d9, 0x86cb=>0xc3c1, 0x86cd=>0xb7d6, 0x86ce=>0xb3c2, 0x86d4=>0xe9dc, 0x86d9=>0xb3bf, 0x86db=>0xe9e1, 0x86de=>0xe9dd, 0x86df=>0xe9e0, 0x86e4=>0xc8ba, 0x86e9=>0xe9de, 0x86ec=>0xe9df, 0x86ed=>0xc9c8, 0x86ee=>0xc8da, 0x86ef=>0xe9e2, 
	0x86f8=>0xc2fd, 0x86f9=>0xe9ec, 0x86fb=>0xe9e8, 0x86fe=>0xb2eb, 0x8700=>0xe9e6, 0x8702=>0xcbaa, 0x8703=>0xe9e7, 0x8706=>0xe9e4, 0x8708=>0xe9e5, 0x8709=>0xe9ea, 0x870a=>0xe9ed, 0x870d=>0xe9eb, 0x8711=>0xe9e9, 0x8712=>0xe9e3, 0x8718=>0xc3d8, 0x871a=>0xe9f4, 
	0x871c=>0xccaa, 0x8725=>0xe9f2, 0x8729=>0xe9f3, 0x8734=>0xe9ee, 0x8737=>0xe9f0, 0x873b=>0xe9f1, 0x873f=>0xe9ef, 0x8749=>0xc0e6, 0x874b=>0xcfb9, 0x874c=>0xe9f8, 0x874e=>0xe9f9, 0x8753=>0xeaa1, 0x8755=>0xbfaa, 0x8757=>0xe9fb, 0x8759=>0xe9fe, 0x875f=>0xe9f6, 
	0x8760=>0xe9f5, 0x8763=>0xeaa2, 0x8766=>0xb2dc, 0x8768=>0xe9fc, 0x876a=>0xeaa3, 0x876e=>0xe9fd, 0x8774=>0xe9fa, 0x8776=>0xc4b3, 0x8778=>0xe9f7, 0x877f=>0xc7e8, 0x8782=>0xeaa7, 0x878d=>0xcdbb, 0x879f=>0xeaa6, 0x87a2=>0xeaa5, 0x87ab=>0xeaae, 0x87af=>0xeaa8, 
	0x87b3=>0xeab0, 0x87ba=>0xcde6, 0x87bb=>0xeab3, 0x87bd=>0xeaaa, 0x87c0=>0xeaab, 0x87c4=>0xeaaf, 0x87c6=>0xeab2, 0x87c7=>0xeab1, 0x87cb=>0xeaa9, 0x87d0=>0xeaac, 0x87d2=>0xeabd, 0x87e0=>0xeab6, 0x87ef=>0xeab4, 0x87f2=>0xeab5, 0x87f6=>0xeaba, 0x87f7=>0xeabb, 
	0x87f9=>0xb3aa, 0x87fb=>0xb5c2, 0x87fe=>0xeab9, 0x8805=>0xeaa4, 0x880d=>0xeab8, 0x880e=>0xeabc, 0x880f=>0xeab7, 0x8811=>0xeabe, 0x8815=>0xeac0, 0x8816=>0xeabf, 0x8821=>0xeac2, 0x8822=>0xeac1, 0x8823=>0xe9da, 0x8827=>0xeac6, 0x8831=>0xeac3, 0x8836=>0xeac4, 
	0x8839=>0xeac5, 0x883b=>0xeac7, 0x8840=>0xb7ec, 0x8842=>0xeac9, 0x8844=>0xeac8, 0x8846=>0xbdb0, 0x884c=>0xb9d4, 0x884d=>0xdea7, 0x8852=>0xeaca, 0x8853=>0xbdd1, 0x8857=>0xb3b9, 0x8859=>0xeacb, 0x885b=>0xb1d2, 0x885d=>0xbed7, 0x885e=>0xeacc, 0x8861=>0xb9d5, 
	0x8862=>0xeacd, 0x8863=>0xb0e1, 0x8868=>0xc9bd, 0x886b=>0xeace, 0x8870=>0xbfea, 0x8872=>0xead5, 0x8875=>0xead2, 0x8877=>0xc3ef, 0x887d=>0xead3, 0x887e=>0xead0, 0x887f=>0xb6de, 0x8881=>0xeacf, 0x8882=>0xead6, 0x8888=>0xb7b6, 0x888b=>0xc2de, 0x888d=>0xeadc, 
	0x8892=>0xead8, 0x8896=>0xc2b5, 0x8897=>0xead7, 0x8899=>0xeada, 0x889e=>0xead1, 0x88a2=>0xeadb, 0x88a4=>0xeadd, 0x88ab=>0xc8ef, 0x88ae=>0xead9, 0x88b0=>0xeade, 0x88b1=>0xeae0, 0x88b4=>0xb8d3, 0x88b5=>0xead4, 0x88b7=>0xb0c1, 0x88bf=>0xeadf, 0x88c1=>0xbadb, 
	0x88c2=>0xcef6, 0x88c3=>0xeae1, 0x88c4=>0xeae2, 0x88c5=>0xc1f5, 0x88cf=>0xcea2, 0x88d4=>0xeae3, 0x88d5=>0xcdb5, 0x88d8=>0xeae4, 0x88d9=>0xeae5, 0x88dc=>0xcae4, 0x88dd=>0xeae6, 0x88df=>0xbac0, 0x88e1=>0xcea3, 0x88e8=>0xeaeb, 0x88f2=>0xeaec, 0x88f3=>0xbed8, 
	0x88f4=>0xeaea, 0x88f8=>0xcde7, 0x88f9=>0xeae7, 0x88fc=>0xeae9, 0x88fd=>0xc0bd, 0x88fe=>0xbffe, 0x8902=>0xeae8, 0x8904=>0xeaed, 0x8907=>0xcaa3, 0x890a=>0xeaef, 0x890c=>0xeaee, 0x8910=>0xb3ec, 0x8912=>0xcbab, 0x8913=>0xeaf0, 0x891d=>0xeafc, 0x891e=>0xeaf2, 
	0x8925=>0xeaf3, 0x892a=>0xeaf4, 0x892b=>0xeaf5, 0x8936=>0xeaf9, 0x8938=>0xeafa, 0x893b=>0xeaf8, 0x8941=>0xeaf6, 0x8943=>0xeaf1, 0x8944=>0xeaf7, 0x894c=>0xeafb, 0x894d=>0xf0b7, 0x8956=>0xb2a8, 0x895e=>0xeafe, 0x895f=>0xb6df, 0x8960=>0xeafd, 0x8964=>0xeba2, 
	0x8966=>0xeba1, 0x896a=>0xeba4, 0x896d=>0xeba3, 0x896f=>0xeba5, 0x8972=>0xbdb1, 0x8974=>0xeba6, 0x8977=>0xeba7, 0x897e=>0xeba8, 0x897f=>0xc0be, 0x8981=>0xcdd7, 0x8983=>0xeba9, 0x8986=>0xcaa4, 0x8987=>0xc7c6, 0x8988=>0xebaa, 0x898a=>0xebab, 0x898b=>0xb8ab, 
	0x898f=>0xb5ac, 0x8993=>0xebac, 0x8996=>0xbbeb, 0x8997=>0xc7c1, 0x8998=>0xebad, 0x899a=>0xb3d0, 0x89a1=>0xebae, 0x89a6=>0xebb0, 0x89a7=>0xcdf7, 0x89a9=>0xebaf, 0x89aa=>0xbfc6, 0x89ac=>0xebb1, 0x89af=>0xebb2, 0x89b2=>0xebb3, 0x89b3=>0xb4d1, 0x89ba=>0xebb4, 
	0x89bd=>0xebb5, 0x89bf=>0xebb6, 0x89c0=>0xebb7, 0x89d2=>0xb3d1, 0x89da=>0xebb8, 0x89dc=>0xebb9, 0x89dd=>0xebba, 0x89e3=>0xb2f2, 0x89e6=>0xbfa8, 0x89e7=>0xebbb, 0x89f4=>0xebbc, 0x89f8=>0xebbd, 0x8a00=>0xb8c0, 0x8a02=>0xc4fb, 0x8a03=>0xebbe, 0x8a08=>0xb7d7, 
	0x8a0a=>0xbfd6, 0x8a0c=>0xebc1, 0x8a0e=>0xc6a4, 0x8a10=>0xebc0, 0x8a13=>0xb7b1, 0x8a16=>0xebbf, 0x8a17=>0xc2f7, 0x8a18=>0xb5ad, 0x8a1b=>0xebc2, 0x8a1d=>0xebc3, 0x8a1f=>0xbed9, 0x8a23=>0xb7ed, 0x8a25=>0xebc4, 0x8a2a=>0xcbac, 0x8a2d=>0xc0df, 0x8a31=>0xb5f6, 
	0x8a33=>0xccf5, 0x8a34=>0xc1ca, 0x8a36=>0xebc5, 0x8a3a=>0xbfc7, 0x8a3b=>0xc3f0, 0x8a3c=>0xbeda, 0x8a41=>0xebc6, 0x8a46=>0xebc9, 0x8a48=>0xebca, 0x8a50=>0xbabe, 0x8a51=>0xc2c2, 0x8a52=>0xebc8, 0x8a54=>0xbedb, 0x8a55=>0xc9be, 0x8a5b=>0xebc7, 0x8a5e=>0xbbec, 
	0x8a60=>0xb1d3, 0x8a62=>0xebce, 0x8a63=>0xb7d8, 0x8a66=>0xbbee, 0x8a69=>0xbbed, 0x8a6b=>0xcfcd, 0x8a6c=>0xebcd, 0x8a6d=>0xebcc, 0x8a6e=>0xc1a7, 0x8a70=>0xb5cd, 0x8a71=>0xcfc3, 0x8a72=>0xb3ba, 0x8a73=>0xbedc, 0x8a7c=>0xebcb, 0x8a82=>0xebd0, 0x8a84=>0xebd1, 
	0x8a85=>0xebcf, 0x8a87=>0xb8d8, 0x8a89=>0xcdc0, 0x8a8c=>0xbbef, 0x8a8d=>0xc7a7, 0x8a91=>0xebd4, 0x8a93=>0xc0c0, 0x8a95=>0xc3c2, 0x8a98=>0xcdb6, 0x8a9a=>0xebd7, 0x8a9e=>0xb8ec, 0x8aa0=>0xc0bf, 0x8aa1=>0xebd3, 0x8aa3=>0xebd8, 0x8aa4=>0xb8ed, 0x8aa5=>0xebd5, 
	0x8aa6=>0xebd6, 0x8aa8=>0xebd2, 0x8aac=>0xc0e2, 0x8aad=>0xc6c9, 0x8ab0=>0xc3af, 0x8ab2=>0xb2dd, 0x8ab9=>0xc8f0, 0x8abc=>0xb5c3, 0x8abf=>0xc4b4, 0x8ac2=>0xebdb, 0x8ac4=>0xebd9, 0x8ac7=>0xc3cc, 0x8acb=>0xc0c1, 0x8acc=>0xb4d2, 0x8acd=>0xebda, 0x8acf=>0xbfdb, 
	0x8ad2=>0xceca, 0x8ad6=>0xcfc0, 0x8ada=>0xebdc, 0x8adb=>0xebe7, 0x8adc=>0xc4b5, 0x8ade=>0xebe6, 0x8ae0=>0xebe3, 0x8ae1=>0xebeb, 0x8ae2=>0xebe4, 0x8ae4=>0xebe0, 0x8ae6=>0xc4fc, 0x8ae7=>0xebdf, 0x8aeb=>0xebdd, 0x8aed=>0xcda1, 0x8aee=>0xbbf0, 0x8af1=>0xebe1, 
	0x8af3=>0xebde, 0x8af7=>0xebe5, 0x8af8=>0xbdf4, 0x8afa=>0xb8c1, 0x8afe=>0xc2fa, 0x8b00=>0xcbc5, 0x8b01=>0xb1da, 0x8b02=>0xb0e2, 0x8b04=>0xc6a5, 0x8b07=>0xebe9, 0x8b0c=>0xebe8, 0x8b0e=>0xc6e6, 0x8b10=>0xebed, 0x8b14=>0xebe2, 0x8b16=>0xebec, 0x8b17=>0xebee, 
	0x8b19=>0xb8ac, 0x8b1a=>0xebea, 0x8b1b=>0xb9d6, 0x8b1d=>0xbcd5, 0x8b20=>0xebef, 0x8b21=>0xcdd8, 0x8b26=>0xebf2, 0x8b28=>0xebf5, 0x8b2b=>0xebf3, 0x8b2c=>0xc9b5, 0x8b33=>0xebf0, 0x8b39=>0xb6e0, 0x8b3e=>0xebf4, 0x8b41=>0xebf6, 0x8b49=>0xebfa, 0x8b4c=>0xebf7, 
	0x8b4e=>0xebf9, 0x8b4f=>0xebf8, 0x8b56=>0xebfb, 0x8b58=>0xbcb1, 0x8b5a=>0xebfd, 0x8b5b=>0xebfc, 0x8b5c=>0xc9e8, 0x8b5f=>0xeca1, 0x8b66=>0xb7d9, 0x8b6b=>0xebfe, 0x8b6c=>0xeca2, 0x8b6f=>0xeca3, 0x8b70=>0xb5c4, 0x8b71=>0xe6c1, 0x8b72=>0xbef9, 0x8b74=>0xeca4, 
	0x8b77=>0xb8ee, 0x8b7d=>0xeca5, 0x8b80=>0xeca6, 0x8b83=>0xbbbe, 0x8b8a=>0xdace, 0x8b8c=>0xeca7, 0x8b8e=>0xeca8, 0x8b90=>0xbdb2, 0x8b92=>0xeca9, 0x8b93=>0xecaa, 0x8b96=>0xecab, 0x8b99=>0xecac, 0x8b9a=>0xecad, 0x8c37=>0xc3ab, 0x8c3a=>0xecae, 0x8c3f=>0xecb0, 
	0x8c41=>0xecaf, 0x8c46=>0xc6a6, 0x8c48=>0xecb1, 0x8c4a=>0xcbad, 0x8c4c=>0xecb2, 0x8c4e=>0xecb3, 0x8c50=>0xecb4, 0x8c55=>0xecb5, 0x8c5a=>0xc6da, 0x8c61=>0xbedd, 0x8c62=>0xecb6, 0x8c6a=>0xb9eb, 0x8c6b=>0xd0ae, 0x8c6c=>0xecb7, 0x8c78=>0xecb8, 0x8c79=>0xc9bf, 
	0x8c7a=>0xecb9, 0x8c7c=>0xecc1, 0x8c82=>0xecba, 0x8c85=>0xecbc, 0x8c89=>0xecbb, 0x8c8a=>0xecbd, 0x8c8c=>0xcbc6, 0x8c8d=>0xecbe, 0x8c8e=>0xecbf, 0x8c94=>0xecc0, 0x8c98=>0xecc2, 0x8c9d=>0xb3ad, 0x8c9e=>0xc4e7, 0x8ca0=>0xc9e9, 0x8ca1=>0xbae2, 0x8ca2=>0xb9d7, 
	0x8ca7=>0xc9cf, 0x8ca8=>0xb2df, 0x8ca9=>0xc8ce, 0x8caa=>0xecc5, 0x8cab=>0xb4d3, 0x8cac=>0xc0d5, 0x8cad=>0xecc4, 0x8cae=>0xecc9, 0x8caf=>0xc3f9, 0x8cb0=>0xcce3, 0x8cb2=>0xecc7, 0x8cb3=>0xecc8, 0x8cb4=>0xb5ae, 0x8cb6=>0xecca, 0x8cb7=>0xc7e3, 0x8cb8=>0xc2df, 
	0x8cbb=>0xc8f1, 0x8cbc=>0xc5bd, 0x8cbd=>0xecc6, 0x8cbf=>0xcbc7, 0x8cc0=>0xb2ec, 0x8cc1=>0xeccc, 0x8cc2=>0xcfa8, 0x8cc3=>0xc4c2, 0x8cc4=>0xcfc5, 0x8cc7=>0xbbf1, 0x8cc8=>0xeccb, 0x8cca=>0xc2b1, 0x8ccd=>0xecdc, 0x8cce=>0xc1a8, 0x8cd1=>0xc6f8, 0x8cd3=>0xc9d0, 
	0x8cda=>0xeccf, 0x8cdb=>0xbbbf, 0x8cdc=>0xbbf2, 0x8cde=>0xbede, 0x8ce0=>0xc7e5, 0x8ce2=>0xb8ad, 0x8ce3=>0xecce, 0x8ce4=>0xeccd, 0x8ce6=>0xc9ea, 0x8cea=>0xbcc1, 0x8ced=>0xc5d2, 0x8cfa=>0xecd1, 0x8cfb=>0xecd2, 0x8cfc=>0xb9d8, 0x8cfd=>0xecd0, 0x8d04=>0xecd3, 
	0x8d05=>0xecd4, 0x8d07=>0xecd6, 0x8d08=>0xc2a3, 0x8d0a=>0xecd5, 0x8d0b=>0xb4e6, 0x8d0d=>0xecd8, 0x8d0f=>0xecd7, 0x8d10=>0xecd9, 0x8d13=>0xecdb, 0x8d14=>0xecdd, 0x8d16=>0xecde, 0x8d64=>0xc0d6, 0x8d66=>0xbccf, 0x8d67=>0xecdf, 0x8d6b=>0xb3d2, 0x8d6d=>0xece0, 
	0x8d70=>0xc1f6, 0x8d71=>0xece1, 0x8d73=>0xece2, 0x8d74=>0xc9eb, 0x8d77=>0xb5af, 0x8d81=>0xece3, 0x8d85=>0xc4b6, 0x8d8a=>0xb1db, 0x8d99=>0xece4, 0x8da3=>0xbcf1, 0x8da8=>0xbff6, 0x8db3=>0xc2ad, 0x8dba=>0xece7, 0x8dbe=>0xece6, 0x8dc2=>0xece5, 0x8dcb=>0xeced, 
	0x8dcc=>0xeceb, 0x8dcf=>0xece8, 0x8dd6=>0xecea, 0x8dda=>0xece9, 0x8ddb=>0xecec, 0x8ddd=>0xb5f7, 0x8ddf=>0xecf0, 0x8de1=>0xc0d7, 0x8de3=>0xecf1, 0x8de8=>0xb8d9, 0x8dea=>0xecee, 0x8deb=>0xecef, 0x8def=>0xcfa9, 0x8df3=>0xc4b7, 0x8df5=>0xc1a9, 0x8dfc=>0xecf2, 
	0x8dff=>0xecf5, 0x8e08=>0xecf3, 0x8e09=>0xecf4, 0x8e0a=>0xcdd9, 0x8e0f=>0xc6a7, 0x8e10=>0xecf8, 0x8e1d=>0xecf6, 0x8e1e=>0xecf7, 0x8e1f=>0xecf9, 0x8e2a=>0xeda9, 0x8e30=>0xecfc, 0x8e34=>0xecfd, 0x8e35=>0xecfb, 0x8e42=>0xecfa, 0x8e44=>0xc4fd, 0x8e47=>0xeda1, 
	0x8e48=>0xeda5, 0x8e49=>0xeda2, 0x8e4a=>0xecfe, 0x8e4c=>0xeda3, 0x8e50=>0xeda4, 0x8e55=>0xedab, 0x8e59=>0xeda6, 0x8e5f=>0xc0d8, 0x8e60=>0xeda8, 0x8e63=>0xedaa, 0x8e64=>0xeda7, 0x8e72=>0xedad, 0x8e74=>0xbdb3, 0x8e76=>0xedac, 0x8e7c=>0xedae, 0x8e81=>0xedaf, 
	0x8e84=>0xedb2, 0x8e85=>0xedb1, 0x8e87=>0xedb0, 0x8e8a=>0xedb4, 0x8e8b=>0xedb3, 0x8e8d=>0xccf6, 0x8e91=>0xedb6, 0x8e93=>0xedb5, 0x8e94=>0xedb7, 0x8e99=>0xedb8, 0x8ea1=>0xedba, 0x8eaa=>0xedb9, 0x8eab=>0xbfc8, 0x8eac=>0xedbb, 0x8eaf=>0xb6ed, 0x8eb0=>0xedbc, 
	0x8eb1=>0xedbe, 0x8ebe=>0xedbf, 0x8ec5=>0xedc0, 0x8ec6=>0xedbd, 0x8ec8=>0xedc1, 0x8eca=>0xbcd6, 0x8ecb=>0xedc2, 0x8ecc=>0xb5b0, 0x8ecd=>0xb7b3, 0x8ed2=>0xb8ae, 0x8edb=>0xedc3, 0x8edf=>0xc6f0, 0x8ee2=>0xc5be, 0x8ee3=>0xedc4, 0x8eeb=>0xedc7, 0x8ef8=>0xbcb4, 
	0x8efb=>0xedc6, 0x8efc=>0xedc5, 0x8efd=>0xb7da, 0x8efe=>0xedc8, 0x8f03=>0xb3d3, 0x8f05=>0xedca, 0x8f09=>0xbadc, 0x8f0a=>0xedc9, 0x8f0c=>0xedd2, 0x8f12=>0xedcc, 0x8f13=>0xedce, 0x8f14=>0xcae5, 0x8f15=>0xedcb, 0x8f19=>0xedcd, 0x8f1b=>0xedd1, 0x8f1c=>0xedcf, 
	0x8f1d=>0xb5b1, 0x8f1f=>0xedd0, 0x8f26=>0xedd3, 0x8f29=>0xc7da, 0x8f2a=>0xced8, 0x8f2f=>0xbdb4, 0x8f33=>0xedd4, 0x8f38=>0xcda2, 0x8f39=>0xedd6, 0x8f3b=>0xedd5, 0x8f3e=>0xedd9, 0x8f3f=>0xcdc1, 0x8f42=>0xedd8, 0x8f44=>0xb3ed, 0x8f45=>0xedd7, 0x8f46=>0xeddc, 
	0x8f49=>0xeddb, 0x8f4c=>0xedda, 0x8f4d=>0xc5b2, 0x8f4e=>0xeddd, 0x8f57=>0xedde, 0x8f5c=>0xeddf, 0x8f5f=>0xb9ec, 0x8f61=>0xb7a5, 0x8f62=>0xede0, 0x8f63=>0xede1, 0x8f64=>0xede2, 0x8f9b=>0xbfc9, 0x8f9c=>0xede3, 0x8f9e=>0xbcad, 0x8f9f=>0xede4, 0x8fa3=>0xede5, 
	0x8fa7=>0xd2a1, 0x8fa8=>0xd1fe, 0x8fad=>0xede6, 0x8fae=>0xe5f0, 0x8faf=>0xede7, 0x8fb0=>0xc3a4, 0x8fb1=>0xbfab, 0x8fb2=>0xc7c0, 0x8fb7=>0xede8, 0x8fba=>0xcad5, 0x8fbb=>0xc4d4, 0x8fbc=>0xb9fe, 0x8fbf=>0xc3a9, 0x8fc2=>0xb1aa, 0x8fc4=>0xcbf8, 0x8fc5=>0xbfd7, 
	0x8fce=>0xb7de, 0x8fd1=>0xb6e1, 0x8fd4=>0xcad6, 0x8fda=>0xede9, 0x8fe2=>0xedeb, 0x8fe5=>0xedea, 0x8fe6=>0xb2e0, 0x8fe9=>0xc6f6, 0x8fea=>0xedec, 0x8feb=>0xc7f7, 0x8fed=>0xc5b3, 0x8fef=>0xeded, 0x8ff0=>0xbdd2, 0x8ff4=>0xedef, 0x8ff7=>0xccc2, 0x8ff8=>0xedfe, 
	0x8ff9=>0xedf1, 0x8ffa=>0xedf2, 0x8ffd=>0xc4c9, 0x9000=>0xc2e0, 0x9001=>0xc1f7, 0x9003=>0xc6a8, 0x9005=>0xedf0, 0x9006=>0xb5d5, 0x900b=>0xedf9, 0x900d=>0xedf6, 0x900e=>0xeea5, 0x900f=>0xc6a9, 0x9010=>0xc3e0, 0x9011=>0xedf3, 0x9013=>0xc4fe, 0x9014=>0xc5d3, 
	0x9015=>0xedf4, 0x9016=>0xedf8, 0x9017=>0xbfe0, 0x9019=>0xc7e7, 0x901a=>0xc4cc, 0x901d=>0xc0c2, 0x901e=>0xedf7, 0x901f=>0xc2ae, 0x9020=>0xc2a4, 0x9021=>0xedf5, 0x9022=>0xb0a9, 0x9023=>0xcfa2, 0x9027=>0xedfa, 0x902e=>0xc2e1, 0x9031=>0xbdb5, 0x9032=>0xbfca, 
	0x9035=>0xedfc, 0x9036=>0xedfb, 0x9038=>0xb0ef, 0x9039=>0xedfd, 0x903c=>0xc9af, 0x903e=>0xeea7, 0x9041=>0xc6db, 0x9042=>0xbfeb, 0x9045=>0xc3d9, 0x9047=>0xb6f8, 0x9049=>0xeea6, 0x904a=>0xcdb7, 0x904b=>0xb1bf, 0x904d=>0xcad7, 0x904e=>0xb2e1, 0x904f=>0xeea1, 
	0x9050=>0xeea2, 0x9051=>0xeea3, 0x9052=>0xeea4, 0x9053=>0xc6bb, 0x9054=>0xc3a3, 0x9055=>0xb0e3, 0x9056=>0xeea8, 0x9058=>0xeea9, 0x9059=>0xf4a3, 0x905c=>0xc2bd, 0x905e=>0xeeaa, 0x9060=>0xb1f3, 0x9061=>0xc1cc, 0x9063=>0xb8af, 0x9065=>0xcdda, 0x9068=>0xeeab, 
	0x9069=>0xc5ac, 0x906d=>0xc1f8, 0x906e=>0xbcd7, 0x906f=>0xeeac, 0x9072=>0xeeaf, 0x9075=>0xbde5, 0x9076=>0xeead, 0x9077=>0xc1ab, 0x9078=>0xc1aa, 0x907a=>0xb0e4, 0x907c=>0xcecb, 0x907d=>0xeeb1, 0x907f=>0xc8f2, 0x9080=>0xeeb3, 0x9081=>0xeeb2, 0x9082=>0xeeb0, 
	0x9083=>0xe3e4, 0x9084=>0xb4d4, 0x9087=>0xedee, 0x9089=>0xeeb5, 0x908a=>0xeeb4, 0x908f=>0xeeb6, 0x9091=>0xcdb8, 0x90a3=>0xc6e1, 0x90a6=>0xcbae, 0x90a8=>0xeeb7, 0x90aa=>0xbcd9, 0x90af=>0xeeb8, 0x90b1=>0xeeb9, 0x90b5=>0xeeba, 0x90b8=>0xc5a1, 0x90c1=>0xb0ea, 
	0x90ca=>0xb9d9, 0x90ce=>0xcfba, 0x90db=>0xeebe, 0x90e1=>0xb7b4, 0x90e2=>0xeebb, 0x90e4=>0xeebc, 0x90e8=>0xc9f4, 0x90ed=>0xb3d4, 0x90f5=>0xcdb9, 0x90f7=>0xb6bf, 0x90fd=>0xc5d4, 0x9102=>0xeebf, 0x9112=>0xeec0, 0x9119=>0xeec1, 0x912d=>0xc5a2, 0x9130=>0xeec3, 
	0x9132=>0xeec2, 0x9149=>0xc6d3, 0x914a=>0xeec4, 0x914b=>0xbdb6, 0x914c=>0xbce0, 0x914d=>0xc7db, 0x914e=>0xc3f1, 0x9152=>0xbcf2, 0x9154=>0xbfec, 0x9156=>0xeec5, 0x9158=>0xeec6, 0x9162=>0xbfdd, 0x9163=>0xeec7, 0x9165=>0xeec8, 0x9169=>0xeec9, 0x916a=>0xcdef, 
	0x916c=>0xbdb7, 0x9172=>0xeecb, 0x9173=>0xeeca, 0x9175=>0xb9da, 0x9177=>0xb9f3, 0x9178=>0xbbc0, 0x9182=>0xeece, 0x9187=>0xbde6, 0x9189=>0xeecd, 0x918b=>0xeecc, 0x918d=>0xc2e9, 0x9190=>0xb8ef, 0x9192=>0xc0c3, 0x9197=>0xc8b0, 0x919c=>0xbdb9, 0x91a2=>0xeecf, 
	0x91a4=>0xbedf, 0x91aa=>0xeed2, 0x91ab=>0xeed0, 0x91af=>0xeed1, 0x91b4=>0xeed4, 0x91b5=>0xeed3, 0x91b8=>0xbefa, 0x91ba=>0xeed5, 0x91c0=>0xeed6, 0x91c1=>0xeed7, 0x91c6=>0xc8d0, 0x91c7=>0xbad3, 0x91c8=>0xbce1, 0x91c9=>0xeed8, 0x91cb=>0xeed9, 0x91cc=>0xcea4, 
	0x91cd=>0xbdc5, 0x91ce=>0xccee, 0x91cf=>0xcecc, 0x91d0=>0xeeda, 0x91d1=>0xb6e2, 0x91d6=>0xeedb, 0x91d8=>0xc5a3, 0x91db=>0xeede, 0x91dc=>0xb3f8, 0x91dd=>0xbfcb, 0x91df=>0xeedc, 0x91e1=>0xeedd, 0x91e3=>0xc4e0, 0x91e6=>0xcbd5, 0x91e7=>0xb6fc, 0x91f5=>0xeee0, 
	0x91f6=>0xeee1, 0x91fc=>0xeedf, 0x91ff=>0xeee3, 0x920d=>0xc6df, 0x920e=>0xb3c3, 0x9211=>0xeee7, 0x9214=>0xeee4, 0x9215=>0xeee6, 0x921e=>0xeee2, 0x9229=>0xefcf, 0x922c=>0xeee5, 0x9234=>0xceeb, 0x9237=>0xb8da, 0x923f=>0xeeef, 0x9244=>0xc5b4, 0x9245=>0xeeea, 
	0x9248=>0xeeed, 0x9249=>0xeeeb, 0x924b=>0xeef0, 0x9250=>0xeef1, 0x9257=>0xeee9, 0x925a=>0xeef6, 0x925b=>0xb1f4, 0x925e=>0xeee8, 0x9262=>0xc8ad, 0x9264=>0xeeec, 0x9266=>0xbee0, 0x9271=>0xb9db, 0x927e=>0xcbc8, 0x9280=>0xb6e4, 0x9283=>0xbdc6, 0x9285=>0xc6bc, 
	0x9291=>0xc1ad, 0x9293=>0xeef4, 0x9295=>0xeeee, 0x9296=>0xeef3, 0x9298=>0xccc3, 0x929a=>0xc4b8, 0x929b=>0xeef5, 0x929c=>0xeef2, 0x92ad=>0xc1ac, 0x92b7=>0xeef9, 0x92b9=>0xeef8, 0x92cf=>0xeef7, 0x92d2=>0xcbaf, 0x92e4=>0xbdfb, 0x92e9=>0xeefa, 0x92ea=>0xcadf, 
	0x92ed=>0xb1d4, 0x92f2=>0xc9c6, 0x92f3=>0xc3f2, 0x92f8=>0xb5f8, 0x92fa=>0xeefc, 0x92fc=>0xb9dd, 0x9306=>0xbbac, 0x930f=>0xeefb, 0x9310=>0xbfed, 0x9318=>0xbfee, 0x9319=>0xefa1, 0x931a=>0xefa3, 0x9320=>0xbefb, 0x9322=>0xefa2, 0x9323=>0xefa4, 0x9326=>0xb6d3, 
	0x9328=>0xc9c5, 0x932b=>0xbce2, 0x932c=>0xcfa3, 0x932e=>0xeefe, 0x932f=>0xbaf8, 0x9332=>0xcfbf, 0x9335=>0xefa6, 0x933a=>0xefa5, 0x933b=>0xefa7, 0x9344=>0xeefd, 0x934b=>0xc6e9, 0x934d=>0xc5d5, 0x9354=>0xc4d7, 0x9356=>0xefac, 0x935b=>0xc3c3, 0x935c=>0xefa8, 
	0x9360=>0xefa9, 0x936c=>0xb7ad, 0x936e=>0xefab, 0x9375=>0xb8b0, 0x937c=>0xefaa, 0x937e=>0xbee1, 0x938c=>0xb3f9, 0x9394=>0xefb0, 0x9396=>0xbabf, 0x9397=>0xc1f9, 0x939a=>0xc4ca, 0x93a7=>0xb3bb, 0x93ac=>0xefae, 0x93ad=>0xefaf, 0x93ae=>0xc4c3, 0x93b0=>0xefad, 
	0x93b9=>0xefb1, 0x93c3=>0xefb7, 0x93c8=>0xefba, 0x93d0=>0xefb9, 0x93d1=>0xc5ad, 0x93d6=>0xefb2, 0x93d7=>0xefb3, 0x93d8=>0xefb6, 0x93dd=>0xefb8, 0x93e1=>0xb6c0, 0x93e4=>0xefbb, 0x93e5=>0xefb5, 0x93e8=>0xefb4, 0x9403=>0xefbf, 0x9407=>0xefc0, 0x9410=>0xefc1, 
	0x9413=>0xefbe, 0x9414=>0xefbd, 0x9418=>0xbee2, 0x9419=>0xc6aa, 0x941a=>0xefbc, 0x9421=>0xefc5, 0x942b=>0xefc3, 0x9435=>0xefc4, 0x9436=>0xefc2, 0x9438=>0xc2f8, 0x943a=>0xefc6, 0x9441=>0xefc7, 0x9444=>0xefc9, 0x9451=>0xb4d5, 0x9452=>0xefc8, 0x9453=>0xccfa, 
	0x945a=>0xefd4, 0x945b=>0xefca, 0x945e=>0xefcd, 0x9460=>0xefcb, 0x9462=>0xefcc, 0x946a=>0xefce, 0x9470=>0xefd0, 0x9475=>0xefd1, 0x9477=>0xefd2, 0x947c=>0xefd5, 0x947d=>0xefd3, 0x947e=>0xefd6, 0x947f=>0xefd8, 0x9481=>0xefd7, 0x9577=>0xc4b9, 0x9580=>0xcce7, 
	0x9582=>0xefd9, 0x9583=>0xc1ae, 0x9587=>0xefda, 0x9589=>0xcac4, 0x958a=>0xefdb, 0x958b=>0xb3ab, 0x958f=>0xb1bc, 0x9591=>0xb4d7, 0x9593=>0xb4d6, 0x9594=>0xefdc, 0x9596=>0xefdd, 0x9598=>0xefde, 0x9599=>0xefdf, 0x95a0=>0xefe0, 0x95a2=>0xb4d8, 0x95a3=>0xb3d5, 
	0x95a4=>0xb9de, 0x95a5=>0xc8b6, 0x95a7=>0xefe2, 0x95a8=>0xefe1, 0x95ad=>0xefe3, 0x95b2=>0xb1dc, 0x95b9=>0xefe6, 0x95bb=>0xefe5, 0x95bc=>0xefe4, 0x95be=>0xefe7, 0x95c3=>0xefea, 0x95c7=>0xb0c7, 0x95ca=>0xefe8, 0x95cc=>0xefec, 0x95cd=>0xefeb, 0x95d4=>0xefee, 
	0x95d5=>0xefed, 0x95d6=>0xefef, 0x95d8=>0xc6ae, 0x95dc=>0xeff0, 0x95e1=>0xeff1, 0x95e2=>0xeff3, 0x95e5=>0xeff2, 0x961c=>0xc9ec, 0x9621=>0xeff4, 0x9628=>0xeff5, 0x962a=>0xbae5, 0x962e=>0xeff6, 0x962f=>0xeff7, 0x9632=>0xcbc9, 0x963b=>0xc1cb, 0x963f=>0xb0a4, 
	0x9640=>0xc2cb, 0x9642=>0xeff8, 0x9644=>0xc9ed, 0x964b=>0xeffb, 0x964c=>0xeff9, 0x964d=>0xb9df, 0x964f=>0xeffa, 0x9650=>0xb8c2, 0x965b=>0xcac5, 0x965c=>0xeffd, 0x965d=>0xf0a1, 0x965e=>0xeffe, 0x965f=>0xf0a2, 0x9662=>0xb1a1, 0x9663=>0xbfd8, 0x9664=>0xbdfc, 
	0x9665=>0xb4d9, 0x9666=>0xf0a3, 0x966a=>0xc7e6, 0x966c=>0xf0a5, 0x9670=>0xb1a2, 0x9672=>0xf0a4, 0x9673=>0xc4c4, 0x9675=>0xcecd, 0x9676=>0xc6ab, 0x9677=>0xeffc, 0x9678=>0xcea6, 0x967a=>0xb8b1, 0x967d=>0xcddb, 0x9685=>0xb6f9, 0x9686=>0xceb4, 0x9688=>0xb7a8, 
	0x968a=>0xc2e2, 0x968b=>0xe7a1, 0x968d=>0xf0a6, 0x968e=>0xb3ac, 0x968f=>0xbfef, 0x9694=>0xb3d6, 0x9695=>0xf0a8, 0x9697=>0xf0a9, 0x9698=>0xf0a7, 0x9699=>0xb7e4, 0x969b=>0xbadd, 0x969c=>0xbee3, 0x96a0=>0xb1a3, 0x96a3=>0xced9, 0x96a7=>0xf0ab, 0x96a8=>0xeeae, 
	0x96aa=>0xf0aa, 0x96b0=>0xf0ae, 0x96b1=>0xf0ac, 0x96b2=>0xf0ad, 0x96b4=>0xf0af, 0x96b6=>0xf0b0, 0x96b7=>0xceec, 0x96b8=>0xf0b1, 0x96b9=>0xf0b2, 0x96bb=>0xc0c9, 0x96bc=>0xc8bb, 0x96c0=>0xbffd, 0x96c1=>0xb4e7, 0x96c4=>0xcdba, 0x96c5=>0xb2ed, 0x96c6=>0xbdb8, 
	0x96c7=>0xb8db, 0x96c9=>0xf0b5, 0x96cb=>0xf0b4, 0x96cc=>0xbbf3, 0x96cd=>0xf0b6, 0x96ce=>0xf0b3, 0x96d1=>0xbba8, 0x96d5=>0xf0ba, 0x96d6=>0xeaad, 0x96d9=>0xd2d6, 0x96db=>0xbff7, 0x96dc=>0xf0b8, 0x96e2=>0xcea5, 0x96e3=>0xc6f1, 0x96e8=>0xb1ab, 0x96ea=>0xc0e3, 
	0x96eb=>0xbcb6, 0x96f0=>0xcab7, 0x96f2=>0xb1c0, 0x96f6=>0xceed, 0x96f7=>0xcdeb, 0x96f9=>0xf0bb, 0x96fb=>0xc5c5, 0x9700=>0xbcfb, 0x9704=>0xf0bc, 0x9706=>0xf0bd, 0x9707=>0xbfcc, 0x9708=>0xf0be, 0x970a=>0xceee, 0x970d=>0xf0b9, 0x970e=>0xf0c0, 0x970f=>0xf0c2, 
	0x9711=>0xf0c1, 0x9713=>0xf0bf, 0x9716=>0xf0c3, 0x9719=>0xf0c4, 0x971c=>0xc1fa, 0x971e=>0xb2e2, 0x9724=>0xf0c5, 0x9727=>0xccb8, 0x972a=>0xf0c6, 0x9730=>0xf0c7, 0x9732=>0xcfaa, 0x9738=>0xdbb1, 0x9739=>0xf0c8, 0x973d=>0xf0c9, 0x973e=>0xf0ca, 0x9742=>0xf0ce, 
	0x9744=>0xf0cb, 0x9746=>0xf0cc, 0x9748=>0xf0cd, 0x9749=>0xf0cf, 0x9752=>0xc0c4, 0x9756=>0xccf7, 0x9759=>0xc0c5, 0x975c=>0xf0d0, 0x975e=>0xc8f3, 0x9760=>0xf0d1, 0x9761=>0xf3d3, 0x9762=>0xcccc, 0x9764=>0xf0d2, 0x9766=>0xf0d3, 0x9768=>0xf0d4, 0x9769=>0xb3d7, 
	0x976b=>0xf0d6, 0x976d=>0xbfd9, 0x9771=>0xf0d7, 0x9774=>0xb7a4, 0x9779=>0xf0d8, 0x977a=>0xf0dc, 0x977c=>0xf0da, 0x9781=>0xf0db, 0x9784=>0xb3f3, 0x9785=>0xf0d9, 0x9786=>0xf0dd, 0x978b=>0xf0de, 0x978d=>0xb0c8, 0x978f=>0xf0df, 0x9790=>0xf0e0, 0x9798=>0xbee4, 
	0x979c=>0xf0e1, 0x97a0=>0xb5c7, 0x97a3=>0xf0e4, 0x97a6=>0xf0e3, 0x97a8=>0xf0e2, 0x97ab=>0xebf1, 0x97ad=>0xcadc, 0x97b3=>0xf0e5, 0x97b4=>0xf0e6, 0x97c3=>0xf0e7, 0x97c6=>0xf0e8, 0x97c8=>0xf0e9, 0x97cb=>0xf0ea, 0x97d3=>0xb4da, 0x97dc=>0xf0eb, 0x97ed=>0xf0ec, 
	0x97ee=>0xc7a3, 0x97f2=>0xf0ee, 0x97f3=>0xb2bb, 0x97f5=>0xf0f1, 0x97f6=>0xf0f0, 0x97fb=>0xb1a4, 0x97ff=>0xb6c1, 0x9801=>0xcac7, 0x9802=>0xc4ba, 0x9803=>0xbaa2, 0x9805=>0xb9e0, 0x9806=>0xbde7, 0x9808=>0xbfdc, 0x980c=>0xf0f3, 0x980f=>0xf0f2, 0x9810=>0xcdc2, 
	0x9811=>0xb4e8, 0x9812=>0xc8d2, 0x9813=>0xc6dc, 0x9817=>0xbffc, 0x9818=>0xcece, 0x981a=>0xb7db, 0x9821=>0xf0f6, 0x9824=>0xf0f5, 0x982c=>0xcbcb, 0x982d=>0xc6ac, 0x9834=>0xb1d0, 0x9837=>0xf0f7, 0x9838=>0xf0f4, 0x983b=>0xc9d1, 0x983c=>0xcdea, 0x983d=>0xf0f8, 
	0x9846=>0xf0f9, 0x984b=>0xf0fb, 0x984c=>0xc2ea, 0x984d=>0xb3db, 0x984e=>0xb3dc, 0x984f=>0xf0fa, 0x9854=>0xb4e9, 0x9855=>0xb8b2, 0x9858=>0xb4ea, 0x985b=>0xc5bf, 0x985e=>0xcee0, 0x9867=>0xb8dc, 0x986b=>0xf0fc, 0x986f=>0xf0fd, 0x9870=>0xf0fe, 0x9871=>0xf1a1, 
	0x9873=>0xf1a3, 0x9874=>0xf1a2, 0x98a8=>0xc9f7, 0x98aa=>0xf1a4, 0x98af=>0xf1a5, 0x98b1=>0xf1a6, 0x98b6=>0xf1a7, 0x98c3=>0xf1a9, 0x98c4=>0xf1a8, 0x98c6=>0xf1aa, 0x98db=>0xc8f4, 0x98dc=>0xe6cc, 0x98df=>0xbfa9, 0x98e2=>0xb5b2, 0x98e9=>0xf1ab, 0x98eb=>0xf1ac, 
	0x98ed=>0xd2ac, 0x98ee=>0xddbb, 0x98ef=>0xc8d3, 0x98f2=>0xb0fb, 0x98f4=>0xb0bb, 0x98fc=>0xbbf4, 0x98fd=>0xcbb0, 0x98fe=>0xbefe, 0x9903=>0xf1ad, 0x9905=>0xccdf, 0x9909=>0xf1ae, 0x990a=>0xcddc, 0x990c=>0xb1c2, 0x9910=>0xbbc1, 0x9912=>0xf1af, 0x9913=>0xb2ee, 
	0x9914=>0xf1b0, 0x9918=>0xf1b1, 0x991d=>0xf1b3, 0x991e=>0xf1b4, 0x9920=>0xf1b6, 0x9921=>0xf1b2, 0x9924=>0xf1b5, 0x9928=>0xb4db, 0x992c=>0xf1b7, 0x992e=>0xf1b8, 0x993d=>0xf1b9, 0x993e=>0xf1ba, 0x9942=>0xf1bb, 0x9945=>0xf1bd, 0x9949=>0xf1bc, 0x994b=>0xf1bf, 
	0x994c=>0xf1c2, 0x9950=>0xf1be, 0x9951=>0xf1c0, 0x9952=>0xf1c1, 0x9955=>0xf1c3, 0x9957=>0xb6c2, 0x9996=>0xbcf3, 0x9997=>0xf1c4, 0x9998=>0xf1c5, 0x9999=>0xb9e1, 0x99a5=>0xf1c6, 0x99a8=>0xb3be, 0x99ac=>0xc7cf, 0x99ad=>0xf1c7, 0x99ae=>0xf1c8, 0x99b3=>0xc3da, 
	0x99b4=>0xc6eb, 0x99bc=>0xf1c9, 0x99c1=>0xc7fd, 0x99c4=>0xc2cc, 0x99c5=>0xb1d8, 0x99c6=>0xb6ee, 0x99c8=>0xb6ef, 0x99d0=>0xc3f3, 0x99d1=>0xf1ce, 0x99d2=>0xb6f0, 0x99d5=>0xb2ef, 0x99d8=>0xf1cd, 0x99db=>0xf1cb, 0x99dd=>0xf1cc, 0x99df=>0xf1ca, 0x99e2=>0xf1d8, 
	0x99ed=>0xf1cf, 0x99ee=>0xf1d0, 0x99f1=>0xf1d1, 0x99f2=>0xf1d2, 0x99f8=>0xf1d4, 0x99fb=>0xf1d3, 0x99ff=>0xbdd9, 0x9a01=>0xf1d5, 0x9a05=>0xf1d7, 0x9a0e=>0xb5b3, 0x9a0f=>0xf1d6, 0x9a12=>0xc1fb, 0x9a13=>0xb8b3, 0x9a19=>0xf1d9, 0x9a28=>0xc2cd, 0x9a2b=>0xf1da, 
	0x9a30=>0xc6ad, 0x9a37=>0xf1db, 0x9a3e=>0xf1e0, 0x9a40=>0xf1de, 0x9a42=>0xf1dd, 0x9a43=>0xf1df, 0x9a45=>0xf1dc, 0x9a4d=>0xf1e2, 0x9a55=>0xf1e1, 0x9a57=>0xf1e4, 0x9a5a=>0xb6c3, 0x9a5b=>0xf1e3, 0x9a5f=>0xf1e5, 0x9a62=>0xf1e6, 0x9a64=>0xf1e8, 0x9a65=>0xf1e7, 
	0x9a69=>0xf1e9, 0x9a6a=>0xf1eb, 0x9a6b=>0xf1ea, 0x9aa8=>0xb9fc, 0x9aad=>0xf1ec, 0x9ab0=>0xf1ed, 0x9ab8=>0xb3bc, 0x9abc=>0xf1ee, 0x9ac0=>0xf1ef, 0x9ac4=>0xbff1, 0x9acf=>0xf1f0, 0x9ad1=>0xf1f1, 0x9ad3=>0xf1f2, 0x9ad4=>0xf1f3, 0x9ad8=>0xb9e2, 0x9ade=>0xf1f4, 
	0x9adf=>0xf1f5, 0x9ae2=>0xf1f6, 0x9ae3=>0xf1f7, 0x9ae6=>0xf1f8, 0x9aea=>0xc8b1, 0x9aeb=>0xf1fa, 0x9aed=>0xc9a6, 0x9aee=>0xf1fb, 0x9aef=>0xf1f9, 0x9af1=>0xf1fd, 0x9af4=>0xf1fc, 0x9af7=>0xf1fe, 0x9afb=>0xf2a1, 0x9b06=>0xf2a2, 0x9b18=>0xf2a3, 0x9b1a=>0xf2a4, 
	0x9b1f=>0xf2a5, 0x9b22=>0xf2a6, 0x9b23=>0xf2a7, 0x9b25=>0xf2a8, 0x9b27=>0xf2a9, 0x9b28=>0xf2aa, 0x9b29=>0xf2ab, 0x9b2a=>0xf2ac, 0x9b2e=>0xf2ad, 0x9b2f=>0xf2ae, 0x9b31=>0xddb5, 0x9b32=>0xf2af, 0x9b3b=>0xe4f8, 0x9b3c=>0xb5b4, 0x9b41=>0xb3a1, 0x9b42=>0xbab2, 
	0x9b43=>0xf2b1, 0x9b44=>0xf2b0, 0x9b45=>0xcca5, 0x9b4d=>0xf2b3, 0x9b4e=>0xf2b4, 0x9b4f=>0xf2b2, 0x9b51=>0xf2b5, 0x9b54=>0xcbe2, 0x9b58=>0xf2b6, 0x9b5a=>0xb5fb, 0x9b6f=>0xcfa5, 0x9b74=>0xf2b7, 0x9b83=>0xf2b9, 0x9b8e=>0xb0be, 0x9b91=>0xf2ba, 0x9b92=>0xcaab, 
	0x9b93=>0xf2b8, 0x9b96=>0xf2bb, 0x9b97=>0xf2bc, 0x9b9f=>0xf2bd, 0x9ba0=>0xf2be, 0x9ba8=>0xf2bf, 0x9baa=>0xcbee, 0x9bab=>0xbbad, 0x9bad=>0xbafa, 0x9bae=>0xc1af, 0x9bb4=>0xf2c0, 0x9bb9=>0xf2c3, 0x9bc0=>0xf2c1, 0x9bc6=>0xf2c4, 0x9bc9=>0xb8f1, 0x9bca=>0xf2c2, 
	0x9bcf=>0xf2c5, 0x9bd1=>0xf2c6, 0x9bd2=>0xf2c7, 0x9bd4=>0xf2cb, 0x9bd6=>0xbbaa, 0x9bdb=>0xc2e4, 0x9be1=>0xf2cc, 0x9be2=>0xf2c9, 0x9be3=>0xf2c8, 0x9be4=>0xf2ca, 0x9be8=>0xb7df, 0x9bf0=>0xf2d0, 0x9bf1=>0xf2cf, 0x9bf2=>0xf2ce, 0x9bf5=>0xb0b3, 0x9c04=>0xf2da, 
	0x9c06=>0xf2d6, 0x9c08=>0xf2d7, 0x9c09=>0xf2d3, 0x9c0a=>0xf2d9, 0x9c0c=>0xf2d5, 0x9c0d=>0xb3e2, 0x9c10=>0xcfcc, 0x9c12=>0xf2d8, 0x9c13=>0xf2d4, 0x9c14=>0xf2d2, 0x9c15=>0xf2d1, 0x9c1b=>0xf2dc, 0x9c21=>0xf2df, 0x9c24=>0xf2de, 0x9c25=>0xf2dd, 0x9c2d=>0xc9c9, 
	0x9c2e=>0xf2db, 0x9c2f=>0xb0f3, 0x9c30=>0xf2e0, 0x9c32=>0xf2e2, 0x9c39=>0xb3ef, 0x9c3a=>0xf2cd, 0x9c3b=>0xb1b7, 0x9c3e=>0xf2e4, 0x9c46=>0xf2e3, 0x9c47=>0xf2e1, 0x9c48=>0xc3ad, 0x9c52=>0xcbf0, 0x9c57=>0xceda, 0x9c5a=>0xf2e5, 0x9c60=>0xf2e6, 0x9c67=>0xf2e7, 
	0x9c76=>0xf2e8, 0x9c78=>0xf2e9, 0x9ce5=>0xc4bb, 0x9ce7=>0xf2ea, 0x9ce9=>0xc8b7, 0x9ceb=>0xf2ef, 0x9cec=>0xf2eb, 0x9cf0=>0xf2ec, 0x9cf3=>0xcbb1, 0x9cf4=>0xccc4, 0x9cf6=>0xc6d0, 0x9d03=>0xf2f0, 0x9d06=>0xf2f1, 0x9d07=>0xc6be, 0x9d08=>0xf2ee, 0x9d09=>0xf2ed, 
	0x9d0e=>0xb2aa, 0x9d12=>0xf2f9, 0x9d15=>0xf2f8, 0x9d1b=>0xb1f5, 0x9d1f=>0xf2f6, 0x9d23=>0xf2f5, 0x9d26=>0xf2f3, 0x9d28=>0xb3fb, 0x9d2a=>0xf2f2, 0x9d2b=>0xbcb2, 0x9d2c=>0xb2a9, 0x9d3b=>0xb9e3, 0x9d3e=>0xf2fc, 0x9d3f=>0xf2fb, 0x9d41=>0xf2fa, 0x9d44=>0xf2f7, 
	0x9d46=>0xf2fd, 0x9d48=>0xf2fe, 0x9d50=>0xf3a5, 0x9d51=>0xf3a4, 0x9d59=>0xf3a6, 0x9d5c=>0xb1ad, 0x9d5d=>0xf3a1, 0x9d5e=>0xf3a2, 0x9d60=>0xb9f4, 0x9d61=>0xccb9, 0x9d64=>0xf3a3, 0x9d6c=>0xcbb2, 0x9d6f=>0xf3ab, 0x9d72=>0xf3a7, 0x9d7a=>0xf3ac, 0x9d87=>0xf3a9, 
	0x9d89=>0xf3a8, 0x9d8f=>0xb7dc, 0x9d9a=>0xf3ad, 0x9da4=>0xf3ae, 0x9da9=>0xf3af, 0x9dab=>0xf3aa, 0x9daf=>0xf2f4, 0x9db2=>0xf3b0, 0x9db4=>0xc4e1, 0x9db8=>0xf3b4, 0x9dba=>0xf3b5, 0x9dbb=>0xf3b3, 0x9dc1=>0xf3b2, 0x9dc2=>0xf3b8, 0x9dc4=>0xf3b1, 0x9dc6=>0xf3b6, 
	0x9dcf=>0xf3b7, 0x9dd3=>0xf3ba, 0x9dd9=>0xf3b9, 0x9de6=>0xf3bc, 0x9ded=>0xf3bd, 0x9def=>0xf3be, 0x9df2=>0xcfc9, 0x9df8=>0xf3bb, 0x9df9=>0xc2eb, 0x9dfa=>0xbaed, 0x9dfd=>0xf3bf, 0x9e1a=>0xf3c0, 0x9e1b=>0xf3c1, 0x9e1e=>0xf3c2, 0x9e75=>0xf3c3, 0x9e78=>0xb8b4, 
	0x9e79=>0xf3c4, 0x9e7d=>0xf3c5, 0x9e7f=>0xbcaf, 0x9e81=>0xf3c6, 0x9e88=>0xf3c7, 0x9e8b=>0xf3c8, 0x9e8c=>0xf3c9, 0x9e91=>0xf3cc, 0x9e92=>0xf3ca, 0x9e93=>0xcfbc, 0x9e95=>0xf3cb, 0x9e97=>0xceef, 0x9e9d=>0xf3cd, 0x9e9f=>0xcedb, 0x9ea5=>0xf3ce, 0x9ea6=>0xc7fe, 
	0x9ea9=>0xf3cf, 0x9eaa=>0xf3d1, 0x9ead=>0xf3d2, 0x9eb8=>0xf3d0, 0x9eb9=>0xb9ed, 0x9eba=>0xcccd, 0x9ebb=>0xcbe3, 0x9ebc=>0xd6f7, 0x9ebe=>0xdde0, 0x9ebf=>0xcbfb, 0x9ec4=>0xb2ab, 0x9ecc=>0xf3d4, 0x9ecd=>0xb5d0, 0x9ece=>0xf3d5, 0x9ecf=>0xf3d6, 0x9ed0=>0xf3d7, 
	0x9ed2=>0xb9f5, 0x9ed4=>0xf3d8, 0x9ed8=>0xe0d4, 0x9ed9=>0xccdb, 0x9edb=>0xc2e3, 0x9edc=>0xf3d9, 0x9edd=>0xf3db, 0x9ede=>0xf3da, 0x9ee0=>0xf3dc, 0x9ee5=>0xf3dd, 0x9ee8=>0xf3de, 0x9eef=>0xf3df, 0x9ef4=>0xf3e0, 0x9ef6=>0xf3e1, 0x9ef7=>0xf3e2, 0x9ef9=>0xf3e3, 
	0x9efb=>0xf3e4, 0x9efc=>0xf3e5, 0x9efd=>0xf3e6, 0x9f07=>0xf3e7, 0x9f08=>0xf3e8, 0x9f0e=>0xc5a4, 0x9f13=>0xb8dd, 0x9f15=>0xf3ea, 0x9f20=>0xc1cd, 0x9f21=>0xf3eb, 0x9f2c=>0xf3ec, 0x9f3b=>0xc9a1, 0x9f3e=>0xf3ed, 0x9f4a=>0xf3ee, 0x9f4b=>0xe3b7, 0x9f4e=>0xecda, 
	0x9f4f=>0xf0ed, 0x9f52=>0xf3ef, 0x9f54=>0xf3f0, 0x9f5f=>0xf3f2, 0x9f60=>0xf3f3, 0x9f61=>0xf3f4, 0x9f62=>0xcef0, 0x9f63=>0xf3f1, 0x9f66=>0xf3f5, 0x9f67=>0xf3f6, 0x9f6a=>0xf3f8, 0x9f6c=>0xf3f7, 0x9f72=>0xf3fa, 0x9f76=>0xf3fb, 0x9f77=>0xf3f9, 0x9f8d=>0xceb6, 
	0x9f95=>0xf3fc, 0x9f9c=>0xf3fd, 0x9f9d=>0xe3d4, 0x9fa0=>0xf3fe, 0xff01=>0xa1aa, 0xff03=>0xa1f4, 0xff04=>0xa1f0, 0xff05=>0xa1f3, 0xff06=>0xa1f5, 0xff08=>0xa1ca, 0xff09=>0xa1cb, 0xff0a=>0xa1f6, 0xff0b=>0xa1dc, 0xff0c=>0xa1a4, 0xff0d=>0xa1dd, 0xff0e=>0xa1a5, 
	0xff0f=>0xa1bf, 0xff10=>0xa3b0, 0xff11=>0xa3b1, 0xff12=>0xa3b2, 0xff13=>0xa3b3, 0xff14=>0xa3b4, 0xff15=>0xa3b5, 0xff16=>0xa3b6, 0xff17=>0xa3b7, 0xff18=>0xa3b8, 0xff19=>0xa3b9, 0xff1a=>0xa1a7, 0xff1b=>0xa1a8, 0xff1c=>0xa1e3, 0xff1d=>0xa1e1, 0xff1e=>0xa1e4, 
	0xff1f=>0xa1a9, 0xff20=>0xa1f7, 0xff21=>0xa3c1, 0xff22=>0xa3c2, 0xff23=>0xa3c3, 0xff24=>0xa3c4, 0xff25=>0xa3c5, 0xff26=>0xa3c6, 0xff27=>0xa3c7, 0xff28=>0xa3c8, 0xff29=>0xa3c9, 0xff2a=>0xa3ca, 0xff2b=>0xa3cb, 0xff2c=>0xa3cc, 0xff2d=>0xa3cd, 0xff2e=>0xa3ce, 
	0xff2f=>0xa3cf, 0xff30=>0xa3d0, 0xff31=>0xa3d1, 0xff32=>0xa3d2, 0xff33=>0xa3d3, 0xff34=>0xa3d4, 0xff35=>0xa3d5, 0xff36=>0xa3d6, 0xff37=>0xa3d7, 0xff38=>0xa3d8, 0xff39=>0xa3d9, 0xff3a=>0xa3da, 0xff3b=>0xa1ce, 0xff3c=>0xa1c0, 0xff3d=>0xa1cf, 0xff3e=>0xa1b0, 
	0xff3f=>0xa1b2, 0xff40=>0xa1ae, 0xff41=>0xa3e1, 0xff42=>0xa3e2, 0xff43=>0xa3e3, 0xff44=>0xa3e4, 0xff45=>0xa3e5, 0xff46=>0xa3e6, 0xff47=>0xa3e7, 0xff48=>0xa3e8, 0xff49=>0xa3e9, 0xff4a=>0xa3ea, 0xff4b=>0xa3eb, 0xff4c=>0xa3ec, 0xff4d=>0xa3ed, 0xff4e=>0xa3ee, 
	0xff4f=>0xa3ef, 0xff50=>0xa3f0, 0xff51=>0xa3f1, 0xff52=>0xa3f2, 0xff53=>0xa3f3, 0xff54=>0xa3f4, 0xff55=>0xa3f5, 0xff56=>0xa3f6, 0xff57=>0xa3f7, 0xff58=>0xa3f8, 0xff59=>0xa3f9, 0xff5a=>0xa3fa, 0xff5b=>0xa1d0, 0xff5c=>0xa1c3, 0xff5d=>0xa1d1, 0xff5e=>0xa1c1, 
	0xff61=>0x8ea1, 0xff62=>0x8ea2, 0xff63=>0x8ea3, 0xff64=>0x8ea4, 0xff65=>0x8ea5, 0xff66=>0x8ea6, 0xff67=>0x8ea7, 0xff68=>0x8ea8, 0xff69=>0x8ea9, 0xff6a=>0x8eaa, 0xff6b=>0x8eab, 0xff6c=>0x8eac, 0xff6d=>0x8ead, 0xff6e=>0x8eae, 0xff6f=>0x8eaf, 0xff70=>0x8eb0, 
	0xff71=>0x8eb1, 0xff72=>0x8eb2, 0xff73=>0x8eb3, 0xff74=>0x8eb4, 0xff75=>0x8eb5, 0xff76=>0x8eb6, 0xff77=>0x8eb7, 0xff78=>0x8eb8, 0xff79=>0x8eb9, 0xff7a=>0x8eba, 0xff7b=>0x8ebb, 0xff7c=>0x8ebc, 0xff7d=>0x8ebd, 0xff7e=>0x8ebe, 0xff7f=>0x8ebf, 0xff80=>0x8ec0, 
	0xff81=>0x8ec1, 0xff82=>0x8ec2, 0xff83=>0x8ec3, 0xff84=>0x8ec4, 0xff85=>0x8ec5, 0xff86=>0x8ec6, 0xff87=>0x8ec7, 0xff88=>0x8ec8, 0xff89=>0x8ec9, 0xff8a=>0x8eca, 0xff8b=>0x8ecb, 0xff8c=>0x8ecc, 0xff8d=>0x8ecd, 0xff8e=>0x8ece, 0xff8f=>0x8ecf, 0xff90=>0x8ed0, 
	0xff91=>0x8ed1, 0xff92=>0x8ed2, 0xff93=>0x8ed3, 0xff94=>0x8ed4, 0xff95=>0x8ed5, 0xff96=>0x8ed6, 0xff97=>0x8ed7, 0xff98=>0x8ed8, 0xff99=>0x8ed9, 0xff9a=>0x8eda, 0xff9b=>0x8edb, 0xff9c=>0x8edc, 0xff9d=>0x8edd, 0xff9e=>0x8ede, 0xff9f=>0x8edf, 0xffe0=>0xa1f1, 
	0xffe1=>0xa1f2, 0xffe2=>0xa2cc, 0xffe3=>0xa1b1, 0xffe5=>0xa1ef );

/*
Convert Japanese encode from numric decimal charcter entity references to EUC-JP.
 -JIS X 0201 (alphabet, numbers, punctuations and halfwide Kana)
 -JIS X 0212 (hojo Kanji)
 -JIS X 0213 1 (Japanese Graphic Character Set for Information Interchange, Plane 1)
 -JIS X 0213 2 (Japanese Graphic Character Set for Information Interchange, Plane 2)
*/
function xnpEntity2Eucjp ($str) {
	if (($str == "") || ($str == NULL)){
		return $str;
	}
	if (!preg_match("/&#\d{1,8};/", $str)) {
		return $str;
	}
	$wk = explode("&", $str);
	$str2 = array();
	$i = 0;
	global $ucs2euc;
	foreach ($wk as  $key => $value) {
		if ((substr($value, 0, 1) == "#") && (substr_count($value, ";") > 0)) {
			$value1 = (int)substr($value, 1, strpos($value, ";") - 1);
			$value2 = substr(strstr($value, ";"), 1);
			
			if ( isset( $ucs2euc[$value1] ) ){
				$code = $ucs2euc[$value1];
				$str2[] = chr($code/256) . chr($code%256);
			}
			else if ( $value1 < 0x0080 ){
				$str2[] = chr($value1);
			}
			else {
				$str2[] = "&#$value1;";
			}
			$str2[] = $value2;
		}
		else {
			if (($i == 0) && (substr($str, 0, 1) != "&")) {
				$str2[] = $value;
			}
			else {
				if ($value != "") {
					$str2[] = "&".$value;
				}
			}
		}
		$i++;
	}
	return implode( '', $str2 );
}

?>
