<?php
//  $Revision: 1.14.2.4 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';
include_once 'lib.php';

/**
 * 
 * Return xml with Basic information.
 * 
 * If unknown item_id or error in database exists, return false.
 * 
 * @param fhdl File handle name which output results
 * @param item_id 
 * @param attachment export attacment files and images:true, unselected:false
 * @return true:success, false:failure
 */
function xnpExportItem( $fhdl, $item_id, $attachment = false )
{
    if( !$fhdl ) return false;

	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
    $itemtypes = array();

    $res = xnp_get_item( $xnpsid, $item_id, $item );
    if( $res != RES_OK ){
        return false;
    }
    
    $res = xnp_get_item_types( $itemtypes );
    if( $res != RES_OK ){
        return false;
    }else{
        foreach( $itemtypes as $i){
            if( $i['item_type_id'] == $item['item_type_id'] ){
                $itemtype = $i;
                break;
            }
        }
    }
    if( !isset( $itemtype ) ){ return false; }
    
    include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
    
    if( !fwrite( $fhdl, "<item>\n" ) ) return false;
    
    // item type module doesn't support export
    $func = "${itemtype['name']}ExportItem";
    if( !function_exists( $func ) ){ return false; }
    
    if( !xnpExportBasic( $fhdl, $item_id ) ) return false;
    
    if( !$func( $fhdl, $item_id, $attachment ) ) return false;
    
    if( !fwrite( $fhdl, "</item>\n" ) ) return false;
    
    return true;
}

/******************************************************************/
//Import 
$parser_hash = array();
function startElement($parser, $name, $attribs){
    global $currentTag, $currentAttribs; 
    global $parser_hash;
    $currentTag = $name; 
    
    //return if item_id is not in accept_id
    if( array_key_exists( 'basic', $parser_hash[$parser] )
        && array_key_exists( 'ID', $parser_hash[$parser]['basic'] )
        && !in_array( $parser_hash[$parser]['basic']['ID'],
                      $parser_hash[$parser]['accept_id'] ) ) return;
    
    $currentAttribs = $attribs; 
    
    array_push( $parser_hash[$parser]['tagstack'], $name );
    
    $tags = "/".implode( '/', $parser_hash[$parser]['tagstack'] );
    if( array_key_exists( $tags, $parser_hash[$parser]['handler'] ) ){
        array_push( $parser_hash[$parser]['handlerstack'], $parser_hash[$parser]['handler'][$tags] );
    }
    
    if( count( $parser_hash[$parser]['handlerstack'] ) > 0 ){
        $handler = end( $parser_hash[$parser]['handlerstack'] );
        //echo "call ${handler[0]}\n";
        if( function_exists( $handler[0] ) )
            $handler[0]($parser, $name, $attribs, $parser_hash[$parser] );
        return;
    }
//    print_r( $parser_hash[$parser] );
//    echo("<b>&lt$name&gt</b><br>"); 
    
} 

function endElement($parser, $name) { 
    global $currentTag; 
    global $parser_hash;
    
    //return if item_id is not in accept_id
    if( array_key_exists( 'basic', $parser_hash[$parser] )
        && array_key_exists( 'ID', $parser_hash[$parser]['basic'] )
        && !in_array( $parser_hash[$parser]['basic']['ID'],
                      $parser_hash[$parser]['accept_id'] ) ) return;
    
    if( count( $parser_hash[$parser]['handlerstack'] ) > 0 ){
        $handler = end( $parser_hash[$parser]['handlerstack'] );
        //echo "call ${handler[1]}($parser, $name)\n";
        if( function_exists( $handler[1] ) )
            $handler[1]($parser, $name, $parser_hash[$parser] );
        //TODO: compare with first value in 'handler' key.
        if( array_key_exists( "/".implode( '/', $parser_hash[$parser]['tagstack'] ), $parser_hash[$parser]['handler'] ) ){
            array_pop( $parser_hash[$parser]['handlerstack'] );
        }
        //print "/".implode( '/', $parser_hash[$parser]['tagstack'] )."\n";
        //print_r( $parser_hash[$parser]['handlerstack'] );
        array_pop( $parser_hash[$parser]['tagstack'] );
        return;
    }
    
//    echo("<br><b>&lt/$name&gt</b><br><br>"); 
    
    $currentTag = ""; 
    $currentAttribs = ""; 
    
    array_pop( $parser_hash[$parser]['tagstack'] );
} 
    
function characterData($parser, $data) { 
    global $currentTag, $currentAttribs; 
    global $parser_hash;
    
    //return if item_id is not in accept_id
    if( array_key_exists( 'basic', $parser_hash[$parser] )
        && array_key_exists( 'ID', $parser_hash[$parser]['basic'] )
        && !in_array( $parser_hash[$parser]['basic']['ID'],
                      $parser_hash[$parser]['accept_id'] ) ) return;
    
    $tags = "/".implode( '/', $parser_hash[$parser]['tagstack'] );
    
    if( count( $parser_hash[$parser]['handlerstack'] ) > 0 ){
        $handler = end( $parser_hash[$parser]['handlerstack'] );
//        echo "call ${handler[2]}\n";
        if( function_exists( $handler[2] ) )
            $handler[2]($parser, $data, $parser_hash[$parser] );
        return;
    }
//    echo("<font color='#ff0000'>".$data."</font>"); 
} 

function basicStartElement($parser, $name, $attribs, &$parser_hash )
{
//    echo("<b><font color=\"#007777\">&lt$name&gt</font></b><br>"); 
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    switch( $tags ){
    case '/ITEM/BASIC':
        $parser_hash['basic'] = $attribs;
        break;
    case "/ITEM/BASIC/KEYWORDS": 
    case "/ITEM/BASIC/DESCRIPTION": 
    case "/ITEM/BASIC/DOI": 
        $parser_hash['basic'][$name] = '';
    }
}
function basicEndElement($parser, $name, &$parser_hash)
{
    global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    switch ($tags) { 
    case '/ITEM/BASIC':
        if( !in_array( $parser_hash['basic']['ID'], $parser_hash['accept_id'] ) ) break; //
//        print_r( $parser_hash['basic'] );
        $xnpsid = $_SESSION['XNPSID'];
        $uid = $_SESSION['xoopsUserId'];
        $myts =& MyTextsanitizer::getInstance();
        
        $sql = "select item_type_id from " . $xoopsDB->prefix('xoonips_item_type') . " where name='".$myts -> addslashes( $parser_hash['basic']['ITEMTYPE'] )."'";
        $result = $xoopsDB->query( $sql );
        if ( !$result ) break;
        list($item_type_id) = $xoopsDB->fetchRow($result);

        list( $Y, $M, $D, $h, $m, $s ) = preg_split( "/[-:T]/", $parser_hash['basic']['LAST_UPDATE_DATE'] );
//        print_r( array( $Y, $M, $D, $h, $m, $s ) );
        $last_update_date = gmmktime( $h, $m, $s, $M, $D, $Y );
//        echo $last_update_date;
        list( $Y, $M, $D, $h, $m, $s ) = preg_split( "/[-:T]/", $parser_hash['basic']['CREATION_DATE'] );
//        print_r( array( $Y, $M, $D, $h, $m, $s ) );
        $creation_date = gmmktime( $h, $m, $s, $M, $D, $Y );
//        echo $creation_date;
        
/*
        $item = array(
            'item_type_id'		=> $item_type_id,
            'uid'				=> $uid,
            'title'				=> $parser_hash['basic']['TITLE'		],
            'keywords'			=> $parser_hash['basic']['KEYWORDS'		],
            'description'		=> $parser_hash['basic']['DESCRIPTION'	],
            'doi'				=> $parser_hash['basic']['DOI'			],
            'last_update_date'  => $last_update_date,
            'creation_date'     => $creation_date,
            'publication_year'	=> $parser_hash['basic']['PUBLICATION_YEAR' ],
            'publication_month'	=> $parser_hash['basic']['PUBLICATION_MONTH'],
            'publication_mday'	=> $parser_hash['basic']['PUBLICATION_MDAY'  ]
            );
*/
        $item = array(
            'item_type_id'		=> $item_type_id,
            'uid'				=> $uid,
            'title'				=> encodeClient2Server( $parser_hash['basic']['TITLE'		] ),
            'keywords'			=> encodeClient2Server( $parser_hash['basic']['KEYWORDS'		] ),
            'description'		=> encodeClient2Server( $parser_hash['basic']['DESCRIPTION'	] ),
            'doi'				=> encodeClient2Server( $parser_hash['basic']['DOI'			] ),
            'last_update_date'  => $last_update_date,
            'creation_date'     => $creation_date,
            'publication_year'	=> $parser_hash['basic']['PUBLICATION_YEAR' ],
            'publication_month'	=> $parser_hash['basic']['PUBLICATION_MONTH'],
            'publication_mday'	=> $parser_hash['basic']['PUBLICATION_MDAY'  ],
            'lang'				=> $parser_hash['basic']['LANG'  ]
            );
        $result = xnp_insert_item_direct( $xnpsid, $item, $item_id );
        if( $result == RES_OK ){
            $parser_hash['id_table'][$parser_hash['basic']['ID']] = $item_id;
            // remove item from private index
            $xids = array();
            if( xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids ) == RES_OK ){
                foreach( $xids as $i ) xnp_unregister_item( $xnpsid, $i, $item_id );
            }
        }else{
            $parser_hash['errmsg'] .= "can't insert item(xnp_insert_item_direct(item_id=${item_id}) returns ${result})\n";
        }
        break;
    }
//    echo("<br><b><font color=\"#007777\">&lt/$name&gt</font></b><br><br>"); 
}
function basicCharacterData($parser, $data, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/BASIC/ITEMTYPE":
    case "/ITEM/BASIC/TITLE": 
    case "/ITEM/BASIC/CONTRIBUTOR": 
    case "/ITEM/BASIC/KEYWORDS": 
    case "/ITEM/BASIC/DESCRIPTION": 
    case "/ITEM/BASIC/DOI": 
    case "/ITEM/BASIC/LAST_UPDATE_DATE": 
    case "/ITEM/BASIC/CREATION_DATE": 
    case "/ITEM/BASIC/PUBLICATION_YEAR": 
    case "/ITEM/BASIC/PUBLICATION_MONTH": 
    case "/ITEM/BASIC/PUBLICATION_MDAY": 
    case "/ITEM/BASIC/URL": 
    case "/ITEM/BASIC/LANG": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['basic'] ) ){
            $parser_hash['basic'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['basic'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
    
    switch ($tags) { 
    case "/ITEM/BASIC/ITEMTYPE":
        $itemtypes = array();
        $tmp = array();
        if( ( $res = xnp_get_item_types( $tmp ) ) != RES_OK ){
            return;
        }else{
            foreach( $tmp as $i){
                $itemtypes[$i['name']]=$i;
            }
        }
        // TODO array_key_exists( $data, $itemtypes )
        include_once XOOPS_ROOT_PATH . '/modules/' . $itemtypes[$data]['viewphp'];
        $func = $data."GetImportHandler";
        if( function_exists( $func ) ){
            $tmp_handler = $func( );
            $parser_hash['handler'] = array_merge( $tmp_handler, $parser_hash['handler'] );
        }else{
            echo "not exists '$func'\n";
        }
        //print_r( $parser_hash );
        break;
    default: 
//        echo("<font color='#ff0000'>".$data."</font>"); 
        break; 
    } 
}

function linkStartElement($parser, $name, $attribs, &$parser_hash )
{
//    echo("<b><font color=\"#007777\">&lt$name&gt</font></b><br>"); 
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    switch( $tags ){
    case "/ITEM/LINK": 
        $xnpsid = $_SESSION['XNPSID'];
        $index_id = $attribs['INDEX_ID'];
        $item_id = $attribs['ITEM_ID'];
        if( array_key_exists( $index_id, $parser_hash['id_table'] )
            && array_key_exists( $item_id, $parser_hash['id_table'] ) ){
            $result = xnp_register_item( $xnpsid, $parser_hash['id_table'][$index_id], $parser_hash['id_table'][$item_id] );
        }
        break;
    }
}
function linkEndElement($parser, $name, &$parser_hash){}
function linkCharacterData($parser, $data, &$parser_hash ){}


function fileStartElement($parser, $name, $attribs, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch ($tags) { 
    case '/ITEM/DETAIL/FILE/CAPTION':
        $parser_hash['file']['caption'] = array();
        break; 
    case '/ITEM/DETAIL/FILE/DATA':
        $parser_hash['file']['data'] = array();
        break;
    case '/ITEM/DETAIL/FILE/THUMBNAIL':
        $parser_hash['file']['thumbnail'] = array();
        break;
    case '/ITEM/DETAIL/FILE':
        $parser_hash['file'] = $attribs;//array();
        break;
    }
//    echo("<b><font color=\"#ff00ff\">&lt$name&gt</font></b><br>"); 
    //print_r( $parser_hash );
}
function fileEndElement($parser, $name, &$parser_hash)
{
    global $xoopsDB;
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch ($tags) { 
    case '/ITEM/DETAIL/FILE':
//        print_r($parser_hash['file']['ITEM_ID']);
//        print_r($parser_hash['id_table'] );
        if( !array_key_exists( $parser_hash['file']['ITEM_ID'], $parser_hash['id_table'] ) ) break;
        
        $myts =& MyTextSanitizer::getInstance();
        $sql = "select file_type_id from " . $xoopsDB->prefix('xoonips_file_type') . " where name='".$myts -> addslashes( $parser_hash['file']['FILE_TYPE_NAME'] )."'";
        $result = $xoopsDB->query( $sql );
        if ( !$result ){
            $parser_hash['errmsg'] .= "Invalid query '".$xoopsDB->error()."'\n";
            break;
        }
        list($file_type_id) = $xoopsDB->fetchRow($result);
        
        $xnpsid = $_SESSION['XNPSID'];
        $thumbnail = array_key_exists( 'thumbnail', $parser_hash['file'] ) ? "0x".bin2hex(base64_decode( preg_replace( "/[\r\n]/", '', implode( '', $parser_hash['file']['thumbnail'] ) ) ) ) : 'NULL';
        $sql = "insert into " . $xoopsDB->prefix('xoonips_file') . 
            " ( original_file_name, file_name, mime_type, file_size, item_id, file_type_id, thumbnail_file, caption, sid ) ".
            " values ( '".implode( "', '", 
                                   array( $myts -> addslashes( encodeClient2Server( $parser_hash['file']['ORIGINAL_FILE_NAME'] ) ),
                                          $myts -> addslashes( encodeClient2Server( $parser_hash['file']['FILE_NAME'] ) ),
                                          $myts -> addslashes( encodeClient2Server( $parser_hash['file']['MIME_TYPE'] ) ),
                                          $parser_hash['file']['FILE_SIZE'],
                                          $parser_hash['id_table'][$parser_hash['file']['ITEM_ID']],
                                          $file_type_id
                                          ) )
            ."', "
            .$thumbnail
            .",'".$myts -> addslashes( encodeClient2Server( implode('', $parser_hash['file']['caption'] ) ) )."'"
            .", NULL"
            ." )";
        $result = $xoopsDB->queryF( $sql );
        if( !$result ){
            $parser_hash['errmsg'] .= "Invalid query '".$xoopsDB->error()."'\n";
            break;
        }
        
        // <data> contents save in file.
        $fileID = $xoopsDB->getInsertId();
        $filePath = xnpGetUploadFilePath($fileID);
        $escFilePath = addslashes( $filePath );
        $hdl = fopen( $filePath, "wb" );
        if( $hdl ){
            fwrite( $hdl, base64_decode( preg_replace( "/[\r\n]/", '', implode( '', $parser_hash['file']['data'] ) ) ) );
            fclose( $hdl );
//            echo "wrote ".$filePath."\n";
            $path = pathinfo( $filePath );
            $sql =  "update " . $xoopsDB->prefix('xoonips_file') . " set file_name='".$myts -> addslashes( $path['basename'] )."' where file_id=$fileID";
            //echo $sql;
            if ( false == $xoopsDB->queryF( $sql ) ){
                $parser_hash['errmsg'] .= "Invalid query '".$xoopsDB->error()."'\n";
                break;
            }
        }
        break;
    }
    
    //print_r( $parser_hash );
//    echo("<br><b><font color=\"#ff00ff\">&lt/$name&gt</font></b><br><br>"); 
    
    $currentTag = ""; 
    $currentAttribs = ""; 
}
function fileCharacterData($parser, $data, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch ($tags) { 
    case '/ITEM/DETAIL/FILE/CAPTION':
        array_push( $parser_hash['file']['caption'], $data );
        break; 
    case '/ITEM/DETAIL/FILE/DATA':
        array_push( $parser_hash['file']['data'], $data );
        break; 
    case '/ITEM/DETAIL/FILE/THUMBNAIL':
        array_push( $parser_hash['file']['thumbnail'], $data );
        break; 
    } 
}

function indexStartElement($parser, $name, $attribs, &$parser_hash )
{
	$xnpsid = $_SESSION['XNPSID'];

    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/INDEXES/INDEX": 
        $ar = array( 'parent_id' => $attribs['PARENT_ID'],
                     'index_id' => $attribs['ID'] );
        array_push( $parser_hash['indexes'], $ar );
        break;
    case "/INDEXES":
        break;
    }
//    echo("<b><font color=\"#007700\">&lt$name&gt</font></b><br>"); 
}
/**
 * 
 * @param parent_index_id index_id of import place
 * @param $indexes array of index information to import
 * index information = array( 'title'     => title of index
 *                            'parent_id' => temporary id of parent index
 *                            'item_id'   => temporary id of parent index ),
 * @param id_table 
 * 
 */
function import_index( $parent_index_id, &$indexes, &$id_table )
{
	$xnpsid = $_SESSION['XNPSID'];
//    echo "import_index( $parent_index_id, ".print_r($indexes).", ".print_r($id_table)." )\n";
    //print_r( $indexes );
    foreach( $indexes as $index ){
//        echo "index=";print_r( $index );
        $index['title'] = encodeClient2Server( $index['title'] );
        $child = array();
		// numbers of same index name
        $cnt = 0;
        $index_id = 0;
        if( xnp_get_indexes( $xnpsid, $parent_index_id, array(), $child ) == RES_OK ){
            foreach( $child as $i ){
                if( $i['title'] == $index['title'] ){
                    $cnt++;
                    $index_id = $i['item_id'];
                }
            }
        }
        if( $cnt == 1 ){
//            echo "conflict index id=${index_id} title=${index['title']}\n";
            $id_table[$index['index_id']] = $index_id;
        }else{
//            echo "insert new index title=${index['title']}\n";
            $insert_index = array();
            $insert_index['title'] = $index['title'];
            $insert_index['parent_index_id'] = $parent_index_id;
            $result = xnp_insert_index( $xnpsid, $insert_index, $index_id );
            if( $result != RES_OK ){
//                $parser_hash['errmsg'] .= "can't insert index(xnp_insert_index returns ${result})\n";
                break;
            }
            $id_table[$index['index_id']] = $index_id;
        }
        if( array_key_exists( 'child', $index ) )
            import_index( $index_id, $index['child'], $id_table );
    }
}
function indexEndElement($parser, $name, &$parser_hash)
{
//    echo("<b><font color=\"#000077\">&lt$name&gt</font></b><br>"); 
	$xnpsid = $_SESSION['XNPSID'];
    
    switch ($name) { 
    case "INDEXES":
        $a = $parser_hash['indexes'];
        $ref = array();
        //foreach( $a as &$i ){
        foreach( $a as $k => $v ){
            $i =& $a[ $k ];
            $ref[$i['index_id']] =& $i;
        }

        $root_id=null;
        //$tmp: tree structure of index is recomposed with parent_id and index_id.
        //foreach( $a as &$i ){
        foreach( $a as $k => $v ){
            $i =& $a[ $k ];
            $parent_id = $i['parent_id'];
            if( array_key_exists( $parent_id, $ref ) ){
                if( !array_key_exists( 'child', $ref[$parent_id] ) ){
                    $ref[$parent_id]['child'] = array();
                }
                $ref[$parent_id]['child'][] =& $i;
            }else{
                $root_id = $i['index_id'];
            }
        }
        if( $root_id != null ){
			$tmp = array( $ref[$root_id] );
            import_index( $parser_hash['parent_index_id'], $tmp, $parser_hash['id_table'] );
        }
        break;
    }
//    echo("<br><b><font color=\"#007700\">&lt/$name&gt</font></b><br><br>"); 
}
function indexCharacterData($parser, $data, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/INDEXES/INDEX/TITLE": 
        $index = array_pop( $parser_hash['indexes'] );
        $index['title'] = $data;
        array_push( $parser_hash['indexes'], $index );
        break;
    }
//    echo $data."\n";
}

/**
 * 
 * import Basic information of item in xml.
 * 
 * @param str XML charactor(UTF-8)
 * @param id_table array( 'temparary ID' => 'actual ID', ... )
 * @param accept_id array( 'temporary id of import item', ... )
 * @param errmsg reference recieve error message
 * @return true success
 * @return false error. refer $errmsg.
 * 
 */
function xnpImportItem( $str, &$id_table, $accept_id = array(), &$errmsg )
{
    global $parser_hash;

    $errmsg = '';
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
    
	$str = xnpEntity2Utf8( $str );
    $parser = xml_parser_create( "UTF-8" );
    if( !$parser ){
        $errmsg .= "can't create parser\n";
        return false;
    }
    $parser_hash[$parser] = array( 'tagstack' => array(),
                                   'id_table'  => $id_table,
                                   'accept_id' => $accept_id,
                                   'errmsg'  => $errmsg,
                                   'handler'  => array(),
                                   'handlerstack'  => array() );
//    print_r($parser_hash[$parser]);
    //XooNIps processes following tags.
    $parser_hash[$parser]['handler']['/ITEM/BASIC'] = array( "basicStartElement", "basicEndElement", "basicCharacterData" );
    $parser_hash[$parser]['handler']['/ITEM/DETAIL/FILE'] = array( "fileStartElement", "fileEndElement", "fileCharacterData" );
    
    xml_set_element_handler($parser, "startElement", "endElement"); 
    xml_set_character_data_handler($parser, "characterData"); 
    
    if( !xml_parse( $parser, $str, true ) ){
		$lines = preg_split( "/[\r\n]+/", $str );
        die( xml_error_string( xml_get_error_code( $parser ) )." at column ".xml_get_current_column_number ( $parser )." of line ".htmlspecialchars($lines[xml_get_current_line_number( $parser )-1]) );
    }

    xml_parser_free( $parser );
    
    $id_table = $parser_hash[$parser]['id_table'];
    $parser_hash[$parser] = NULL;
    return true;
}

/**
 * 
 * import 'Related to' data of item from xml.
 * 
 * @param str XML characters (UTF-8)
 * @param id_table array( 'temporary ID' => 'actual ID', ... )
 * @param accept_id array( 'temporary id of import item', ... )
 * @param errmsg reference recieve error message
 * @return true success
 * @return false error. refer $errmsg.
 */
function xnpImportRelatedTo( $str, &$id_table, $accept_id = array(), &$errmsg )
{
	global $parser_hash;

	$errmsg = '';
	$xnpsid = $_SESSION['XNPSID'];
	$item = array();
	
	$str = xnpEntity2Utf8( $str );
	$parser = xml_parser_create( "UTF-8" );
	if( !$parser ){
		$errmsg .= "can't create parser\n";
		return false;
	}
	$parser_hash[$parser] = array( 'tagstack' => array(),
								   'id_table'  => $id_table,
								   'accept_id' => $accept_id,
								   'errmsg'  => $errmsg,
								   'handler'  => array(),
								   'handlerstack'  => array() );
//	print_r($parser_hash[$parser]);
	//XooNIps processes following tags.
	$parser_hash[$parser]['handler']['/ITEM/BASIC'] = array( "relatedToStartElement", "relatedToEndElement", "relatedToCharacterData" );
	
	xml_set_element_handler($parser, "startElement", "endElement"); 
	xml_set_character_data_handler($parser, "characterData"); 
	
	if( !xml_parse( $parser, $str, true ) ){
		$lines = preg_split( "/[\r\n]+/", $str );
		die( xml_error_string( xml_get_error_code( $parser ) )." at column ".xml_get_current_column_number ( $parser )." of line ".htmlspecialchars($lines[xml_get_current_line_number( $parser )-1]) );
	}

	xml_parser_free( $parser );
	
	$id_table = $parser_hash[$parser]['id_table'];
	$parser_hash[$parser] = NULL;
	return true;
}

/**
 * 
 * 
 * @param str XML characters (UTF-8)
 * @param parent_id index_id of import place
 * @return array( 'temporary ID' => 'actual ID', ... )
 * @param errmsg reference recieve error message
 * @return true success
 * @return false error. refer $errmsg.
 */
function xnpImportIndex( $str, $parent_index_id, &$id_table, &$errmsg )
{
    global $parser_hash;
    
    $uid = $_SESSION['xoopsUserId'];
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
    
	$str = xnpEntity2Utf8( $str );
    $parser = xml_parser_create( "UTF-8" );
    if( !$parser ){
        $errmsg .= "can't create parser\n";
        return false;
    }
    $parser_hash[$parser] = array( 'tagstack' => array(),
                                   'id_table'  => $id_table,
                                   'errmsg'  => $errmsg,
                                   'handler'  => array(),
                                   'handlerstack'  => array(),
                                   'indexes' => array(),
                                   'parent_index_id' => $parent_index_id );
    
    $parser_hash[$parser]['handler']['/INDEXES'] = array( "indexStartElement", "indexEndElement", "indexCharacterData" );
    
    xml_set_element_handler($parser, "startElement", "endElement"); 
    xml_set_character_data_handler($parser, "characterData"); 
    
    if( !xml_parse( $parser, $str, true ) ){
		$lines = preg_split( "/[\r\n]+/", $str );
        die( xml_error_string( xml_get_error_code( $parser ) )." at column ".xml_get_current_column_number ( $parser )." of line ".htmlspecialchars($lines[xml_get_current_line_number( $parser )-1]) );
    }

    xml_parser_free( $parser );
    
    $id_table = $parser_hash[$parser]['id_table'];
    $parser_hash[$parser] = NULL;
    return true;
}


/**
 * 
 * import <link> of items's Basic Information from xml.
 * 
 * @param str XML characters (UTF-8)
 * @param reference of idtable array( 'temporary ID' => 'actual ID', ... )
 * @param errmsg reference recieve error message
 * @return true success
 * @return false error refer $errmsg.
 */
function xnpImportItemLink( $str, &$idtable, &$errmsg )
{
    global $parser_hash;
    
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
    
	$str = xnpEntity2Utf8( $str );
    $parser = xml_parser_create( "UTF-8" );
    if( !$parser ){
        $errmsg .= "can't create parser\n";
        return false;
    }
    $parser_hash[$parser] = array( 'tagstack' => array(),
                                   'id_table'  => $idtable,
                                   'handler'  => array(),
                                   'handlerstack'  => array() );
//    print_r($parser_hash[$parser]);
    //XooNIps processes following tags.
    $parser_hash[$parser]['handler']['/ITEM/LINK'] = array( "linkStartElement", "linkEndElement", "linkCharacterData" );
    
    xml_set_element_handler($parser, "startElement", "endElement"); 
    xml_set_character_data_handler($parser, "characterData"); 
    
    if( !xml_parse( $parser, $str, true ) ){
		$lines = preg_split( "/[\r\n]+/", $str );
        die( xml_error_string( xml_get_error_code( $parser ) )." at column ".xml_get_current_column_number ( $parser )." of line ".htmlspecialchars($lines[xml_get_current_line_number( $parser )-1]) );
    }

    xml_parser_free( $parser );
    
    $idtable = $parser_hash[$parser]['id_table'];
    $parser_hash[$parser] = NULL;
    return true;
}


/**
 * 
 * @param fhdl File handle name which output results
 * @param index_id id of index to display
 * @param recurse true:export recursively index that hangs under index_id.
 * @return true:success, false:failure
 */
function xnpExportIndex( $fhdl, $index_id, $recurse )
{
    if( !$fhdl ) return false;

	$xnpsid = $_SESSION['XNPSID'];
    $index = array();
    $child = array();
    
    $res = xnp_get_index( $xnpsid, $index_id, $index );
    if( $res != RES_OK ){
        return false;
    }
    
    $res = xnp_get_indexes( $xnpsid, $index_id, array(), $child );
    if( $res != RES_OK ){
        return false;
    }
    
    if( !fwrite( $fhdl, "<index parent_id=\"${index['parent_index_id']}\" id=\"${index_id}\">\n"
                 ."<title>".xnpHtmlspecialchars($index['title'], ENT_QUOTES)."</title>\n"
                 ."</index>\n" ) ) return false;
    
    $xml = array();
    if( $recurse ){
        $res = xnp_get_indexes( $xnpsid, $index_id, array( 'orders' => array( array( 'sort_number', 0 ) ) ), $child );
        if( $res == RES_OK ){
            foreach( $child as $i ){
                if( !xnpExportIndex( $fhdl, $i['item_id'], $recurse ) ) return false;
            }
        }
    }
    return true;
}

/**
 * 
 * export attachment files related to item.
 * 
 * @param fhdl File handle name which output results
 * @param item_id id of item with attachment files to export.
 * @return true:success, false:failure
 */
function xnpExportFile( $fhdl, $item_id )
{
    $file = xnpGetFileInfo( "t_file.file_id, t_file_type.name, t_file.original_file_name, t_file.file_name, t_file.file_size, t_file.mime_type, t_file.thumbnail_file, t_file.caption", 
                            "item_id = ${item_id}", $item_id );
    
    if( !$fhdl ) return false;
    
    $xml = array();
    foreach( $file as $f ){
        $file = array();
        list( $file['file_id'], $file['file_type_name'], $file['original_file_name'], $file['file_name'], $file['file_size'], $file['mime_type'], $file['thumbnail_file'], $file['caption'] ) = $f;
        $hdl = fopen( xnpGetUploadFilePath( $file['file_id'] ), "rb" );
        if( $hdl ){

            if( !fwrite( $fhdl, "<file"
                         ." item_id=\"${item_id}\""
                         ." file_type_name=\"${file['file_type_name']}\""
                         ." original_file_name=\"${file['original_file_name']}\""
                         ." file_name=\"${file['file_name']}\""
                         ." file_size=\"${file['file_size']}\""
                         ." mime_type=\"${file['mime_type']}\""
                         .">\n"
                         ."<data>" ) ){
                fclose( $hdl );
                return false;
            }
			while( !feof( $hdl ) ){
                $data = fread( $hdl, 3072 * 1024 ); // 3072Byte:Size that can be divided with 6bits and also with 8bits.
                if( !fwrite( $fhdl, base64_encode( $data ) ) ){
                    fclose( $hdl );
                    return false;
                }
            }
            fclose( $hdl );
            if( !fwrite( $fhdl, "</data>\n"
                         .( isset( $file['thumbnail_file'] ) ? "<thumbnail>".base64_encode( $file['thumbnail_file'] )."</thumbnail>\n" : '' )
                         ."<caption>".$file['caption']."</caption>\n"
                         ."</file>\n" ) ) return false;
        }
    }
    return true;
}

/**
 * 
 * export Basic information of item
 * 
 * @param fhdl File handle name which output results
 * @param item_id id of the item to change into XML.
 * @return true:success, false:failure
 */
function xnpExportBasic( $fhdl, $item_id )
{
    if( !$fhdl ) return false;
    
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
    $account = array();

    $res = xnp_get_item( $xnpsid, $item_id, $item );
    if( $res != RES_OK ){
        return false;
    }
    return xnpBasicInformation2XML( $fhdl, $item );
}

/**
 * 
 * export ChangeLog of item.
 * 
 * @param fhdl File handle name which output results
 * @param item id of the item to export.
 * @return true:success, false:failure
 */
function xnpExportChangeLog( $fhdl, $item_id )
{
    if( !$fhdl ) return false;
    
	$xnpsid = $_SESSION['XNPSID'];
    $xml = array();
    $logs = array();
    $res = xnp_get_change_logs( $xnpsid, $item_id, $logs );
    if( $res != RES_OK ) return false;
    if( !fwrite( $fhdl, "<changelogs>\n" ) ) return false;
    foreach( $logs as $l ){
        $log_date    = gmdate( "Y-m-d\TH:i:s", $l['log_date'] );
        if( !fwrite( $fhdl, "<changelog date='${log_date}'>".xnpHtmlspecialchars( $l['log'] )."</changelog>\n" ) ) return false;
    }
    if( !fwrite( $fhdl, "</changelogs>\n" ) ) return false;
    
    return true;
}


/**
 * 
 * export 'Related to' information of an item.
 * 
 * @param parent_id id of the item to export.
 * @return generated XML or NULL
 */
function xnpExportRelatedTo( $parent_id )
{
	$xnpsid = $_SESSION['XNPSID'];
	$xml = array();
	$item_id = array();
	//Export item: only accesible item
	//->export link information getted xnp_get_related_to.
	$res = xnp_get_related_to( $xnpsid, $parent_id, $item_id );
	if( $res != RES_OK ) return NULL;
	$xml = '';
	foreach( $item_id as $i ){
		$xml = $xml . "<related_to item_id='${i}'/>\n";
	}
	return $xml;
}




function titleStartElement($parser, $name, $attribs, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/BASIC":
        $parser_hash['basic']['item_id'] = $attribs['ID'];
        break;
    case "/ITEM/BASIC/TITLE":
        $parser_hash['basic']['title'] = '';
        break;
    }
}

function titleEndElement($parser, $name, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/BASIC":
        $data = $parser_hash['basic']['title'];
        $xnpsid = $_SESSION['XNPSID'];
        $iids = array( );
        $msg = '';
        $search_var = array();
        if( xnpSearchExec( 'quicksearch', encodeClient2Server( $data ), 'basic', false, $msg, $iids, $search_var ) ){
            $ret = array();
            foreach( $iids as $item_id ){
                $item = array();
                if( xnp_get_item( $xnpsid, $item_id, $item ) == RES_OK ){
                    if( $item['title'] == encodeClient2Server( $data ) ) $ret[] = $item_id;
                }
            }
            $parser_hash['ids'] = $ret;
        }
        break;
    }
}

function titleCharacterData($parser, $data, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/BASIC/ITEMTYPE":
        $parser_hash['basic']['itemtype'] = $data;
        break;
        
    case "/ITEM/BASIC/CONTRIBUTOR":
        $parser_hash['basic']['contributor'] = $data;
        break;
        
    case "/ITEM/BASIC/TITLE":
        $parser_hash['basic']['title'] = $parser_hash['basic']['title'] . $data;
        break;
    } 
}
/**
 * 
 * check the existance of same name item in index to import, 
 * and return its results.
 * 
 * @param str XML characters (UTF-8)
 * @param basic Basic Information in XML
 * @param ids id of item with possibility of collision
 * @return 
 */
function xnpImportItemCheck( $str, &$basic, &$ids )
{
    global $parser_hash;
    
    if( !is_array( $basic ) ) $basic = array( );
    if( !is_array( $ids ) ) $ids = array( );
    
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
    
	$str = xnpEntity2Utf8( $str );
    $parser = xml_parser_create( "UTF-8" );
    if( !$parser ) return NULL;
    $parser_hash[$parser] = array(
        'tagstack' => array(),
        'basic' => array(),
        'ids'  => array(),
        'handler'  => array(),
        'handlerstack'  => array() );
    $parser_hash[$parser]['handler']['/ITEM/BASIC'] = array( "titleStartElement", "titleEndElement", "titleCharacterData" );
    
    xml_set_element_handler($parser, "startElement", "endElement"); 
    xml_set_character_data_handler($parser, "characterData"); 
    
    if( !xml_parse( $parser, $str, true ) ){
		$lines = preg_split( "/[\r\n]+/", $str );
        die( xml_error_string( xml_get_error_code( $parser ) )." at column ".xml_get_current_column_number ( $parser )." of line ".htmlspecialchars($lines[xml_get_current_line_number( $parser )-1]) );
    }

    xml_parser_free( $parser );
    
    $ids = $parser_hash[$parser]['ids'];
    $basic = $parser_hash[$parser]['basic'];
    $parser_hash[$parser] = NULL;
    return true;
}


function indexcheckStartElement($parser, $name, $attribs, &$parser_hash )
{
//    echo("<b><font color=\"#007777\">&lt$name&gt</font></b><br>"); 
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/INDEXES": 
        $parser_hash['indexlinks'] = array();
    case "/INDEXES/INDEX": 
        if( !array_key_exists( 'current_index', $parser_hash['indexlinks'] ) )
            $parser_hash['indexlinks']['current_index'] = array();
        array_push( $parser_hash['indexes'], $attribs );
        break;
    }
}
function indexcheckEndElement($parser, $name, &$parser_hash){}
function indexcheckCharacterData($parser, $data, &$parser_hash )
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/INDEXES/INDEX/TITLE":
        $index = array_pop( $parser_hash['indexes'] );
        $index['title'] = $data;
        array_push( $parser_hash['indexes'], $index );
        break;
    } 
}
function xnpImportIndexCheck( $str,&$indexes )
{
     global $parser_hash;

     $xnpsid = $_SESSION['XNPSID'];
     $item = array();

	 $str = xnpEntity2Utf8( $str );
     $parser = xml_parser_create( "UTF-8" );
     if( !$parser ) return NULL;
     $parser_hash[$parser] = array(
         'tagstack' => array(),
         'indexes' => array(),
         'handler'  => array(),
         'handlerstack'  => array() );
     //XooNIps processes following tags.
     $parser_hash[$parser]['handler']['/INDEXES'] = array( "indexcheckStartElement", "indexcheckEndElement", "indexcheckCharacterData" );
    
    xml_set_element_handler($parser, "startElement", "endElement"); 
    xml_set_character_data_handler($parser, "characterData"); 
    
    if( !xml_parse( $parser, $str, true ) ){
		$lines = preg_split( "/[\r\n]+/", $str );
        die( xml_error_string( xml_get_error_code( $parser ) )." at column ".xml_get_current_column_number ( $parser )." of line ".htmlspecialchars($lines[xml_get_current_line_number( $parser )-1]) );
    }

    xml_parser_free( $parser );
    
    $indexes = $parser_hash[$parser]['indexes'];
    $parser_hash[$parser] = NULL;
    return true;
}


function relatedToStartElement($parser, $name, $attribs, &$parser_hash )
{
	$xnpsid = $_SESSION['XNPSID'];
	$tags = "/".implode( '/', $parser_hash['tagstack'] );
	switch( $tags ){
	case '/ITEM/BASIC':
		$parser_hash['basic'] = $attribs;
		$parser_hash['related_to'] = array();
		$parser_hash['related_to']['parent_id'] = $attribs['ID']; // id of a original link
		$parser_hash['related_to']['child_id'] = 0; // id of a ahead link
		break;
	case '/ITEM/BASIC/RELATED_TO':
		if( isset( $attribs['ITEM_ID'] ) ) $parser_hash['related_to']['child_id'] = $attribs['ITEM_ID'];
		if( $parser_hash['related_to']['child_id'] != 0 ){
			//insert link among items into id_table,
			//if there is correspondence from temporary id to the actual id in both original link and ahead link.
			if( array_key_exists( $parser_hash['related_to']['parent_id'], $parser_hash['id_table'] )
				&& array_key_exists( $parser_hash['related_to']['child_id'], $parser_hash['id_table'] ) ){
				$parent_id = $parser_hash['id_table'][ $parser_hash['related_to']['parent_id'] ];
				$child_id = $parser_hash['id_table'][ $parser_hash['related_to']['child_id'] ];
				echo "\nxnp_insert_related_to( $xnpsid, $parent_id, $child_id )=";
				echo xnp_insert_related_to( $xnpsid, $parent_id, $child_id );
			}
		}
		break;
	}
}
function relatedToEndElement($parser, $name, &$parser_hash)
{
}
function relatedToCharacterData($parser, $data, &$parser_hash )
{
}


?>
