<?
header( "Content-Type: application/xml" );

include_once "../../mainfile.php";

include_once 'condefs.php';
include_once 'include/lib.php';
include_once 'include/create_session.php';
xnp_load_init_create_session();

include_once 'oaiclass.php';
include_once 'oai_dc.php';
include_once 'junii.php';

// retrieve admin's e-mail
$emails = array();
$member_handler =& xoops_gethandler('member');
$members =& $member_handler->getUsersByGroup(XOOPS_GROUP_ADMIN, false);
foreach( $members as $userid ){
	$user =& $member_handler->getUser($userid);
	$emails[] = $user -> getVar( 'email' );
}

xnp_get_config_value( 'repository_name', $repositoryName );

$pmh = new OAIPMH( XOOPS_URL."/modules/xoonips/oai.php", $repositoryName, $emails );
$pmh -> addHandler( new JUNIIHandler() );
$pmh -> addHandler( new OAI_DCHandler() );

$args = array();
foreach( array( 'verb', 'metadataPrefix', 'set', 'from', 'until', 'identifier', 'resumptionToken' ) as $k ){
	if( isset( $_GET[ $k ] ) ) $args[$k] = $_GET[ $k ];
	else if( isset( $_POST[ $k ] ) ) $args[$k] = $_POST[ $k ];
}

if( !isset( $args['verb'] ) ){
	echo $pmh -> header()
		.$pmh -> request( $args )
		.$pmh -> error( 'badVerb', 'no verb' )
		.$pmh -> footer();
    exit();
}
if( $args['verb'] == 'GetRecord' ){
	echo $pmh -> GetRecord( $args );
}else if( $args['verb'] == 'Identify' ){
	echo $pmh -> Identify( );
}else if( $args['verb'] == 'ListIdentifiers' ){
	echo $pmh -> ListIdentifiers( $args );
}else if( $args['verb'] == 'ListMetadataFormats' ){
	echo $pmh -> ListMetadataFormats( $args );
}else if( $args['verb'] == 'ListRecords' ){
	echo $pmh -> ListRecords( $args );
}else if( $args['verb'] == 'ListSets' ){
	echo $pmh -> ListSets( $args );
}else{
	echo $pmh -> header()
		.$pmh -> request( $args )
		.$pmh -> error( 'badVerb', 'illegal verb' )
		.$pmh -> footer();
}
?>
