<?php
//  page to register items                                                      //
//  $Revision: 1.14.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/* REQUEST_METHOD: POST -> invalid cache. $_POST saved as $_SESSION['post_id'], and variables are acquired with GET.
   specified post_id -> valid cache. Input forms are accuired in $_SESSION['post_id'].
   specified item_type_id -> valid cache. Input forms are empty.
   unspecified item_type_id and unspecified post_id -> invalid cache. variables are acquired after the specification of item_type_id.
   If cache is valid, the #8043 problem occurs. -> xnpsid is buried in URL.
*/
if ( $_SERVER['REQUEST_METHOD'] == 'GET' && ( isset($_GET['item_type_id']) || isset($_GET['post_id']) ) ) {
	session_cache_limiter( 'private' );
	session_cache_expire( 5 );
}

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'include/lib.php';
include_once 'condefs.php';
include_once 'include/item_limit_check.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

xnpEncodeMacSafariPost();
xnpEncodeMacSafariGet();
// If post_id is specified, $_POST is restored.
if ( isset( $_GET['post_id'] ) && $_SERVER["REQUEST_METHOD"] == 'GET' ){
	$post_id = $_GET['post_id'];
	if ( isset( $_SESSION[$post_id] ) ){
		$_POST = unserialize( $_SESSION[$post_id] );
		//unset( $_SESSION[$post_id] );
	}
}

foreach( array( 'item_type_id' => 0 ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

// If not a user, redirect
if ( !$xoopsUser ) {
	redirect_header( 'index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
	exit();
}

$uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
	&& !xnp_is_activated( $xnpsid, $uid ) ){
  	redirect_header('index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
  	exit();
}

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);

$select_item_type = array();
$itemtypes = array();
if( xnp_get_item_types( $itemtypes ) != RES_OK ){
	redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
	break;
}else{
	if ( empty($item_type_id) ){
		// set default item type id
		if ( isset($_SESSION['xoonipsITID']) )
			$item_type_id = $_SESSION['xoonipsITID'];
		else
			$item_type_id = ITID_BINDER;
	}
	foreach( $itemtypes as $i){
		if( $i['item_type_id'] >= ITID_BINDER ){
			if( $i['item_type_id'] == $item_type_id ){
				$itemtype = $i;
			}
			$select_item_type[$i['display_name']]=$i['item_type_id'];
		}
	}
	$result = array();
	$moduleTable = $xoopsDB->prefix('modules');
	$sql = "select weight from $moduleTable where dirname like 'xnp%' or dirname like 'xoonips' order by mid";
	$result = $xoopsDB->query($sql);
	while ( list($weight) = $xoopsDB->fetchRow($result) ){
	        $order[] = $weight;
			}
    array_multisort($order, $select_item_type);
	$_SESSION['xoonipsITID'] = $item_type_id; // setting of default value in item_type_id to display next time
}

if ( !isset($_GET['item_type_id']) && !isset($_GET['post_id']) && $_SERVER['REQUEST_METHOD'] == 'GET' ){
	header( "HTTP/1.0 303 See Other" );
	header( "Location: " .  XOOPS_URL . "/modules/xoonips/register.php?item_type_id=$item_type_id&dummy=$xnpsid" );
	echo sprintf( _IFNOTRELOAD, XOOPS_URL . "/modules/xoonips/register.php?item_type_id=$item_type_id&dummy=$xnpsid" );
	exit;
}

//index tree( checkbox enabled )
if ( $item_type_id == ITID_BINDER ){
	$xoonipsEditBinder = true;
}
$xoonipsTreeCheckBox = true;
$xoonipsURL = '';
$xoonipsCheckPrivate = 'nextButton';


$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$xoopsOption['template_main'] = 'xoonips_register.html';
include XOOPS_ROOT_PATH.'/header.php';

// test1
//check private_item_number_limit
if( !check_private_item_number_limit( ) ){
	if( !isset( $system_message ) ) $system_message='';
	$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT."</font><br/>";
	$xoopsTpl->assign("system_message", $system_message );
	include XOOPS_ROOT_PATH.'/footer.php';
}

//select_item_type: array( 'item type name' => 'item_type_id', ... );
$xoopsTpl->assign("select_item_type", $select_item_type );
$xoopsTpl->assign("item_type_id", $item_type_id );
$xoopsTpl->assign("xnpsid", $xnpsid );
$xoopsTpl->assign("next_url", "confirm_register.php" );
$xoopsTpl->assign("prev_url", "register.php" );
$xoopsTpl->assign("this_url", XOOPS_URL . "/modules/xoonips/register.php" );
$xoopsTpl->assign('accept_charset', xnpGetMacSafariAcceptCharset() );
if( isset( $itemtype ) ){
	include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
	eval( "\$body = ".$itemtype['name']."GetRegisterBlock( );" );
	$xoopsTpl->assign('body', $body);
}

if( isset( $system_message ) )
	$xoopsTpl->assign("system_message", $system_message );
if ( isset($_POST['xoonipsCheckedXID']) )
	$xoopsTpl->assign("index_checked_id", $_POST['xoonipsCheckedXID'] );

/*
$account = array();
if( xnp_get_account( $xnpsid, $uid, $account ) == RES_OK ){
    $iids = array();
    if( xnp_get_private_item_id( $xnpsid, $uid, $iids ) == RES_OK ){
        $xoopsTpl->assign( 'num_of_items_current', count( $iids ) );
    }
    $xoopsTpl->assign( 'num_of_items_max', $account['item_number_limit'] );
    $xoopsTpl->assign( 'storage_of_items_max', sprintf( "%.02lf", $account['item_storage_limit'] / 1000 / 1000 ) );
    $xoopsTpl->assign( 'storage_of_items_current', sprintf( "%.02lf", filesize_private( ) / 1000 / 1000 ) );
}
*/

// If the page is made by POST, $_POST is made to save somewhere and page redirects.
// rfc2616 10.3.4 303 See Other
if ( $_SERVER["REQUEST_METHOD"] == 'POST' ){
	$post_id = uniqid('postid');
	$_SESSION[$post_id] = serialize( $_POST );
	header( "HTTP/1.0 303 See Other" );
	header( "Location: " .  XOOPS_URL . "/modules/xoonips/register.php?post_id=$post_id" );
	echo sprintf( _IFNOTRELOAD, XOOPS_URL . "/modules/xoonips/register.php?post_id=$post_id" );
	//redirect_header("register.php?post_id=$post_id", 5, "redirecting...");
	exit;
}

// The output( header("Cache-control: no-cache") etc ) is prevented by footer.php.
header('Content-Type:text/html; charset='._CHARSET);
echo "\r\n"; flush();

include XOOPS_ROOT_PATH.'/footer.php';

?>
