<?php

/**
 * *An experiment class*
 * This class defines function communication between modules.
 * This class conceals real processes.
 */
class XCube_Service
{
	var $mOperations=array();
	var $mErrorStr=null;

	function XCube_Service()
	{
	}

	function register($name,$in=false,$out=false)
	{
		$this->mOperations[$name]=array(
			"name"=>$name,
			"in"=>$in,
			"out"=>$out);
	}
	
	function setError($message)
	{
		$this->mErrorStr=$message;
	}
}

/**
 * *An experiment class*
 * This class is the adapter of a service class.
 * I give a caller the interface that resembled NUSOAP.
 */
class XCube_ServiceClient
{
	var $mService;
	var $mClientErrorStr;

	function XCube_ServiceClient($point)
	{
		if(is_object($point))
			$this->mService=&$point;
	}

	function &call($operation,&$parameters)
	{
		$ret =null;
		
		$this->mClientErrorStr=null;
		
		if(!is_object($this->mService)) {
			$this->mClientErrorStr="This instance is not connected to service";
			return $ret;
		}
		
		$methodName="do".ucfirst($operation);
		if(method_exists($this->mService,$methodName)) {
			return call_user_func(array($this->mService,$methodName),$parameters);
		}
		else {
			$this->mClientErrorStr="operation $operation not present.";
			return $ret;
		}
	}
	
	function getOperationData($operation)
	{
	}

	function setError($message)
	{
		$this->mClientErrorStr=$message;
	}

	function getError()
	{
		return !empty($this->mClientErrorStr) ? $this->mClientErrorStr : $this->mService->mErrorStr;
	}
}

?>