<?php
/**
 * @version $Id: LegacyModuleInstallAction.class.php,v 1.1.2.2 2005/12/29 07:24:46 minahito Exp $
 */

require_once XOOPS_BASE_PATH."/admin/actions/AbstractModuleInstallAction.class.php";
require_once XOOPS_BASE_PATH."/admin/class/ModuleInstaller.class.php";

/**
 * Install module
 */
class LegacyModuleInstallAction extends Legacy_AbstractModuleInstallAction
{
	var $mLicence;
	var $mLicenceText;

	function &_getInstaller($dirname)
	{
		$installer =& new Legacy_ModuleInstaller($dirname);
		return $installer;
	}

	function _loadAgreement()
	{
		$root =& XCube_Root::getSingleton();
		
		$this->mLicence = $this->mModuleObject->modinfo['installer']['licence']['title'];

		$file = $this->mModuleObject->modinfo['installer']['licence']['file'];
		$language = $root->mController->getConfig('language');

		$path = XOOPS_MODULE_PATH . "/" . $this->mModuleObject->getVar('dirname') ."/language/" . $language . "/" . $file;
		if (!file_exists($path)) {
			$path = XOOPS_MODULE_PATH . "/" . $this->mModuleObject->getVar('dirname') . "pm/language/english/" . $file;
			if (!file_exists($path)) {
				return;
			}
		}

		$this->mLicenceText = file_get_contents($path);
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("module_install_success.html");
		$renderer->setAttribute('log', $this->mLog->mMessages);
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setAttribute('module', $this->mModuleObject);

		if (isset($this->mModuleObject->modinfo['installer'])) {
			$renderer->setAttribute('image', $this->mModuleObject->modinfo['installer']['image']);
			$renderer->setAttribute('description', $this->mModuleObject->modinfo['installer']['description']);
			$renderer->setTemplateName("module_installer.html");
		}
		else {
			$renderer->setTemplateName("module_install_confirm.html");
		}
	}

	function executeViewInput(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_installer_licence.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('licence', $this->mLicence);
		$renderer->setAttribute('licenceText', $this->mLicenceText);
	}
}

?>