<?php

/**
 * This is test menu block for control panel of legacy module.
 * This loads module objects by a permission of the current user.
 * Then this load module's adminmenu and module's information.
 *
 * [ASSIGN]
 *  Array of module objects.
 * 
 * @package legacy
 */
class Legacy_AdminSideMenu extends XCube_BlockProcedure
{
	var $mModules=array();

	function getTitle()
	{
		return "TEST: AdminSideMenu";
	}
	
	function getEntryIndex()
	{
		return 0;
	}

	function enableCached()
	{
		return false;
	}

	function execute(&$controller,&$user)
	{
		$db=&$controller->getDB();
		//
		// TODO : We don't use handler and write sql directly.
		//
		$sql = "SELECT {mod}.* FROM {mod},{perm} ".
		        "WHERE {mod}.mid={perm}.gperm_itemid AND {perm}.gperm_name='module_admin' AND {perm}.gperm_groupid IN ({groups}) ".
		        "ORDER BY {mod}.weight";

		$replaceMap=array("mod"=>$db->prefix("modules"),
		                 "perm"=>$db->prefix("group_permission"),
		                 "groups"=>implode(",",$user->getGroups()));

		$sql=XCube_Utils::formatMessageByMap($sql,$replaceMap);

		$result=$db->query($sql);
		while($row=$db->fetchArray($result)) {
			$module = new XoopsModule();
			$module->assignVars($row);
			$dmy=&$module->getInfo();

			//
			// Load admin menu, and add preference menu by own judge.
			//
			$module->loadAdminMenu();
			if ($module->getVar('hasnotification')
			    || ($module->getInfo('config') && is_array($module->getInfo('config')))
			    || ($module->getInfo('comments') && is_array($module->getInfo('comments')))) {
					$module->adminmenu[] = array(
						'link' => XOOPS_URL.'/modules/system/admin.php?fct=preferences&amp;op=showmod&amp;mod='.$module->getVar('mid'),
						'title' => _PREFERENCES,
						'absolute' => true);
			}
			
			if ($module->hasHelp()) {
				$helpUrl = XOOPS_MODULE_URL . "/base/admin/index.php?action=Help&amp;dirname=" . $module->getVar('dirname');
				$module->adminmenu[] = array('link' => $helpUrl,
				                              'title' => _HELP,
				                              'absolute' => true);
			}

			$this->mModules[]=&$module;
			unset($module);
		}
	}

	function hasResult()
	{
		return true;
	}

	function &getResult()
	{
		return $this->mModules;
	}

	function getTemplateName()
	{
		return "legacy_admin_block_sidemenu.html";
	}
}

?>