<?php

//
// TODO
//
require_once XOOPS_ROOT_PATH."/modules/legacyRender/kernel/Legacy_RenderSystem.class.php";

define('LEGACY_ADMIN_RENDER_TEMPLATE_DIRNAME', "templates");
define('_TMP_THEME_NAME', "admin");

define('LEGACY_ADMIN_RENDER_FALLBACK_PATH', XOOPS_MODULE_PATH . "/base/admin/theme");
define('LEGACY_ADMIN_RENDER_FALLBACK_URL', XOOPS_MODULE_URL . "/base/admin/theme");

require_once XOOPS_ROOT_PATH."/class/smarty/Smarty.class.php";

/**
 * This class extends Smarty to mediate the collision compiled file name.
 */
class Legacy_AdminSmarty extends Smarty
{
	var $mModulePrefix = null;

	//
	// If you don't hope to override for theme, set false.
	//
	var $overrideMode = true;
	
	function Legacy_AdminSmarty()
	{
		parent::Smarty();

		$this->compile_id = null;
		$this->_canUpdateFromFile = true;
		$this->compile_check = true;
		$this->compile_dir = XOOPS_COMPILE_PATH;
		$this->left_delimiter = "<{";
		$this->right_delimiter = "}>";

		$this->register_modifier("theme", "Legacy_modifier_theme");
		$this->register_function("stylesheet", "Legacy_function_stylesheet");
	}
	
	function setModulePrefix($prefix)
	{
		$this->mModulePrefix = $prefix;
	}
	
	function _get_auto_filename($autoBase, $autoSource = null, $auotId = null)
	{
		$autoSource = $this->mModulePrefix . "_admin_" . $autoSource;
		return parent::_get_auto_filename($autoBase, $autoSource, $auotId);
	}

	function _fetch_resource_info(&$params)
	{
		//
		// Get dirname from root object.
		//
		$root =& XCube_Root::getSingleton();
		$modController =& $root->mController->getModuleController();
		$moduleObject =& $modController->getXoopsModule();
		$dirname = $moduleObject->getVar('dirname');

		$overridePath = XOOPS_THEME_PATH . "/" . _TMP_THEME_NAME . "/modules/" . $dirname;

		$params['resource_base_path'] = $overridePath;
		$params['quiet'] = true;

		$_return = parent::_fetch_resource_info($params);

		if (!$_return) {
			unset ($params['resource_base_path']);
			$params['quiet'] = false;

			$_return = parent::_fetch_resource_info($params);
		}

		return $_return;
	}
	
}

/**
 * [TODO]
 * We depends on Legacy_RenderSystem that a add-in module defines. We must stop
 * this situation.
 */
class Legacy_AdminRenderSystem extends Legacy_RenderSystem
{
	var $mSmarty;
	
	function prepare()
	{
		$this->mSmarty=new Legacy_AdminSmarty();

		$this->mSmarty->assign(array("xoops_url"=>XOOPS_URL,
		                              "xoops_rootpath"=>XOOPS_ROOT_PATH,
		                              "xoops_langcode"=>_LANGCODE,
		                              "xoops_charset"=>_CHARSET,
		                              "xoops_version"=>XOOPS_VERSION,
		                              "xoops_upload_url"=>XOOPS_UPLOAD_URL));

	}
	
	function renderBlock(&$target)
	{
		$this->mSmarty->template_dir=XOOPS_ROOT_PATH."/modules/base/admin/templates";

		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->assign($key,$value);
		}
		
		$this->mSmarty->setModulePrefix("base");
		$result=&$this->mSmarty->fetch("blocks/".$target->getTemplateName());
		$target->setResult($result);
		
		//
		// Reset
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->clear_assign($key);
		}
	}
	
	function renderTheme(&$target)
	{
		$this->mController->mDebugger->displayLog();

		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->assign($key,$value);
		}

		$this->mSmarty->assign("currentModule",$this->mController->mModuleController->mModuleObject);

		//
		// Theme rendering
		//
		foreach($this->mBlockContents[0] as $result) {
			$this->mSmarty->append('xoops_lblocks',$result);
		}

		//
		// Check Theme or Fallback
		//
		if (file_exists(XOOPS_ROOT_PATH."/themes/"._TMP_THEME_NAME."/admin_theme.html")) {
			$this->mSmarty->template_dir=XOOPS_THEME_PATH."/"._TMP_THEME_NAME;
		}
		else {
			$this->mSmarty->template_dir=LEGACY_ADMIN_RENDER_FALLBACK_PATH;
		}

		$this->mSmarty->setModulePrefix('');
		$result=$this->mSmarty->fetch("file:admin_theme.html");

		$target->setResult($result);
	}

	function renderMain(&$target)
	{
		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->assign($key,$value);
		}

		$result=null;
		if($target->getTemplateName()) {
			$this->mSmarty->template_dir=$this->mController->mModuleController->getModuleDir() . "/". LEGACY_ADMIN_RENDER_TEMPLATE_DIRNAME;
			$this->mSmarty->setModulePrefix($this->mController->mModuleController->getModuleDir());
			$result=$this->mSmarty->fetch("file:".$this->mTemplateName);
		}
		else {
			$result=$target->getAttribute("stdout_buffer");
		}
		
		$target->setResult($result);
	}
}

/**
 * Return URL string by "overriding" rule.
 * (Now, test implement)
 * 1) Search file in specified theme directory.
 * 2) Search file in current module template directory.
 * 3) Search file in fallback theme directory.
 */
function Legacy_modifier_theme($string)
{
	$root =& XCube_Root::getSingleton();
	$modController =& $root->mController->getModuleController();
	$moduleObject =& $modController->getXoopsModule();

	if (!is_object($moduleObject)) {
		// TODO We must remove Hard-Coding
		$themePath = XOOPS_THEME_PATH . "/" . _TMP_THEME_NAME . "/" . $string;
		if (file_exists($themePath)) {
			return XOOPS_THEME_URL . "/" . _TMP_THEME_NAME . "/" . $string;
		}

		return LEGACY_ADMIN_RENDER_FALLBACK_URL . "/" . $string;
	}
	else {
		$dirname = $moduleObject->getVar('dirname');

		// TODO We must remove Hard-Coding
		$themePath = XOOPS_THEME_PATH . "/" . _TMP_THEME_NAME . "/modules/" . $dirname . "/" . $string;
		if (file_exists($themePath)) {
			return XOOPS_THEME_URL . "/" . _TMP_THEME_NAME . "/modules/" . $dirname . "/" . $string;
		}

		$themePath = XOOPS_THEME_PATH . "/" . _TMP_THEME_NAME . "/" . $string;
		if (file_exists($themePath)) {
			return XOOPS_THEME_URL . "/" . _TMP_THEME_NAME . "/" . $string;
		}

		$modulePath = XOOPS_MODULE_PATH . "/" . $dirname . "/admin/templates/" . $string;

		if (file_exists($modulePath)) {
			return XOOPS_MODULE_URL . "/" . $dirname . "/admin/templates/" . $string;
		}

		return LEGACY_ADMIN_RENDER_FALLBACK_URL . "/" . $string;
	}
}

function Legacy_function_stylesheet($params, &$smarty)
{
	$file = $params['file'];

	$theme = null;

	// TODO We must remove Hard-Coding
	$themePath = XOOPS_THEME_PATH . "/" . _TMP_THEME_NAME . "/" . $file;
	if (file_exists($themePath)) {
		$theme = _TMP_THEME_NAME;
		$url = XOOPS_MODULE_URL . "/base/admin/css.php?theme=${theme}&amp;file=${file}";
	}
	else {
		$url = XOOPS_MODULE_URL . "/base/admin/css.php?file=${file}";
	}

	// TEMP
	// TODO We must return FALLBACK_URL here.

	print '<link rel="stylesheet" type="text/css" media="all" href="' . $url . '" />';
}


?>