<?php
// $Id: Legacy_ModuleController.class.php,v 1.1.2.1 2005/12/27 05:30:09 minahito Exp $
//  ------------------------------------------------------------------------ //
//              XOOPS Cube - PHP Content Management System                   //
//                  Copyright (c) 2005 XOOPS Cube.org                        //
//                     <http://www.xoopscube.org/>                           //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

define("LEGACY_XOOPS_MODULE_MANIFESTO_FILENAME","./xoops_version.php");

class Legacy_ModuleController extends XCube_ModuleController
{
	var $mModuleObject;

	function prepare()
	{
		// Is this request module process?
		if(!$this->isModuleProcess())
			return;

		$this->_createModuleObject();
			
		if(!$this->isActive())
			return;

		//
		// Set config values for this module
		//
		if($this->mModuleObject!=null) {
			if($this->mModuleObject->getVar('hasconfig')==1 || $this->mModuleObject->getVar('hascomments')==1) {
				$configHandler=&xoops_gethandler('config');
				$this->mConfig=&$configHandler->getConfigsByCat(0,$this->mModuleObject->getVar('mid'));
			}
			
			define('__XC_DIRNAME__', $this->mModuleObject->getVar('dirname'));
		}
	}

	/**
	 @return boolean
	 */
	function isModuleProcess()
	{
		return file_exists(LEGACY_XOOPS_MODULE_MANIFESTO_FILENAME);
	}
	
	function isActive()
	{
		return is_object($this->mModuleObject) && $this->mModuleObject->getVar('isactive');
	}
	
	/**
	 * @todo This method re-writes $GLOBAL['xoopsUserIsAdmin']! Wmm...
	 * @return bool
	 */
	function isPermission()
	{
		$xoopsUser =& $this->mController->mXoopsUser;
		$xoopsModule=&$this->mModuleObject;
        $modPermHandler =& xoops_gethandler('groupperm');

		if(is_object($xoopsUser)) {
			if (!$modPermHandler->checkRight('module_read', $xoopsModule->getVar('mid'), $xoopsUser->getGroups())) {
				return false;
			}
			$GLOBALS['xoopsUserIsAdmin']=$xoopsUser->isAdmin($xoopsModule->getVar('mid'));
			return true;
		}
		else {
			return $modPermHandler->checkRight('module_read', $xoopsModule->getVar('mid'), XOOPS_GROUP_ANONYMOUS);
		}
	}

	/**
	 @return void
	*/
	function _createModuleObject()
	{
		$moduleHandler=&xoops_gethandler('module');
		$this->mModuleObject=&$moduleHandler->getByDirname($this->_getDirname());
	}


	function _getDirname()
	{
	    $url_arr = explode("/",strstr($_SERVER['REQUEST_URI'],'/modules/'));
	    return $url_arr[2];
	}
	
	function setupLanguage()
	{
		$languageManager=&$this->mController->mRoot->getLanguageManager();
		$languageManager->loadModuleLanguage($this->mModuleObject->getVar('dirname'));
	}
	
	function _processErrorModuleNotExist()
	{
		// Wmm...
		require_once XOOPS_ROOT_PATH ."/header.php";
		print "<h4>" . _MODULENOEXIST . "</h4>";
		require_once XOOPS_ROOT_PATH ."/footer.php";
		exit();
	}

	function getModuleDir()
	{
		return XOOPS_ROOT_PATH."/modules/".$this->mModuleObject->getVar('dirname');
	}
	
	function &getXoopsModule()
	{
		return $this->mModuleObject;
	}
}
?>