<?php
// $Id: LegacyRenderActionFrame.class.php,v 1.1.2.1 2005/11/25 10:28:15 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                  Copyright (c) 2005 XOOPS Cube.org                        //
//                     <http://www.xoopscube.org/>                           //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

require_once XOOPS_ROOT_PATH."/class/XCube_ActionStrategy.class.php";

define ("LEGACY_RENDER_FRAME_PERFORM_SUCCESS",1);
define ("LEGACY_RENDER_FRAME_PERFORM_FAIL",2);
define ("LEGACY_RENDER_FRAME_INIT_SUCCESS",3);

define ("LEGACY_RENDER_FRAME_VIEW_NONE",0);
define ("LEGACY_RENDER_FRAME_VIEW_SUCCESS",1);
define ("LEGACY_RENDER_FRAME_VIEW_ERROR",2);
define ("LEGACY_RENDER_FRAME_VIEW_INDEX",3);
define ("LEGACY_RENDER_FRAME_VIEW_INPUT",4);

/**
 * This is simple frame work for misc page controller.
 * @package legacy
 */
class LegacyRenderActionFrame extends XCube_ActionStrategy
{
	var $mActionName="";
	var $mAction=null;
	
	function LegacyRenderActionFrame()
	{
	}
	
	function setActionName($actionName)
	{
		$this->mActionName=$actionName;
	}
	
	function execute(&$controller)
	{
		if($this->mActionName==null)
			$this->mActionName=isset($_REQUEST['action']) ? trim($_REQUEST['action']) : "default";

		if(!preg_match("/^\w+$/",$this->mActionName))
			die();


		//
		// Create action object by mActionName
		//
		$className="LegacyRender".ucfirst($this->mActionName)."Action";
		$fileName=XOOPS_ROOT_PATH."/modules/legacyRender/admin/actions/${className}.class.php";
		if(!file_exists($fileName))
			die();	// TODO
		
		require_once $fileName;
		if(class_exists($className))
				$this->mAction=new $className($controller,$controller->getXoopsUser());
		
		if(!is_object($this->mAction))
			die();	// TODO

		//
		// Simple execute action switch.
		//
		if(xoops_getenv("REQUEST_METHOD")=="POST") {
			$viewStatus=$this->mAction->execute($controller,$controller->getXoopsUser());
		}
		else {
			$viewStatus=$this->mAction->getDefaultView($controller,$controller->getXoopsUser());
		}


		//
		// Call the view stab method of action by $viewStatus
		//
		switch($viewStatus) {
			case LEGACY_RENDER_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;
			
			case LEGACY_RENDER_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;
			
			case LEGACY_RENDER_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;

			case LEGACY_RENDER_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;
		}
	}
}

class LegacyRenderAction
{
	var $mConfig;
	
	function LegacyRenderAction(&$controller,&$xoopsUser)
	{
		$this->mConfig=$controller->mModuleController->getConfig();
	}
	
	/**
	 * @param $controller Base_Controller
	 * @param $xoopsUser XoopsUserObject
	 */
	function getDefaultView(&$controller,&$xoopsUser)
	{
		return LEGACY_RENDER_FRAME_VIEW_NONE;
	}
	
	function execute(&$controller,&$xoopsUser)
	{
		return LEGACY_RENDER_FRAME_VIEW_NONE;
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
	}
}

?>