<?php

require_once XOOPS_MODULE_PATH."/user/forms/EditUserForm.class.php";

class UserEdituserAction extends UserAction
{
	var $mUid;
	var $mEditUser=null;
	var $mActionForm=null;
	
	function prepare(&$controller,&$xoopsUser)
	{
		$this->mUid=isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
		if($this->mUid!==0) {
			$memberHandler=&xoops_gethandler('member');
			$this->mEditUser=&$memberHandler->getUser($this->mUid);
		}
		else {
			$this->mUid=$xoopsUser->getVar('uid');
			$this->mEditUser=&$xoopsUser;
		}
	}

	function execute(&$controller,&$xoopsUser)
	{
		$this->_processActionForm($controller);
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if($this->mActionForm->hasError()) {
			return USER_FRAME_VIEW_INPUT;
		}
		else {
			$this->mActionForm->update($xoopsUser);
			$userHandler=&xoops_gethandler('user');
			$url="./userinfo.php?uid=".$xoopsUser->getVar('uid');
			if($userHandler->insert($xoopsUser)) {
				// SUCCESS
				$controller->executeForward($url);
			}
			else {
				// ERROR
				XCube_Utils::redirectHeader($url,1,"ERROR");	// TODO message
			}
		}
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_processActionForm($controller);
		$this->mActionForm->load($xoopsUser);

		return USER_FRAME_VIEW_INPUT;
	}
	
	function isSecure()
	{
		return true;
	}
	
	function _processActionForm(&$controller)
	{
		$this->mActionForm=new EditUserForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_edituser.html");
		$renderSystem->setAttribute("thisUser",$this->mEditUser);
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}
}

?>