<?php

require_once XOOPS_ROOT_PATH."/class/XCube_PageNavigator.class.php";
require_once XOOPS_MODULE_PATH."/user/admin/class/XoopsGroupEx.class.php";

/**
 *
 * This function keeps difficult problems that this depens on the column's block of X2 theme format.
 */
class UserGroupMemberAction extends UserAction
{
	var $mGroup = null;
	
	/**
	 * group member list.
	 */
	var $mUsers = array();
	var $mPageNavi = null;

	/**
	 * No group member list.
	 */
	var $mNoUsers = array();
	var $mNoPageNavi = null;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();
		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}

		$memberHandler =& xoops_gethandler('member');
		$groupid = $this->mGroup->getVar('groupid');

		//
		// Get member list
		//
		$total = $memberHandler->getUserCountByGroup($groupid);

		$this->mPageNavi=new XCube_PageNavigator("./index.php?action=GroupMember", $total, XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?
		$this->mPageNavi->addExtra('groupid', $groupid);

		$this->mPageNavi->fetch();
		
		$this->mUsers =& $memberHandler->getUsersByGroup($groupid, true, $this->mPageNavi->getPerpage(), $this->mPageNavi->getStart());

		//
		// Get no member list
		//
		$total = $memberHandler->getUserCountByNoGroup($groupid);

		$this->mNoPageNavi=new XCube_PageNavigator("./index.php?action=GroupMember", $total, XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?
		$this->mNoPageNavi->addExtra('groupid', $groupid);
		$this->mNoPageNavi->setPrefix("no");

		$this->mNoPageNavi->fetch();
		
		$this->mNoUsers =& $memberHandler->getUsersByNoGroup($groupid, true, $this->mNoPageNavi->getPerpage(), $this->mNoPageNavi->getStart());

		return USER_FRAME_VIEW_INDEX;
	}

	function execute(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();
		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}

		$memberHandler =& xoops_gethandler('member');
		
		if (isset($_POST['uid']) && is_array($_POST['uid'])) {
			foreach($_POST['uid'] as $uid => $value) {
				if ($value==1) {
					$memberHandler->addUserToGroup($this->mGroup->getVar('groupid'), $uid);
				}
				elseif ($value==2) {
					$memberHandler->removeUserFromGroup($this->mGroup->getVar('groupid'), $uid);
				}
			}
		}
		
		return $this->getDefaultView($controller, $xoopsUser);
	}

	function _loadGroup()
	{
		if (!is_object($this->mGroup)) {
			$groupId = isset($_REQUEST['groupid']) ? intval($_REQUEST['groupid']) : 0;

			$groupHandler =& xoops_gethandler('group');
			$group =& $groupHandler->get($groupId);
			if (is_object($group)) {
				$this->mGroup =& new XoopsGroupEx($group);
			}
		}
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("group_member.html");
		$render->setAttribute("group",$this->mGroup);

		$render->setAttribute("users",$this->mUsers);
		$render->setAttribute("pageNavi",$this->mPageNavi);

		$render->setAttribute("noUsers",$this->mNoUsers);
		$render->setAttribute("noPageNavi",$this->mNoPageNavi);
	}
}

?>