<?php

/**
 * WARNING : This class extends XoopsObject that is deprecated.
 */
class UserRankObject extends XoopsObject
{
	function UserRankObject($arr=null)
	{
		$this->initVar('rank_id',XOBJ_DTYPE_INT,null,true);
		$this->initVar('rank_title',XOBJ_DTYPE_TXTBOX,null,true,50);
		$this->initVar('rank_min',XOBJ_DTYPE_INT,0,true);
		$this->initVar('rank_max',XOBJ_DTYPE_INT,0,true);
		$this->initVar('rank_special',XOBJ_DTYPE_INT,null,true);
		$this->initVar('rank_image',XOBJ_DTYPE_TXTBOX,null,true,255);
		
		if($arr!=null && is_array($arr)) {
			$this->assignVars($arr);
		}
	}
}

class UserRankObjectHandler extends XoopsObjectHandler
{
	/**
	 * @return UserRankObject
	 */
	function &create()
	{
		$ret=new UserRankObject();
		$ret->setNew();
		
		return $ret;
	}

	/**
	 * @return UserRankObject
	 */
	function &get($rank_id)
	{
		$ret=null;

		$table=$this->db->prefix('ranks');
		$this->db->prepare("SELECT * FROM ${table} WHERE rank_id=?");
		$this->db->bind_param("i",$rank_id);
		$result=$this->db->execute();
		if(!$result)
			return $ret;

		if($row=$this->db->fetchArray($result)) {
			$ret=new UserRankObject($row);
		}
		
		return $ret;
	}

	function &getObjects($criteria=null)
	{
	}
	
	function getCount($criteria=null)
	{
	}
	
	function insert(&$rank)
	{
		if(!is_a($rank,"UserRankObject"))
			return false;

		$table=$this->db->prefix('ranks');

		if($rank->isNew()) {
			$sql="INSERT INTO ${table} (rank_id,rank_title,rank_min,rank_max,rank_special,rank_image) " .
				"VALUES ( ?, ?, ?, ?, ?, ?)";

			$this->db->prepare($sql);
			$this->db->bind_param("isiiis",
								$rank->getProperty('rank_id'),
								$rank->getProperty('rank_title'),
								$rank->getProperty('rank_min'),
								$rank->getProperty('rank_max'),
								$rank->getProperty('rank_special'),
								$rank->getProperty('rank_image') );
		}
		else {
			$sql="UPDATE ${table} SET rank_title=?,rank_min=?,rank_max=?,rank_special=?,rank_image=? WHERE rank_id=?";

			$this->db->prepare($sql);
			$this->db->bind_param("siiisi",
								$rank->getProperty('rank_title'),
								$rank->getProperty('rank_min'),
								$rank->getProperty('rank_max'),
								$rank->getProperty('rank_special'),
								$rank->getProperty('rank_image'),
								$rank->getProperty('rank_id') );
		}

		$result=$this->db->execute();
		
		//
		// Return
		//
		return $result ? true : false;
	}
	
	function delete($rankObj)
	{
		if(!is_a($rankObj,"UserRankObject"))
			return false;

		$table=$this->db->prefix('ranks');
		$this->db->prepare("DELETE FROM ${table} WHERE rank_id=?");
		$this->db->bind_param("i",$rankObj->getVar('rank_id'));
		$result=$this->db->execute();

		if(!$result)
			return false;

		@unlink(XOOPS_UPLOAD_PATH."/".$rankObj->getVar('rank_image'));

		return true;
	}

	/**
	 * @return UserRank[] If the handler cann't get result, then this returns null.
	 */
	function enumAll($special=null,$sort='rank_id',$order='ASC')
	{
		$ret=null;

		$sql="SELECT * FROM " . $this->db->prefix('ranks');
		if($special!=null) {
			$sql .= " WHERE special=".intval($special);
		}
		$sql.=" ORDER BY ${sort} ${order}";

		$result=$this->db->query($sql);
		if(!$result)
			return $ret;

		while($row=$this->db->fetchArray($result)) {
			$ret[]=new UserRankObject($row);
		}
		
		return $ret;
	}

	/**
	 * @param $special int
	 * @return int
	 */
	function countAll($special=null)
	{
		$sql="SELECT COUNT(*) FROM " . $this->db->prefix('ranks');
		if($special!=null) {
			$sql .= " WHERE special=".intval($special);
		}

		$result=$this->db->query($sql);
		if(!$result)
			return 0;

		list($count)=$this->db->fetchRow($result);
		return $count;
	}
}

?>