<?php

class UserRegistMailDirector
{
	var $mBuilder;
	var $mUser;
	var $mXoopsConfig;
	var $mUserConfig;

	function UserRegistMailDirector(&$user,$xoopsConfig,$userConfig)
	{
		$this->mUser=&$user;
		$this->mXoopsConfig=$xoopsConfig;
		$this->mUserConfig=$userConfig;
	}
	
	function contruct(&$builder)
	{
		$builder->setTemplate();
		$builder->setToUsers($this->mUser,$this->mUserConfig);
		$builder->setFromEmail($this->mXoopsConfig);
		$builder->setSubject($this->mUser,$this->mXoopsConfig);
		$builder->setBody($this->mUser,$this->mXoopsConfig);
	}
}

class RegistUserActivateMailBuilder
{
	var $mMailer;
	
	function RegistUserActivateMailBuilder()
	{
		$this->mMailer=&getMailer();
		$this->mMailer->userMail();
	}

	function setTemplate()
	{
		$this->mMailer->setTemplate("register.tpl");
	}

	function setToUsers($user,$userConfig)
	{
		$this->mMailer->setToUsers($user);
	}
	
	function setFromEmail($xoopsConfig)
	{
		$this->mMailer->setFromEmail($xoopsConfig['adminmail']);
		$this->mMailer->setFromName($xoopsConfig['sitename']);
	}
	
	function setSubject($user,$xoopsConfig)
	{
		$this->mMailer->setSubject(@sprintf(_US_USERKEYFOR,$user->getVar('uname')));
	}

	function setBody($user,$xoopsConfig)
	{
		$this->mMailer->assign("SITENAME",$xoopsConfig['sitename']);
		$this->mMailer->assign("ADMINMAIL",$xoopsConfig['adminmail']);
		$this->mMailer->assign("SITEURL",XOOPS_URL."/");
	}
	
	function &getResult()
	{
		$this->mMailer;
	}
}

class RegistUserAdminActivateMailBuilder extends RegistUserActivateMailBuilder
{
	function setTemplate()
	{
		$this->mMailer->setTemplate("adminactivate.tpl");
	}

	function setToUsers($user,$userConfig)
	{
		$memberHandler=&xoops_gethandler('member');
		$this->mMailer->setToGroups($memberHandler->getGroup($userConfig['activation_group']));
		$this->mMailer->setToUsers($user);
	}
	
	function setFromUser($xoopsConfig)
	{
		$this->mMailer->setFromEmail($xoopsConfig['adminmail']);
		$this->mMailer->setFromName($xoopsConfig['sitename']);
	}
	
	function setSubject($user,$xoopsConfig)
	{
		$this->mMailer->setSubject(@sprintf(_US_USERKEYFOR,$user->getVar('uname')));
	}

	function setBody($user,$xoopsConfig)
	{
		parent::doAssign();
		$this->mMailer->assign('USERNAME', $user->getVar('uname'));
		$this->mMailer->assign('USEREMAIL', $user->getVar('email'));
		$this->mMailer->assign('USERACTLINK', XOOPS_URL.'/user.php?op=actv&id='.$user->getVar('uid').'&actkey='.$user->getVar('actkey'));
	}
}

class RegistUserNotifyMailBuilder extends RegistUserNotifyMail
{
	function setTemplate()
	{
	}

	function setToUsers($user,$userConfig)
	{
		$memberHandler=&xoops_gethandler('member');
		$this->mMailer->setToGroups($memberHandler->getGroup($userConfig['new_user_notify_group']));
	}
	
	function setFromUser($xoopsConfig)
	{
		$this->mMailer->setFromEmail($xoopsConfig['adminmail']);
		$this->mMailer->setFromName($xoopsConfig['sitename']);
	}
	
	function setSubject($user,$xoopsConfig)
	{
		$this->mMailer->setSubject(@sprintf(_US_NEWUSERREGAT,$xoopsConfig['sitename']));
	}

	function setBody($user,$xoopsConfig)
	{
		$xoopsMailer->setBody(@printf(_US_HASJUSTREG,$uname->getVar('uname')));
	}
}


?>