<?php
/**
 * @version $Id: XCube_Root.class.php,v 1.1.2.10 2006/01/24 14:21:32 minahito Exp $
 * @package Cube
 */

/**
 * This class offers the access course same as global variable for a logic in old mechanism.
 * This class does not let you depend on a main controller class name
 * You must not succeed to this class.
 *
 * @final
 */
class XCube_Root
{
	/**
	@access private
	*/
	var $mController=null;
	
	/**
	 * @access private
	 */
	var $mFeatureManager=null;

	/**
	 * @access private ?
	 */
	var $mLanguageManager=null;
	
	var $mEventManager=null;
	
	var $mServiceManager=null;

	/**
	 * @deprecated
	 */
	var $mRenderSystem=null;
	
	var $mRenderSystems=array();
	
	var $mSiteConfig=array();
	
	/**
	 * THIS IS TEST
	 * 
	 * Why this is public is that PHP4 does not give property overload to us.
	 * This naming rule is test, too.
	 * 
	 * @access public
	 */
	var $ContentManager=null;
	
	/**
	 * THIS IS TEST
	 * 
	 * Why this is public is that PHP4 does not give property overload to us.
	 * This naming rule is test, too.
	 * 
	 * @access public
	 */
	var $ModifierManager=null;

	/**
	 * The theme is one in one time of request.
	 * A decided theme is registered with this property
	 *
	 * @access private
	 */
	var $mThemeName = null;

	var $mCacheSystem = null;

	function XCube_Root()
	{
	}

	/**
	 * @return XCube_Root
	 */
	function &getSingleton()
	{
		static $instance;
		if(!isset($instance))
			$instance=new XCube_Root();
		
		return $instance;
	}

	/**
	 * Load SiteConfig from plural files, and control set and override site config.
	 */
	function loadSiteConfig()
	{
		if(func_num_args()==0)
			die("FETAL: You doesn't have site setting config.");

		$file=func_get_arg(0);
		if(!file_exists($file))
			die("FETAL: You cann't open site setting config.");
		
		$this->setSiteConfig(parse_ini_file($file,true));

		//
		// Override setting.
		//
		if(func_num_args()>1) {
			for($i=1;$i<func_num_args();$i++) {
				$overrideFile=func_get_arg($i);
				
				if(file_exists($overrideFile))
					$this->overrideSiteConfig(parse_ini_file($overrideFile,true));
			}
		}
	}
	
	function setSiteConfig($config)
	{
		$this->mSiteConfig=$config;
	}
	
	/**
	 * Override site config. SiteConfig is overrided by $config value. And, if $config has new key, the key is set.
	 */
	function overrideSiteConfig($config)
	{
		foreach($config as $_overKey=>$_overVal) {
			if(array_key_exists($_overKey,$this->mSiteConfig)) {
				$this->mSiteConfig[$_overKey]=array_merge($this->mSiteConfig[$_overKey],$_overVal);
			}
			else {
				$this->mSiteConfig[$_overKey]=$_overVal;
			}
		}
	}

	function getSiteConfig()
	{
		//
		// TODO Check keys with using 'isset'
		//
		if(func_num_args()==0) {
			return $this->mSiteConfig;
		}
		elseif(func_num_args()==1) {
			if(isset($this->mSiteConfig[func_get_arg(0)]))
				return $this->mSiteConfig[func_get_arg(0)];
		}
		elseif(func_num_args()==2) {
			if(isset($this->mSiteConfig[func_get_arg(0)][func_get_arg(1)]))
				return $this->mSiteConfig[func_get_arg(0)][func_get_arg(1)];
		}

		return null;
	}

	/**
	 * Create controller with own site setting.
	 */
	function setupController()
	{
		//
		// [NOTICE]
		// We don't decide the style of SiteConfig.
		//
		$controllerName = $this->mSiteConfig['Cube']['Controller'];
		$this->mController=&$this->_createInstance($this->mSiteConfig[$controllerName]['class'],$this->mSiteConfig[$controllerName]['path']);
		$this->mController->prepare($this);
	}

	function &getController()
	{
		return $this->mController;
	}

	function setFeatureManager(&$featureManager)
	{
		$this->mFeatureManager=&$featureManager;
	}
	
	function &getFeatureManager()
	{
		return $this->mFeatureManager;
	}
	
	function setLanguageManager(&$languageManager)
	{
		$this->mLanguageManager=&$languageManager;
	}
	
	function &getLanguageManager()
	{
		return $this->mLanguageManager;
	}
	
	function setEventManager(&$eventManager)
	{
		$this->mEventManager=&$eventManager;
	}
	
	function &getEventManager()
	{
		return $this->mEventManager;
	}
	
	function setServiceManager(&$serviceManager)
	{
		$this->mServiceManager=&$serviceManager;
	}
	
	function &getServiceManager()
	{
		return $this->mServiceManager;
	}
	
	function setModifierManager(&$modifierManager)
	{
		$this->ModifierManager=&$modifierManager;
	}
	
	function &getModifierManager()
	{
		return $this->ModifierManager;
	}

	function setThemeName($theme)
	{
		$this->mThemeName = $theme;
	}
	
	function getThemeName()
	{
		return $this->mThemeName;
	}
	
	function &getCacheSystem()
	{
		if (!is_object($this->mCacheSystem)) {
			$this->mCacheSystem =& $this->_createInstance($this->mSiteConfig['Cube']['CacheSystem.class'], $this->mSiteConfig['Cube']['CacheSystem.path']);
		}

		return $this->mCacheSystem;
	}
	
	function &getRenderSystem($name)
	{
		if (isset($this->mRenderSystems[$name])) {
			return $this->mRenderSystems[$name];
		}
		
		//
		// create
		//
		$chunkName = $this->mSiteConfig['RenderSystems'][$name];
		$this->mRenderSystems[$name] =& $this->_createInstance($this->mSiteConfig[$chunkName]['class'], $this->mSiteConfig[$chunkName]['path']);
		
		if (!is_object($this->mRenderSystems[$name])) {
			die("NO");
		}
		
		$this->mRenderSystems[$name]->prepare($this->mController);
		
		return $this->mRenderSystems[$name];
	}

	function &_createInstance($className, $classPath=null)
	{
		$ret = null;
		
		if($classPath!=null) {
			require_once XOOPS_ROOT_PATH . "/" . $classPath . "/" . $className . ".class.php";
		}
		
		if(class_exists($className)) {
			$ret =& new $className();
		}

		return $ret;
	}
}

?>