<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/EditUserForm.class.php";

class User_EditUserAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_gethandler('user');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm=new EditUserForm();
		$this->mActionForm->prepare();
	}
	
	function isEnableCreate()
	{
		return false;
	}

	function isSecure()
	{
		return true;
	}
	
	function isPerm(&$controller, &$xoopsUser, &$moduleConfig)
	{
		if ($this->mObject != null) {
			return ($this->mObject->get('uid') == $xoopsUser->get('uid') || $xoopsUser->isAdmin());
		}
		
		return false;
	}

	function executeViewInput(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("user_edituser.html");
		$render->setAttribute("actionForm",$this->mActionForm);
		$render->setAttribute("thisUser",$this->mObject);
		$render->setAttribute("currentUser",$xoopsUser);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$controller->executeForward('./index.php?action=UserInfo&uid=' . $this->mObject->get('uid'));
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		redirect_header(XOOPS_URL, 1, _MD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>