<?php

/**
 * Receive $_GET['uid']
 */
class User_UserInfoAction extends User_Action
{
	var $mObject = null;
	var $mRankObject = null;
	var $mSearchResults = null;

	function isSecure()
	{
		return false;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$uid = isset($_GET['uid']) ? intval($_GET['uid']) : 0;
		
		$handler =& xoops_gethandler('user');
		$this->mObject =& $handler->get($uid);
		
		if (!is_object($this->mObject)) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		$rankHandler =& xoops_getmodulehandler('ranks');
		$this->mRankObject =& $rankHandler->get($this->mObject->get('rank'));
		
		$root =& $controller->mRoot;
		$service =& $root->mServiceManager->searchXCubeService("LegacySearch");
		if ($service) {
			$current_uid = is_object($xoopsUser) ? $xoopsUser->get('uid') : 0;
			
			$client =& new XCube_ServiceClient($service);

			$parameters = array("uid" => $uid, 'current_uid' => $current_uid);
			$this->mSearchResults = $client->call("getItems", $parameters);
		}

		return USER_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_userinfo.html");
		$render->setAttribute("thisUser", $this->mObject);
		$render->setAttribute("rank", $this->mRankObject);

		$myts =& MyTextSanitizer::getInstance();
		$userSignature = $myts->makeTareaData4Show($this->mObject->get('user_sig'), 0, 1, 1);
		
		$render->setAttribute('user_signature', $userSignature);

		$render->setAttribute("searchResults", $this->mSearchResults);
		
		//
		// set flags.
		//
		$user_ownpage = (is_object($xoopsUser) && $xoopsUser->get('uid') == $this->mObject->get('uid'));
		$render->setAttribute("user_ownpage", $user_ownpage);
	}
	
	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php");
	}
}

?>