<?php

require_once XOOPS_MODULE_PATH."/user/forms/UserRegisterEditForm.class.php";

class User_UserRegisterAction extends User_Action
{
	var $mActionForm=null;
	var $mConfig;
	var $mEnableAgreeFlag=false;

	function prepare(&$controller,&$xoopsUser)
	{
		$this->mConfig=$controller->mModuleController->getConfig();
		
		//
		// If user is registered, kick to his information page.
		//
		if(is_object($xoopsUser))
			$controller->executeForward(XOOPS_URL."/user.php");
	}

	function execute(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if($this->mActionForm->hasError()) {
			return USER_FRAME_VIEW_INPUT;
		}
		else {
			$_SESSION['user_register_actionform']=serialize(&$this->mActionForm);
			$controller->executeForward('./index.php?action=UserRegister_confirm');
		}
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->_processActionForm();

		return USER_FRAME_VIEW_INPUT;
	}
	
	function _processActionForm()
	{
		if($this->mConfig['reg_dispdsclmr']!=0 && $this->mConfig['reg_disclaimer']!=null) {
			$this->mEnableAgreeFlag=true;
			$this->mActionForm=new UserRegisterAgreeEditForm();
		}
		else {
			$this->mActionForm=new UserRegisterEditForm();
		}
		
		$this->mActionForm->prepare($this->mConfig);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		//
		// Get some objects for input form.
		//
		$tzoneHandler =& xoops_gethandler('timezone');
		$timezones =& $tzoneHandler->getObjects();
		
		$renderSystem->setAttribute('timezones', $timezones);

		$renderSystem->setTemplateName("user_register_form.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
		$renderSystem->setAttribute("enableAgree",$this->mEnableAgreeFlag);
		if($this->mEnableAgreeFlag)
			$renderSystem->setAttribute("disclaimer",$this->mConfig['reg_disclaimer']);
	}
}

?>