<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/AvatarAdminDeleteForm.class.php";

class User_AvatarDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return isset($_REQUEST['avatar_id']) ? $_REQUEST['avatar_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('avatar');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new AvatarAdminDeleteForm();
		$this->mActionForm->prepare();
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("avatar_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=AvatarList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=AvatarList", 1, _AD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>
