<?php

require_once XOOPS_MODULE_PATH . "/user/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/GroupFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/class/XoopsGroupEx.class.php";

class User_GroupListAction extends User_AbstractListAction
{
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('groups');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new User_GroupFilterForm($navi);
		return $filter;
	}

	function _getBaseUrl()
	{
		return "./index.php?action=GroupsList";
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$groups = array();
		foreach ($this->mObjects as $_group) {
			$groups[] =& new XoopsGroupEx($_group);
		}

		$render->setTemplateName("group_list.html");
		$render->setAttribute("objects", $groups);
		$render->setAttribute("pageNavi", $this->mNavi);
	}
}

?>
