<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserAdminEditForm.class.php";

class User_UserEditAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new User_UserAdminEditForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("user_edit.html");
		$render->setAttribute("actionForm",$this->mActionForm);

		//
		// Get some objects for input form.
		//
		$tzoneHandler =& xoops_gethandler('timezone');
		$timezones =& $tzoneHandler->getObjects();
		
		$render->setAttribute('timezones', $timezones);

		$rankHandler =& xoops_getmodulehandler('ranks');
		$ranks =& $rankHandler->getObjects(new Criteria('rank_special',1));

		$render->setAttribute('ranks', $ranks);
		
		$groupHandler =& xoops_gethandler('group');
		$groups =& $groupHandler->getObjects(null, true);
		
		$groupOptions = array();
		foreach ($groups as $gid => $group) {
			$groupOptions[$gid] = $group->getVar('name');
		}

		$render->setAttribute('groupOptions', $groupOptions);

		//
		// umode option
		//
		$umodeOptions = array("nest" => _NESTED, "flat" => _FLAT, "thread" => _THREADED);
		$render->setAttribute('umodeOptions', $umodeOptions);

		//		
		// uorder option
		//
		$uorderOptions = array(0 => _OLDESTFIRST, 1 => _NEWESTFIRST);
		$render->setAttribute('uorderOptions', $uorderOptions);


		//
		// notify option
		//

		// Because abstract message catalog style is not decided, we load directly.
		$root =& XCube_Root::getSingleton();
		require_once XOOPS_ROOT_PATH . "/language/" . $root->mController->getConfig('language') . "/notification.php";
		require_once XOOPS_ROOT_PATH . "/include/notification_constants.php";

		$methodOptions = array(XOOPS_NOTIFICATION_METHOD_DISABLE => _NOT_METHOD_DISABLE,
		                         XOOPS_NOTIFICATION_METHOD_PM => _NOT_METHOD_PM,
		                         XOOPS_NOTIFICATION_METHOD_EMAIL => _NOT_METHOD_EMAIL
		                   );
		$render->setAttribute('notify_methodOptions', $methodOptions);
		
		$modeOptions = array(XOOPS_NOTIFICATION_MODE_SENDALWAYS => _NOT_MODE_SENDALWAYS,
		                       XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE => _NOT_MODE_SENDONCE,
		                       XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT => _NOT_MODE_SENDONCEPERLOGIN
		                 );
		$render->setAttribute('notify_modeOptions', $modeOptions);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$controller->executeForward("./index.php?action=UserList");
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("index.php", 1, "*ERROR*");
	}
}

?>