<?php

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/RankEditForm.class.php";

class UserRankEditAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['rank_id']) ? intval($_REQUEST['rank_id']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('rank');
		return $handler;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm=new RankEditForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("?action=RankList",1,_MD_A_USER_MESSAGE_SAVE_RANK_SUCCESS);
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("?action=RankList",1,_MD_A_USER_ERROR_RAISE_ERROR);
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_admin_rankedit_input.html");
		$renderSystem->setAttribute("actionForm",$this->mActionForm);
	}
}

?>