<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";

/**
 * This class is generated by makeActionForm tool.
 */
class User_UserAdminEditForm extends XCube_ActionForm
{
	var $_mIsNew;
	
	function getTokenName()
	{
		return "module.user.UserAdminEditForm.Token";
	}
	
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
		$this->mFormProperties['name'] =& new XCube_StringProperty('name');
		$this->mFormProperties['uname'] =& new XCube_StringProperty('uname');
		$this->mFormProperties['email'] =& new XCube_StringProperty('email');
		$this->mFormProperties['url'] =& new XCube_StringProperty('url');
		$this->mFormProperties['user_icq'] =& new XCube_StringProperty('user_icq');
		$this->mFormProperties['user_from'] =& new XCube_StringProperty('user_from');
		$this->mFormProperties['user_sig'] =& new XCube_TextProperty('user_sig');
		$this->mFormProperties['user_viewemail'] =& new XCube_IntProperty('user_viewemail');
		$this->mFormProperties['user_aim'] =& new XCube_StringProperty('user_aim');
		$this->mFormProperties['user_yim'] =& new XCube_StringProperty('user_yim');
		$this->mFormProperties['user_msnm'] =& new XCube_StringProperty('user_msnm');
		$this->mFormProperties['pass'] =& new XCube_StringProperty('pass');
		$this->mFormProperties['vpass'] =& new XCube_StringProperty('vpass');
		$this->mFormProperties['posts'] =& new XCube_IntProperty('posts');
		$this->mFormProperties['attachsig'] =& new XCube_IntProperty('attachsig');
		$this->mFormProperties['rank'] =& new XCube_IntProperty('rank');
		$this->mFormProperties['level'] =& new XCube_IntProperty('level');
		$this->mFormProperties['timezone_offset'] =& new XCube_FloatProperty('timezone_offset');
		$this->mFormProperties['umode'] =& new XCube_StringProperty('umode');
		$this->mFormProperties['uorder'] =& new XCube_IntProperty('uorder');
		$this->mFormProperties['notify_method'] =& new XCube_IntProperty('notify_method');
		$this->mFormProperties['notify_mode'] =& new XCube_IntProperty('notify_mode');
		$this->mFormProperties['user_occ'] =& new XCube_StringProperty('user_occ');
		$this->mFormProperties['bio'] =& new XCube_TextProperty('bio');
		$this->mFormProperties['user_intrest'] =& new XCube_StringProperty('user_intrest');
		$this->mFormProperties['user_mailok'] =& new XCube_IntProperty('user_mailok');
		$this->mFormProperties['groups'] =& new XCube_IntArrayProperty('groups');

		//
		// Set field properties
		//
		$this->mFieldProperties['uid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_UID);

		$this->mFieldProperties['name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['name']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_NAME, '60');
		$this->mFieldProperties['name']->addVar('maxlength', 60);

		$this->mFieldProperties['uname'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uname']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['uname']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_UNAME, '25');
		$this->mFieldProperties['uname']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_UNAME, '25');
		$this->mFieldProperties['uname']->addVar('maxlength', 25);

		$this->mFieldProperties['email'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['email']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_EMAIL, '60');
		$this->mFieldProperties['email']->setDependsByArray(array('required', 'maxlength'));
		$this->mFieldProperties['email']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_EMAIL, '60');
		$this->mFieldProperties['email']->addVar('maxlength', 60);

		$this->mFieldProperties['url'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['url']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['url']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_URL, '100');
		$this->mFieldProperties['url']->addVar('maxlength', 100);

		$this->mFieldProperties['user_icq'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_icq']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_icq']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_ICQ, '15');
		$this->mFieldProperties['user_icq']->addVar('maxlength', 15);

		$this->mFieldProperties['user_from'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_from']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_from']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_FROM, '100');
		$this->mFieldProperties['user_from']->addVar('maxlength', 100);

		$this->mFieldProperties['user_sig'] =& new XCube_FieldProperty($this);
//		$this->mFieldProperties['user_sig']->setDependsByArray(array(''));
//		$this->mFieldProperties['user_sig']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_USER_SIG);

		$this->mFieldProperties['user_viewemail'] =& new XCube_FieldProperty($this);
//		$this->mFieldProperties['user_viewemail']->setDependsByArray(array(''));

		$this->mFieldProperties['user_aim'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_aim']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_aim']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_AIM, '18');
		$this->mFieldProperties['user_aim']->addVar('maxlength', 18);

		$this->mFieldProperties['user_yim'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_yim']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_yim']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_YIM, '25');
		$this->mFieldProperties['user_yim']->addVar('maxlength', 25);

		$this->mFieldProperties['user_msnm'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_msnm']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_msnm']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_MSNM, '100');
		$this->mFieldProperties['user_msnm']->addVar('maxlength', 100);

		$this->mFieldProperties['pass'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['pass']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['pass']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_PASS, '32');
		$this->mFieldProperties['pass']->addVar('maxlength', 32);

		$this->mFieldProperties['vpass'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['vpass']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['vpass']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_PASS, '32');
		$this->mFieldProperties['vpass']->addVar('maxlength', 32);

		$this->mFieldProperties['posts'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['posts']->setDependsByArray(array('required'));
		$this->mFieldProperties['posts']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_POSTS);

		$this->mFieldProperties['attachsig'] =& new XCube_FieldProperty($this);
//		$this->mFieldProperties['attachsig']->setDependsByArray(array(''));

		$this->mFieldProperties['rank'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['rank']->setDependsByArray(array('required'));
		$this->mFieldProperties['rank']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_RANK);

		$this->mFieldProperties['level'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['level']->setDependsByArray(array('required'));
		$this->mFieldProperties['level']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_LEVEL);

		$this->mFieldProperties['timezone_offset'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['timezone_offset']->setDependsByArray(array('required'));
		$this->mFieldProperties['timezone_offset']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_TIMEZONE_OFFSET);

		$this->mFieldProperties['umode'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['umode']->setDependsByArray(array('required'));
		$this->mFieldProperties['umode']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_UMODE);

		$this->mFieldProperties['uorder'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uorder']->setDependsByArray(array('required','intRange'));
		$this->mFieldProperties['uorder']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_UORDER);
		$this->mFieldProperties['uorder']->addMessage('intRange', _AD_USER_ERROR_INJURY, _AD_USER_LANG_UORDER);
		$this->mFieldProperties['uorder']->addVar('min', 0);
		$this->mFieldProperties['uorder']->addVar('max', 1);

		$this->mFieldProperties['notify_method'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['notify_method']->setDependsByArray(array('required','intRange'));
		$this->mFieldProperties['notify_method']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_NOTIFY_METHOD);
		$this->mFieldProperties['notify_method']->addMessage('intRange', _AD_USER_ERROR_INJURY, _AD_USER_LANG_NOTIFY_METHOD);
		$this->mFieldProperties['notify_method']->addVar('min', 0);
		$this->mFieldProperties['notify_method']->addVar('max', 2);

		$this->mFieldProperties['notify_mode'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['notify_mode']->setDependsByArray(array('required','intRange'));
		$this->mFieldProperties['notify_mode']->addMessage('required', _AD_USER_ERROR_REQUIRED, _AD_USER_LANG_NOTIFY_MODE);
		$this->mFieldProperties['notify_mode']->addMessage('intRange', _AD_USER_ERROR_INJURY, _AD_USER_LANG_NOTIFY_MODE);
		$this->mFieldProperties['notify_mode']->addVar('min', 0);
		$this->mFieldProperties['notify_mode']->addVar('max', 2);

		$this->mFieldProperties['user_occ'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_occ']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_occ']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_OCC, '100');
		$this->mFieldProperties['user_occ']->addVar('maxlength', 100);

		$this->mFieldProperties['bio'] =& new XCube_FieldProperty($this);
//		$this->mFieldProperties['bio']->setDependsByArray(array(''));

		$this->mFieldProperties['user_intrest'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['user_intrest']->setDependsByArray(array('maxlength'));
		$this->mFieldProperties['user_intrest']->addMessage('maxlength', _AD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_INTREST, '150');
		$this->mFieldProperties['user_intrest']->addVar('maxlength', 150);

		$this->mFieldProperties['user_mailok'] =& new XCube_FieldProperty($this);
//		$this->mFieldProperties['user_mailok']->setDependsByArray(array(''));
	}
	
	function validateUname()
	{
		if ($this->get('uname') != null) {
			$handler =& xoops_gethandler('user');
			$criteria =& new CriteriaCompo(new Criteria('uname', $this->get('uname')));
			if ($this->get('uid')) {
				$criteria->add(new Criteria('uid', $this->get('uid'), '<>'));
			}
			if ($handler->getCount($criteria) > 0) {
				$this->addErrorMessage(_AD_USER_ERROR_UNAME_NO_UNIQUE);
			}
		}
	}
	
	function validateGroups()
	{
		$groupHandler =& xoops_gethandler('group');
		foreach ($this->get('groups') as $gid) {
			$group =& $groupHandler->get($gid);
			if (!is_object($group)) {
				$this->addErrorMessage(_AD_USER_ERROR_GROUP_VALUE);
			}
		}
	}
	
	function validatePass()
	{
		if (strlen($this->get('pass'))) {
			if ($this->get('pass') != $this->get('vpass')) {
				$this->addErrorMessage(_AD_USER_ERROR_PASSWORD);
				$this->set('pass', '');
				$this->set('vpass', '');
			}
		}
		elseif($this->_mIsNew) {
				$this->addErrorMessage(_AD_USER_ERROR_PASSWORD_REQUIRED);
		}
	}
	
	function validateUmode()
	{
		if (!in_array($this->get('umode'), array('nest', 'flat', 'thread'))) {
			$this->addErrorMessage(_AD_USER_ERROR_UMODE);
		}
	}
	
	function load(&$obj)
	{
		$this->set('uid', $obj->get('uid'));
		$this->set('name', $obj->get('name'));
		$this->set('uname', $obj->get('uname'));
		$this->set('email', $obj->get('email'));
		$this->set('url', $obj->get('url'));
		$this->set('user_icq', $obj->get('user_icq'));
		$this->set('user_from', $obj->get('user_from'));
		$this->set('user_sig', $obj->get('user_sig'));
		$this->set('user_viewemail', $obj->get('user_viewemail'));
		$this->set('user_aim', $obj->get('user_aim'));
		$this->set('user_yim', $obj->get('user_yim'));
		$this->set('user_msnm', $obj->get('user_msnm'));

		$this->set('posts', $obj->get('posts'));
		$this->set('attachsig', $obj->get('attachsig'));
		$this->set('rank', $obj->get('rank'));
		$this->set('level', $obj->get('level'));
		$this->set('timezone_offset', $obj->get('timezone_offset'));
		$this->set('umode', $obj->get('umode'));
		$this->set('uorder', $obj->get('uorder'));
		$this->set('notify_method', $obj->get('notify_method'));
		$this->set('notify_mode', $obj->get('notify_mode'));
		$this->set('user_occ', $obj->get('user_occ'));
		$this->set('bio', $obj->get('bio'));
		$this->set('user_intrest', $obj->get('user_intrest'));
		$this->set('user_mailok', $obj->get('user_mailok'));
		
		$this->_mIsNew = $obj->isNew();

		$groups =& $obj->getGroups();
		$i = 0;
		foreach ($groups as $gid) {
			$this->set('groups', $i++, $gid);
		}
	}

	function update(&$obj)
	{
		$obj->setVar('uid', $this->get('uid'));
		$obj->setVar('name', $this->get('name'));
		$obj->setVar('uname', $this->get('uname'));
		$obj->setVar('email', $this->get('email'));
		$obj->setVar('url', $this->get('url'));
		$obj->setVar('user_icq', $this->get('user_icq'));
		$obj->setVar('user_from', $this->get('user_from'));
		$obj->setVar('user_sig', $this->get('user_sig'));
		$obj->setVar('user_viewemail', $this->get('user_viewemail'));
		$obj->setVar('user_aim', $this->get('user_aim'));
		$obj->setVar('user_yim', $this->get('user_yim'));
		$obj->setVar('user_msnm', $this->get('user_msnm'));

		if (strlen($this->get('pass'))) {
			$obj->set('pass', md5($this->get('pass')));
		}

		$obj->setVar('posts', $this->get('posts'));
		$obj->setVar('attachsig', $this->get('attachsig'));
		$obj->setVar('rank', $this->get('rank'));
		$obj->setVar('level', $this->get('level'));
		$obj->setVar('timezone_offset', $this->get('timezone_offset'));
		$obj->setVar('umode', $this->get('umode'));
		$obj->setVar('uorder', $this->get('uorder'));
		$obj->setVar('notify_method', $this->get('notify_method'));
		$obj->setVar('notify_mode', $this->get('notify_mode'));
		$obj->setVar('user_occ', $this->get('user_occ'));
		$obj->setVar('bio', $this->get('bio'));
		$obj->setVar('user_intrest', $this->get('user_intrest'));
		$obj->setVar('user_mailok', $this->get('user_mailok'));
//		$obj->setVar('groups', $this->get('groups'));
		
		$obj->Groups = array();
		$groups = $this->get('groups');
		
		foreach ($groups as $gid) {
			$obj->Groups[] = $gid;
		}
	}
}

?>
