<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

//
// TODO
//
require_once XOOPS_ROOT_PATH."/modules/legacyRender/kernel/Legacy_RenderSystem.class.php";

define('LEGACY_ADMIN_RENDER_TEMPLATE_DIRNAME', "templates");

define('LEGACY_ADMIN_RENDER_FALLBACK_PATH', XOOPS_MODULE_PATH . "/base/admin/theme");
define('LEGACY_ADMIN_RENDER_FALLBACK_URL', XOOPS_MODULE_URL . "/base/admin/theme");

require_once XOOPS_ROOT_PATH."/class/smarty/Smarty.class.php";

/**
 * This class extends Smarty to mediate the collision compiled file name.
 */
class Legacy_AdminSmarty extends Smarty
{
	var $mModulePrefix = null;

	//
	// If you don't hope to override for theme, set false.
	//
	var $overrideMode = true;
	
	function Legacy_AdminSmarty()
	{
		parent::Smarty();

		$this->compile_id = null;
		$this->_canUpdateFromFile = true;
		$this->compile_check = true;
		$this->compile_dir = XOOPS_COMPILE_PATH;
		$this->left_delimiter = "<{";
		$this->right_delimiter = "}>";

		$this->register_modifier("theme", "Legacy_modifier_theme");
		$this->register_function("stylesheet", "Legacy_function_stylesheet");
		
		//
		// [TODO]
		//  If we don't set true to the following flag, a user can not recover
		// with deleting additional theme. But, a user should to select true or
		// false by site_custom.ini.php.
		//
		$this->force_compile = false;
	}
	
	function setModulePrefix($prefix)
	{
		$this->mModulePrefix = $prefix;
	}
	
	function _get_auto_filename($autoBase, $autoSource = null, $auotId = null)
	{
		$autoSource = $this->mModulePrefix . "_admin_" . $autoSource;
		return parent::_get_auto_filename($autoBase, $autoSource, $auotId);
	}

	function _fetch_resource_info(&$params)
	{
		$_return = false;

		$root =& XCube_Root::getSingleton();
		$theme = $root->mSiteConfig['Legacy']['Theme'];
		$dirname = $this->mModulePrefix;
		
		if ($dirname != null) {
			$params['resource_base_path'] = XOOPS_THEME_PATH . "/" . $theme . "/modules/" . $dirname;
			$params['quiet'] = true;
			
			$_return = parent::_fetch_resource_info($params);
		}

		if (!$_return) {
			unset ($params['resource_base_path']);
			$params['quiet'] = false;
			
			$_return = parent::_fetch_resource_info($params);
		}
		
		return $_return;
	}
	
}

/**
 * [TODO]
 * We depends on Legacy_RenderSystem that a add-in module defines. We must stop
 * this situation.
 */
class Legacy_AdminRenderSystem extends Legacy_RenderSystem
{
	var $mController;
	var $mSmarty;
	
	function prepare(&$controller)
	{
		$this->mController =& $controller;
		
		$this->mSmarty=new Legacy_AdminSmarty();

		$this->mSmarty->assign(array("xoops_url"=>XOOPS_URL,
		                              "xoops_rootpath"=>XOOPS_ROOT_PATH,
		                              "xoops_langcode"=>_LANGCODE,
		                              "xoops_charset"=>_CHARSET,
		                              "xoops_version"=>XOOPS_VERSION,
		                              "xoops_upload_url"=>XOOPS_UPLOAD_URL));

	}
	
	function renderBlock(&$target)
	{
		$this->mSmarty->template_dir=XOOPS_ROOT_PATH."/modules/base/admin/templates";

		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->assign($key,$value);
		}
		
		$this->mSmarty->setModulePrefix("base");
		$result=&$this->mSmarty->fetch("blocks/".$target->getTemplateName());
		$target->setResult($result);
		
		//
		// Reset
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->clear_assign($key);
		}
	}
	
	function renderTheme(&$target)
	{
		$this->mController->mDebugger->displayLog();

		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->assign($key,$value);
		}

		//
		// Get a virtual current module object from the controller and assign it.
		//
		$moduleObject =& $this->mController->getVirtualCurrentModule();
		$this->mSmarty->assign("currentModule", $moduleObject);

		//
		// Theme rendering
		//
		foreach($this->mBlockContents[0] as $result) {
			$this->mSmarty->append('xoops_lblocks',$result);
		}

		//
		// Check Theme or Fallback
		//
		$root =& XCube_Root::getSingleton();
		$theme = $root->mSiteConfig['Legacy']['Theme'];
		
		if (file_exists(XOOPS_ROOT_PATH."/themes/".$theme."/admin_theme.html")) {
			$this->mSmarty->template_dir=XOOPS_THEME_PATH."/".$theme;
		}
		else {
			$this->mSmarty->template_dir=LEGACY_ADMIN_RENDER_FALLBACK_PATH;
		}

		$this->mSmarty->setModulePrefix('');
		$result=$this->mSmarty->fetch("file:admin_theme.html");

		$target->setResult($result);
	}

	function renderMain(&$target)
	{
		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mSmarty->assign($key,$value);
		}

		$result=null;
		
		if($target->getTemplateName()) {
			if ($target->getModuleName()) {
				$this->mSmarty->setModulePrefix($target->getModuleName());
				$this->mSmarty->template_dir = XOOPS_MODULE_PATH . "/" . $target->getModuleName() . "/admin/". LEGACY_ADMIN_RENDER_TEMPLATE_DIRNAME;
			}
			
			$result=$this->mSmarty->fetch("file:".$target->getTemplateName());
		}
		else {
			$result=$target->getAttribute("stdout_buffer");
		}
		
		$target->setResult($result);
	}
}

/**
 * Return URL string by "overriding" rule.
 * (Now, test implement)
 * 1) Search file in specified theme directory.
 * 2) Search file in current module template directory.
 * 3) Search file in fallback theme directory.
 */
function Legacy_modifier_theme($string)
{
	$root =& XCube_Root::getSingleton();
	$modController =& $root->mController->getModuleController();
	$moduleObject =& $modController->getXoopsModule();

	$theme = $root->mSiteConfig['Legacy']['Theme'];

	if (!is_object($moduleObject)) {
		// TODO We must remove Hard-Coding
		$themePath = XOOPS_THEME_PATH . "/" . $theme . "/" . $string;
		if (file_exists($themePath)) {
			return XOOPS_THEME_URL . "/" . $theme . "/" . $string;
		}

		return LEGACY_ADMIN_RENDER_FALLBACK_URL . "/" . $string;
	}
	else {
		$dirname = $moduleObject->getVar('dirname');

		// TODO We must remove Hard-Coding
		$themePath = XOOPS_THEME_PATH . "/" . $theme . "/modules/" . $dirname . "/" . $string;
		if (file_exists($themePath)) {
			return XOOPS_THEME_URL . "/" . $theme . "/modules/" . $dirname . "/" . $string;
		}

		$themePath = XOOPS_THEME_PATH . "/" . $theme . "/" . $string;
		if (file_exists($themePath)) {
			return XOOPS_THEME_URL . "/" . $theme . "/" . $string;
		}

		$modulePath = XOOPS_MODULE_PATH . "/" . $dirname . "/admin/templates/" . $string;

		if (file_exists($modulePath)) {
			return XOOPS_MODULE_URL . "/" . $dirname . "/admin/templates/" . $string;
		}

		return LEGACY_ADMIN_RENDER_FALLBACK_URL . "/" . $string;
	}
}

function Legacy_function_stylesheet($params, &$smarty)
{
	$file = $params['file'];

	$root =& XCube_Root::getSingleton();
	$theme = $root->mSiteConfig['Legacy']['Theme'];

	// TODO We must remove Hard-Coding
	$themePath = XOOPS_THEME_PATH . "/" . $theme . "/" . $file;
	if (file_exists($themePath)) {
		$url = XOOPS_MODULE_URL . "/base/admin/css.php?theme=${theme}&amp;file=${file}";
	}
	else {
		$url = XOOPS_MODULE_URL . "/base/admin/css.php?file=${file}";
	}

	// TEMP
	// TODO We must return FALLBACK_URL here.

	print '<link rel="stylesheet" type="text/css" media="all" href="' . $url . '" />';
}


?>