<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/GroupAdminDeleteForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/class/XoopsGroupEx.class.php";

class User_GroupDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return isset($_REQUEST['groupid']) ? $_REQUEST['groupid'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_gethandler('group');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new GroupAdminDeleteForm();
		$this->mActionForm->prepare();
	}
	
	function _doExecute()
	{
		$handler =& xoops_gethandler('member');
		return $handler->delete($this->mObject) ? USER_FRAME_VIEW_SUCCESS
		                                        : USER_FRAME_VIEW_ERROR;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$group =& new XoopsGroupEx($this->mObject);
		
		$render->setTemplateName("group_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $group);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=GroupList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=GroupList", 1, _AD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>
