<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/XCube_ActionForm.class.php";

/**
 * This class is generated by makeActionForm tool.
 * 
 * This class was generated in the old days. We should to check it.
 * 
 * @auchor makeActionForm
 * @abstract
 */
class Pm_PmliteEditForm extends XCube_ActionForm 
{
	var $mState = null;
	
	function getTokenName()
	{
		return "module.pm.PmliteEditForm.TOKEN";
	}

	function prepare()
	{
		$this->mFormProperties['subject'] = new XCube_StringProperty('subject');
		$this->mFormProperties['message'] = new XCube_TextProperty('message');

		// set fields
		$this->mFieldProperties['subject'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['subject']->setDependsByArray(array('required', 'maxlength'));
		$this->mFieldProperties['subject']->addMessage("required", _MD_PM_ERROR_REQUIRED, _MD_PM_LANG_SUBJECT);
		$this->mFieldProperties['subject']->addMessage('maxlength', _MD_PM_ERROR_MAXLENGTH, _MD_PM_LANG_SUBJECT, '255');
		$this->mFieldProperties['subject']->addVar('maxlength', '255');

		$this->mFieldProperties['message'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['message']->setDependsByArray(array('required'));
		$this->mFieldProperties['message']->addMessage("required", _MD_PM_ERROR_REQUIRED, _MD_PM_LANG_MESSAGE);

		if (is_object($this->mState)) {
			$this->mState->prepare($this);
		}
	}
	
	function fetch()
	{
		parent::fetch();

		if (is_object($this->mState)) {
			$this->mState->fetch($this);
		}
	}

	function changeStateReply()
	{
		$this->mState =& new Pm_PmliteEditFormReplyState();
	}
	
	function resetToUser()
	{
	}
}

class Pm_PmliteComboEditForm extends Pm_PmliteEditForm
{
	function prepare()
	{
		parent::prepare();
		$this->mFormProperties['to_userid'] = new XCube_IntProperty('to_userid');
	}

	/**
	 * Check existence of the target user.
	 */
	function validateTo_userid()
	{
		if ($this->get('to_userid')) {
			$handler =& xoops_gethandler('user');
			$user =& $handler->get($this->get('to_userid'));

			if (!(is_object($user) && $user->isActive())) {
				$this->set('to_userid', 0);
				$this->addErrorMessage(_MD_PM_ERROR_USERNOEXIST);
			}
		}
	}

	function update(&$obj)
	{
		$obj->setVar('to_userid', $this->get('to_userid'));
		$obj->setVar('subject', $this->get('subject'));
		$obj->setVar('msg_text', $this->get('message'));
	}
	
	function resetToUser()
	{
		$this->set('to_userid', 0);
	}
}

class Pm_PmliteDirectEditForm extends Pm_PmliteEditForm
{
	var $_mUid;

	function prepare()
	{
		parent::prepare();
		$this->mFormProperties['to_uname'] = new XCube_StringProperty('to_uname');
	}

	/**
	 * Check existence of the target user.
	 */
	function validateTo_uname()
	{
		if ($this->get('to_uname')) {
			$handler =& xoops_gethandler('user');
			$criteria =& new Criteria("uname", $this->get("to_uname"));
			$userArr =& $handler->getObjects($criteria);

			if (count($userArr) > 0 && is_object($userArr[0]) && $userArr[0]->isActive()) {
				$this->_mId = $userArr[0]->get('uid');
			}
			else {
				$this->addErrorMessage(_MD_PM_ERROR_PLZTRYAGAIN);
			}
		}
		else {
			$this->addErrorMessage(_MD_PM_ERROR_PLZTRYAGAIN);
		}
	}

	function update(&$obj)
	{
		$obj->setVar('to_userid', $this->_mUid);
		$obj->setVar('subject', $this->get('subject'));
		$obj->setVar('msg_text', $this->get('message'));
	}
	
	function resetToUser()
	{
		$this->_mUid = 0;
	}
}

/**
 * This shows reply-mode for ActionForm of pmlite.
 */
class Pm_PmliteEditFormReplyState
{
	/**
	 * @param $form PmliteEditForm
	 */
	function prepare(&$form)
	{
		$form->mFormProperties['msg_id'] = new XCube_IntProperty('msg_id');
	}

	/**
	 * @param $form PmliteEditForm
	 */
	function fetch(&$form)
	{
		if ($form->get('msg_id')) {
			$handler =& xoops_gethandler('privmessage');
			$pm =& $handler->get($form->get('msg_id'));
			if (is_object($pm)) {
				$root =& XCube_Root::getSingleton();
				$currentUser =& $root->mController->getXoopsUser();
				if ($pm->get('to_userid') == $currentUser->get('uid')) {
					//
					// Create subject
					//
					if (!preg_match("/^Re:/", $pm->get('subject'))) {
						$form->set('subject', "Re: " . $pm->get('subject'));
					}

					// TODO Use Active Check
					$handler =& xoops_gethandler('user');
					$user =& $handler->get($pm->get('from_userid'));
					
					if (!(is_object($user) && $user->isActive())) {
						$this->addErrorMessage(_MD_PM_ERROR_USERNOEXIST);
					}
					else {
						$message = "[quote]\n";
						$message .= sprintf(_MD_PM_ERROR_USERWROTE, $user->get('uname')) . "\n";
						$message .= $pm->get("msg_text") . "\n";
						$message .= "[/quote]\n";
						$form->set('message', $message);
					}
					return;
				}
			}
		}

		//
		// Reset
		//
		$form->set('msg_id', 0);
		$form->resetToUser();
	}
}

?>
