<?php
/**
 * @package XCube
 * @version $Id: XCube_RenderSystem.class.php,v 1.1.2.19 2006/10/07 08:58:28 ryuji_amano Exp $
 */

 if (!defined('XOOPS_ROOT_PATH')) exit();

define("XCUBE_RENDER_MODE_NORMAL",1);
define("XCUBE_RENDER_MODE_DIALOG",2);

/**
 * We had to define classes that are XCube_RenderTargetBuffer, XCube_RenderTargetTheme,
 * XCube_RenderTargetBlock and XCube_RenderTargetMain. And, a render-system had
 * to define render-sub-system that renders to these render-target. However, this
 * style gives a heavy load to our XOOPS Cube system that is a PHP application.
 *
 * We prepare the following constants for the flag of a render-target instead of
 * the group of many classes. 
 */
define("XCUBE_RENDER_TARGET_TYPE_BUFFER",0);
define("XCUBE_RENDER_TARGET_TYPE_THEME",1);
define("XCUBE_RENDER_TARGET_TYPE_BLOCK",2);
define("XCUBE_RENDER_TARGET_TYPE_MAIN",3);

/**
 * This is a target whom a render-system renders. This has a buffer and receives
 * a result of a render-system to the buffer. A developer can control rendering
 * with using this class.
 */
class XCube_RenderTarget
{
	var $mName=null;

	var $mRenderBuffer=null;
	
	var $mModuleName = null;
	
	var $mTemplateName=null;

	var $mAttributes = array();
	
	var $mType = XCUBE_RENDER_TARGET_TYPE_BUFFER;
	
	var $mCacheTime = null;
		
	function XCube_RenderTarget()
	{
	}

	function setName($name)
	{
		$this->mName = $name;
	}

	function getName()
	{
		return $this->mName;
	}
	
	function setModuleName($name)
	{
		$this->mModuleName = $name;
	}
	
	function getModuleName()
	{
		return $this->mModuleName;
	}

	function setTemplateName($name)
	{
		$this->mTemplateName = $name;
	}

	function getTemplateName()
	{
		return $this->mTemplateName;
	}
	
	function setAttribute($key,$value)
	{
		$this->mAttributes[$key] = $value;
	}
	
	function setAttributes($attr)
	{
		$this->mAttributes = $attr;
	}
	
	function getAttribute($key)
	{
		return isset($this->mAttributes[$key]) ? $this->mAttributes[$key] : null;
	}

	function getAttributes()
	{
		return $this->mAttributes;
	}
	
	function setRenderBuffer($buf)
	{
		$this->mRenderBuffer = $buf;
	}
	
	function getRenderBuffer()
	{
		return $this->mRenderBuffer;
	}
	
	function setResult(&$result)
	{
		$this->mRenderBuffer = $result;
	}
	
	function getResult()
	{
		return $this->mRenderBuffer;
	}
	
	/**
	 * Set render-target type.
	 * @param $type int Use constants that are defined by us.
	 */
	function setType($type)
	{
		$this->mType = $type;
	}
	
	/**
	 * Return render-target type.
	 * @return int
	 */
	function getType()
	{
		return $this->mType;
	}
	
	/**
	 * Reset a template name and attributes in own properties.
	 */
	function reset()
	{
		$this->setTemplateName(null);
		$this->setModuleName(null);
		unset($this->mAttributes);
		$this->mAttributes = array();
		$this->mRenderBuffer = null;
	}
}

/**
 * This system is in charge of rendering and contents cache management.
 * For cache management, this system must talk with a business logic before business logic executes.
 * This class has a bad design so that the template engine is strongly tied to cache management.
 * We must divide this class into renderer and cache management.
 */
class XCube_RenderSystem
{
	/**
	 @access private
	 */
	var $mController;

	var $mRenderMode = XCUBE_RENDER_MODE_NORMAL;
	
	function XCube_RenderSystem()
	{
	}
	
	/**
	 * Prepare.
	 *
	 * @param XCube_Controller $controller
	 */
	function prepare(&$controller)
	{
		$this->mController =& $controller;
	}
	
	/**
	 * Create an object of the render-target, and return it.
	 *
	 * @param  int  $type  The number which shows the type of the render-target. Use constants.
	 * @return XCube_RenderTarget
	 */
	function &createRenderTarget($type = XCUBE_RENDER_TARGET_TYPE_MAIN)
	{
		$renderTarget =& new XCube_RenderTarget();
		$renderTarget->setType($type);

		return $renderTarget;
	}

	/**
	 * Render to $target.
	 *
	 * @param XCube_RenderTarget $target
	 */
	function render(&$target)
	{
		$this->renderWithTarget($target);
	}

	/**
	 * @deprecated see render()
	 */	
	function renderWithTarget(&$renderTarget)
	{
	}
}

?>