<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * This is test menu block for control panel of legacy module.
 * This loads module objects by a permission of the current user.
 * Then this load module's adminmenu and module's information.
 *
 * [ASSIGN]
 *  Array of module objects.
 * 
 * @package legacy
 */
class Legacy_AdminSideMenu extends XCube_BlockProcedure
{
	var $mModules = array();
	
	/**
	 * protected, but read OK.
	 * 
	 * @access protected
	 */
	var $mCurrentModule = null;

	function getName()
	{
		return "sidemenu";
	}

	function getTitle()
	{
		return "TEST: AdminSideMenu";
	}
	
	function getEntryIndex()
	{
		return 0;
	}

	function enableCached()
	{
		return false;
	}

	function execute(&$controller, &$user, &$render)
	{
		$this->mCurrentModule =& $controller->mModuleController->mModuleObject;
		if ($this->mCurrentModule->get('dirname') == 'base') {
			if (xoops_getrequest('action') == "help") {
				$moduleHandler =& xoops_gethandler('module');
				$t_module =& $moduleHandler->getByDirname(xoops_gethandler('dirname'));
				if (is_object($t_module)) {
					$this->mCurrentModule =& $t_module;
				}
			}
		}
		
		$db=&$controller->getDB();
		//
		// TODO : We don't use handler and write sql directly.
		//
		$sql = "SELECT DISTINCT {mod}.mid FROM {mod},{perm} ".
		        "WHERE {mod}.isactive=1 AND {mod}.mid={perm}.gperm_itemid AND {perm}.gperm_name='module_admin' AND {perm}.gperm_groupid IN ({groups}) ".
		        "ORDER BY {mod}.weight, {mod}.mid";

		$replaceMap=array("mod"=>$db->prefix("modules"),
		                 "perm"=>$db->prefix("group_permission"),
		                 "groups"=>implode(",",$user->getGroups()));

		$sql=XCube_Utils::formatMessageByMap($sql,$replaceMap);

		$result=$db->query($sql);
		
		$handler =& xoops_gethandler('module');
		
		while($row=$db->fetchArray($result)) {
			$module =& $handler->get($row['mid']);
			$dmy=&$module->getInfo();

			//
			// Load admin menu, and add preference menu by own judge.
			//
			$module->loadAdminMenu();
			if ($module->getVar('hasnotification')
			    || ($module->getInfo('config') && is_array($module->getInfo('config')))
			    || ($module->getInfo('comments') && is_array($module->getInfo('comments')))) {
					$module->adminmenu[] = array(
						'link' => XOOPS_URL.'/modules/base/admin/index.php?action=PreferenceEdit&amp;confmod_id='.$module->getVar('mid'),
						'title' => _PREFERENCES,
						'absolute' => true);
			}
			
			if ($module->hasHelp()) {
				$helpUrl = XOOPS_MODULE_URL . "/base/admin/index.php?action=Help&amp;dirname=" . $module->getVar('dirname');
				$module->adminmenu[] = array('link' => $helpUrl,
				                              'title' => _HELP,
				                              'absolute' => true);
			}

			$this->mModules[]=&$module;
			unset($module);
		}
		
		$render->setTemplateName('legacy_admin_block_sidemenu.html');
		$render->setAttribute('modules', $this->mModules);
		$render->setAttribute('currentModule', $this->mCurrentModule);
	}

	function hasResult()
	{
		return true;
	}

	function getRenderSystemName()
	{
		return 'Legacy_AdminRenderSystem';
	}
}

?>