<?php
/**
 * @package user
 * @version $Id: AvatarEditAction.class.php,v 1.1.2.9 2006/09/25 09:39:28 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarEditForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarSelectForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/forms/AvatarFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/PageNavigator.class.php";

/**
 * This action handles the uploaded avatar image file.
 * 
 * Users who are allowed to upload, can upload custom avatars and select system
 * avatars. So this action has to implement both of uploading and selecting.
 * In the case of GET request, this action shows two forms to changing a avatar
 * for specified user. One of form shows upload-form. Anther form shows the list
 * of system avatars and the page navigator of the list.
 * 
 * @see User_AvatarEditForm
 * @see User_AvatarSelectForm
 */
class User_AvatarEditAction extends User_AbstractEditAction
{
	/**
	 * @var int
	 */
	var $mAvatarWidth = 0;
	
	/**
	 * @var int
	 */
	var $mAvatarHeight = 0;
	
	/**
	 * @var int
	 */
	var $mAvatarMaxfilesize = 0;
	
	/**
	 * @var int
	 */
	var $_mMinPost = 0;
	
	/**
	 * @var bool
	 */
	var $_mAllowUpload = false;
	
	/**
	 * @var User_PageNavigator
	 */
	var $mNavi;
	
	/**
	 * @var User_AvatarFilterForm
	 */
	var $mFilter;

	/**
	 * Preset avatar object collection.
	 */	
	var $mSystemAvatars = array();
	
	/**
	 * Other action form for AvatarSelect.
	 * @var User_AvatarSelectForm
	 */
	var $mAvatarSelectForm = null;
	
	/**
	 * Fetch conditions from $moduleConfig and set these to member properties.
	 * And, by the member property mConfig of the base class, any member
	 * functions of this class can access $moduleConfig.
	 * 
	 * @todo The limit may be not completed, yet.
	 */
	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		$this->mAvatarWidth = $moduleConfig['avatar_width'];
		$this->mAvatarHeight = $moduleConfig['avatar_height'];
		$this->mAvatarMaxfilesize = $moduleConfig['avatar_maxsize'];
		
		$this->_mMinPost = $moduleConfig['avatar_minposts'];
		$this->_mAllowUpload = $moduleConfig['avatar_allow_upload'];

		parent::prepare($controller, $xoopsUser, $moduleConfig);
	}

	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval(xoops_getrequest('uid')) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users');
		return $handler;
	}

	/**
	 * This class uses AvatarUploadForm class. It requests three condition
	 * which are width limit, height limit and filesize limit.
	 * 
	 * @todo We may have to hand three parameters to constructor.
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& new User_AvatarEditForm();
		$this->mActionForm->prepare($this->mAvatarWidth, $this->mAvatarHeight, $this->mAvatarMaxfilesize);
	}
	
	function isEnableCreate()
	{
		return false;
	}

	/**
	 *  Return true. This action should not be used by a guest user.
	 */
	function isSecure()
	{
		return true;
	}
	
	/**
	 * Check whether a current user can access this action.
	 * 1) A specified user has to exist.
	 * 2) A current user has to equal the specified user, or a current user has
	 *    to be a administrator.
	 */
	function hasPermission(&$controller, &$xoopsUser, $moduleConfig)
	{
		if (!is_object($this->mObject)) {
			return false;
		}

		if ($xoopsUser->isAdmin()) {	//< FIXME
			return true;
		}
		elseif ($this->mObject->get('uid') == $xoopsUser->get('uid')) {
			return ($this->mObject->get('posts') >= $this->_mMinPost);
		}
		
		return false;
	}

	/**
	 * This override method looks like the same method of ListAction, and tries
	 * to get system avatars. After, it will call base class.
	 */
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mNavi =& new User_PageNavigator("index.php?AvatarUpload", 0, XCUBE_PAGENAVI_START);
		
		$this->mFilter =& new User_AvatarFilterForm($this->mNavi);
		$this->mFilter->fetch();
		$handler =& xoops_gethandler('avatar');
		
		$total = $handler->getCount($this->mFilter->getCriteria());
		
		$this->mNavi->setTotal($total);
		$this->mNavi->fetch();
		
		$criteria = $this->mFilter->getCriteria($this->mNavi->getStart(), $this->mNavi->getPerpage());
		$this->mSystemAvatars =& $handler->getObjects($criteria);
		
		$this->mAvatarSelectForm =& new User_AvatarSelectForm();
		$this->mAvatarSelectForm->prepare();
		
		$this->mAvatarSelectForm->load($this->mObject);
		
		return parent::getDefaultView($controller, $xoopsUser);
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		if ($this->mObject == null) {
			return USER_FRAME_VIEW_ERROR;
		}
	
		$this->mActionForm->load($this->mObject);
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
	
		if($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}
	
		$this->mActionForm->update($this->mObject);
		
		return $this->_doExecute($this->mObject) ? USER_FRAME_VIEW_SUCCESS
		                                         : USER_FRAME_VIEW_ERROR;
	}

	/**
	 * 1) Save avatar file which has been uploaded.
	 * 2) If old avatar file exists, remove it.
	 * 3) Insert a data to DB with calling base class method.
	 */
	function _doExecute()
	{
		if ($this->mActionForm->mFormFile != null) {
			if (!$this->mActionForm->mFormFile->saveAs(XOOPS_UPLOAD_PATH)) {
				return false;
			}
		}
		
		if ($this->mActionForm->mOldAvatarFilename != null && $this->mActionForm->mOldAvatarFilename != "blank.gif") {
			$avatarHandler =& xoops_getmodulehandler('avatar');
			$criteria =& new Criteria('avatar_file', $this->mActionForm->mOldAvatarFilename);
			$avatarArr =& $avatarHandler->getObjects($criteria);
			if (count($avatarArr) > 0 && is_object($avatarArr[0]) && $avatarArr[0]->get('avatar_type') == 'C') {
				$avatarHandler->delete($avatarArr[0]);
			}
		}
		
		if (parent::_doExecute()) {
			$avatar =& $this->mActionForm->createAvatar();
			if ($avatar != null) {
				$avatar->set('avatar_name', $this->mObject->get('uname'));
				$avatarHandler =& xoops_getmodulehandler('avatar');
				$avatarHandler->insert($avatar);
				
				$linkHandler =& xoops_getmodulehandler('avatar_user_link');
				$linkHandler->deleteAllByUser($this->mObject);
				
				$link =& $linkHandler->create();
				$link->set('user_id', $this->mObject->get('uid'));
				$link->set('avatar_id', $avatar->get('avatar_id'));
				
				$linkHandler->insert($link);
			}
			
			return true;
		}
		else {
			return false;
		}
	}

	function executeViewInput(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("user_avatar_edit.html");
		$render->setAttribute("actionForm", $this->mActionForm);
		$render->setAttribute("thisUser", $this->mObject);

		$render->setAttribute("allowUpload", $this->_mAllowUpload);
		$render->setAttribute("avatarWidth", $this->mAvatarWidth);
		$render->setAttribute("avatarHeight", $this->mAvatarHeight);
		$render->setAttribute("avatarMaxfilesize", $this->mAvatarMaxfilesize);

		$render->setAttribute("pageNavi", $this->mNavi);
		$render->setAttribute("systemAvatars", $this->mSystemAvatars);
		$render->setAttribute("avatarSelectForm", $this->mAvatarSelectForm);
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, $render)
	{
		$controller->executeForward("./index.php?action=UserInfo&uid=" . $this->mActionForm->get('uid'));
	}

	function executeViewError(&$controller,&$xoopsUser,&$render)
	{
		$controller->executeRedirect("./index.php?action=UserInfo&uid=" . $this->mActionForm->get('uid'), 1, _MD_ERROR_DBUPDATE_FAILED);
	}
}

?>