<?php
/**
 * @package Legacy
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) die();

/**
 * The class for blocks which has interfaces to exchange informations with the
 * controller. The sub-class must implement these interfaces with helper
 * functions, to be called back by the controller.
 */
class Legacy_AbstractBlockProcedure
{
	/**
	 * @var XCube_RenderTarget
	 */
	var $mRender = null;
	
	function Legacy_AbstractBlockProcedure()
	{
	}
	
	/**
	 * Preparation. If it's in exception case, returns false.
	 * @return bool
	 */
	function prepare()
	{
		return true;
	}
	
	/**
	 * @var XCube_RenderTarget
	 */
	function &getRenderBuffer()
	{
		if (!is_object($this->mRender)) {
			$this->_createRenderBuffer();
		}
		
		return $this->mRender;
	}

	/**
	 * Gets a name of the dependence render-system.
	 * @return string
	 */
	function getRenderSystemName()
	{
		$root =& XCube_Root::getSingleton();
		return $root->mContext->mBaseRenderSystemName;
	}
	
	/**
	 * Creates a instance of the render buffer, and set it to the property.
	 * This is a helper function for sub-classes.
	 * @access protected
	 */
	function &_createRenderBuffer()
	{
		$this->mRender =& new XCube_RenderTarget();
		$this->mRender->setType(XCUBE_RENDER_TARGET_TYPE_BLOCK);
		
		return $this->mRender;
	}

	/**
	 * Gets a number as ID.
	 * @return int
	 */
	function getId()
	{
	}

	/**
	 * Gets a name of this block.
	 * @return string
	 */	
	function getName()
	{
	}
	
	/**
	 * Gets a value indicating whether the block can be cached.
	 * @return bool
	 */	
	function isEnableCache()
	{
	}
	
	/**
	 * Return cache time
	 * @return int
	 */
	function getCacheTime()
	{
	}

	/**
	 * Gets a title of this block.
	 * @return string
	 */
	function getTitle()
	{
		return $this->_mBlock->get('title');
	}
	
	/**
	 * Gets a column index of this block.
	 * @return int
	 */
	function getEntryIndex()
	{
	}
	
	/**
	 * Gets a weight of this block.
	 * @return int
	 */
	function getWeight()
	{
	}

	/**
	 * Gets a value indicating whether this block nees to display its content.
	 * @return bool
	 */
	function isDisplay()
	{
		return true;
	}
	
	function &createCacheInfo()
	{
		$cacheInfo =& new Legacy_BlockCacheInformation();
		$cacheInfo->setBlock($this);
		return $cacheInfo;
	}
}

/**
 * This class extends the base class to exchange of information with the
 * controller. And, it has a XoopsBlock instance, and some public methods for
 * the public side and the control panel side.
 */
class Legacy_BlockProcedure extends Legacy_AbstractBlockProcedure
{
	/**
	 * @var XoopsBlock
	 */
	var $_mBlock = null;
	
	/**
	 * @var XCube_RenderTarget
	 */
	var $mRender = null;
	
	function Legacy_BlockProcedure(&$block)
	{
		$this->_mBlock =& $block;
	}
	
	function prepare()
	{
		return true;
	}
	
	function getId()
	{
		return $this->_mBlock->get('bid');
	}
	
	function getName()
	{
		return $this->_mBlock->get('title');
	}
	
	function enableCache()
	{
		return $this->_mBlock->get('bcachetime') > 0;
	}
	
	function getCacheTime()
	{
		return $this->_mBlock->get('bcachetime');
	}

	function getTitle()
	{
		return $this->_mBlock->get('title');
	}
	
	function getEntryIndex()
	{
		return $this->_mBlock->getVar('side');
	}
	
	function getWeight()
	{
		return $this->_mBlock->get('weight');
	}
	
	/**
	 * Gets rendered HTML buffer for the option form of the control panel.
	 * @return string
	 */
	function getOptionForm()
	{
	}
}

/**
 * The adapter class for XoopsBlock objects of XOOPS2 JP.
 * @see Legacy_AbstractBlockProcedure
 */
class Legacy_BlockProcedureAdapter extends Legacy_BlockProcedure
{
	var $_mDisplayFlag = true;
	
	function execute()
	{
		$result =& $this->_mBlock->buildBlock();
		
		if (empty($result)) {
			$this->_mDisplayFlag = false;
			return;
		}
		
		$render =& $this->getRenderBuffer();
		$render->setAttribute("mid", $this->getId());
		
		if ($this->_mBlock->get('template') == null) {
			$render->setTemplateName('system_dummy.html');
			$render->setAttribute('dummy_content', $result['content']);
		}
		else {
			$render->setTemplateName($this->_mBlock->get('template'));
			$render->setAttribute('block', $result);
		}
		
		$root =& XCube_Root::getSingleton();
		$renderSystem =& $root->getRenderSystem($this->getRenderSystemName());
		
		$renderSystem->renderBlock($render);
	}
	
	function isDisplay()
	{
		return $this->_mDisplayFlag;
	}

	function getOptionForm()
	{
		if ($this->_mBlock->get('func_file') && $this->_mBlock->get('edit_func')) {
			$func_file = XOOPS_MODULE_PATH . "/" . $this->_mBlock->get('dirname') . "/blocks/" . $this->_mBlock->get('func_file');
			if (file_exists($func_file)) {
				require $func_file;
				$edit_func = $this->_mBlock->get('edit_func');
				
				$options = explode('|', $this->_mBlock->get('options'));
				
				if (function_exists($edit_func)) {
					//
					// load language file.
					//
					$root =& XCube_Root::getSingleton();
					$langManager =& $root->getLanguageManager();
					$langManager->loadBlockMessageCatalog($this->_mBlock->get('dirname'));
					
					return call_user_func($edit_func, $options);
				}
			}
		}
		
		return null;
	}
}

?>