<?php
/**
 * @package Legacy
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * The action filter for the site close procedure.
 */
class Legacy_SiteClose extends XCube_ActionFilter
{
	function preBlockFilter()
	{
		if (($this->mRoot->mContext->getXoopsConfig('closesite') == 1) || is_array(Legacy_Utils::checkSystemModules())) {
			$this->mController->mSetupUser->add("Legacy_SiteClose::callbackSetupUser", XCUBE_DELEGATE_PRIORITY_FINAL);
			$this->mRoot->mDelegateManager->add("Site.CheckLogin.Success", array(&$this, "callbackCheckLoginSuccess"));
		}
	}

	/**
	 * Checks whether the site is closed now, and whether all of must modules
	 * have been installed. This function is called through delegates.
	 * @var XoopsUser &$xoopsUser
	 * @see preBlockFilter()
	 */
	function callbackSetupUser(&$principal, &$controller, &$context)
	{
		$retArray = Legacy_Utils::checkSystemModules();
		$accessAllowFlag = false;
		$xoopsConfig = $controller->mRoot->mContext->getXoopsConfig();
		
		if (!empty($_POST['xoops_login'])) {
			if (is_array($retArray)) {
				define('XOOPS_CPFUNC_LOADED', 1);
			}

			$controller->checkLogin();
			return;
		} elseif (is_object($context->mXoopsUser)) {
			foreach ($context->mXoopsUser->getGroups() as $group) {
				if (in_array($group, $xoopsConfig['closesite_okgrp']) || XOOPS_GROUP_ADMIN == $group) {
					$accessAllowFlag = true;
					break;
				}
			}
		}
		
		// @todo Devide following lines to another preload file
		if ($accessAllowFlag && is_array($retArray)) {
			if (in_array(XOOPS_GROUP_ADMIN, $context->mXoopsUser->getGroups())) {
				$GLOBALS['xoopsUser'] = $context->mXoopsUser;
				if (!empty($_POST['cube_module_install'])) { //@todo use Ticket
					require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleInstaller.class.php";
					if (isset($_POST['uninstalled_modules']) && is_array($_POST['uninstalled_modules'])){
						foreach ($_POST['uninstalled_modules'] as $module) {
							$module = basename($module);
							if (in_array($module, $retArray['uninstalled'])) {
								$installer =& new Legacy_ModuleInstaller($module);
								$installer->execute();
							}
						}
					}
					if (isset($_POST['disabled_modules']) && is_array($_POST['disabled_modules'])){
						$moduleHandler =& xoops_gethandler('module');
						foreach ($_POST['disabled_modules'] as $module) {
							$module = basename($module);
							if (in_array($module, $retArray['disabled'])) {
								if ($moduleObject =& $moduleHandler->getByDirname($module)) {
									$moduleObject->setVar('isactive', 1);
									$moduleHandler->insert($moduleObject);
								}
							}
						}
					}
					if (isset($_POST['option_modules']) && is_array($_POST['option_modules']) ){
						$handler =& xoops_getmodulehandler('non_installation_module', 'legacy');
						$objects = $handler->getObjects();
						$optionModules = array();
						foreach ($objects as $module) {
							if (!in_array($module->get('dirname'), $retArray['uninstalled'])) {
								$optionModules[] = $module->get('dirname');
							}
						}
						foreach ($_POST['option_modules'] as $module) {
							$module = basename($module);
							if (in_array($module, $optionModules)) {
								$installer =& new Legacy_ModuleInstaller($module);
								$installer->execute();
							}
						}
					}
					$controller->executeRedirect(XOOPS_URL . '/', 1);
				}
				elseif (!empty($_GET['cube_module_uninstall'])) {
					require_once XOOPS_ROOT_PATH . '/class/template.php';
					$xoopsTpl =& new XoopsTpl();
					$xoopsTpl->assign('cube_module_uninstall', htmlspecialchars($_GET['cube_module_uninstall'],ENT_QUOTES));
					$xoopsTpl->assign( array(
								   'xoops_sitename' => htmlspecialchars($xoopsConfig['sitename']),
								   'xoops_themecss' => xoops_getcss(),
								   'xoops_imageurl' => XOOPS_THEME_URL . '/' . $xoopsConfig['theme_set'] . '/',
								   ));
					///< @todo filebase template with absolute file path
					$xoopsTpl->compile_check = true;
					$xoopsTpl->display(XOOPS_ROOT_PATH . '/modules/legacy/templates/legacy_uninstall_modules.html');
					exit();
				}
				elseif (!empty($_POST['cube_module_uninstallok'])) { //@todo use Ticket
					require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleUninstaller.class.php";
					$module = basename($_POST['cube_module_uninstallok']);
					if (in_array($module, $retArray['disabled'])) {
						$uninstaller =& new Legacy_ModuleUninstaller($module);
						$uninstaller->execute();
					}
					$controller->executeRedirect(XOOPS_URL . '/',1);
				}
				else {
					$handler =& xoops_getmodulehandler('non_installation_module','legacy');
					$objects = $handler->getObjects();
					$optionModules = array();
					foreach ($objects as $module) {
						$dirname = $module->getVar('dirname');
						if (!in_array($dirname, $retArray['uninstalled'])) {
							$optionModule['dirname']  = $dirname;
							if (in_array($dirname, $retArray['recommended'])) {
								$optionModule['checked']  = 'checked="checked"';
								$optionModule['desc']  = _SYS_RECOMMENDED_MODULES;
							} else {
								$optionModule['checked']  = '';
								$optionModule['desc']  = _SYS_OPTION_MODULES;
							}
							$optionModules[] = $optionModule;
						}
					}
					require_once XOOPS_ROOT_PATH . '/class/template.php';
					$xoopsTpl =& new XoopsTpl();
					$xoopsTpl->assign('uninstalled',$retArray['uninstalled']);
					$xoopsTpl->assign('disabled',$retArray['disabled']);
					$xoopsTpl->assign('option',$optionModules);
					$xoopsTpl->assign(array(
								   'xoops_sitename' => htmlspecialchars($xoopsConfig['sitename']),
								   'xoops_themecss' => xoops_getcss(),
								   'xoops_imageurl' => XOOPS_THEME_URL . '/' . $xoopsConfig['theme_set'] . '/'
								   ));
					///< @todo filebase template with absolute file path
					$xoopsTpl->compile_check = true;
					$xoopsTpl->display(XOOPS_ROOT_PATH . '/modules/legacy/templates/legacy_install_modules.html');
					exit();
				}
		   } else {
				$accessAllowFlag = false;
		   }
		}

		if (!$accessAllowFlag) {
			require_once XOOPS_ROOT_PATH . '/class/template.php';
			$xoopsTpl =& new XoopsTpl();
			$xoopsTpl->assign(array('xoops_sitename' => htmlspecialchars($xoopsConfig['sitename']),
									   'xoops_themecss' => xoops_getcss(),
									   'xoops_imageurl' => XOOPS_THEME_URL . '/' . $xoopsConfig['theme_set'] . '/',
									   'lang_login' => _LOGIN,
									   'lang_username' => _USERNAME,
									   'lang_password' => _PASSWORD,
									   'lang_siteclosemsg' => $xoopsConfig['closesite_text']
									   ));
									   
			$xoopsTpl->compile_check = true;
			
			// @todo filebase template with absolute file path
			$xoopsTpl->display(XOOPS_ROOT_PATH . '/modules/legacy/templates/legacy_site_closed.html');
			exit();
		}
	}
	
	/**
	 * When the user logs in successfully, checks whether the user belongs to
	 * the special group which is allowed to login. This function is called
	 * through delegates.
	 * @var XoopsUser &$xoopsUser
	 * @see preBlockFilter
	 */
	function callbackCheckLoginSuccess(&$xoopsUser)
	{
		//
		// This check is not needed. :)
		//
		if (!is_object($xoopsUser)) {
			return;
		}

		// Site close
		if ($this->mRoot->mContext->getXoopsConfig('closesite')) {
			$accessAllowed = false;

			foreach ($xoopsUser->getGroups() as $group) {
				if (in_array($group, $this->mRoot->mContext->getXoopsConfig('closesite_okgrp')) || ($group == XOOPS_GROUP_ADMIN)) {
					$accessAllowed = true;
					break;
				}
			}

			if (!$accessAllowed) {
				$this->mController->redirectHeader(XOOPS_URL . '/', 1, _NOPERM);
			}
		}
	}
}

?>