<?php
/**
 * @version $Id: Legacy_RenderSystem.class.php,v 1.1.2.30.2.6 2006/10/23 11:22:30 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/modules/legacyRender/kernel/Legacy_RenderTarget.class.php";

/**
 * Compatible render system with XOOPS 2 Themes & Templates.
 *
 * This manages theme and main render-target directly. And, this realizes
 * variable-sharing-mechanism with using smarty.
 */
class Legacy_RenderSystem extends XCube_RenderSystem
{
	var $mXoopsTpl;

	/**
	 * Temporary
	 */
	var $mThemeRenderTarget;
	
	/**
	 * Temporary
	 */
	var $mMainRenderTarget;
	
	var $_mContentsData = null;

	/**
	 * @type XCube_Delegate
	 */
	var $mSetupXoopsTpl = null;
	
	function Legacy_RenderSystem()
	{
		parent::XCube_RenderSystem();
		$this->mSetupXoopsTpl =& new XCube_Delegate();
		$this->mSetupXoopsTpl->register('Legacy_RenderSystem.SetupXoopsTpl');
	}
	
	function prepare(&$controller)
	{
		parent::prepare($controller);
		
		require_once XOOPS_ROOT_PATH . "/class/template.php";

		// XoopsTpl default setup
		$this->mXoopsTpl =& new XoopsTpl();
		$this->mXoopsTpl->register_function("legacy_notifications_select", "LegacyRender_smartyfunction_notifications_select");
		$this->mSetupXoopsTpl->call(new XCube_Ref($this->mXoopsTpl));

		// compatible
		$GLOBALS['xoopsTpl'] =& $this->mXoopsTpl;
		
		$this->mXoopsTpl->xoops_setCaching(0);

		$this->mXoopsTpl->assign(array('xoops_requesturi' => htmlspecialchars($GLOBALS['xoopsRequestUri'], ENT_QUOTES),	//@todo ?????????????
									// set JavaScript /Weird, but need extra <script> tags for 2.0.x themes
									'xoops_js' => '//--></script><script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script><script type="text/javascript"><!--'
								));

		// If debugger request debugging to me, send debug mode signal by any methods.
		if ($controller->mDebugger->isDebugRenderSystem()) {
			$this->mXoopsTpl->xoops_setDebugging(true);
		}
		
   		$this->mXoopsTpl->assign(array('xoops_requesturi' => htmlspecialchars($GLOBALS['xoopsRequestUri'], ENT_QUOTES),	//@todo ?????????????
							'xoops_sitename' => htmlspecialchars($this->mController->mRoot->mContext->mXoopsConfig['sitename'], ENT_QUOTES),
							'xoops_slogan' => htmlspecialchars($this->mController->mRoot->mContext->mXoopsConfig['slogan'], ENT_QUOTES),
							// set JavaScript/Weird, but need extra <script> tags for 2.0.x themes
							'xoops_js' => '//--></script><script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script><script type="text/javascript"><!--'
						));

		// --------------------------------------
		// Meta tags
		// --------------------------------------
        $moduleHandler =& xoops_gethandler('module');
        $legacyRender =& $moduleHandler->getByDirname('legacyRender');
		
		if (is_object($legacyRender)) {
			$configHandler =& xoops_gethandler('config');
			$configs =& $configHandler->getConfigsByCat(0, $legacyRender->get('mid'));
			
			$this->mXoopsTpl->assign('xoops_meta_keywords', $configs['meta_keywords']);
			$this->mXoopsTpl->assign('xoops_meta_description', $configs['meta_description']);
			$this->mXoopsTpl->assign('xoops_meta_robots', $configs['meta_robots']);
			$this->mXoopsTpl->assign('xoops_meta_rating', $configs['meta_rating']);
			$this->mXoopsTpl->assign('xoops_meta_author', $configs['meta_author']);
			$this->mXoopsTpl->assign('xoops_meta_copyright', $configs['meta_copyright']);
			$this->mXoopsTpl->assign('xoops_footer', $configs['footer']);
			
			//
			// If this site has the setting of banner.
			// TODO this process depends on XOOPS 2.0.x.
			//
			if ($configs['banners'] == 1) {
				$this->mXoopsTpl->assign('xoops_banner',xoops_getbanner());
			}
			else {
				$this->mXoopsTpl->assign('xoops_banner','&nbsp;');
			}
		}
		else {
			$this->mXoopsTpl->assign('xoops_banner','&nbsp;');
		}
		
		// --------------------------------------
		// Add User
		// --------------------------------------
		$arr = null;
		if (is_object($this->mController->mRoot->mContext->mXoopsUser)) {
			$arr = array(
				'xoops_isuser' => true,
				'xoops_userid' => $this->mController->mRoot->mContext->mXoopsUser->getShow('uid'),
				'xoops_uname' => $this->mController->mRoot->mContext->mXoopsUser->getShow('uname')
			);
		}
		else {
			$arr = array(
				'xoops_isuser' => false
			);
		}
		
		//
		// Assign module informations.
		//
		if($this->mController->mRoot->mContext->mModule != null) {	// The process of module
			$xoopsModule =& $this->mController->mRoot->mContext->mXoopsModule;
			$this->mXoopsTpl->assign(array('xoops_modulename' => $xoopsModule->getShow('name'),
			                               'xoops_dirname' => $xoopsModule->getShow('dirname')));
			if (!$this->mXoopsTpl->get_template_vars('xoops_pagetitle')) {
				$this->mXoopsTpl->assign(array('xoops_pagetitle' => $xoopsModule->getShow('name')));
			}
		}
		else {
			$this->mXoopsTpl->assign('xoops_pagetitle', htmlspecialchars($this->mController->mRoot->mContext->mXoopsConfig['slogan'], ENT_QUOTES));
		}

		$this->mXoopsTpl->assign($arr);
	}

	function setAttribute($key,$value)
	{
		$this->mRenderTarget->setAttribute($key,$value);
	}
	
	function getAttribute($key)
	{
		$this->mRenderTarget->getAttribute($key);
	}

	function renderBlock(&$target)
	{
		$themeName = $this->mController->mRoot->mContext->getThemeName();
   		$this->mXoopsTpl->assign('xoops_theme', $themeName);
   		$this->mXoopsTpl->assign('xoops_imageurl', XOOPS_THEME_URL . "/${themeName}/");
   		$this->mXoopsTpl->assign('xoops_themecss', xoops_getcss($themeName));
		
		if (isset($GLOBALS['xoopsUserIsAdmin'])) {
			$this->mXoopsTpl->assign('xoops_isadmin', $GLOBALS['xoopsUserIsAdmin']);
		}
		
		//
		// Temporary
		//
		$this->mXoopsTpl->xoops_setCaching(0);

		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		$result=&$this->mXoopsTpl->fetchBlock($target->getTemplateName(),$target->getAttribute("mid"));
		$target->setResult($result);
		
		//
		// Reset
		//
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->clear_assign($key);
		}
	}
	
	function _render(&$target)
	{
		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		$result=$this->mXoopsTpl->fetch("db:".$target->getTemplateName());
		$target->setResult($result);

		foreach ($keys as $key => $value) {
			$this->mXoopsTpl->clear_assign($key);
		}
	}
	
	function renderWithTarget(&$target)
	{
		//
		// The following lines are temporary until we will finish changing the style!
		//
		switch ($target->getAttribute('legacy_buffertype')) {
			case XCUBE_RENDER_TARGET_TYPE_BLOCK:
				$this->renderBlock($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_MAIN:
				$this->renderMain($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_THEME:
				$this->renderTheme($target);
				break;

			case XCUBE_RENDER_TARGET_TYPE_BUFFER:
			default:
				break;
		}
	}

	function renderMain(&$target)
	{
		$themeName = $this->mController->mRoot->mContext->getThemeName();
   		$this->mXoopsTpl->assign('xoops_theme', $themeName);
   		$this->mXoopsTpl->assign('xoops_imageurl', XOOPS_THEME_URL . "/${themeName}/");
   		$this->mXoopsTpl->assign('xoops_themecss', xoops_getcss($themeName));
		
		if (isset($GLOBALS['xoopsUserIsAdmin'])) {
			$this->mXoopsTpl->assign('xoops_isadmin', $GLOBALS['xoopsUserIsAdmin']);
		}
		
		$cachedTemplateId = isset($GLOBLAS['xoopsCachedTemplateId']) ? $GLOBLAS['xoopsCachedTemplateId'] : null;

		foreach($target->getAttributes() as $key=>$value) {
			$this->mXoopsTpl->assign($key,$value);
		}

		if ($target->getTemplateName()) {
		    if ($cachedTemplateId!==null) {
		        $contents=$this->mXoopsTpl->fetch('db:'.$target->getTemplateName(), $xoopsCachedTemplateId);
		    } else {
		        $contents=$this->mXoopsTpl->fetch('db:'.$target->getTemplateName());
		    }
		} else {
		    if ($cachedTemplateId!==null) {
		        $this->mXoopsTpl->assign('dummy_content', $target->getAttribute("stdout_buffer"));
		        $contents=$this->mXoopsTpl->fetch($GLOBALS['xoopsCachedTemplate'], $xoopsCachedTemplateId);
		    } else {
		        $contents=$target->getAttribute("stdout_buffer");
		    }
		}
		
		$target->setResult($contents);
	}

	function renderTheme(&$target)
	{
		$themeName = $this->mController->mRoot->mContext->getThemeName();
   		$this->mXoopsTpl->assign('xoops_theme', $themeName);
   		$this->mXoopsTpl->assign('xoops_imageurl', XOOPS_THEME_URL . "/${themeName}/");
   		$this->mXoopsTpl->assign('xoops_themecss', xoops_getcss($themeName));
		
		if (isset($GLOBALS['xoopsUserIsAdmin'])) {
			$this->mXoopsTpl->assign('xoops_isadmin', $GLOBALS['xoopsUserIsAdmin']);
		}
		
		//
		// Assign from attributes of the render-target.
		//
		foreach($target->getAttributes() as $key => $value) {
			$this->mXoopsTpl->assign($key, $value);
		}
		
		//
		// [TODO]
		// We must implement with a render-target.
		//
		// $this->_processLegacyTemplate();

		// assing
		/// @todo I must move these to somewhere.
		$assignNameMap = array(
				XOOPS_SIDEBLOCK_LEFT=>array('showflag'=>'xoops_showlblock','block'=>'xoops_lblocks'),
				XOOPS_CENTERBLOCK_LEFT=>array('showflag'=>'xoops_showcblock','block'=>'xoops_clblocks'),
				XOOPS_CENTERBLOCK_RIGHT=>array('showflag'=>'xoops_showcblock','block'=>'xoops_crblocks'),
				XOOPS_CENTERBLOCK_CENTER=>array('showflag'=>'xoops_showcblock','block'=>'xoops_ccblocks'),
				XOOPS_SIDEBLOCK_RIGHT=>array('showflag'=>'xoops_showrblock','block'=>'xoops_rblocks')
			);

		foreach($assignNameMap as $key=>$val) {
			$this->mXoopsTpl->assign($val['showflag'],$this->_getBlockShowFlag($val['showflag']));
			if(isset($this->mController->mRoot->mContext->mAttributes['legacy_BlockContents'][$key])) {
				foreach($this->mController->mRoot->mContext->mAttributes['legacy_BlockContents'][$key] as $result) {
					$this->mXoopsTpl->append($val['block'], $result);
				}
			}
		}
		
		//
		// Render result, and set it to the RenderBuffer of the $target.
		//
		$result=null;
		if($target->getAttribute("isFileTheme")) {
			$result=$this->mXoopsTpl->fetch($target->getTemplateName()."/theme.html");
		}
		else {
			$result=$this->mXoopsTpl->fetch("db:".$target->getTemplateName());
		}
		
		$result .= $this->mXoopsTpl->fetchDebugConsole();

		$target->setResult($result);
	}

	function _getBlockShowFlag($area) {
		switch($area) {
			case 'xoops_showrblock' :
				if (isset($GLOBALS['show_rblock']) && empty($GLOBALS['show_rblock'])) return 0;
				return (!empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_SIDEBLOCK_RIGHT])) ? 1 : 0;
				break;
			case 'xoops_showlblock' :
				if (isset($GLOBALS['show_lblock']) && empty($GLOBALS['show_lblock'])) return 0;
				return (!empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_SIDEBLOCK_LEFT])) ? 1 : 0;
				break;
			case 'xoops_showcblock' :
				if (isset($GLOBALS['show_cblock']) && empty($GLOBALS['show_cblock'])) return 0;
				return (!empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_CENTERBLOCK_LEFT])||
				        !empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_CENTERBLOCK_RIGHT])||
				        !empty($this->mController->mRoot->mContext->mAttributes['legacy_BlockShowFlags'][XOOPS_CENTERBLOCK_CENTER])) ? 1 : 0;
				break;
			default :
				return 0;
		}
	}
	//
	// There must not be the following functions here!
	//
	//

	/**
	 * @deprecated
	 */
	function sendHeader()
	{
		header('Content-Type:text/html; charset='._CHARSET);
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0', false);
		header('Pragma: no-cache');
	}

	/**
	 * @deprecated
	 */
	function showXoopsHeader($closeHead=true)
	{
		global $xoopsConfig;
		$myts =& MyTextSanitizer::getInstance();
		if ($xoopsConfig['gzip_compression'] == 1) {
			ob_start("ob_gzhandler");
		} else {
			ob_start();
		}

		$this->sendHeader();
		$this->_renderHeader($closeHead);
	}
	
	// TODO never direct putput
	/**
	 * @deprecated
	 */
	function _renderHeader($closehead=true)
	{
		global $xoopsConfig, $xoopsTheme, $xoopsConfigMetaFooter;

		echo "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>";

		echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="'._LANGCODE.'" lang="'._LANGCODE.'">
		<head>
		<meta http-equiv="content-type" content="text/html; charset='._CHARSET.'" />
		<meta http-equiv="content-language" content="'._LANGCODE.'" />
		<meta name="robots" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_robots']).'" />
		<meta name="keywords" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_keywords']).'" />
		<meta name="description" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_desc']).'" />
		<meta name="rating" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_rating']).'" />
		<meta name="author" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_author']).'" />
		<meta name="copyright" content="'.htmlspecialchars($xoopsConfigMetaFooter['meta_copyright']).'" />
		<meta name="generator" content="XOOPS" />
		<title>'.htmlspecialchars($xoopsConfig['sitename']).'</title>
		<script type="text/javascript" src="'.XOOPS_URL.'/include/xoops.js"></script>
		';
		$themecss = getcss($xoopsConfig['theme_set']);
		echo '<link rel="stylesheet" type="text/css" media="all" href="'.XOOPS_URL.'/xoops.css" />';
		if ($themecss) {
			echo '<link rel="stylesheet" type="text/css" media="all" href="'.$themecss.'" />';
			//echo '<style type="text/css" media="all"><!-- @import url('.$themecss.'); --></style>';
		}
		if ($closehead) {
			echo '</head><body>';
		}
	}
	
	/**
	 * @deprecated
	 */
	function _renderFooter()
	{
		echo '</body></html>';
	    ob_end_flush();
	}
	
	/**
	 * @deprecated
	 */
	function showXoopsFooter()
	{
		$this->_renderFooter();
	}

	function &createRenderTarget($type = LEGACY_RENDER_TARGET_TYPE_MAIN, $option = null)
	{
		$renderTarget = null;
		switch ($type) {
			case XCUBE_RENDER_TARGET_TYPE_MAIN:
				$renderTarget =& new Legacy_RenderTargetMain();
				break;
				
			case LEGACY_RENDER_TARGET_TYPE_BLOCK:
				$renderTarget =& new XCube_RenderTarget();
				$renderTarget->setAttribute('legacy_buffertype', LEGACY_RENDER_TARGET_TYPE_BLOCK);
				break;
				
			default:
				$renderTarget =& new XCube_RenderTarget();
				break;
		}

		return $renderTarget;
	}
	
	/**
	 * @TODO This function is not cool!
	 */
	function &getThemeRenderTarget($isDialog = false)
	{
		$screenTarget = $isDialog ? new Legacy_DialogRenderTarget() : new Legacy_ThemeRenderTarget();
		return $screenTarget;
	}
}

function LegacyRender_smartyfunction_notifications_select($params, &$smarty)
{
	$root =& XCube_Root::getSingleton();
	$renderSystem =& $root->getRenderSystem('Legacy_RenderSystem');
	
	$renderTarget =& $renderSystem->createRenderTarget('main');
	$renderTarget->setTemplateName("legacy_notification_select_form.html");

	XCube_DelegateUtils::call('Legacyfunction.Notifications.Select', new XCube_Ref($renderTarget));

	$renderSystem->renderWithTarget($renderTarget);
	
	return $renderTarget->getResult();
}

?>