<?php
//YANMAH2 - Yet ANother Mobile Accelerated HatenaHaiku
//(c) 2009 YANMAH2 project
//This program is freesoftware. you can redistribute it and/ormodify it under the terms of the [GNU Affero GPL v3](http://www.gnu.org/licenses/agpl.html).
?>
<?php //セキュリティのための前処理。
//NULL バイトの入力を弾く
function checkNull($array){
	if (is_array($array)){
		return array_map('checkNull', $array);
	}
	if (preg_match('/\0/', $array)){
		echo "NULL ぽ";
		exit();
	}
}
checkNull($_GET);
//長すぎる keyword
function checkKeyword($element){
	if (strlen(bin2hex($element)) > 511){
		echo "あう、キーワードが長すぎて入らないですっ…\n(YANMAH2: キーワードの指定に関するエラー)";
		exit();
	}
}
if ($_GET["keyword"] != ''){
	checkKeyword($_GET["keyword"]);
}
//不正なはてなID
//正しいはてなID＝アルファベットで始まり、アルファベットか数字で終わる3文字以上､32文字以内の半角英数字

function checkId($element){
	if (preg_match("/^[a-zA-Z]+[-_a-zA-Z1234567890]+[a-zA-Z1234567890]+$/u",$element) == 0){
		echo "あなたはだあれ\n(YANMAH2: はてなIDの指定に関するエラー)";
		exit();
	}
	if (strlen(bin2hex($element)) > 65){
		echo "なにそれこわい\n(YANMAH2: はてなIDの指定に関するエラー)";
		exit();
	}
}

if ($_GET["user"] != ''){
	checkId($_GET["user"]);
}
if ($_GET["following"] != ''){
	checkId($_GET["following"]);
}

//不正な page
//page=n は100までの数値であること。

function checkPagenum($element){
	if (preg_match("/^[1234567890]{1,3}$/u",$element) == 0){
		echo "なっ、何を入れたのっ？\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
	if ($element > 100){
		echo "ぺ、ページ数が大きすぎて頭変になりそうでふ…\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
}
if ($_GET[page] != ''){
	checkPagenum($_GET[page]);
}
?>

<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"; ?>
<?php
define("HELLO","world");
require_once "configurable_variables.php";
?>
<?php
require_once "HTTP/Request.php";
$selfcall = htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES);
$safequery = htmlspecialchars($_SERVER["QUERY_STRING"], ENT_QUOTES);
$http_url_regexp = 's?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]+';
$http_host_regexp = 's?https?:\/\/[-_.!~*\'()a-zA-Z0-9;?:@&=+$,%#]+\/*';
$http_path_regexp = '[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]*';

if ($_GET["keyword"] != ''){
	$json_url = "http://h.hatena.ne.jp/api/statuses/keyword_timeline/" . rawurlencode(htmlspecialchars($_GET["keyword"], ENT_QUOTES)) . ".json";
	$page_head = htmlspecialchars($_GET["keyword"], ENT_QUOTES) . " でひとこと";
}	elseif ($_GET["user"] != ''){
		$json_url = "http://h.hatena.ne.jp/api/statuses/user_timeline/" . htmlspecialchars($_GET["user"]) . ".json";
		$page_head = htmlspecialchars($_GET["user"], ENT_QUOTES) . " さんのエントリー";
}	elseif ($_GET["following"] != ''){
		$json_url = "http://h.hatena.ne.jp/api/statuses/friends_timeline/" . htmlspecialchars($_GET["following"]) . ".json";
		$page_head = htmlspecialchars($_GET["following"], ENT_QUOTES) . " さんのアンテナ";
}	else {
	$json_url = "http://h.hatena.ne.jp/api/statuses/public_timeline.json";
	$page_head = "みんなのエントリー";
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<?php echo "<title>{$page_head} - {$site_name}</title>\n"; ?>
	<link rel="stylesheet" href="./found.css" />
</head>
<body>
<?php
//var_dump($_GET);

echo "<h1>" . $page_head . "</h1>\n<hr />";

if ($_GET["page"] === ''){
	$request_url = $json_url;
}	else {
		$request_url = $json_url . "?page=" . htmlspecialchars($_GET["page"], ENT_QUOTES);
}
$req =& new HTTP_Request($request_url);

if (!PEAR::isError($req->sendRequest())) {
	$json = $req->getResponseBody();
	$contents = json_decode($json,true);
	if (is_array($contents)){
	}	else {
			echo "<blockquote>{$json}</blockquote>";
			exit();
		}
//	var_dump($contents);
	foreach ($contents as $val){
		//エスケープ処理
		$entry_body = nl2br(htmlspecialchars($val["text"]));
		//キーワードの前処理
		$entry_body = mb_ereg_replace("^{$val["keyword"]}={1}","{$val["keyword"]}<br />",$entry_body);
		//本文中の URL の処理
		$entry_body = preg_replace("/({$http_host_regexp})({$http_path_regexp})/u","<a href=\"{$mobile_gateway}\${1}\${2}\">［リンク（\${1}）］</a>",$entry_body);
		//キーワードの処理
		$entry_body = mb_ereg_replace("^{$val["keyword"]}","<a href=\"{$selfcall}?keyword={$val["keyword"]}\">{$val["keyword"]}</a>",$entry_body);
		//本文中のキーワード記法の処理
		$entry_body = preg_replace("/(\[\[)([^\]]+)(\]\])/u","<a href=\"{$selfcall}?keyword=\${2}\">\${2}</a>",$entry_body);
		//本文中の画像の URL の処理（上の「本文中の URL の処理」がすでに行われているとして）
		$entry_body = preg_replace("/<a href=\"({$http_url_regexp})(\.gif|\.jpg|\.jpeg|\.png|\.bmp)\">［リンク（.+）］<\/a>/u","<a href=\"\${1}\${2}\">［画像（\${2}）］</a>",$entry_body);
		//公式モバイル版における各エントリへのリンク URL 生成
		$refer_link = preg_replace("/({$http_host_regexp})({$http_path_regexp})/u","\${1}mobile/\${2}",$val["link"]);
		//表示
		echo "<p><a href=\"http://";
		echo $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES);
		echo "?user=";
		echo $val["user"]["id"];
		echo "\">";
		echo $val["user"]["id"];
		echo '</a>　';
		echo $entry_body;
		echo "　<a href=\"{$refer_link}\">†</a>";
		echo "</p><hr />\n";
	}
}

if ($_GET[page] != ''){
	if ($_GET[page] >= 100){
		$next_query = preg_replace('/page=[0123456789]{1,3}/u',"page=1",$safequery);
		$next_url = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}?$next_query";
	}	else {
			$next_num = $_GET[page] + 1;
			$next_query = preg_replace('/page=[0123456789]{1,3}/u',"page={$next_num}",$_SERVER["QUERY_STRING"]);
			$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . htmlspecialchars($next_query, ENT_QUOTES);
		}
}	elseif ($_SERVER["QUERY_STRING"] != ""){
		$next_num = 2;
		$next_query = $_SERVER["QUERY_STRING"] . "&page=" . $next_num;
		$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . htmlspecialchars($next_query, ENT_QUOTES);
}	else {
		$next_num = 2;
		$next_query = "page=" . $next_num;
		$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . $next_query;
}

	echo "<ul>";
	echo "<li><a href=\"{$next_url}\">次のページ</a></li>";

	echo "<li><a href=\"{$selfcall}\">みんなの最新エントリー</a></li>";
	echo "<li><a href=\"./index.php\">インデックス</a></li>";
	echo "<li><a href=\"mailto:?subject=" . htmlspecialchars($_GET["keyword"], ENT_QUOTES) . "\">メールで投稿</a></li>";
	echo "</ul>\n";

?>
<hr />
<address>
<?php
echo "はてなハイク&copy;<a href=\"http://mobile.hatena.ne.jp/\">はてな</a><br />";
echo "{$product_name_abbr} PHP script &copy;<a href=\"{$mobile_gateway}{$project_url}\">{$project_name}</a><br />";
echo "設置者:<a href=\"{$mobile_gateway}{$admin_url}\">$admin_name</a><br />";
echo "<a href=\"./about.php\">YANMAH2 について</a>";
?>
</address>

</body>
</html>
