<?php
//YANMAH2 - Yet ANother Mobile Accelerated HatenaHaiku
//(c) 2009 YANMAH2 project
//This program is freesoftware. you can redistribute it and/ormodify it under the terms of the [GNU Affero GPL v3](http://www.gnu.org/licenses/agpl.html).
?>
<?php
define("HELLO","world");
require_once "product_definitions.php";
require_once "configurable_variables.php";
?>
<?php
if ($extra_include_path != "default"){
	$default_include_path = ini_get("include_path");
	ini_set('include_path', ".:{$extra_include_path}:{$default_include_path}");
}
$selfcall = htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES);
$safequery = htmlspecialchars($_SERVER["QUERY_STRING"], ENT_QUOTES);
$http_url_regexp = 's?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]+';
$http_host_regexp = 's?https?:\/\/[-_.!~*\'()a-zA-Z0-9;?:@&=+$,%#]+\/*';
$http_path_regexp = '[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]*';
mb_regex_encoding("UTF-8");
?>
<?php //セキュリティのための前処理。
//NULL バイトの入力を弾く
function checkNull($array){
	if (is_array($array)){
		return array_map('checkNull', $array);
	}
	if (preg_match('/\0/', $array)){
		echo "NULL ぽ";
		exit();
	}
}
checkNull($_GET);
//長すぎる keyword
function checkKeyword($element){
	if (strlen(bin2hex($element)) > 511){
		echo "あう、キーワードが長すぎて入らないですっ…\n(YANMAH2: キーワードの指定に関するエラー)";
		exit();
	}
}
if ($_GET["keyword"] != ''){
	checkKeyword($_GET["keyword"]);
}
//不正なはてなID
//正しいはてなID＝アルファベットで始まり、アルファベットか数字で終わる3文字以上､32文字以内の半角英数字
function checkId($element){
	if (preg_match("/^[a-zA-Z]{1}[-_a-zA-Z1234567890]{1,30}[a-zA-Z1234567890]{1}$/u" ,$element) == 0){
		echo "なにそれこわい\n(YANMAH2: はてなIDの指定に関するエラー)";
		exit();
	}
}
if ($_GET["user"] != ''){
	checkId($_GET["user"]);
}
if ($_GET["following"] != ''){
	checkId($_GET["following"]);
}
//不正な page
//page=n は100までの数値であること。
function checkPagenum($element){
	if (preg_match("/^[1234567890]{1,3}$/u",$element) == 0){
		echo "数字以外入れちゃだめっ…\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
	if ($element > 100){
		echo "ぺ、ページ数が大きすぎでふ…\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
}
if ($_GET[page] != ''){
	checkPagenum($_GET[page]);
}
?>

<?php
//前置きはこのくらいにして、本題に入る！
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
?>
<?php
require_once "HTTP/Request.php";

if ($_GET["keyword"] != ''){
	$get_keyword = $_GET["keyword"];
	$json_url = "http://h.hatena.ne.jp/api/statuses/keyword_timeline/" . rawurlencode($get_keyword) . ".json";
	$page_head = htmlspecialchars($get_keyword) . " でひとこと";
	$official = "{$haiku_official_url}keyword/" . rawurlencode($get_keyword);
	$self_anchor = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}?keyword=" . rawurlencode($get_keyword);
	$entries_mode = 'keyword_timeline';
}	elseif ($_GET["user"] != ''){
		$get_user = htmlspecialchars($_GET["user"], ENT_QUOTES);
		$json_url = "http://h.hatena.ne.jp/api/statuses/user_timeline/{$get_user}.json";
		$page_head = "{$get_user} さんのエントリー";
		$official = "{$haiku_official_url}{$get_user}/";
		$self_anchor = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}?user={$get_user}";
		$entries_mode = 'user_timeline';
}	elseif ($_GET["following"] != ''){
		$get_following = htmlspecialchars($_GET["following"], ENT_QUOTES);
		$json_url = "http://h.hatena.ne.jp/api/statuses/friends_timeline/{$get_following}.json";
		$page_head = "{$get_following} さんのアンテナ";
		$official = "{$haiku_official_url}following";
		$self_anchor = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}?following={$get_following}";
		$entries_mode = 'friends_timeline';
}
	else {
	$json_url = "http://h.hatena.ne.jp/api/statuses/public_timeline.json";
	$page_head = "みんなのエントリー";
	$official = $haiku_official_url;
	$self_anchor = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}";
	$entries_mode = 'default';
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<?php echo "<title>{$page_head} - {$site_name}{$site_name_caption}</title>\n"; ?>
	<link rel="stylesheet" href="./found.css" />
	<link rel="icon" href="./favicon.ico" type="image/vnd.microsoft.icon" />
	<link rel="shortcut icon" href="./favicon.ico" type="image/vnd.microsoft.icon" /></head>
<body>
<?php
//var_dump($_GET);
echo "<div id=\"header\">\n";
echo "<h1 id=\"entries-head\" class=\"head1\">{$page_head} <a href=\"{$official}\" class=\"to-original-link\">&nbsp;‡&nbsp;</a></h1>\n<hr />";
echo "</div>\n";
?>
<div class="contents">
<?php
if ($_GET["page"] === ''){
	$request_url = $json_url;
}	else {
		$request_url = $json_url . "?page=" . htmlspecialchars($_GET["page"], ENT_QUOTES);
}
$req =& new HTTP_Request($request_url);

if (!PEAR::isError($req->sendRequest())) {
	$json = $req->getResponseBody();
	$contents = json_decode($json,true);
	if (is_array($contents)){
	}	else {
			echo "<blockquote>{$json}</blockquote>";
			exit();
		}
//	echo "<pre>" . var_dump($contents) . "</pre>";
	$entry_processor_mode = "entries";
	foreach ($contents as $val){
	require 'entry_processor.php';
	}
}
?>
</div>
<?php
if ($_GET[page] != ''){
	if ($_GET[page] >= 100){
		$next_query = preg_replace('/page=[0123456789]{1,3}/u',"page=1",$safequery);
		$next_url = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}?$next_query";
		$next_num = 1;
	}	else {
			$next_num = $_GET[page] + 1;
			$next_query = preg_replace('/page=[0123456789]{1,3}/u',"page={$next_num}",$_SERVER["QUERY_STRING"]);
			$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . htmlspecialchars($next_query, ENT_QUOTES);
		}
}	elseif ($_SERVER["QUERY_STRING"] != ""){
		$next_num = 2;
		$next_query = $_SERVER["QUERY_STRING"] . "&page=" . $next_num;
		$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . htmlspecialchars($next_query, ENT_QUOTES);
}	else {
		$next_num = 2;
		$next_query = "page=" . $next_num;
		$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . $next_query;
}
if ($next_num == 1){
	$current_page = 100;
}	else {
		$current_page = $next_num - 1;
}
echo "<ul class=\"navigation-menu\">";
echo "<li>この頁は " . $current_page . " ページ</li>";
echo "<li><a href=\"{$next_url}\" class=\"navigation-link\" accesskey=\"6\">次は {$next_num} ページ</a>へ<span class=\"access-key\">(6)</span></li>";
echo "<li><a href=\"{$self_anchor}\" class=\"navigation-link\" accesskey=\"1\">最初のページ</a>へ<span class=\"access-key\">(1)</span></li>";
if ($entries_mode == 'user_timeline'){
	echo '<li><a href="./keywords.php?user=' . $get_user . '" class="navigation-link" accesskey="7">' . $get_user . ' のお気に入りキーワード</a>へ<span class="access-key">(7)</span></li>';
}	elseif ($entries_mode == 'friends_timeline'){
		echo '<li><a href="./keywords.php?user=' . $get_following . '" class="navigation-link" accesskey="7">' . $get_following . ' のお気に入りキーワード</a>へ<span class="access-key">(7)</span></li>';
}	else {
		echo '<li><a href="./keywords.php" class="navigation-link" accesskey="7">キーワード一覧／検索</a>へ<span class="access-key">(7)</span></li>';
}
echo "<li><a href=\"{$selfcall}\" class=\"navigation-link\" accesskey=\"8\">みんなの最新エントリー</a>へ<span class=\"access-key\">(8)</span></li>";
echo "<li><a href=\"./index.php\" class=\"navigation-link\" accesskey=\"0\">インデックス</a>へ<span class=\"access-key\">(0)</span></li>";
echo "<li><a href=\"mailto:?subject=" . htmlspecialchars($_GET["keyword"], ENT_QUOTES) . "\" class=\"navigation-link\" accesskey=\"3\">メールで投稿</a>する<span class=\"access-key\">(3)</span></li>";
echo "</ul>\n";

?>
<hr />
<?php
echo $footer;
?>
</body>
</html>
