<?php
//YANMAH2 - Yet ANother Mobile Accelerated HatenaHaiku
//(c) 2009 YANMAH2 project
//This program is freesoftware. you can redistribute it and/ormodify it under the terms of the [GNU Affero GPL v3](http://www.gnu.org/licenses/agpl.html).
?>
<?php
define("HELLO","world");
require_once "product_definitions.php";
require_once "configurable_variables.php";
?>
<?php
if ($extra_include_path != "default"){
	$default_include_path = ini_get("include_path");
	ini_set('include_path', ".:{$extra_include_path}:{$default_include_path}");
}
$selfcall = htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES);
$safequery = htmlspecialchars($_SERVER["QUERY_STRING"], ENT_QUOTES);
$http_url_regexp = 's?https?:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]+';
$http_host_regexp = 's?https?:\/\/[-_.!~*\'()a-zA-Z0-9;?:@&=+$,%#]+\/*';
$http_path_regexp = '[-_.!~*\'()a-zA-Z0-9;\/?:@&=+$,%#]*';
mb_regex_encoding("UTF-8");
?>
<?php
//NULL バイトの入力を弾く
function checkNull($array){
	if (is_array($array)){
		return array_map('checkNull', $array);
	}
	if (preg_match('/\0/', $array)){
		echo "NULL ぽ";
		exit();
	}
}
checkNull($_GET);
//長すぎる検索ワード
function checkWord($element){
	if (strlen(bin2hex($element)) > 511){
		echo "あう、キーワードが長すぎて入らないですっ…\n(YANMAH2: キーワードの指定に関するエラー)";
		exit();
	}
}
if ($_GET["word"] != ''){
	checkWord($_GET["word"]);
}
//不正なはてなID
//正しいはてなID＝アルファベットで始まり、アルファベットか数字で終わる3文字以上､32文字以内の半角英数字
function checkId($element){
	if (preg_match("/^[a-zA-Z]{1}[-_a-zA-Z1234567890]{1,30}[a-zA-Z1234567890]{1}$/u" ,$element) == 0){
		echo "なにそれこわい\n(YANMAH2: はてなIDの指定に関するエラー)";
		exit();
	}
}
if ($_GET["user"] != ''){
	checkId($_GET["user"]);
}
//不正な page
//page=n は100までの数値であること。
function checkPagenum($element){
	if (preg_match("/^[1234567890]{1,3}$/u",$element) == 0){
		echo "数字以外入れちゃだめっ…\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
	if ($element > 100){
		echo "ぺ、ページ数が大きすぎでふ…\n(YANMAH2: ページ数に関するエラー)";
		exit();
	}
}
if ($_GET[page] != ''){
	checkPagenum($_GET[page]);
}
?>
<?php
if ($_GET['word'] != ''){
	$get_word = $_GET['word'];
	$json_url = 'http://h.hatena.ne.jp/api/keywords/list.json?word=' . rawurlencode($get_word);
	$page_head = htmlspecialchars($get_word, ENT_QUOTES) . ' に一致するキーワード';
	$self_anchor = './keywords.php?word=' . rawurlencode(htmlspecialchars($get_word, ENT_QUOTES));
	$list_mode = 'search';
}	elseif ($_GET['user'] != ''){
		$get_user = $_GET['user'];
		$json_url = 'http://h.hatena.ne.jp/api/statuses/keywords/' . $get_user . '.json';
		$page_head = htmlspecialchars($get_user, ENT_QUOTES) . ' のお気に入りキーワード';
		$self_anchor = './keywords.php?user=' . $get_user;
		$list_mode = 'following';
}	else {
		$json_url = 'http://h.hatena.ne.jp/api/keywords/list.json';
		$page_head = 'キーワード一覧';
		$self_anchor = './keywords.php';
		$list_mode = 'default';
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<?php echo "<title>{$page_head} - {$site_name}{$site_name_caption}</title>\n"; ?>
	<link rel="stylesheet" href="./found.css" />
	<link rel="icon" href="./favicon.ico" type="image/vnd.microsoft.icon" />
	<link rel="shortcut icon" href="./favicon.ico" type="image/vnd.microsoft.icon" /></head>
<body>
<?php
//var_dump($_GET);
echo "<div id=\"header\">\n";
echo "<h1 id=\"entries-head\" class=\"head1\">{$page_head}</h1>\n<hr />";
echo "</div>\n";
?>
<div class="contents">
<ul>
<li><form method="get" action="./keywords.php">
<label for="go2keyword">キーワード</label><input type="text" name="word" maxlength="170" id="go2keyword" /><label for="go2keyword">を</label>
<input type="submit" value="検索" />
</form></li>
<?php
if ($_GET["page"] != ''){
	if ($get_word != ''){
		$request_url = $json_url . "&page=" . htmlspecialchars($_GET["page"], ENT_QUOTES);
	}	elseif ($get_user != ''){
			$request_url = $json_url . "?page=" . htmlspecialchars($_GET["page"], ENT_QUOTES);
	}	else {
			$request_url = $json_url . '?page=' . htmlspecialchars($_GET['page'], ENT_QUOTES);
	}
}	else {
	$request_url = $json_url;
}
//var_dump($request_url);
require_once 'keywords_processor.php';
?>
</ul><hr />
</div>
<ul class="navigation-menu">
<?php
if ($list_mode != 'following'){
if ($_GET[page] != ''){
	if ($_GET[page] >= 100){
		$next_query = preg_replace('/page=[0123456789]{1,3}/u',"page=1",$safequery);
		$next_url = "http://{$_SERVER["SERVER_NAME"]}{$selfcall}?$next_query";
		$next_num = 1;
	}	else {
			$next_num = $_GET[page] + 1;
			$next_query = preg_replace('/page=[0123456789]{1,3}/u',"page={$next_num}",$_SERVER["QUERY_STRING"]);
			$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . htmlspecialchars($next_query, ENT_QUOTES);
		}
}	elseif ($_SERVER["QUERY_STRING"] != ""){
		$next_num = 2;
		$next_query = $_SERVER["QUERY_STRING"] . "&page=" . $next_num;
		$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . htmlspecialchars($next_query, ENT_QUOTES);
}	else {
		$next_num = 2;
		$next_query = "page=" . $next_num;
		$next_url = "http://" . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES) . "?" . $next_query;
}
if ($next_num == 1){
	$current_page = 100;
}	else {
		$current_page = $next_num - 1;
}
	echo "<li>この頁は " . $current_page . " ページ</li>";
	echo "<li><a href=\"{$next_url}\" class=\"navigation-link\" accesskey=\"6\">次は {$next_num} ページ</a>へ<span class=\"access-key\">(6)</span></li>";
	echo "<li><a href=\"{$self_anchor}\" class=\"navigation-link\" accesskey=\"1\">最初のページ</a>へ<span class=\"access-key\">(1)</span></li>";
}
	echo "<li><a href=\"./entries.php\" class=\"navigation-link\" accesskey=\"8\">みんなの最新エントリー</a>へ<span class=\"access-key\">(8)</span></li>";
	echo "<li><a href=\"./index.php\" class=\"navigation-link\" accesskey=\"0\">インデックス</a>へ<span class=\"access-key\">(0)</span></li>";
	echo "<li><a href=\"mailto:?subject=" . htmlspecialchars($_GET["keyword"], ENT_QUOTES) . "\" class=\"navigation-link\" accesskey=\"3\">メールで投稿</a>する<span class=\"access-key\">(3)</span></li>";
?>
</ul>
<hr />
<?php
echo $footer;
?>
</body>
</html>
