/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.RowProcessor;

public class BasicRowProcessor
implements RowProcessor {
    private static final BeanProcessor defaultConvert = new BeanProcessor();
    private static final BasicRowProcessor instance = new BasicRowProcessor();
    private BeanProcessor convert = null;

    public static BasicRowProcessor instance() {
        return instance;
    }

    public BasicRowProcessor() {
        this(defaultConvert);
    }

    public BasicRowProcessor(BeanProcessor convert) {
        this.convert = convert;
    }

    public Object[] toArray(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        Object[] result = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            result[i] = rs.getObject(i + 1);
        }
        return result;
    }

    public Object toBean(ResultSet rs, Class type) throws SQLException {
        return this.convert.toBean(rs, type);
    }

    public List toBeanList(ResultSet rs, Class type) throws SQLException {
        return this.convert.toBeanList(rs, type);
    }

    public Map toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            result.put(rsmd.getColumnName(i), rs.getObject(i));
        }
        return result;
    }

    private static class CaseInsensitiveHashMap
    extends HashMap {
        private CaseInsensitiveHashMap() {
        }

        public boolean containsKey(Object key) {
            return super.containsKey(key.toString().toLowerCase());
        }

        public Object get(Object key) {
            return super.get(key.toString().toLowerCase());
        }

        public Object put(Object key, Object value) {
            return super.put(key.toString().toLowerCase(), value);
        }

        public void putAll(Map m) {
            Iterator iter = m.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = m.get(key);
                this.put(key, value);
            }
        }

        public Object remove(Object key) {
            return super.remove(key.toString().toLowerCase());
        }
    }
}

