/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class StructuredViewer
extends ContentViewer
implements IPostSelectionProvider {
    private CustomHashtable elementMap;
    private IElementComparer comparer;
    private ViewerSorter sorter;
    private List filters;
    private boolean inChange;
    private boolean restoreSelection;
    private ListenerList doubleClickListeners = new ListenerList(1);
    private ListenerList openListeners = new ListenerList(1);
    private ListenerList postSelectionChangedListeners = new ListenerList(1);
    private ColorAndFontCollector colorAndFontCollector = new ColorAndFontCollector();

    protected StructuredViewer() {
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add(listener);
    }

    public void addOpenListener(IOpenListener listener) {
        this.openListeners.add(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.add(listener);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        Control myControl = this.getControl();
        DragSource dragSource = new DragSource(myControl, operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener(listener);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        Control control = this.getControl();
        DropTarget dropTarget = new DropTarget(control, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }

    public void addFilter(ViewerFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(filter);
        this.refresh();
    }

    protected void assertElementsNotNull(Object[] elements) {
        Assert.isNotNull(elements);
        int i = 0;
        int n = elements.length;
        while (i < n) {
            Assert.isNotNull(elements[i]);
            ++i;
        }
    }

    protected void associate(Object element, Item item) {
        Object data = item.getData();
        if (data != element) {
            if (data != null) {
                this.disassociate(item);
            }
            item.setData(element);
        }
        this.mapElement(element, item);
    }

    protected void disassociate(Item item) {
        Object element = item.getData();
        Assert.isNotNull(element);
        this.unmapElement(element, item);
        item.setData(null);
    }

    protected abstract Widget doFindInputItem(Object var1);

    protected abstract Widget doFindItem(Object var1);

    protected abstract void doUpdateItem(Widget var1, Object var2, boolean var3);

    protected boolean equals(Object elementA, Object elementB) {
        if (this.comparer == null) {
            return elementA == null ? elementB == null : elementA.equals(elementB);
        }
        return elementA == null ? elementB == null : this.comparer.equals(elementA, elementB);
    }

    protected Object[] filter(Object[] elements) {
        if (this.filters != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            Object root = this.getRoot();
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                int j = 0;
                while (j < this.filters.size()) {
                    add = ((ViewerFilter)this.filters.get(j)).select(this, root, elements[i]);
                    if (!add) break;
                    ++j;
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return elements;
    }

    protected final Widget findItem(Object element) {
        Widget result = this.doFindInputItem(element);
        if (result != null) {
            return result;
        }
        if (this.elementMap != null) {
            return (Widget)this.elementMap.get(element);
        }
        return this.doFindItem(element);
    }

    protected void fireDoubleClick(final DoubleClickEvent event) {
        Object[] listeners = this.doubleClickListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IDoubleClickListener l = (IDoubleClickListener)listeners[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    l.doubleClick(event);
                }
            });
            ++i;
        }
    }

    protected void fireOpen(final OpenEvent event) {
        Object[] listeners = this.openListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IOpenListener l = (IOpenListener)listeners[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    l.open(event);
                }
            });
            ++i;
        }
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.postSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public IElementComparer getComparer() {
        return this.comparer;
    }

    protected Object[] getFilteredChildren(Object parent) {
        Object[] result = this.getRawChildren(parent);
        if (this.filters != null) {
            Iterator iter = this.filters.iterator();
            while (iter.hasNext()) {
                ViewerFilter f = (ViewerFilter)iter.next();
                result = f.filter(this, parent, result);
            }
        }
        return result;
    }

    public ViewerFilter[] getFilters() {
        if (this.filters == null) {
            return new ViewerFilter[0];
        }
        ViewerFilter[] result = new ViewerFilter[this.filters.size()];
        this.filters.toArray(result);
        return result;
    }

    protected Item getItem(int x, int y) {
        return null;
    }

    protected Object[] getRawChildren(Object parent) {
        IStructuredContentProvider cp;
        Object[] result = null;
        if (parent != null && (cp = (IStructuredContentProvider)this.getContentProvider()) != null) {
            result = cp.getElements(parent);
            this.assertElementsNotNull(result);
        }
        return result != null ? result : new Object[]{};
    }

    protected Object getRoot() {
        return this.getInput();
    }

    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        List list = this.getSelectionFromWidget();
        return new StructuredSelection(list);
    }

    protected abstract List getSelectionFromWidget();

    protected Object[] getSortedChildren(Object parent) {
        Object[] result = this.getFilteredChildren(parent);
        if (this.sorter != null) {
            result = (Object[])result.clone();
            this.sorter.sort(this, result);
        }
        return result;
    }

    public ViewerSorter getSorter() {
        return this.sorter;
    }

    protected void handleDoubleSelect(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            ISelection selection;
            if (event.item != null && event.item.getData() != null) {
                selection = new StructuredSelection(event.item.getData());
            } else {
                selection = this.getSelection();
                this.updateSelection(selection);
            }
            this.fireDoubleClick(new DoubleClickEvent(this, selection));
        }
    }

    protected void handleOpen(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            ISelection selection = this.getSelection();
            this.fireOpen(new OpenEvent(this, selection));
        }
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        this.updateSelection(newSelection);
        SelectionChangedEvent event = new SelectionChangedEvent(this, newSelection);
        this.firePostSelectionChanged(event);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] elements = event.getElements();
        if (elements != null) {
            this.update(elements, (String[])null);
        } else {
            super.handleLabelProviderChanged(event);
        }
    }

    protected void handleSelect(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateSelection(this.getSelection());
        }
    }

    protected void handlePostSelect(SelectionEvent e) {
        SelectionChangedEvent event = new SelectionChangedEvent(this, this.getSelection());
        this.firePostSelectionChanged(event);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        OpenStrategy handler = new OpenStrategy(control);
        handler.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredViewer.this.handleSelect(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StructuredViewer.this.handleDoubleSelect(e);
            }
        });
        handler.addPostSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredViewer.this.handlePostSelect(e);
            }
        });
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                StructuredViewer.this.handleOpen(e);
            }
        });
    }

    protected boolean hasFilters() {
        return this.filters != null && this.filters.size() > 0;
    }

    protected abstract void internalRefresh(Object var1);

    protected void internalRefresh(Object element, boolean updateLabels) {
        this.internalRefresh(element);
    }

    protected void mapElement(Object element, Widget item) {
        if (this.elementMap != null) {
            this.elementMap.put(element, item);
        }
    }

    protected boolean needsRefilter(Object element, String property) {
        if (this.sorter != null && this.sorter.isSorterProperty(element, property)) {
            return true;
        }
        if (this.filters != null) {
            int i = 0;
            int n = this.filters.size();
            while (i < n) {
                ViewerFilter filter = (ViewerFilter)this.filters.get(i);
                if (filter.isFilterProperty(element, property)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    CustomHashtable newHashtable(int capacity) {
        return new CustomHashtable(capacity, this.getComparer());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void preservingSelection(Runnable updateCode) {
        ISelection oldSelection = null;
        try {
            oldSelection = this.getSelection();
            this.restoreSelection = true;
            this.inChange = true;
            updateCode.run();
        }
        catch (Throwable throwable) {
            ISelection newSelection;
            Object var3_4 = null;
            this.inChange = false;
            if (this.restoreSelection) {
                this.setSelectionToWidget(oldSelection, false);
            }
            if ((newSelection = this.getSelection()).equals(oldSelection)) throw throwable;
            this.handleInvalidSelection(oldSelection, newSelection);
            throw throwable;
        }
        {
            ISelection newSelection;
            Object var3_5 = null;
            this.inChange = false;
            if (this.restoreSelection) {
                this.setSelectionToWidget(oldSelection, false);
            }
            if ((newSelection = this.getSelection()).equals(oldSelection)) return;
            this.handleInvalidSelection(oldSelection, newSelection);
            return;
        }
    }

    public void refresh() {
        this.refresh(this.getRoot());
    }

    public void refresh(boolean updateLabels) {
        this.refresh(this.getRoot(), updateLabels);
    }

    public void refresh(final Object element) {
        this.preservingSelection(new Runnable(){

            public void run() {
                StructuredViewer.this.internalRefresh(element);
            }
        });
    }

    public void refresh(final Object element, final boolean updateLabels) {
        this.preservingSelection(new Runnable(){

            public void run() {
                StructuredViewer.this.internalRefresh(element, updateLabels);
            }
        });
    }

    protected final void refreshItem(Widget widget, Object element) {
        SafeRunnable.run(new UpdateItemSafeRunnable(widget, element, true));
    }

    public void removeOpenListener(IOpenListener listener) {
        this.openListeners.remove(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.remove(listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.remove(listener);
    }

    public void removeFilter(ViewerFilter filter) {
        Assert.isNotNull(filter);
        if (this.filters != null) {
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o != filter) continue;
                i.remove();
                this.refresh();
                if (this.filters.size() == 0) {
                    this.filters = null;
                }
                return;
            }
        }
    }

    public void resetFilters() {
        if (this.filters != null) {
            this.filters = null;
            this.refresh();
        }
    }

    public abstract void reveal(Object var1);

    public void setContentProvider(IContentProvider provider) {
        this.assertContentProviderType(provider);
        super.setContentProvider(provider);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        Assert.isTrue(provider instanceof IStructuredContentProvider);
    }

    public final void setInput(Object input) {
        this.unmapAllElements();
        super.setInput(input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (!this.inChange) {
            this.setSelectionToWidget(selection, reveal);
            ISelection sel = this.getSelection();
            this.updateSelection(sel);
            this.firePostSelectionChanged(new SelectionChangedEvent(this, sel));
        } else {
            this.restoreSelection = false;
            this.setSelectionToWidget(selection, reveal);
        }
    }

    protected abstract void setSelectionToWidget(List var1, boolean var2);

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            this.setSelectionToWidget(((IStructuredSelection)selection).toList(), reveal);
        } else {
            this.setSelectionToWidget((List)null, reveal);
        }
    }

    public void setSorter(ViewerSorter sorter) {
        if (this.sorter != sorter) {
            this.sorter = sorter;
            this.refresh();
        }
    }

    public void setUseHashlookup(boolean enable) {
        Assert.isTrue(this.getInput() == null, "Can only enable the hash look up before input has been set");
        this.elementMap = enable ? this.newHashtable(13) : null;
    }

    public void setComparer(IElementComparer comparer) {
        this.comparer = comparer;
        if (this.elementMap != null) {
            this.elementMap = new CustomHashtable(this.elementMap, comparer);
        }
    }

    public Widget testFindItem(Object element) {
        return this.findItem(element);
    }

    protected void unmapAllElements() {
        if (this.elementMap != null) {
            this.elementMap = this.newHashtable(13);
        }
    }

    protected void unmapElement(Object element) {
        if (this.elementMap != null) {
            this.elementMap.remove(element);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (this.elementMap != null && this.elementMap.get(element) == item) {
            this.unmapElement(element);
        }
    }

    public void update(Object[] elements, String[] properties) {
        int i = 0;
        while (i < elements.length) {
            this.update(elements[i], properties);
            ++i;
        }
    }

    public void update(Object element, String[] properties) {
        Assert.isNotNull(element);
        Widget item = this.findItem(element);
        if (item == null) {
            return;
        }
        this.internalUpdate(item, element, properties);
    }

    protected void internalUpdate(Widget widget, Object element, String[] properties) {
        boolean needsUpdate;
        boolean needsRefilter = false;
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                needsRefilter = this.needsRefilter(element, properties[i]);
                if (needsRefilter) break;
                ++i;
            }
        }
        if (needsRefilter) {
            this.refresh();
            return;
        }
        if (properties == null) {
            needsUpdate = true;
        } else {
            needsUpdate = false;
            IBaseLabelProvider labelProvider = this.getLabelProvider();
            int i = 0;
            while (i < properties.length) {
                needsUpdate = labelProvider.isLabelProperty(element, properties[i]);
                if (needsUpdate) break;
                ++i;
            }
        }
        if (needsUpdate) {
            this.updateItem(widget, element);
        }
    }

    protected final void updateItem(Widget widget, Object element) {
        SafeRunnable.run(new UpdateItemSafeRunnable(widget, element, true));
    }

    protected void updateSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent(this, selection);
        this.fireSelectionChanged(event);
    }

    protected boolean usingElementMap() {
        return this.elementMap != null;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.colorAndFontCollector = labelProvider instanceof IColorProvider || labelProvider instanceof IFontProvider ? new ColorAndFontCollectorWithProviders(labelProvider) : new ColorAndFontCollector();
        super.setLabelProvider(labelProvider);
    }

    protected void buildLabel(ViewerLabel updateLabel, Object element) {
        if (this.getLabelProvider() instanceof IViewerLabelProvider) {
            IViewerLabelProvider itemProvider = (IViewerLabelProvider)this.getLabelProvider();
            itemProvider.updateLabel(updateLabel, element);
            this.colorAndFontCollector.setUsedDecorators();
            if (updateLabel.hasNewBackground()) {
                this.colorAndFontCollector.setBackground(updateLabel.getBackground());
            }
            if (updateLabel.hasNewForeground()) {
                this.colorAndFontCollector.setForeground(updateLabel.getForeground());
            }
            if (updateLabel.hasNewFont()) {
                this.colorAndFontCollector.setFont(updateLabel.getFont());
            }
            return;
        }
        if (this.getLabelProvider() instanceof ILabelProvider) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            updateLabel.setText(labelProvider.getText(element));
            updateLabel.setImage(labelProvider.getImage(element));
        }
    }

    void buildLabel(ViewerLabel updateLabel, Object element, IViewerLabelProvider labelProvider) {
        labelProvider.updateLabel(updateLabel, element);
        this.colorAndFontCollector.setUsedDecorators();
        if (updateLabel.hasNewBackground()) {
            this.colorAndFontCollector.setBackground(updateLabel.getBackground());
        }
        if (updateLabel.hasNewForeground()) {
            this.colorAndFontCollector.setForeground(updateLabel.getForeground());
        }
        if (updateLabel.hasNewFont()) {
            this.colorAndFontCollector.setFont(updateLabel.getFont());
        }
    }

    void buildLabel(ViewerLabel updateLabel, Object element, ILabelProvider labelProvider) {
        updateLabel.setText(labelProvider.getText(element));
        updateLabel.setImage(labelProvider.getImage(element));
    }

    protected ColorAndFontCollector getColorAndFontCollector() {
        return this.colorAndFontCollector;
    }

    protected class ColorAndFontCollectorWithProviders
    extends ColorAndFontCollector {
        IColorProvider colorProvider;
        IFontProvider fontProvider;

        public ColorAndFontCollectorWithProviders(IBaseLabelProvider provider) {
            if (provider instanceof IColorProvider) {
                this.colorProvider = (IColorProvider)((Object)provider);
            }
            if (provider instanceof IFontProvider) {
                this.fontProvider = (IFontProvider)((Object)provider);
            }
        }

        public void setFontsAndColors(Object element) {
            if (this.fontProvider != null && this.font == null) {
                this.font = this.fontProvider.getFont(element);
            }
            if (this.colorProvider == null) {
                return;
            }
            if (this.background == null) {
                this.background = this.colorProvider.getBackground(element);
            }
            if (this.foreground == null) {
                this.foreground = this.colorProvider.getForeground(element);
            }
        }

        public void applyFontsAndColors(TableItem control) {
            if (this.colorProvider == null) {
                if (this.usedDecorators) {
                    if (this.background != null) {
                        control.setBackground(this.background);
                    }
                    if (this.foreground != null) {
                        control.setForeground(this.foreground);
                    }
                }
            } else {
                control.setBackground(this.background);
                control.setForeground(this.foreground);
            }
            if (this.fontProvider == null) {
                if (this.usedDecorators && this.font != null) {
                    control.setFont(this.font);
                }
            } else {
                control.setFont(this.font);
            }
            this.clear();
        }

        public void applyFontsAndColors(TreeItem control) {
            if (this.colorProvider == null) {
                if (this.usedDecorators) {
                    if (this.background != null) {
                        control.setBackground(this.background);
                    }
                    if (this.foreground != null) {
                        control.setForeground(this.foreground);
                    }
                }
            } else {
                control.setBackground(this.background);
                control.setForeground(this.foreground);
            }
            if (this.fontProvider == null) {
                if (this.usedDecorators && this.font != null) {
                    control.setFont(this.font);
                }
            } else {
                control.setFont(this.font);
            }
            this.clear();
        }

        public void applyFontsAndColors(TableTreeItem control) {
            if (this.colorProvider == null) {
                if (this.usedDecorators) {
                    if (this.background != null) {
                        control.setBackground(this.background);
                    }
                    if (this.foreground != null) {
                        control.setForeground(this.foreground);
                    }
                }
            } else {
                control.setBackground(this.background);
                control.setForeground(this.foreground);
            }
            if (this.fontProvider == null) {
                if (this.usedDecorators && this.font != null) {
                    control.setFont(this.font);
                }
            } else {
                control.setFont(this.font);
            }
            this.clear();
        }
    }

    class ColorAndFontCollector {
        Color foreground = null;
        Color background = null;
        Font font = null;
        boolean usedDecorators = false;

        public void clear() {
            this.foreground = null;
            this.background = null;
            this.font = null;
            this.usedDecorators = false;
        }

        public void setFontsAndColors(Object element) {
        }

        public void setUsedDecorators() {
            this.usedDecorators = true;
        }

        public void applyFontsAndColors(TableItem control) {
            if (this.usedDecorators) {
                if (this.background != null) {
                    control.setBackground(this.background);
                }
                if (this.foreground != null) {
                    control.setForeground(this.foreground);
                }
                if (this.font != null) {
                    control.setFont(this.font);
                }
            }
            this.clear();
        }

        public void applyFontsAndColors(TreeItem control) {
            if (this.usedDecorators) {
                if (this.background != null) {
                    control.setBackground(this.background);
                }
                if (this.foreground != null) {
                    control.setForeground(this.foreground);
                }
                if (this.font != null) {
                    control.setFont(this.font);
                }
            }
            this.clear();
        }

        public void applyFontsAndColors(TableTreeItem control) {
            if (this.usedDecorators) {
                if (this.background != null) {
                    control.setBackground(this.background);
                }
                if (this.foreground != null) {
                    control.setForeground(this.foreground);
                }
                if (this.font != null) {
                    control.setFont(this.font);
                }
            }
            this.clear();
        }

        public void setBackground(Color background) {
            this.background = background;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }
    }

    class UpdateItemSafeRunnable
    extends SafeRunnable {
        private Widget widget;
        private Object element;
        private boolean fullMap;

        UpdateItemSafeRunnable(Widget widget, Object element, boolean fullMap) {
            this.widget = widget;
            this.element = element;
            this.fullMap = fullMap;
        }

        public void run() {
            StructuredViewer.this.doUpdateItem(this.widget, this.element, this.fullMap);
        }
    }
}

