/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.unitarou.jface.pref.PreferenceArrayCodec;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckGroupFieldEditor<T>
extends FieldEditor {
    private Group frame_;
    private final int columns_;
    private final String[][] items_;
    private final SelectionListener listener_;
    private final List<Button> buttons_;
    private String value_;
    private final PreferenceArrayCodec<T> codec_;

    public CheckGroupFieldEditor(String string, String string2, Composite composite, String[][] stringArray, int n, PreferenceArrayCodec<T> preferenceArrayCodec) {
        ArgumentChecker.throwIfNull(stringArray, preferenceArrayCodec);
        ArgumentChecker.throwIfZeroOrLess(n);
        this.items_ = new String[stringArray.length][];
        for (int i = 0; i < this.items_.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (stringArray2.length < 2) {
                throw new IllegalArgumentException();
            }
            this.items_[i] = new String[stringArray2.length];
            System.arraycopy(stringArray2, 0, this.items_[i], 0, this.items_[i].length);
        }
        this.columns_ = n;
        this.listener_ = new ButtionListener();
        this.buttons_ = new ArrayList<Button>(stringArray.length);
        this.value_ = "";
        this.codec_ = preferenceArrayCodec;
        this.init(string, string2);
        this.createControl(composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        if (label != null) {
            ((GridData)label.getLayoutData()).horizontalSpan = n;
        }
        ((GridData)this.frame_.getLayoutData()).horizontalSpan = n;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        if (this.frame_ != null) {
            return;
        }
        this.frame_ = new Group(composite, 16);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = n;
        this.frame_.setLayoutData(gridData);
        this.frame_.setText(this.getLabelText());
        this.frame_.setLayout(new GridLayout(this.columns_, true));
        this.createCheckBoxes();
    }

    private void createCheckBoxes() {
        for (String[] stringArray : this.items_) {
            List<T> list = this.codec_.decode(stringArray[1]);
            if (list.isEmpty()) continue;
            Button button = new Button(this.frame_, 32);
            button.setData(list.get(0));
            button.setText(stringArray[0]);
            button.addSelectionListener(this.listener_);
            this.buttons_.add(button);
        }
    }

    @Override
    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        if (this.value_ == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value_);
    }

    private void updateValue(String string) {
        this.value_ = string;
        if (this.buttons_.isEmpty()) {
            return;
        }
        if (this.value_ == null) {
            this.value_ = "";
        }
        HashSet<T> hashSet = new HashSet<T>(this.codec_.decode(this.value_));
        for (Button button : this.buttons_) {
            button.setSelection(hashSet.contains(button.getData()));
        }
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    private class ButtionListener
    extends SelectionAdapter {
        private ButtionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ArrayList<Object> arrayList = new ArrayList<Object>(CheckGroupFieldEditor.this.buttons_.size());
            for (Button button : CheckGroupFieldEditor.this.buttons_) {
                if (!button.getSelection()) continue;
                arrayList.add(button.getData());
            }
            CheckGroupFieldEditor.this.value_ = CheckGroupFieldEditor.this.codec_.encode(arrayList);
        }
    }
}

