/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.util.ArgumentChecker;

public final class EnumCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(EnumCodec.class);
    private static final EnumCodec instance_s_ = new EnumCodec();

    public static EnumCodec instance() {
        return instance_s_;
    }

    private EnumCodec() {
    }

    public boolean isEncodable(Object object) {
        return object instanceof Enum;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((Enum)object);
    }

    public String encode(Enum enum_) {
        ArgumentChecker.throwIfNull((Object)enum_);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(enum_.getDeclaringClass().getName()).append('@').append(enum_.name());
        return stringBuilder.toString();
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        int n = string.indexOf(64);
        if (n == -1) {
            log_s_.warn("[IGNORE] Unknown type value: " + string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = ++n < string.length() ? string.substring(n) : "";
        try {
            Class<?> clazz = Class.forName(string2);
            ?[] objArray = clazz.getEnumConstants();
            if (objArray == null) {
                return null;
            }
            for (Object obj : objArray) {
                if (!((Enum)obj).name().equals(string3)) continue;
                return obj;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.warn("[IGNORE] " + string + '@' + classNotFoundException.getLocalizedMessage());
        }
        return null;
    }
}

