/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.memory;

import java.lang.reflect.Constructor;
import java.util.WeakHashMap;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.memory.ReferenceCounterException;

public class ReferenceCounter {
    private final WeakHashMap<Object, Counter> counterMap_;
    private final Constructor constructor_;

    public ReferenceCounter(Class clazz) {
        if (clazz == null) {
            throw new NullArgumentException();
        }
        try {
            this.counterMap_ = new WeakHashMap();
            this.constructor_ = clazz.getConstructor(clazz);
        }
        catch (Exception exception) {
            throw new ReferenceCounterException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(Object object) {
        Counter counter;
        this.checkParameter(object);
        WeakHashMap<Object, Counter> weakHashMap = this.counterMap_;
        synchronized (weakHashMap) {
            counter = this.counterMap_.get(object);
            if (counter == null) {
                counter = new Counter();
                this.counterMap_.put(object, counter);
            }
        }
        counter.increase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(Object object) {
        this.checkParameter(object);
        WeakHashMap<Object, Counter> weakHashMap = this.counterMap_;
        synchronized (weakHashMap) {
            Counter counter = this.counterMap_.get(object);
            if (counter == null) {
                throw new IllegalArgumentException();
            }
            if (counter.count() == 1) {
                this.counterMap_.remove(object);
            } else {
                counter.decrease();
            }
        }
    }

    public Object getEditable(Object object) {
        Object var2_2;
        block2: {
            this.decrement(object);
            var2_2 = null;
            try {
                var2_2 = this.constructor_.newInstance(object);
                this.increment(var2_2);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Never reach this Statement.");
            }
        }
        return var2_2;
    }

    public int count(Object object) {
        this.checkParameter(object);
        Counter counter = this.counterMap_.get(object);
        return counter == null ? 0 : counter.count_;
    }

    public int size() {
        return this.counterMap_.size();
    }

    private void checkParameter(Object object) {
        if (object == null) {
            throw new NullArgumentException();
        }
        if (!this.constructor_.getDeclaringClass().equals(object.getClass())) {
            throw new IllegalArgumentException(object + "is not an instance of " + this.constructor_.getDeclaringClass());
        }
    }

    private static final class Counter {
        private int count_ = 0;

        private Counter() {
        }

        private void increase() {
            ++this.count_;
        }

        private void decrease() {
            --this.count_;
        }

        private int count() {
            return this.count_;
        }
    }
}

