/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.unitarou.io.FileSnapshot;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.WeakedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
implements Iterable<RootGameTree> {
    private final WeakedList<CollectionListener> listeners_;
    private FileSnapshot fileSnapshot_;
    private SgfParserLogger parserLog_;
    private final List<RootGameTree> rootGameTrees_;

    public Collection() {
        this.listeners_ = new WeakedList();
        this.fileSnapshot_ = null;
        this.parserLog_ = null;
        this.rootGameTrees_ = new ArrayList<RootGameTree>(1);
    }

    public Collection(Collection collection) {
        this.fileSnapshot_ = collection.fileSnapshot_;
        this.listeners_ = new WeakedList();
        this.parserLog_ = collection.parserLog_ != null ? new SgfParserLogger(collection.parserLog_) : null;
        this.rootGameTrees_ = new LinkedList<RootGameTree>();
        for (RootGameTree rootGameTree : collection.rootGameTrees_) {
            this.rootGameTrees_.add(new RootGameTree(rootGameTree));
        }
    }

    public void addListener(CollectionListener collectionListener) {
        if (collectionListener == null) {
            return;
        }
        this.listeners_.add(collectionListener);
    }

    public void removeListener(CollectionListener collectionListener) {
        this.listeners_.remove(collectionListener);
    }

    public void addLast(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.rootGameTrees_.add(new RootGameTree(rootGameTree));
        CollectionEvent collectionEvent = new CollectionEvent(this, this, rootGameTree);
        for (CollectionListener collectionListener : this.listeners_) {
            collectionListener.rootGameTreeAppended(collectionEvent);
        }
    }

    public RootGameTree remove(int n) {
        if (n < 0 || this.rootGameTrees_.size() <= n) {
            throw new IllegalArgumentException("Bad index:" + n);
        }
        RootGameTree rootGameTree = this.rootGameTrees_.remove(n);
        CollectionEvent collectionEvent = new CollectionEvent(this, this, rootGameTree);
        for (CollectionListener collectionListener : this.listeners_) {
            collectionListener.rootGameTreeRemoved(collectionEvent);
        }
        return rootGameTree;
    }

    public void swap(int n, int n2) {
        if (n < 0 || this.rootGameTrees_.size() <= n || n2 < 0 || this.rootGameTrees_.size() <= n2) {
            throw new IllegalArgumentException("Parameter is out of range. index1:" + n + ", index2:" + n2);
        }
        RootGameTree rootGameTree = this.rootGameTrees_.get(n);
        this.rootGameTrees_.set(n, this.rootGameTrees_.get(n2));
        this.rootGameTrees_.set(n2, rootGameTree);
    }

    public void setFile(File file) {
        this.fileSnapshot_ = file == null ? null : new FileSnapshot(file);
    }

    public void setParserLog(SgfParserLogger sgfParserLogger) {
        this.parserLog_ = sgfParserLogger;
    }

    public RootGameTree get(int n) {
        return this.rootGameTrees_.get(n);
    }

    public int size() {
        return this.rootGameTrees_.size();
    }

    public File getFile() {
        return this.fileSnapshot_ != null ? this.fileSnapshot_.file() : null;
    }

    public FileSnapshot getFileSnapshot() {
        return this.fileSnapshot_;
    }

    public SgfParserLogger getParserLog() {
        return this.parserLog_;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator
    implements java.util.Iterator<RootGameTree> {
        private final ListIterator<RootGameTree> iterator_;

        private Iterator(Collection collection) {
            this.iterator_ = collection.rootGameTrees_.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        @Override
        public RootGameTree next() {
            return this.iterator_.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

