/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

public class PropertyValue {
    private final Property property_;
    private final LinkedHashMap<String, Value> valueMap_;
    private int hashCode_;

    PropertyValue(Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        this.property_ = property;
        this.valueMap_ = new LinkedHashMap(1);
        this.hashCode_ = 0;
    }

    public void setValue(Value value) {
        this.checkValue(value, false);
        this.valueMap_.clear();
        this.valueMap_.put(value.getString(), value);
        this.hashCode_ = 0;
    }

    public int addValue(Value[] valueArray) {
        this.checkValue(valueArray, true);
        this.hashCode_ = 0;
        if (this.property_.sgfId().cardinalityType().equals(CardinalityType.ELIST) && valueArray.length != 0) {
            if ("".equals(valueArray[0].getString())) {
                this.valueMap_.clear();
                this.valueMap_.put(valueArray[0].getString(), new Value(valueArray[0]));
                return 1;
            }
            this.valueMap_.remove("");
        }
        int n = 0;
        for (int i = 0; i < valueArray.length; ++i) {
            if (this.valueMap_.containsKey(valueArray[i].getString())) continue;
            this.valueMap_.put(valueArray[i].getString(), new Value(valueArray[i]));
            ++n;
        }
        return n;
    }

    public void addValue(Value value) {
        ArgumentChecker.throwIfNull((Object)value);
        this.hashCode_ = 0;
        if (this.property_.sgfId().cardinalityType().equals(CardinalityType.ELIST)) {
            if ("".equals(value.getString())) {
                this.valueMap_.clear();
            }
            this.valueMap_.remove("");
        }
        this.valueMap_.put(value.getString(), value);
    }

    public boolean removeValue(Value value) {
        this.checkValue(value, true);
        this.hashCode_ = 0;
        return this.valueMap_.remove(value.getString()) != null;
    }

    public void singularizeIfNeeds() {
        if (1 < this.valueMap_.size() && !ValueType.permitsMultiValues(this.property_.sgfId().cardinalityType())) {
            Value value = this.valueMap_.values().toArray(new Value[this.valueMap_.size()])[0];
            this.valueMap_.clear();
            this.valueMap_.put(value.getString(), value);
            this.hashCode_ = 0;
        }
    }

    public void clear() {
        this.hashCode_ = 0;
        this.valueMap_.clear();
    }

    private void checkValue(Object object, boolean bl) {
        ArgumentChecker.throwIfNull(object);
        if (bl != ValueType.permitsMultiValues(this.property_.sgfId().cardinalityType())) {
            throw new IllegalStateException("type_.getCardinalityType() is :" + this.property_.sgfId().cardinalityType());
        }
    }

    public String getString() {
        return this.getValue().getString();
    }

    public String[] getStrings() {
        String[] stringArray = new String[this.valueMap_.size()];
        int n = 0;
        Iterator<Value> iterator = this.valueMap_.values().iterator();
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().getString();
            ++n;
        }
        return stringArray;
    }

    public boolean contains(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.valueMap_.containsKey(string);
    }

    public Value getValue() {
        this.checkValue(this, false);
        return new Value(this.valueMap_.values().iterator().next());
    }

    public Value[] getValues() {
        Value[] valueArray = new Value[this.valueMap_.size()];
        int n = 0;
        for (Value value : this.valueMap_.values()) {
            valueArray[n] = new Value(value);
            ++n;
        }
        return valueArray;
    }

    public int size() {
        return this.valueMap_.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        PropertyValue propertyValue = (PropertyValue)object;
        return this.valueMap_.equals(propertyValue.valueMap_);
    }

    public int hashCode() {
        if (this.hashCode_ == 0) {
            for (Value value : this.valueMap_.values()) {
                this.hashCode_ += this.hashCode_ * value.hashCode();
            }
        }
        return this.hashCode_;
    }

    public String toString() {
        if (this.valueMap_.isEmpty()) {
            return "<<EMPTY>>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Value value : this.valueMap_.values()) {
            stringBuilder.append('[').append(value.getString()).append(']');
        }
        return stringBuilder.toString();
    }
}

