/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

public class AddNode
extends AbstractCommand {
    private final GameTree tree_;
    private final Node newNode_;

    public AddNode(GameTree gameTree, Node node) {
        if (gameTree == null || node == null) {
            throw new NullPointerException("Arguments must not be null. tree = " + gameTree + " newNode = " + node);
        }
        this.tree_ = gameTree;
        this.newNode_ = node;
    }

    public void execute() {
        super.execute();
        this.tree_.getSequence().addLast(this.newNode_);
    }

    public void undo() {
        super.undo();
        Node node = this.tree_.getSequence().removeLast();
        if (!this.newNode_.equals(node)) {
            throw new IllegalStateException("Cannot remove addition node. lastNode = " + node + "additionNode = " + this.newNode_);
        }
    }
}

