/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;
import org.unitarou.util.ArgumentChecker;

public class InsertNode
extends AbstractCommand {
    private final GameTree tree_;
    private final Node insertPoint_;
    private final Node newNode_;

    public InsertNode(GameTree gameTree, Node node, Node node2) {
        ArgumentChecker.throwIfNull((Object)gameTree, (Object)node, (Object)node2);
        if (!this.contain(gameTree.getSequence(), node)) {
            throw new IllegalArgumentException("insertPoint doesn't contain tree!");
        }
        this.tree_ = gameTree;
        this.insertPoint_ = node;
        this.newNode_ = node2;
    }

    private boolean contain(Sequence sequence, Node node) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)node);
        for (Node node2 : sequence) {
            if (node2 != node) continue;
            return true;
        }
        return false;
    }

    public void execute() {
        super.execute();
        this.tree_.getSequence().insert(this.newNode_, this.insertPoint_);
    }

    public void undo() {
        super.undo();
        this.tree_.getSequence().remove(this.newNode_);
    }
}

